/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.vcs.EditFileProvider;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.Revision;
import org.jetbrains.idea.svn.api.Target;
import org.jetbrains.idea.svn.properties.PropertyClient;
import org.jetbrains.idea.svn.properties.PropertyValue;

public class SvnEditFileProvider
implements EditFileProvider {
    private final SvnVcs myVCS;

    public SvnEditFileProvider(SvnVcs vcs) {
        this.myVCS = vcs;
    }

    public void editFiles(VirtualFile[] files) throws VcsException {
        File[] ioFiles = new File[files.length];
        for (int i = 0; i < files.length; ++i) {
            ioFiles[i] = VfsUtilCore.virtualToIoFile((VirtualFile)files[i]);
            PropertyClient client = this.myVCS.getFactory(ioFiles[i]).createPropertyClient();
            PropertyValue property = client.getProperty(Target.on(ioFiles[i], Revision.WORKING), "svn:needs-lock", false, Revision.WORKING);
            if (property != null) continue;
            throw new VcsException(SvnBundle.message("exception.text.file.miss.svn", ioFiles[i].getName()));
        }
        SvnUtil.doLockFiles(this.myVCS.getProject(), this.myVCS, ioFiles);
    }

    public String getRequestText() {
        return SvnBundle.message("confirmation.text.edit.file", new Object[0]);
    }
}

