/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.validation;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.python.PyNames;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.highlighting.PyHighlighter;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDecorator;
import com.jetbrains.python.psi.PyElementVisitor;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.validation.PyAnnotationHolder;
import com.jetbrains.python.validation.PyAnnotatorBase;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public final class PyDefinitionsHighlightingAnnotator
extends PyAnnotatorBase {
    public void annotate(@NotNull PsiElement element, @NotNull PyAnnotationHolder holder) {
        if (element == null) {
            PyDefinitionsHighlightingAnnotator.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            PyDefinitionsHighlightingAnnotator.$$$reportNull$$$0(1);
        }
        element.accept((PsiElementVisitor)new MyVisitor(holder));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/python/validation/PyDefinitionsHighlightingAnnotator";
        objectArray[2] = "annotate";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyVisitor
    extends PyElementVisitor {
        @NotNull
        private final PyAnnotationHolder myHolder;

        private MyVisitor(@NotNull PyAnnotationHolder holder) {
            if (holder == null) {
                MyVisitor.$$$reportNull$$$0(0);
            }
            this.myHolder = holder;
        }

        public void visitPyClass(@NotNull PyClass node) {
            ASTNode name_node;
            if (node == null) {
                MyVisitor.$$$reportNull$$$0(1);
            }
            if ((name_node = node.getNameNode()) != null) {
                this.myHolder.addHighlightingAnnotation(name_node, PyHighlighter.PY_CLASS_DEFINITION);
            }
        }

        public void visitPyFunction(@NotNull PyFunction node) {
            ASTNode nameNode;
            if (node == null) {
                MyVisitor.$$$reportNull$$$0(2);
            }
            if ((nameNode = node.getNameNode()) != null) {
                String name = node.getName();
                LanguageLevel languageLevel = LanguageLevel.forElement((PsiElement)node);
                if (PyNames.UNDERSCORED_ATTRIBUTES.contains(name) || PyNames.getBuiltinMethods((LanguageLevel)languageLevel).containsKey(name)) {
                    PyClass cls = node.getContainingClass();
                    if (PyUtil.isNewMethod((PsiElement)node)) {
                        boolean new_style_class = false;
                        try {
                            if (cls != null) {
                                new_style_class = cls.isNewStyleClass(null);
                            }
                        }
                        catch (IndexNotReadyException indexNotReadyException) {
                            // empty catch block
                        }
                        if (new_style_class) {
                            this.myHolder.addHighlightingAnnotation(nameNode, PyHighlighter.PY_PREDEFINED_DEFINITION);
                        }
                    } else {
                        this.myHolder.addHighlightingAnnotation(nameNode, PyHighlighter.PY_PREDEFINED_DEFINITION);
                    }
                } else if (ScopeUtil.getScopeOwner((PsiElement)node) instanceof PyFunction) {
                    this.myHolder.addHighlightingAnnotation(nameNode, PyHighlighter.PY_NESTED_FUNC_DEFINITION);
                } else {
                    this.myHolder.addHighlightingAnnotation(nameNode, PyHighlighter.PY_FUNC_DEFINITION);
                }
            }
        }

        public void visitPyDecorator(@NotNull PyDecorator node) {
            PsiElement atSign;
            if (node == null) {
                MyVisitor.$$$reportNull$$$0(3);
            }
            if ((atSign = node.getFirstChild()) != null) {
                this.myHolder.addHighlightingAnnotation(atSign, PyHighlighter.PY_DECORATOR);
                if (node.getQualifiedName() != null) {
                    this.myHolder.addHighlightingAnnotation((PsiElement)Objects.requireNonNull(node.getCallee()), PyHighlighter.PY_DECORATOR);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "holder";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/validation/PyDefinitionsHighlightingAnnotator$MyVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyClass";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyFunction";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyDecorator";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

