/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.core.CoreBundle;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SearchScope {
    private static int hashCodeCounter;
    private transient int myHashCode;
    private final int myDefaultHashCode = ++hashCodeCounter;

    @ApiStatus.NonExtendable
    public int hashCode() {
        int hashCode = this.myHashCode;
        if (hashCode == 0) {
            this.myHashCode = hashCode = this.calcHashCode();
        }
        return hashCode;
    }

    protected int calcHashCode() {
        return this.myDefaultHashCode;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getDisplayName() {
        String string = CoreBundle.message("search.scope.unknown", new Object[0]);
        if (string == null) {
            SearchScope.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nullable
    public Icon getIcon() {
        return null;
    }

    @NotNull
    @ApiStatus.Internal
    public String toFullString() {
        String string = this.toString();
        if (string == null) {
            SearchScope.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Contract(pure=true)
    @NotNull
    public abstract SearchScope intersectWith(@NotNull SearchScope var1);

    @Contract(pure=true)
    @NotNull
    public abstract SearchScope union(@NotNull SearchScope var1);

    @Contract(pure=true)
    public abstract boolean contains(@NotNull VirtualFile var1);

    public static boolean isEmptyScope(@NotNull SearchScope scope) {
        if (scope == null) {
            SearchScope.$$$reportNull$$$0(2);
        }
        return scope == GlobalSearchScope.EMPTY_SCOPE || scope == LocalSearchScope.EMPTY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/search/SearchScope";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "toFullString";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/search/SearchScope";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isEmptyScope";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

