/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.input;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.text.input.EditCommand;
import androidx.compose.ui.text.input.EditCommandKt;
import androidx.compose.ui.text.input.EditingBuffer;
import androidx.compose.ui.text.internal.InlineClassHelperKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0096\u0002J\b\u0010\u0012\u001a\u00020\u0003H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0015"}, d2={"Landroidx/compose/ui/text/input/DeleteSurroundingTextInCodePointsCommand;", "Landroidx/compose/ui/text/input/EditCommand;", "lengthBeforeCursor", "", "lengthAfterCursor", "<init>", "(II)V", "getLengthBeforeCursor", "()I", "getLengthAfterCursor", "applyTo", "", "buffer", "Landroidx/compose/ui/text/input/EditingBuffer;", "equals", "", "other", "", "hashCode", "toString", "", "ui-text"})
@StabilityInferred(parameters=1)
@SourceDebugExtension(value={"SMAP\nEditCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditCommand.kt\nandroidx/compose/ui/text/input/DeleteSurroundingTextInCodePointsCommand\n+ 2 InlineClassHelper.kt\nandroidx/compose/ui/text/internal/InlineClassHelperKt\n*L\n1#1,558:1\n118#2,4:559\n*S KotlinDebug\n*F\n+ 1 EditCommand.kt\nandroidx/compose/ui/text/input/DeleteSurroundingTextInCodePointsCommand\n*L\n309#1:559,4\n*E\n"})
public final class DeleteSurroundingTextInCodePointsCommand
implements EditCommand {
    private final int lengthBeforeCursor;
    private final int lengthAfterCursor;
    public static final int $stable;

    public DeleteSurroundingTextInCodePointsCommand(int lengthBeforeCursor, int lengthAfterCursor) {
        this.lengthBeforeCursor = lengthBeforeCursor;
        this.lengthAfterCursor = lengthAfterCursor;
        boolean value$iv = this.lengthBeforeCursor >= 0 && this.lengthAfterCursor >= 0;
        boolean $i$f$requirePrecondition = false;
        if (!value$iv) {
            boolean bl = false;
            InlineClassHelperKt.throwIllegalArgumentException("Expected lengthBeforeCursor and lengthAfterCursor to be non-negative, were " + this.lengthBeforeCursor + " and " + this.lengthAfterCursor + " respectively.");
        }
    }

    public final int getLengthBeforeCursor() {
        return this.lengthBeforeCursor;
    }

    public final int getLengthAfterCursor() {
        return this.lengthAfterCursor;
    }

    @Override
    public void applyTo(@NotNull EditingBuffer buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        int beforeLenInChars = 0;
        int n = this.lengthBeforeCursor;
        for (int i = 0; i < n; ++i) {
            if (buffer.getSelectionStart$ui_text() > ++beforeLenInChars) {
                char trail;
                char lead = buffer.get$ui_text(buffer.getSelectionStart$ui_text() - beforeLenInChars - 1);
                if (!EditCommandKt.access$isSurrogatePair(lead, trail = buffer.get$ui_text(buffer.getSelectionStart$ui_text() - beforeLenInChars))) continue;
                ++beforeLenInChars;
                continue;
            }
            beforeLenInChars = buffer.getSelectionStart$ui_text();
            break;
        }
        int afterLenInChars = 0;
        int n2 = this.lengthAfterCursor;
        for (int i = 0; i < n2; ++i) {
            if (buffer.getSelectionEnd$ui_text() + ++afterLenInChars < buffer.getLength$ui_text()) {
                char trail;
                char lead = buffer.get$ui_text(buffer.getSelectionEnd$ui_text() + afterLenInChars - 1);
                if (!EditCommandKt.access$isSurrogatePair(lead, trail = buffer.get$ui_text(buffer.getSelectionEnd$ui_text() + afterLenInChars))) continue;
                ++afterLenInChars;
                continue;
            }
            afterLenInChars = buffer.getLength$ui_text() - buffer.getSelectionEnd$ui_text();
            break;
        }
        buffer.delete$ui_text(buffer.getSelectionEnd$ui_text(), buffer.getSelectionEnd$ui_text() + afterLenInChars);
        buffer.delete$ui_text(buffer.getSelectionStart$ui_text() - beforeLenInChars, buffer.getSelectionStart$ui_text());
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DeleteSurroundingTextInCodePointsCommand)) {
            return false;
        }
        if (this.lengthBeforeCursor != ((DeleteSurroundingTextInCodePointsCommand)other).lengthBeforeCursor) {
            return false;
        }
        return this.lengthAfterCursor == ((DeleteSurroundingTextInCodePointsCommand)other).lengthAfterCursor;
    }

    public int hashCode() {
        int result2 = this.lengthBeforeCursor;
        result2 = 31 * result2 + this.lengthAfterCursor;
        return result2;
    }

    @NotNull
    public String toString() {
        return "DeleteSurroundingTextInCodePointsCommand(lengthBeforeCursor=" + this.lengthBeforeCursor + ", lengthAfterCursor=" + this.lengthAfterCursor + ")";
    }
}

