/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.clikt.core;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u0010\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0002\u001a\u0018\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0000\u00a8\u0006\u0006"}, d2={"jaroSimilarity", "", "s1", "", "s2", "jaroWinklerSimilarity", "clikt"})
public final class JaroWinkerSimilarityKt {
    private static final double jaroSimilarity(String s1, String s2) {
        if (((CharSequence)s1).length() == 0 && ((CharSequence)s2).length() == 0) {
            return 1.0;
        }
        if (((CharSequence)s1).length() == 0 || ((CharSequence)s2).length() == 0) {
            return 0.0;
        }
        if (s1.length() == 1 && s2.length() == 1) {
            return s1.charAt(0) == s2.charAt(0) ? 1.0 : 0.0;
        }
        int searchRange = Math.max(s1.length(), s2.length()) / 2 - 1;
        boolean[] s2Consumed = new boolean[s2.length()];
        double matches = 0.0;
        int transpositions = 0;
        int s2MatchIndex = 0;
        int n = s1.length();
        block0: for (int i = 0; i < n; ++i) {
            int end;
            int i2 = i;
            char c1 = s1.charAt(i);
            int start2 = Math.max(0, i2 - searchRange);
            int j = start2;
            if (j > (end = Math.min(StringsKt.getLastIndex(s2), i2 + searchRange))) continue;
            while (true) {
                char c2;
                if (c1 == (c2 = s2.charAt(j)) && !s2Consumed[j]) {
                    s2Consumed[j] = true;
                    matches += 1.0;
                    if (j < s2MatchIndex) {
                        ++transpositions;
                    }
                    s2MatchIndex = j;
                    continue block0;
                }
                if (j == end) continue block0;
                ++j;
            }
        }
        return matches == 0.0 ? 0.0 : (matches / (double)s1.length() + matches / (double)s2.length() + (matches - (double)transpositions) / matches) / 3.0;
    }

    public static final double jaroWinklerSimilarity(@NotNull String s1, @NotNull String s2) {
        Intrinsics.checkNotNullParameter(s1, "s1");
        Intrinsics.checkNotNullParameter(s2, "s2");
        int prefixLength = StringsKt.commonPrefixWith$default(s1, s2, false, 2, null).length();
        double jaro = JaroWinkerSimilarityKt.jaroSimilarity(s1, s2);
        double winkler = jaro + 0.1 * (double)prefixLength * (1.0 - jaro);
        return Math.min(winkler, 1.0);
    }
}

