/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl;

import java.util.Iterator;
import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.http.HttpMessage;
import org.apache.hc.core5.http.MessageHeaders;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.ProtocolException;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.message.MessageSupport;
import org.apache.hc.core5.http.ssl.TLS;

@Internal
public final class ProtocolSwitchStrategy {
    public ProtocolVersion switchProtocol(HttpMessage response) throws ProtocolException {
        Iterator it = MessageSupport.iterateTokens((MessageHeaders)response, (String)"Upgrade");
        ProtocolVersion tlsUpgrade = null;
        while (it.hasNext()) {
            String token = (String)it.next();
            if (token.startsWith("TLS")) {
                try {
                    tlsUpgrade = token.length() == 3 ? TLS.V_1_2.getVersion() : TLS.parse((String)token.replace("TLS/", "TLSv"));
                    continue;
                }
                catch (ParseException ex) {
                    throw new ProtocolException("Invalid protocol: " + token);
                }
            }
            if (token.equals("HTTP/1.1")) continue;
            throw new ProtocolException("Unsupported protocol: " + token);
        }
        if (tlsUpgrade == null) {
            throw new ProtocolException("Invalid protocol switch response");
        }
        return tlsUpgrade;
    }

    static enum ProtocolSwitch {
        FAILURE,
        TLS;

    }
}

