/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.profile;

import java.io.IOException;
import java.util.concurrent.ExecutionException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.BitSet;
import org.opensearch.knn.index.SpaceType;
import org.opensearch.knn.index.VectorDataType;
import org.opensearch.knn.index.engine.KNNEngine;
import org.opensearch.knn.index.memory.NativeMemoryAllocation;
import org.opensearch.knn.index.query.DefaultKNNWeight;
import org.opensearch.knn.index.query.ExactSearcher;
import org.opensearch.knn.index.query.KNNQuery;
import org.opensearch.knn.index.query.SegmentLevelQuantizationInfo;
import org.opensearch.knn.profile.KNNProfileUtil;
import org.opensearch.knn.profile.LongMetric;
import org.opensearch.knn.profile.query.KNNQueryTimingType;
import org.opensearch.search.profile.ContextualProfileBreakdown;

public class ProfileDefaultKNNWeight
extends DefaultKNNWeight {
    protected final ContextualProfileBreakdown profile;

    public ProfileDefaultKNNWeight(KNNQuery query, float boost, Weight filterWeight, ContextualProfileBreakdown profile) {
        super(query, boost, filterWeight);
        this.profile = profile;
    }

    @Override
    protected BitSet getFilteredDocsBitSet(LeafReaderContext ctx) throws IOException {
        BitSet filterBitSet = (BitSet)KNNProfileUtil.profileBreakdown(this.profile, ctx, KNNQueryTimingType.BITSET_CREATION, () -> super.getFilteredDocsBitSet(ctx));
        LongMetric cardMetric = (LongMetric)this.profile.context((Object)ctx).getMetric("cardinality");
        cardMetric.setValue(Long.valueOf(filterBitSet.cardinality()));
        return filterBitSet;
    }

    @Override
    public TopDocs approximateSearch(LeafReaderContext context, BitSet filterIdsBitSet, int cardinality, int k) throws IOException {
        return (TopDocs)KNNProfileUtil.profileBreakdown(this.profile, context, KNNQueryTimingType.ANN_SEARCH, () -> super.approximateSearch(context, filterIdsBitSet, cardinality, k));
    }

    @Override
    public TopDocs exactSearch(LeafReaderContext leafReaderContext, ExactSearcher.ExactSearcherContext exactSearcherContext) throws IOException {
        return (TopDocs)KNNProfileUtil.profileBreakdown(this.profile, leafReaderContext, KNNQueryTimingType.EXACT_SEARCH, () -> super.exactSearch(leafReaderContext, exactSearcherContext));
    }

    @Override
    protected NativeMemoryAllocation loadGraph(SegmentReader reader, String cacheKey, SpaceType spaceType, KNNEngine knnEngine, KNNQuery knnQuery, VectorDataType vectorDataType, byte[] quantizedVector, SegmentLevelQuantizationInfo segmentLevelQuantizationInfo, String modelId, LeafReaderContext context) throws ExecutionException, IOException {
        return (NativeMemoryAllocation)KNNProfileUtil.profileBreakdown(this.profile, context, KNNQueryTimingType.GRAPH_LOAD, () -> {
            try {
                return super.loadGraph(reader, cacheKey, spaceType, knnEngine, knnQuery, vectorDataType, quantizedVector, segmentLevelQuantizationInfo, modelId, context);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
        });
    }
}

