/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.interpreter;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import sun.jvm.hotspot.interpreter.Bytecode;
import sun.jvm.hotspot.interpreter.BytecodeANewArray;
import sun.jvm.hotspot.interpreter.BytecodeBipush;
import sun.jvm.hotspot.interpreter.BytecodeCheckCast;
import sun.jvm.hotspot.interpreter.BytecodeGetField;
import sun.jvm.hotspot.interpreter.BytecodeGetStatic;
import sun.jvm.hotspot.interpreter.BytecodeGoto;
import sun.jvm.hotspot.interpreter.BytecodeGotoW;
import sun.jvm.hotspot.interpreter.BytecodeIf;
import sun.jvm.hotspot.interpreter.BytecodeIinc;
import sun.jvm.hotspot.interpreter.BytecodeInstanceOf;
import sun.jvm.hotspot.interpreter.BytecodeInvoke;
import sun.jvm.hotspot.interpreter.BytecodeJsr;
import sun.jvm.hotspot.interpreter.BytecodeJsrW;
import sun.jvm.hotspot.interpreter.BytecodeLoad;
import sun.jvm.hotspot.interpreter.BytecodeLoadConstant;
import sun.jvm.hotspot.interpreter.BytecodeLookupswitch;
import sun.jvm.hotspot.interpreter.BytecodeMultiANewArray;
import sun.jvm.hotspot.interpreter.BytecodeNew;
import sun.jvm.hotspot.interpreter.BytecodeNewArray;
import sun.jvm.hotspot.interpreter.BytecodePutField;
import sun.jvm.hotspot.interpreter.BytecodePutStatic;
import sun.jvm.hotspot.interpreter.BytecodeRet;
import sun.jvm.hotspot.interpreter.BytecodeSipush;
import sun.jvm.hotspot.interpreter.BytecodeStore;
import sun.jvm.hotspot.interpreter.BytecodeStream;
import sun.jvm.hotspot.interpreter.BytecodeTableswitch;
import sun.jvm.hotspot.interpreter.BytecodeVisitor;
import sun.jvm.hotspot.oops.Method;
import sun.jvm.hotspot.utilities.Assert;

public class BytecodeDisassembler {
    private Method method;
    private static Map bytecode2Class = new HashMap();

    private static void addBytecodeClass(int bytecode, Class clazz) {
        bytecode2Class.put(new Integer(bytecode), clazz);
    }

    private static Class getBytecodeClass(int bytecode) {
        return (Class)bytecode2Class.get(new Integer(bytecode));
    }

    public BytecodeDisassembler(Method method) {
        this.method = method;
    }

    public Method getMethod() {
        return this.method;
    }

    public void decode(BytecodeVisitor visitor) {
        visitor.prologue(this.method);
        BytecodeStream stream = new BytecodeStream(this.method);
        int javacode = -1;
        while ((javacode = stream.next()) != -1) {
            Bytecode bytecodeObj;
            int bci;
            block10: {
                Constructor cstr;
                Class<Bytecode> clazz;
                block9: {
                    bci = stream.bci();
                    int hotspotcode = this.method.getBytecodeOrBPAt(bci);
                    clazz = BytecodeDisassembler.getBytecodeClass(javacode);
                    if (clazz == null && (clazz = BytecodeDisassembler.getBytecodeClass(hotspotcode)) == null) {
                        clazz = Bytecode.class;
                    }
                    cstr = null;
                    try {
                        cstr = clazz.getDeclaredConstructor(Method.class, Integer.TYPE);
                    }
                    catch (NoSuchMethodException nomethod) {
                        if (!Assert.ASSERTS_ENABLED) break block9;
                        Assert.that(false, "Bytecode class without proper constructor!");
                    }
                }
                bytecodeObj = null;
                try {
                    bytecodeObj = (Bytecode)cstr.newInstance(this.method, new Integer(bci));
                }
                catch (Exception exp) {
                    if (!Assert.ASSERTS_ENABLED) break block10;
                    Assert.that(false, "Bytecode instance of class " + clazz.getName() + " can not be created!");
                }
            }
            if (stream.isWide()) {
                visitor.visit(new Bytecode(this.method, bci - 1));
            }
            try {
                visitor.visit(bytecodeObj);
            }
            catch (ClassCastException castfail) {
                castfail.printStackTrace();
                System.err.println(this.method.getAddress() + " " + bci);
            }
        }
        visitor.epilogue();
    }

    static {
        BytecodeDisassembler.addBytecodeClass(189, BytecodeANewArray.class);
        BytecodeDisassembler.addBytecodeClass(16, BytecodeBipush.class);
        BytecodeDisassembler.addBytecodeClass(192, BytecodeCheckCast.class);
        BytecodeDisassembler.addBytecodeClass(180, BytecodeGetField.class);
        BytecodeDisassembler.addBytecodeClass(178, BytecodeGetStatic.class);
        BytecodeDisassembler.addBytecodeClass(167, BytecodeGoto.class);
        BytecodeDisassembler.addBytecodeClass(200, BytecodeGotoW.class);
        BytecodeDisassembler.addBytecodeClass(153, BytecodeIf.class);
        BytecodeDisassembler.addBytecodeClass(154, BytecodeIf.class);
        BytecodeDisassembler.addBytecodeClass(155, BytecodeIf.class);
        BytecodeDisassembler.addBytecodeClass(156, BytecodeIf.class);
        BytecodeDisassembler.addBytecodeClass(157, BytecodeIf.class);
        BytecodeDisassembler.addBytecodeClass(158, BytecodeIf.class);
        BytecodeDisassembler.addBytecodeClass(159, BytecodeIf.class);
        BytecodeDisassembler.addBytecodeClass(160, BytecodeIf.class);
        BytecodeDisassembler.addBytecodeClass(161, BytecodeIf.class);
        BytecodeDisassembler.addBytecodeClass(162, BytecodeIf.class);
        BytecodeDisassembler.addBytecodeClass(163, BytecodeIf.class);
        BytecodeDisassembler.addBytecodeClass(164, BytecodeIf.class);
        BytecodeDisassembler.addBytecodeClass(165, BytecodeIf.class);
        BytecodeDisassembler.addBytecodeClass(166, BytecodeIf.class);
        BytecodeDisassembler.addBytecodeClass(198, BytecodeIf.class);
        BytecodeDisassembler.addBytecodeClass(199, BytecodeIf.class);
        BytecodeDisassembler.addBytecodeClass(132, BytecodeIinc.class);
        BytecodeDisassembler.addBytecodeClass(193, BytecodeInstanceOf.class);
        BytecodeDisassembler.addBytecodeClass(182, BytecodeInvoke.class);
        BytecodeDisassembler.addBytecodeClass(184, BytecodeInvoke.class);
        BytecodeDisassembler.addBytecodeClass(183, BytecodeInvoke.class);
        BytecodeDisassembler.addBytecodeClass(185, BytecodeInvoke.class);
        BytecodeDisassembler.addBytecodeClass(186, BytecodeInvoke.class);
        BytecodeDisassembler.addBytecodeClass(168, BytecodeJsr.class);
        BytecodeDisassembler.addBytecodeClass(201, BytecodeJsrW.class);
        BytecodeDisassembler.addBytecodeClass(21, BytecodeLoad.class);
        BytecodeDisassembler.addBytecodeClass(22, BytecodeLoad.class);
        BytecodeDisassembler.addBytecodeClass(23, BytecodeLoad.class);
        BytecodeDisassembler.addBytecodeClass(24, BytecodeLoad.class);
        BytecodeDisassembler.addBytecodeClass(25, BytecodeLoad.class);
        BytecodeDisassembler.addBytecodeClass(18, BytecodeLoadConstant.class);
        BytecodeDisassembler.addBytecodeClass(19, BytecodeLoadConstant.class);
        BytecodeDisassembler.addBytecodeClass(20, BytecodeLoadConstant.class);
        BytecodeDisassembler.addBytecodeClass(171, BytecodeLookupswitch.class);
        BytecodeDisassembler.addBytecodeClass(197, BytecodeMultiANewArray.class);
        BytecodeDisassembler.addBytecodeClass(187, BytecodeNew.class);
        BytecodeDisassembler.addBytecodeClass(188, BytecodeNewArray.class);
        BytecodeDisassembler.addBytecodeClass(181, BytecodePutField.class);
        BytecodeDisassembler.addBytecodeClass(179, BytecodePutStatic.class);
        BytecodeDisassembler.addBytecodeClass(169, BytecodeRet.class);
        BytecodeDisassembler.addBytecodeClass(17, BytecodeSipush.class);
        BytecodeDisassembler.addBytecodeClass(54, BytecodeStore.class);
        BytecodeDisassembler.addBytecodeClass(55, BytecodeStore.class);
        BytecodeDisassembler.addBytecodeClass(56, BytecodeStore.class);
        BytecodeDisassembler.addBytecodeClass(57, BytecodeStore.class);
        BytecodeDisassembler.addBytecodeClass(58, BytecodeStore.class);
        BytecodeDisassembler.addBytecodeClass(170, BytecodeTableswitch.class);
    }
}

