/*
 * Decompiled with CFR 0.152.
 */
package git4idea.commands;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.ThrowableConsumer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public final class GitHandlerInputProcessorUtil {
    private static final String DEFAULT_SEPARATOR = "\n";

    private GitHandlerInputProcessorUtil() {
    }

    @NotNull
    public static ThrowableConsumer<OutputStream, IOException> writeLines(@NotNull Collection<String> lines, @NotNull Charset charset) {
        if (lines == null) {
            GitHandlerInputProcessorUtil.$$$reportNull$$$0(0);
        }
        if (charset == null) {
            GitHandlerInputProcessorUtil.$$$reportNull$$$0(1);
        }
        return GitHandlerInputProcessorUtil.writeLines(lines, DEFAULT_SEPARATOR, charset, false);
    }

    @NotNull
    public static ThrowableConsumer<OutputStream, IOException> writeLines(@NotNull Collection<String> lines, @NotNull String separator, @NotNull Charset charset, boolean endWithSecondSeparator) {
        if (lines == null) {
            GitHandlerInputProcessorUtil.$$$reportNull$$$0(2);
        }
        if (separator == null) {
            GitHandlerInputProcessorUtil.$$$reportNull$$$0(3);
        }
        if (charset == null) {
            GitHandlerInputProcessorUtil.$$$reportNull$$$0(4);
        }
        ThrowableConsumer throwableConsumer = stream -> {
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)stream, charset);){
                for (String line : lines) {
                    writer.write(line);
                    writer.write(separator);
                }
                if (endWithSecondSeparator) {
                    writer.write(separator);
                }
                writer.flush();
            }
        };
        if (throwableConsumer == null) {
            GitHandlerInputProcessorUtil.$$$reportNull$$$0(5);
        }
        return throwableConsumer;
    }

    @NotNull
    public static ThrowableConsumer<OutputStream, IOException> redirectStream(@NotNull InputStream stream) {
        if (stream == null) {
            GitHandlerInputProcessorUtil.$$$reportNull$$$0(6);
        }
        ThrowableConsumer throwableConsumer = outputStream2 -> {
            try (OutputStream outputStream3 = outputStream2;){
                FileUtil.copy((InputStream)stream, (OutputStream)outputStream2);
            }
        };
        if (throwableConsumer == null) {
            GitHandlerInputProcessorUtil.$$$reportNull$$$0(7);
        }
        return throwableConsumer;
    }

    @NotNull
    public static ThrowableConsumer<OutputStream, IOException> empty() {
        ThrowableConsumer throwableConsumer = outputStream2 -> outputStream2.close();
        if (throwableConsumer == null) {
            GitHandlerInputProcessorUtil.$$$reportNull$$$0(8);
        }
        return throwableConsumer;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lines";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charset";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separator";
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/commands/GitHandlerInputProcessorUtil";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/commands/GitHandlerInputProcessorUtil";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "writeLines";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "redirectStream";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "empty";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "writeLines";
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "redirectStream";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 7, 8 -> new IllegalStateException(string);
        };
    }
}

