/*
 * Decompiled with CFR 0.152.
 */
package util;

import ghidra.util.datastruct.FixedSizeStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;

public class HistoryList<T> {
    private final FixedSizeStack<T> historyStack;
    private final BiConsumer<T, T> itemSelectedCallback;
    private int historyIndex;
    private boolean isBroadcasting;
    private boolean allowDuplicates;
    private boolean allowsNulls;

    public HistoryList(int size, Consumer<T> itemSelectedCallback) {
        this(size, HistoryList.asBiConsumer(itemSelectedCallback));
    }

    public HistoryList(int size, BiConsumer<T, T> itemSelectedCallback) {
        Objects.requireNonNull(itemSelectedCallback, "Item selected callback cannot be null");
        if (size < 1) {
            throw new IllegalArgumentException("Size cannot be less than 1");
        }
        this.itemSelectedCallback = itemSelectedCallback;
        this.historyStack = new FixedSizeStack(size);
    }

    private static <T> BiConsumer<T, T> asBiConsumer(Consumer<T> consumer) {
        return (t, ignored) -> consumer.accept(t);
    }

    public void setAllowDuplicates(boolean allowDuplicates) {
        this.allowDuplicates = allowDuplicates;
    }

    public void setAllowNulls(boolean allowNulls) {
        this.allowsNulls = allowNulls;
    }

    public void add(T t) {
        if (this.isBroadcasting) {
            return;
        }
        if (this.ignoreItem(t)) {
            return;
        }
        this.dropNull();
        this.trimHistoryToCurrentIndex();
        this.handleDuplicate(t);
        this.historyStack.push(t);
        this.historyIndex = this.historyStack.size() - 1;
    }

    public boolean hasNext() {
        boolean hasNext = this.historyIndex < this.historyStack.size() - 1;
        return hasNext;
    }

    public boolean hasPrevious() {
        boolean hasPrevious = this.historyIndex > 0;
        return hasPrevious;
    }

    public void goBack() {
        if (this.historyIndex == 0) {
            return;
        }
        T leaving = this.getCurrentHistoryItem();
        Object t = this.historyStack.get(--this.historyIndex);
        this.dropNull();
        this.broadcast(t, leaving);
    }

    public void goBackTo(T t) {
        while (!this.getCurrentHistoryItem().equals(t) && this.hasPrevious()) {
            this.goBack();
        }
    }

    public void goForward() {
        if (this.historyIndex >= this.historyStack.size() - 1) {
            return;
        }
        T leaving = this.getCurrentHistoryItem();
        Object t = this.historyStack.get(++this.historyIndex);
        this.broadcast(t, leaving);
    }

    public void goForwardTo(T t) {
        while (!this.getCurrentHistoryItem().equals(t) && this.hasNext()) {
            this.goForward();
        }
    }

    public T getCurrentHistoryItem() {
        if (this.historyStack.isEmpty()) {
            return null;
        }
        return (T)this.historyStack.get(this.historyIndex);
    }

    public List<T> getPreviousHistoryItems() {
        ArrayList list = new ArrayList();
        for (int i = this.historyIndex - 1; i >= 0; --i) {
            list.add(this.historyStack.get(i));
        }
        return list;
    }

    public List<T> getNextHistoryItems() {
        int nextIndex;
        ArrayList list = new ArrayList();
        for (int i = nextIndex = this.historyIndex + 1; i < this.historyStack.size(); ++i) {
            list.add(this.historyStack.get(i));
        }
        return list;
    }

    public void clear() {
        this.historyStack.clear();
        this.historyIndex = 0;
    }

    public int size() {
        return this.historyStack.size();
    }

    private boolean ignoreItem(T t) {
        if (this.ignoreNull(t)) {
            return true;
        }
        if (t == null) {
            return false;
        }
        return t.equals(this.getCurrentHistoryItem());
    }

    private boolean ignoreNull(T t) {
        if (t != null) {
            return false;
        }
        if (!this.allowsNulls) {
            return true;
        }
        if (!this.isAtEnd()) {
            return true;
        }
        return this.historyStack.peek() == null;
    }

    private void dropNull() {
        if (this.historyStack.peek() == null) {
            this.historyStack.pop();
        }
    }

    private boolean isAtEnd() {
        return this.historyIndex == this.historyStack.size() - 1;
    }

    FixedSizeStack<T> getHistoryStack() {
        return this.historyStack;
    }

    private void handleDuplicate(T t) {
        if (this.allowDuplicates) {
            return;
        }
        int itemIndex = this.historyStack.search(t);
        if (itemIndex == -1) {
            return;
        }
        this.historyStack.remove(itemIndex);
    }

    private void broadcast(T t, T leaving) {
        try {
            this.isBroadcasting = true;
            this.itemSelectedCallback.accept(t, leaving);
        }
        finally {
            this.isBroadcasting = false;
        }
    }

    private void trimHistoryToCurrentIndex() {
        int upcomingIndex = this.historyIndex + 1;
        while (this.historyStack.size() > upcomingIndex) {
            this.historyStack.pop();
        }
    }

    public String toString() {
        String key = "    items: ";
        String newlinePad = StringUtils.repeat((char)' ', (int)key.length());
        StringBuilder buffy = new StringBuilder();
        for (int i = 0; i < this.historyStack.size(); ++i) {
            Object t = this.historyStack.get(i);
            if (t == null) continue;
            if (i == this.historyIndex) {
                buffy.append('[').append(t.toString()).append(']');
            } else {
                buffy.append(t.toString());
            }
            if (i == this.historyStack.size() - 1) continue;
            buffy.append(',').append('\n').append(newlinePad);
        }
        return "{\n" + key + buffy.toString() + "\n}";
    }
}

