/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.map;

import db.DBFieldIterator;
import db.DBLongIterator;
import db.Field;
import db.LongField;
import db.Table;
import ghidra.program.database.map.AddressMap;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.KeyRange;
import java.io.IOException;
import java.util.List;
import java.util.NoSuchElementException;

public class AddressIndexKeyIterator
implements DBLongIterator {
    private Table table;
    private List<KeyRange> keyRangeList;
    private DBFieldIterator it;
    private int keyRangeIndex = -1;
    private int indexCol;

    public AddressIndexKeyIterator() {
    }

    public AddressIndexKeyIterator(Table table, int indexCol, AddressMap addrMap, boolean atStart) throws IOException {
        this(table, indexCol, addrMap, false, (AddressSetView)null, atStart);
    }

    public AddressIndexKeyIterator(Table table, int indexCol, AddressMap addrMap, Address minAddr, Address maxAddr, boolean atStart) throws IOException {
        this(table, indexCol, addrMap, false, new AddressSet(minAddr, maxAddr), atStart);
    }

    public AddressIndexKeyIterator(Table table, int indexCol, AddressMap addrMap, AddressSetView set, boolean atStart) throws IOException {
        this(table, indexCol, addrMap, false, set, atStart);
    }

    public AddressIndexKeyIterator(Table table, int indexCol, AddressMap addrMap, boolean absolute, AddressSetView set, boolean atStart) throws IOException {
        this.table = table;
        this.indexCol = indexCol;
        this.keyRangeList = addrMap.getKeyRanges(set, absolute, false);
        if (this.keyRangeList.size() == 0) {
            return;
        }
        if (atStart) {
            this.keyRangeIndex = 0;
            KeyRange keyRange = this.keyRangeList.get(this.keyRangeIndex);
            this.it = table.indexFieldIterator((Field)new LongField(keyRange.minKey), (Field)new LongField(keyRange.maxKey), true, indexCol);
        } else {
            this.keyRangeIndex = this.keyRangeList.size() - 1;
            KeyRange keyRange = this.keyRangeList.get(this.keyRangeIndex);
            this.it = table.indexFieldIterator((Field)new LongField(keyRange.minKey), (Field)new LongField(keyRange.maxKey), false, indexCol);
        }
    }

    public AddressIndexKeyIterator(Table table, int indexCol, AddressMap addrMap, Address start, boolean before) throws IOException {
        this(table, indexCol, addrMap, false, start, before);
    }

    AddressIndexKeyIterator(Table table, int indexCol, AddressMap addrMap, boolean absolute, Address start, boolean before) throws IOException {
        this.table = table;
        this.indexCol = indexCol;
        this.keyRangeList = addrMap.getKeyRanges(null, absolute, false);
        this.keyRangeIndex = addrMap.findKeyRange(this.keyRangeList, start);
        if (this.keyRangeList.size() == 0) {
            return;
        }
        if (this.keyRangeIndex < 0) {
            this.keyRangeIndex = -this.keyRangeIndex - 1;
            if (this.keyRangeIndex == 0) {
                KeyRange keyRange = this.keyRangeList.get(this.keyRangeIndex);
                this.it = table.indexFieldIterator((Field)new LongField(keyRange.minKey), (Field)new LongField(keyRange.maxKey), true, indexCol);
            } else {
                KeyRange keyRange = this.keyRangeList.get(--this.keyRangeIndex);
                this.it = table.indexFieldIterator((Field)new LongField(keyRange.minKey), (Field)new LongField(keyRange.maxKey), false, indexCol);
            }
        } else {
            KeyRange keyRange = this.keyRangeList.get(this.keyRangeIndex);
            long startKey = absolute ? addrMap.getAbsoluteEncoding(start, false) : addrMap.getKey(start, false);
            this.it = table.indexFieldIterator((Field)new LongField(keyRange.minKey), (Field)new LongField(keyRange.maxKey), (Field)new LongField(startKey), before, indexCol);
        }
    }

    public boolean hasNext() throws IOException {
        if (this.it == null) {
            return false;
        }
        if (!this.it.hasNext()) {
            while (this.keyRangeIndex < this.keyRangeList.size() - 1) {
                KeyRange keyRange = this.keyRangeList.get(++this.keyRangeIndex);
                this.it = this.table.indexFieldIterator((Field)new LongField(keyRange.minKey), (Field)new LongField(keyRange.maxKey), true, this.indexCol);
                if (this.it.hasPrevious()) {
                    this.it.previous();
                }
                if (!this.it.hasNext()) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public boolean hasPrevious() throws IOException {
        if (this.it == null) {
            return false;
        }
        if (!this.it.hasPrevious()) {
            while (this.keyRangeIndex > 0) {
                KeyRange keyRange = this.keyRangeList.get(--this.keyRangeIndex);
                this.it = this.table.indexFieldIterator((Field)new LongField(keyRange.minKey), (Field)new LongField(keyRange.maxKey), false, this.indexCol);
                if (this.it.hasNext()) {
                    this.it.next();
                }
                if (!this.it.hasPrevious()) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public long next() throws IOException {
        if (this.hasNext()) {
            return ((LongField)this.it.next()).getLongValue();
        }
        throw new NoSuchElementException();
    }

    public long previous() throws IOException {
        if (this.hasPrevious()) {
            return ((LongField)this.it.previous()).getLongValue();
        }
        throw new NoSuchElementException();
    }

    public boolean delete() throws IOException {
        if (this.it != null) {
            return this.it.delete();
        }
        return false;
    }
}

