/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.api.util;

import ghidra.app.util.dialog.CheckoutDialog;
import ghidra.app.util.task.ProgramOpener;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.remote.User;
import ghidra.program.database.ProgramDB;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

public class VTSessionFileUtil {
    private VTSessionFileUtil() {
    }

    public static void validateSourceProgramFile(DomainFile file, boolean includeFilePathInError) throws IllegalArgumentException {
        Object error = null;
        if (!ProgramDB.class.isAssignableFrom(file.getDomainObjectClass())) {
            error = "Source file does not correspond to a Program";
        }
        if (error != null) {
            if (includeFilePathInError) {
                error = (String)error + ":\n" + file.getPathname();
            }
            throw new IllegalArgumentException((String)error);
        }
    }

    public static void validateDestinationProgramFile(DomainFile file, boolean includeFilePathInError, boolean silent) throws IllegalArgumentException {
        Object error = null;
        if (!ProgramDB.class.isAssignableFrom(file.getDomainObjectClass())) {
            error = "Destination file does not correspond to a Program";
        } else {
            DomainFolder folder = file.getParent();
            if (folder == null || !folder.isInWritableProject()) {
                error = "Destination file must be from active project";
            } else if (file.isReadOnly()) {
                error = "Destination file must not be read-only";
            } else if (file.isVersioned()) {
                if (!silent) {
                    VTSessionFileUtil.doOptionalDestinationProgramCheckout(file);
                }
                if (!file.isCheckedOut()) {
                    error = "Versioned destination file must be checked-out for update";
                }
            }
        }
        if (error != null) {
            if (includeFilePathInError) {
                error = (String)error + ":\n" + file.getPathname();
            }
            throw new IllegalArgumentException((String)error);
        }
    }

    public static boolean canUpdate(DomainFile file) {
        DomainFolder folder = file.getParent();
        if (folder == null || !folder.isInWritableProject()) {
            return false;
        }
        if (file.isReadOnly()) {
            return false;
        }
        return !file.isVersioned();
    }

    private static void doOptionalDestinationProgramCheckout(DomainFile file) {
        if (SystemUtilities.isInHeadlessMode() || !file.canCheckout()) {
            return;
        }
        User user = file.getParent().getProjectData().getUser();
        CheckoutDialog dialog = new CheckoutDialog(file, user);
        dialog.setTitle("VT Destination Program not Checked Out");
        if (dialog.showDialog() == 0) {
            CheckoutDestinationProgramTask task = new CheckoutDestinationProgramTask(file, dialog.exclusiveCheckout());
            TaskLauncher.launch((Task)task);
        }
    }

    private static class CheckoutDestinationProgramTask
    extends Task {
        private DomainFile file;
        boolean exclusiveCheckout;

        CheckoutDestinationProgramTask(DomainFile file, boolean exclusiveCheckout) {
            super("Checking Out " + String.valueOf(file), true, true, true, true);
            this.file = file;
            this.exclusiveCheckout = exclusiveCheckout;
        }

        public void run(TaskMonitor monitor) throws CancelledException {
            monitor.setMessage("Checking Out " + String.valueOf(this.file));
            try {
                if (!this.file.checkout(this.exclusiveCheckout, monitor)) {
                    Msg.showError(ProgramOpener.class, null, (String)"Checkout Failed", (Object)("Exclusive checkout failed for: " + String.valueOf(this.file) + "\nOne or more users have file checked out!"));
                }
            }
            catch (IOException e) {
                Msg.showError(ProgramOpener.class, null, (String)"Checkout Failed", (Object)("Checkout failed for: " + String.valueOf(this.file) + "\n" + e.getMessage()));
            }
            catch (CancelledException cancelledException) {
                // empty catch block
            }
        }
    }
}

