/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.art.headers;

import ghidra.app.util.bin.BinaryReader;
import ghidra.file.formats.android.art.ArtBlock;
import ghidra.file.formats.android.art.ArtHeader;
import ghidra.file.formats.android.art.ArtImageSections;
import ghidra.file.formats.android.art.ArtImageSectionsFactory;
import ghidra.file.formats.android.art.image_method.ImageMethod_Q;
import ghidra.file.formats.android.util.DecompressionManager;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Structure;
import ghidra.program.model.listing.Program;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ArtHeader_074
extends ArtHeader {
    private int image_reservation_size_;
    private int component_count_;
    private int image_begin_;
    private int image_size_;
    private int image_checksum_;
    private int oat_checksum_;
    private int oat_file_begin_;
    private int oat_data_begin_;
    private int oat_data_end_;
    private int oat_file_end_;
    private int boot_image_begin_;
    private int boot_image_size_;
    private int image_roots_;
    private int pointer_size_;
    private long[] image_methods_ = new long[ImageMethod_Q.kImageMethodsCount.ordinal()];
    private int data_size_;
    private int blocks_offset_;
    private int blocks_count_;
    private List<ArtBlock> blocks = new ArrayList<ArtBlock>();
    private ArtImageSections sections;

    public ArtHeader_074(BinaryReader reader) throws IOException {
        super(reader);
        this.parse(reader);
    }

    @Override
    protected void parse(BinaryReader reader) throws IOException {
        this.image_reservation_size_ = reader.readNextInt();
        this.component_count_ = reader.readNextInt();
        this.image_begin_ = reader.readNextInt();
        this.image_size_ = reader.readNextInt();
        this.image_checksum_ = reader.readNextInt();
        this.oat_checksum_ = reader.readNextInt();
        this.oat_file_begin_ = reader.readNextInt();
        this.oat_data_begin_ = reader.readNextInt();
        this.oat_data_end_ = reader.readNextInt();
        this.oat_file_end_ = reader.readNextInt();
        this.boot_image_begin_ = reader.readNextInt();
        this.boot_image_size_ = reader.readNextInt();
        this.image_roots_ = reader.readNextInt();
        this.pointer_size_ = reader.readNextInt();
        this.sections = ArtImageSectionsFactory.getArtImageSections(reader, this);
        this.sections.parseSections(reader);
        this.parseImageMethods(reader);
        this.data_size_ = reader.readNextInt();
        this.blocks_offset_ = reader.readNextInt();
        this.blocks_count_ = reader.readNextInt();
        if (this.blocks_offset_ > 0 && this.blocks_count_ > 0) {
            reader.setPointerIndex(this.blocks_offset_);
            for (int i = 0; i < this.blocks_count_; ++i) {
                this.blocks.add(new ArtBlock(reader));
            }
        }
        reader = DecompressionManager.decompress(reader, this.blocks, TaskMonitor.DUMMY);
        this.sections.parse(reader);
    }

    @Override
    public int getArtMethodCountForVersion() {
        return ImageMethod_Q.kImageMethodsCount.ordinal();
    }

    @Override
    public int getImageBegin() {
        return this.image_begin_;
    }

    @Override
    public int getImageSize() {
        return this.image_size_;
    }

    public int getImageChecksum_() {
        return this.image_checksum_;
    }

    @Override
    public int getOatChecksum() {
        return this.oat_checksum_;
    }

    @Override
    public int getOatDataBegin() {
        return this.oat_data_begin_;
    }

    @Override
    public int getOatDataEnd() {
        return this.oat_data_end_;
    }

    @Override
    public int getOatFileBegin() {
        return this.oat_file_begin_;
    }

    @Override
    public int getOatFileEnd() {
        return this.oat_file_end_;
    }

    @Override
    public int getPointerSize() {
        return this.pointer_size_;
    }

    public int getBootImageBegin() {
        return this.boot_image_begin_;
    }

    public boolean isAppImage() {
        return this.boot_image_size_ != 0;
    }

    public int getImageReservationSize() {
        return this.image_reservation_size_;
    }

    public int getComponentCount() {
        return this.component_count_;
    }

    public int getImageRoots() {
        return this.image_roots_;
    }

    public int getDataSize() {
        return this.data_size_;
    }

    public List<ArtBlock> getBlocks() {
        return this.blocks;
    }

    @Override
    public void markup(Program program, TaskMonitor monitor) throws Exception {
        DecompressionManager.decompressOverMemory(program, this.blocks, monitor);
        this.sections.markup(program, monitor);
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        int i;
        Structure structure = (Structure)super.toDataType();
        structure.add(DWORD, "image_reservation_size_", null);
        structure.add(DWORD, "component_count_", null);
        structure.add(DWORD, "image_begin_", null);
        structure.add(DWORD, "image_size_", null);
        structure.add(DWORD, "image_checksum_", null);
        structure.add(DWORD, "oat_checksum_", null);
        structure.add(DWORD, "oat_file_begin_", null);
        structure.add(DWORD, "oat_data_begin_", null);
        structure.add(DWORD, "oat_data_end_", null);
        structure.add(DWORD, "oat_file_end_", null);
        structure.add(DWORD, "boot_image_begin_", null);
        structure.add(DWORD, "boot_image_size_", null);
        structure.add(DWORD, "image_roots_", null);
        structure.add(DWORD, "pointer_size_", null);
        for (i = 0; i < this.sections.getSectionList().size(); ++i) {
            structure.add(this.sections.getSectionList().get(i).toDataType(), "section_" + i, null);
        }
        for (i = 0; i < this.image_methods_.length; ++i) {
            structure.add(QWORD, "image_method_" + i, null);
        }
        structure.add(DWORD, "data_size_", null);
        structure.add(DWORD, "blocks_offset_", null);
        structure.add(DWORD, "blocks_count_", null);
        return structure;
    }
}

