/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.fun;

import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;

public class SqlPositionFunction
extends SqlFunction {
    private static final SqlOperandTypeChecker OTC_CUSTOM = OperandTypes.STRING_SAME_SAME.or(OperandTypes.STRING_SAME_SAME_INTEGER).or(OperandTypes.sequence("INSTR(<STRING>, <STRING>, <INTEGER>, <INTEGER>)", OperandTypes.STRING, OperandTypes.STRING, OperandTypes.INTEGER, OperandTypes.INTEGER));

    public SqlPositionFunction(String name) {
        super(name, SqlKind.POSITION, ReturnTypes.INTEGER_NULLABLE, null, OTC_CUSTOM, SqlFunctionCategory.NUMERIC);
    }

    @Override
    public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        SqlWriter.Frame frame = writer.startFunCall(this.getName());
        if (call.operandCount() == 2 || call.operandCount() == 3) {
            ((SqlNode)call.operand(0)).unparse(writer, leftPrec, rightPrec);
            writer.sep("IN");
            ((SqlNode)call.operand(1)).unparse(writer, leftPrec, rightPrec);
            if (call.operandCount() == 3) {
                writer.sep("FROM");
                ((SqlNode)call.operand(2)).unparse(writer, leftPrec, rightPrec);
            }
        }
        if (call.operandCount() == 4) {
            ((SqlNode)call.operand(0)).unparse(writer, leftPrec, rightPrec);
            writer.sep(",");
            ((SqlNode)call.operand(1)).unparse(writer, leftPrec, rightPrec);
            writer.sep(",");
            ((SqlNode)call.operand(2)).unparse(writer, leftPrec, rightPrec);
            writer.sep(",");
            ((SqlNode)call.operand(3)).unparse(writer, leftPrec, rightPrec);
        }
        writer.endFunCall(frame);
    }

    @Override
    public String getSignatureTemplate(int operandsCount) {
        switch (operandsCount) {
            case 2: {
                return "{0}({1} IN {2})";
            }
            case 3: {
                return "{0}({1} IN {2} FROM {3})";
            }
            case 4: {
                return "{0}({1}, {2}, {3}, {4})";
            }
        }
        throw new AssertionError();
    }

    @Override
    public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
        switch (callBinding.getOperandCount()) {
            case 2: {
                return OperandTypes.SAME_SAME.checkOperandTypes(callBinding, throwOnFailure) && super.checkOperandTypes(callBinding, throwOnFailure);
            }
            case 3: {
                return OperandTypes.SAME_SAME_INTEGER.checkOperandTypes(callBinding, throwOnFailure) && super.checkOperandTypes(callBinding, throwOnFailure);
            }
            case 4: {
                return OperandTypes.sequence("INSTR(<STRING>, <STRING>, <INTEGER>, <INTEGER>)", OperandTypes.STRING, OperandTypes.STRING, OperandTypes.INTEGER, OperandTypes.INTEGER).checkOperandTypes(callBinding, throwOnFailure) && super.checkOperandTypes(callBinding, throwOnFailure);
            }
        }
        throw new AssertionError();
    }
}

