/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.compiler;

import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.compiler.BinaryOps;
import com.oracle.graal.python.compiler.Block;
import com.oracle.graal.python.compiler.BlockInfo;
import com.oracle.graal.python.compiler.BytecodeCodeUnit;
import com.oracle.graal.python.compiler.CodeUnit;
import com.oracle.graal.python.compiler.CompilationScope;
import com.oracle.graal.python.compiler.CompilationUnit;
import com.oracle.graal.python.compiler.Instruction;
import com.oracle.graal.python.compiler.OpCodes;
import com.oracle.graal.python.compiler.SSTUtils;
import com.oracle.graal.python.compiler.UnaryOps;
import com.oracle.graal.python.compiler.Unparser;
import com.oracle.graal.python.lib.PyObjectRichCompareBool;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.pegparser.AbstractParser;
import com.oracle.graal.python.pegparser.FutureFeature;
import com.oracle.graal.python.pegparser.InputType;
import com.oracle.graal.python.pegparser.Parser;
import com.oracle.graal.python.pegparser.ParserCallbacks;
import com.oracle.graal.python.pegparser.scope.Scope;
import com.oracle.graal.python.pegparser.scope.ScopeEnvironment;
import com.oracle.graal.python.pegparser.sst.AliasTy;
import com.oracle.graal.python.pegparser.sst.ArgTy;
import com.oracle.graal.python.pegparser.sst.ArgumentsTy;
import com.oracle.graal.python.pegparser.sst.BoolOpTy;
import com.oracle.graal.python.pegparser.sst.CmpOpTy;
import com.oracle.graal.python.pegparser.sst.ComprehensionTy;
import com.oracle.graal.python.pegparser.sst.ConstantValue;
import com.oracle.graal.python.pegparser.sst.ExceptHandlerTy;
import com.oracle.graal.python.pegparser.sst.ExprContextTy;
import com.oracle.graal.python.pegparser.sst.ExprTy;
import com.oracle.graal.python.pegparser.sst.KeywordTy;
import com.oracle.graal.python.pegparser.sst.MatchCaseTy;
import com.oracle.graal.python.pegparser.sst.ModTy;
import com.oracle.graal.python.pegparser.sst.OperatorTy;
import com.oracle.graal.python.pegparser.sst.PatternTy;
import com.oracle.graal.python.pegparser.sst.SSTNode;
import com.oracle.graal.python.pegparser.sst.SSTreeVisitor;
import com.oracle.graal.python.pegparser.sst.StmtTy;
import com.oracle.graal.python.pegparser.sst.TypeIgnoreTy;
import com.oracle.graal.python.pegparser.sst.TypeParamTy;
import com.oracle.graal.python.pegparser.sst.UnaryOpTy;
import com.oracle.graal.python.pegparser.sst.WithItemTy;
import com.oracle.graal.python.pegparser.tokenizer.SourceRange;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.graal.python.util.SuppressFBWarnings;
import com.oracle.truffle.api.memory.ByteArraySupport;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class Compiler
implements SSTreeVisitor<Void> {
    public static final int BYTECODE_VERSION = 29;
    private final ParserCallbacks parserCallbacks;
    ScopeEnvironment env;
    EnumSet<Flags> flags = EnumSet.noneOf(Flags.class);
    EnumSet<FutureFeature> futureFeatures = EnumSet.noneOf(FutureFeature.class);
    int futureLineno = -1;
    int optimizationLevel = 0;
    int nestingLevel = 0;
    CompilationUnit unit;
    List<CompilationUnit> stack = new ArrayList<CompilationUnit>();
    private boolean interactive;
    private List<Instruction> quickeningStack = new ArrayList<Instruction>();

    public Compiler(ParserCallbacks parserCallbacks) {
        this.parserCallbacks = parserCallbacks;
    }

    public CompilationUnit compile(ModTy mod, EnumSet<Flags> flags, int optimizationLevel, EnumSet<FutureFeature> futureFeatures) {
        this.flags = flags;
        if (mod instanceof ModTy.Module) {
            this.futureLineno = Compiler.parseFuture(((ModTy.Module)mod).body, futureFeatures, this.parserCallbacks);
        } else if (mod instanceof ModTy.Interactive) {
            this.futureLineno = Compiler.parseFuture(((ModTy.Interactive)mod).body, futureFeatures, this.parserCallbacks);
        }
        this.futureFeatures.addAll(futureFeatures);
        this.env = ScopeEnvironment.analyze(mod, this.parserCallbacks, this.futureFeatures);
        this.optimizationLevel = optimizationLevel;
        this.enterScope("<module>", CompilationScope.Module, mod);
        mod.accept(this);
        CompilationUnit topUnit = this.unit;
        this.exitScope();
        return topUnit;
    }

    public static int parseFuture(StmtTy[] modBody, EnumSet<FutureFeature> futureFeatures, ParserCallbacks parserCallbacks) {
        int lastFutureLine = -1;
        if (modBody == null || modBody.length == 0) {
            return lastFutureLine;
        }
        boolean done = false;
        int prevLine = 0;
        int i = 0;
        if (Compiler.findDocstring(modBody) != null) {
            ++i;
        }
        while (i < modBody.length) {
            StmtTy s = modBody[i];
            int line = s.getSourceRange().startLine;
            if (done && line > prevLine) {
                return lastFutureLine;
            }
            prevLine = line;
            if (s instanceof StmtTy.ImportFrom) {
                StmtTy.ImportFrom importFrom = (StmtTy.ImportFrom)s;
                if ("__future__".equals(importFrom.module)) {
                    if (done) {
                        throw parserCallbacks.onError(ParserCallbacks.ErrorType.Syntax, s.getSourceRange(), "from __future__ imports must occur at the beginning of the file");
                    }
                    Compiler.parseFutureFeatures(importFrom, futureFeatures, parserCallbacks);
                    lastFutureLine = line;
                } else {
                    done = true;
                }
            } else {
                done = true;
            }
            ++i;
        }
        return lastFutureLine;
    }

    private static void parseFutureFeatures(StmtTy.ImportFrom node, EnumSet<FutureFeature> features, ParserCallbacks parserCallbacks) {
        block19: for (AliasTy alias : node.names) {
            if (alias.name == null) continue;
            switch (alias.name) {
                case "nested_scopes": 
                case "generators": 
                case "division": 
                case "absolute_import": 
                case "with_statement": 
                case "print_function": 
                case "unicode_literals": 
                case "generator_stop": {
                    continue block19;
                }
                case "barry_as_FLUFL": {
                    features.add(FutureFeature.BARRY_AS_BDFL);
                    continue block19;
                }
                case "annotations": {
                    features.add(FutureFeature.ANNOTATIONS);
                    continue block19;
                }
                case "braces": {
                    throw parserCallbacks.onError(ParserCallbacks.ErrorType.Syntax, node.getSourceRange(), "not a chance");
                }
                default: {
                    throw parserCallbacks.onError(ParserCallbacks.ErrorType.Syntax, node.getSourceRange(), "future feature %s is not defined", alias.name);
                }
            }
        }
    }

    void pushOp(Instruction insn) {
        int i;
        if (insn.opcode == OpCodes.FOR_ITER) {
            this.quickeningStack.add(insn);
            return;
        }
        if (insn.target != null && insn.opcode.getNumberOfProducedStackItems(insn.arg, insn.followingArgs, true) > 0) {
            this.quickeningStack.clear();
            return;
        }
        int consumed = insn.opcode.getNumberOfConsumedStackItems(insn.arg, insn.followingArgs, false);
        int produced = insn.opcode.getNumberOfProducedStackItems(insn.arg, insn.followingArgs, false);
        byte canQuickenInputTypes = insn.opcode.canQuickenInputTypes();
        ArrayList<Instruction> inputs = null;
        if (insn.opcode == OpCodes.BINARY_SUBSCR) {
            Instruction index = this.popQuickeningStack();
            this.popQuickeningStack();
            if (index != null && (index.opcode.canQuickenOutputTypes() & 2) != 0) {
                index.quickenOutput = (byte)2;
                insn.quickeningGeneralizeList = List.of(index);
            }
            this.quickeningStack.add(insn);
            return;
        }
        if (insn.opcode == OpCodes.STORE_SUBSCR) {
            Instruction index = this.popQuickeningStack();
            this.popQuickeningStack();
            Instruction value = this.popQuickeningStack();
            if (index != null && (index.opcode.canQuickenOutputTypes() & 2) != 0) {
                index.quickenOutput = (byte)2;
                if (value != null && (value.opcode.canQuickenOutputTypes() & canQuickenInputTypes) != 0) {
                    value.quickenOutput = canQuickenInputTypes;
                    insn.quickeningGeneralizeList = List.of(value, index);
                } else {
                    insn.quickeningGeneralizeList = List.of(index);
                }
            }
            return;
        }
        if (consumed > 0) {
            if (canQuickenInputTypes != 0) {
                inputs = new ArrayList<Instruction>(consumed);
                for (i = 0; i < consumed; ++i) {
                    Instruction input = this.popQuickeningStack();
                    if (input == null) {
                        canQuickenInputTypes = 0;
                        break;
                    }
                    canQuickenInputTypes = (byte)(canQuickenInputTypes & input.opcode.canQuickenOutputTypes());
                    inputs.add(input);
                }
            } else {
                for (i = 0; i < consumed; ++i) {
                    this.popQuickeningStack();
                }
            }
        }
        if (produced > 0) {
            if (produced > 1) {
                this.quickeningStack.clear();
                return;
            }
            this.quickeningStack.add(insn);
        }
        if (canQuickenInputTypes != 0) {
            insn.quickeningGeneralizeList = inputs;
        }
        if (canQuickenInputTypes != 0 && inputs != null) {
            for (i = 0; i < inputs.size(); ++i) {
                ((Instruction)inputs.get((int)i)).quickenOutput = canQuickenInputTypes;
            }
        }
    }

    Instruction popQuickeningStack() {
        if (this.quickeningStack.size() == 0) {
            return null;
        }
        return this.quickeningStack.remove(this.quickeningStack.size() - 1);
    }

    private void enterScope(String name, CompilationScope scopeType, SSTNode node) {
        this.enterScope(name, scopeType, node, 0, 0, 0, false, false, node.getSourceRange());
    }

    private void enterScope(String name, CompilationScope scope, Object key, ArgumentsTy args, SourceRange startLocation) {
        boolean splat;
        boolean kwSplat;
        int argc;
        int pargc;
        int kwargc;
        if (args == null) {
            kwargc = 0;
            pargc = 0;
            argc = 0;
            kwSplat = false;
            splat = false;
        } else {
            argc = args.args == null ? 0 : args.args.length;
            pargc = args.posOnlyArgs == null ? 0 : args.posOnlyArgs.length;
            kwargc = args.kwOnlyArgs == null ? 0 : args.kwOnlyArgs.length;
            splat = args.varArg != null;
            kwSplat = args.kwArg != null;
        }
        this.enterScope(name, scope, key, argc, pargc, kwargc, splat, kwSplat, startLocation);
    }

    private void enterScope(String name, CompilationScope scopeType, Object key, int argc, int pargc, int kwargc, boolean hasSplat, boolean hasKwSplat, SourceRange startLocation) {
        if (this.unit != null) {
            this.stack.add(this.unit);
        }
        this.unit = new CompilationUnit(scopeType, this.env.lookupScope(key), name, this.getNewScopeQualName(name, scopeType), this.unit, argc, pargc, kwargc, hasSplat, hasKwSplat, startLocation, this.futureFeatures);
        ++this.nestingLevel;
    }

    private String getNewScopeQualName(String name, CompilationScope scopeType) {
        CompilationUnit parent = this.unit;
        int scopeDepth = this.stack.size();
        if (scopeDepth > 1 && parent != null) {
            if (parent.scopeType == CompilationScope.TypeParams) {
                parent = this.stack.get(scopeDepth - 2);
                if (scopeDepth == 2) {
                    return name;
                }
            }
            if (!EnumSet.of(CompilationScope.Function, CompilationScope.AsyncFunction, CompilationScope.Class).contains((Object)scopeType) || !parent.scope.getUseOfName(ScopeEnvironment.mangle(parent.privateName, name)).contains((Object)Scope.DefUse.GlobalExplicit)) {
                Object base = EnumSet.of(CompilationScope.Function, CompilationScope.AsyncFunction, CompilationScope.Lambda).contains((Object)parent.scopeType) ? parent.qualName + ".<locals>" : parent.qualName;
                return (String)base + "." + name;
            }
        }
        return name;
    }

    private void exitScope() {
        --this.nestingLevel;
        this.unit = !this.stack.isEmpty() ? this.stack.remove(this.stack.size() - 1) : null;
    }

    protected final void checkForbiddenName(String id, ExprContextTy context) {
        SSTUtils.checkForbiddenName(this.parserCallbacks, this.unit.currentLocation, id, context);
    }

    private boolean containsAnnotations(StmtTy[] stmts) {
        if (stmts == null) {
            return false;
        }
        for (StmtTy stmt : stmts) {
            if (!this.containsAnnotations(stmt)) continue;
            return true;
        }
        return false;
    }

    private boolean containsAnnotations(StmtTy stmt) {
        if (stmt instanceof StmtTy.AnnAssign) {
            return true;
        }
        if (stmt instanceof StmtTy.For) {
            StmtTy.For forStmt = (StmtTy.For)stmt;
            return this.containsAnnotations(forStmt.body) || this.containsAnnotations(forStmt.orElse);
        }
        if (stmt instanceof StmtTy.While) {
            StmtTy.While whileStmt = (StmtTy.While)stmt;
            return this.containsAnnotations(whileStmt.body) || this.containsAnnotations(whileStmt.orElse);
        }
        if (stmt instanceof StmtTy.If) {
            StmtTy.If ifStmt = (StmtTy.If)stmt;
            return this.containsAnnotations(ifStmt.body) || this.containsAnnotations(ifStmt.orElse);
        }
        if (stmt instanceof StmtTy.With) {
            StmtTy.With withStmt = (StmtTy.With)stmt;
            return this.containsAnnotations(withStmt.body);
        }
        if (stmt instanceof StmtTy.Try) {
            StmtTy.Try tryStmt = (StmtTy.Try)stmt;
            if (tryStmt.handlers != null) {
                for (ExceptHandlerTy h : tryStmt.handlers) {
                    if (!this.containsAnnotations(((ExceptHandlerTy.ExceptHandler)h).body)) continue;
                    return true;
                }
            }
            return this.containsAnnotations(tryStmt.body) || this.containsAnnotations(tryStmt.finalBody) || this.containsAnnotations(tryStmt.orElse);
        }
        if (stmt instanceof StmtTy.TryStar) {
            StmtTy.TryStar tryStmt = (StmtTy.TryStar)stmt;
            if (tryStmt.handlers != null) {
                for (ExceptHandlerTy h : tryStmt.handlers) {
                    if (!this.containsAnnotations(((ExceptHandlerTy.ExceptHandler)h).body)) continue;
                    return true;
                }
            }
            return this.containsAnnotations(tryStmt.body) || this.containsAnnotations(tryStmt.finalBody) || this.containsAnnotations(tryStmt.orElse);
        }
        return false;
    }

    private Void addOp(OpCodes code) {
        this.addOp(code, 0, null, this.unit.currentLocation);
        return null;
    }

    private void addOp(OpCodes code, Block target) {
        this.addOp(code, target, null);
    }

    private void addConditionalJump(OpCodes code, Block target) {
        int profileIndex = this.unit.conditionProfileCount;
        this.unit.conditionProfileCount += 2;
        byte[] followingArgs = new byte[2];
        ByteArraySupport.littleEndian().putShort(followingArgs, 0, (short)profileIndex);
        this.addOp(code, target, followingArgs);
    }

    private void addOp(OpCodes code, Block target, byte[] followingArgs) {
        Block b = this.unit.currentBlock;
        Instruction insn = new Instruction(code, 0, followingArgs, target, this.unit.currentLocation);
        b.instr.add(insn);
        this.pushOp(insn);
    }

    private Void addOp(OpCodes code, int arg) {
        this.addOp(code, arg, null, this.unit.currentLocation);
        return null;
    }

    private Void addOp(OpCodes code, int arg, byte[] followingArgs) {
        this.addOp(code, arg, followingArgs, this.unit.currentLocation);
        return null;
    }

    private void addOp(OpCodes code, int arg, byte[] followingArgs, SourceRange location) {
        assert (code != OpCodes.YIELD_VALUE || this.unit.scope.isGenerator() || this.unit.scope.isCoroutine());
        Block b = this.unit.currentBlock;
        Instruction insn = new Instruction(code, arg, followingArgs, null, location);
        b.instr.add(insn);
        this.pushOp(insn);
    }

    private Void addOpName(OpCodes code, HashMap<String, Integer> dict, String name) {
        String mangled = ScopeEnvironment.maybeMangle(this.unit.privateName, this.unit.scope, name);
        this.addOpObject(code, dict, mangled);
        return null;
    }

    private <T> void addOpObject(OpCodes code, HashMap<T, Integer> dict, T obj) {
        int arg = Compiler.addObject(dict, obj);
        this.addOp(code, arg);
    }

    private void addDerefVariableOpcode(ExprContextTy ctx, int idx) {
        switch (ctx) {
            case Load: {
                if (this.unit.scope.isClass()) {
                    this.addOp(OpCodes.LOAD_LOCALS);
                    this.addOp(OpCodes.LOAD_FROM_DICT_OR_DEREF, idx);
                    break;
                }
                if (this.unit.scope.canSeeClassScope()) {
                    this.addOp(OpCodes.LOAD_DEREF, Compiler.addObject(this.unit.freevars, "__classdict__"));
                    this.addOp(OpCodes.LOAD_FROM_DICT_OR_DEREF, idx);
                    break;
                }
                this.addOp(OpCodes.LOAD_DEREF, idx);
                break;
            }
            case Store: {
                this.addOp(OpCodes.STORE_DEREF, idx);
                break;
            }
            case Del: {
                this.addOp(OpCodes.DELETE_DEREF, idx);
            }
        }
    }

    private void addFastVariableOpcode(ExprContextTy ctx, int idx) {
        switch (ctx) {
            case Load: {
                this.addOp(OpCodes.LOAD_FAST, idx);
                break;
            }
            case Store: {
                this.addOp(OpCodes.STORE_FAST, idx);
                break;
            }
            case Del: {
                this.addOp(OpCodes.DELETE_FAST, idx);
            }
        }
    }

    private void addGlobalVariableOpcode(ExprContextTy ctx, int idx, boolean isImplicitScope) {
        switch (ctx) {
            case Load: {
                if (this.unit.scope.canSeeClassScope() && isImplicitScope) {
                    this.addOp(OpCodes.LOAD_DEREF, Compiler.addObject(this.unit.freevars, "__classdict__"));
                    this.addOp(OpCodes.LOAD_FROM_DICT_OR_GLOBALS, idx);
                    break;
                }
                this.addOp(OpCodes.LOAD_GLOBAL, idx);
                break;
            }
            case Store: {
                this.addOp(OpCodes.STORE_GLOBAL, idx);
                break;
            }
            case Del: {
                this.addOp(OpCodes.DELETE_GLOBAL, idx);
            }
        }
    }

    private void addNameVariableOpcode(ExprContextTy ctx, int idx) {
        switch (ctx) {
            case Load: {
                if (this.unit.scope.isClass()) {
                    this.addOp(OpCodes.LOAD_NAME, idx);
                    break;
                }
                this.addOp(OpCodes.LOAD_NAME, idx);
                break;
            }
            case Store: {
                this.addOp(OpCodes.STORE_NAME, idx);
                break;
            }
            case Del: {
                this.addOp(OpCodes.DELETE_NAME, idx);
            }
        }
    }

    private void addNameOp(String name, ExprContextTy ctx) {
        this.checkForbiddenName(name, ctx);
        String mangled = ScopeEnvironment.maybeMangle(this.unit.privateName, this.unit.scope, name);
        EnumSet<Scope.DefUse> uses = this.unit.scope.getUseOfName(mangled);
        if (uses != null) {
            if (uses.contains((Object)Scope.DefUse.Free)) {
                this.addDerefVariableOpcode(ctx, Compiler.addObject(this.unit.freevars, mangled));
                return;
            }
            if (uses.contains((Object)Scope.DefUse.Cell)) {
                this.addDerefVariableOpcode(ctx, Compiler.addObject(this.unit.cellvars, mangled));
                return;
            }
            if (uses.contains((Object)Scope.DefUse.Local)) {
                if (this.unit.scope.isFunction()) {
                    this.addFastVariableOpcode(ctx, Compiler.addObject(this.unit.varnames, mangled));
                    return;
                }
            } else if (uses.contains((Object)Scope.DefUse.GlobalImplicit)) {
                if (this.unit.scope.isFunction()) {
                    this.addGlobalVariableOpcode(ctx, Compiler.addObject(this.unit.names, mangled), true);
                    return;
                }
            } else if (uses.contains((Object)Scope.DefUse.GlobalExplicit)) {
                this.addGlobalVariableOpcode(ctx, Compiler.addObject(this.unit.names, mangled), false);
                return;
            }
        }
        this.addNameVariableOpcode(ctx, Compiler.addObject(this.unit.names, mangled));
    }

    private static <T> int addObject(HashMap<T, Integer> dict, T o) {
        Integer v = dict.get(o);
        if (v == null) {
            v = dict.size();
            dict.put(o, v);
        }
        return v;
    }

    private static TruffleString findDocstring(StmtTy[] body) {
        ExprTy expr;
        StmtTy stmt;
        if (body != null && body.length > 0 && (stmt = body[0]) instanceof StmtTy.Expr && (expr = ((StmtTy.Expr)stmt).value) instanceof ExprTy.Constant) {
            ConstantValue value = ((ExprTy.Constant)expr).value;
            if (value.kind == ConstantValue.Kind.CODEPOINTS) {
                return PythonUtils.codePointsToTruffleString(value.getCodePoints());
            }
        }
        return null;
    }

    private TruffleString getDocstring(StmtTy[] body) {
        if (this.optimizationLevel >= 2) {
            return null;
        }
        return Compiler.findDocstring(body);
    }

    private SourceRange setLocation(SourceRange location) {
        SourceRange savedLocation = this.unit.currentLocation;
        this.unit.currentLocation = location;
        return savedLocation;
    }

    private SourceRange setLocation(SSTNode node) {
        return this.setLocation(node.getSourceRange());
    }

    private void collectIntoArray(ExprTy[] nodes, int bits, int alreadyOnStack) {
        Collector collector = new Collector(bits, alreadyOnStack);
        if (nodes != null) {
            for (ExprTy e : nodes) {
                if (e instanceof ExprTy.Starred) {
                    collector.flushStackIfNecessary();
                    ((ExprTy.Starred)e).value.accept(this);
                    collector.appendCollection();
                    continue;
                }
                e.accept(this);
                collector.appendItem();
            }
        }
        collector.finishCollection();
    }

    private void collectIntoArray(ExprTy[] nodes, int bits) {
        this.collectIntoArray(nodes, bits, 0);
    }

    private void collectIntoDict(ExprTy[] keys, ExprTy[] values) {
        Collector collector = new Collector(128);
        if (keys != null) {
            assert (keys.length == values.length);
            for (int i = 0; i < keys.length; ++i) {
                ExprTy key = keys[i];
                ExprTy value = values[i];
                if (key == null) {
                    collector.flushStackIfNecessary();
                    value.accept(this);
                    collector.appendCollection();
                    continue;
                }
                key.accept(this);
                value.accept(this);
                collector.appendItem();
            }
        }
        collector.finishCollection();
    }

    protected final void validateKeywords(KeywordTy[] keywords) {
        for (int i = 0; i < keywords.length; ++i) {
            if (keywords[i].arg == null) continue;
            this.checkForbiddenName(keywords[i].arg, ExprContextTy.Store);
            for (int j = i + 1; j < keywords.length; ++j) {
                if (!keywords[i].arg.equals(keywords[j].arg)) continue;
                throw this.parserCallbacks.onError(ParserCallbacks.ErrorType.Syntax, this.unit.currentLocation, "keyword argument repeated: " + keywords[i].arg);
            }
        }
    }

    private void collectKeywords(KeywordTy[] keywords, OpCodes callOp) {
        this.validateKeywords(keywords);
        boolean hasSplat = false;
        for (KeywordTy k : keywords) {
            if (k.arg != null) continue;
            hasSplat = true;
            break;
        }
        if (!hasSplat) {
            collector = new Collector(160);
            for (KeywordTy k : keywords) {
                k.accept(this);
                collector.appendItem();
            }
            collector.finishCollection();
        } else if (keywords.length == 1) {
            keywords[0].value.accept(this);
            this.addOp(OpCodes.COLLECTION_FROM_COLLECTION, 160);
        } else {
            collector = new KwargsMergingDictCollector(callOp);
            for (KeywordTy k : keywords) {
                if (k.arg == null) {
                    collector.flushStackIfNecessary();
                    k.value.accept(this);
                    collector.appendCollection();
                    continue;
                }
                this.addOp(OpCodes.LOAD_STRING, Compiler.addObject(this.unit.constants, PythonUtils.toTruffleStringUncached(k.arg)));
                k.value.accept(this);
                collector.appendItem();
            }
            collector.finishCollection();
            this.addOp(OpCodes.COLLECTION_FROM_COLLECTION, 160);
        }
    }

    private void makeClosure(CodeUnit code, int makeFunctionFlags) {
        int newFlags = makeFunctionFlags;
        if (code.freevars.length > 0) {
            for (TruffleString tfv : code.freevars) {
                String fv = tfv.toJavaStringUncached();
                int arg = this.unit.scopeType == CompilationScope.Class && ("__class__".equals(fv) || "__classdict__".equals(fv)) || this.unit.scope.getUseOfName(fv).contains((Object)Scope.DefUse.Cell) ? this.unit.cellvars.get(fv).intValue() : this.unit.freevars.get(fv).intValue();
                this.addOp(OpCodes.LOAD_CLOSURE, arg);
            }
            this.addOp(OpCodes.CLOSURE_FROM_STACK, code.freevars.length);
            newFlags |= 8;
        }
        this.addOp(OpCodes.MAKE_FUNCTION, Compiler.addObject(this.unit.constants, code), new byte[]{(byte)newFlags});
    }

    private void visitBody(StmtTy[] stmts, boolean returnValue) {
        if (stmts != null) {
            if (this.unit.scope.isModule() && stmts.length > 0) {
                this.setLocation(stmts[0]);
            }
            if (this.containsAnnotations(stmts)) {
                this.addOp(OpCodes.SETUP_ANNOTATIONS);
            }
            if (stmts.length > 0) {
                int i = 0;
                TruffleString docstring = this.getDocstring(stmts);
                if (docstring != null) {
                    ++i;
                    StmtTy.Expr stmt = (StmtTy.Expr)stmts[0];
                    stmt.value.accept(this);
                    this.addNameOp("__doc__", ExprContextTy.Store);
                }
                while (i < stmts.length - 1) {
                    stmts[i].accept(this);
                    ++i;
                }
                StmtTy lastStatement = stmts[stmts.length - 1];
                if (returnValue && lastStatement instanceof StmtTy.Expr) {
                    ExprTy value = ((StmtTy.Expr)lastStatement).value;
                    value.accept(this);
                    this.setLocation(value);
                    this.addOp(OpCodes.RETURN_VALUE);
                    return;
                }
                lastStatement.accept(this);
            }
        }
        if (returnValue) {
            this.addOp(OpCodes.LOAD_NONE);
            this.addOp(OpCodes.RETURN_VALUE);
        }
    }

    @Override
    public Void visit(AliasTy node) {
        this.addOp(OpCodes.LOAD_BYTE, 0);
        this.addOp(OpCodes.LOAD_CONST, Compiler.addObject(this.unit.constants, PythonUtils.EMPTY_TRUFFLESTRING_ARRAY));
        this.addOpName(OpCodes.IMPORT_NAME, this.unit.names, node.name);
        if (node.asName != null) {
            int dotIdx = node.name.indexOf(46);
            if (dotIdx >= 0) {
                while (true) {
                    int pos;
                    int end = (dotIdx = node.name.indexOf(46, pos = dotIdx + 1)) >= 0 ? dotIdx : node.name.length();
                    String attr = node.name.substring(pos, end);
                    this.addOpObject(OpCodes.IMPORT_FROM, this.unit.names, attr);
                    if (dotIdx < 0) break;
                    this.addOp(OpCodes.ROT_TWO);
                    this.addOp(OpCodes.POP_TOP);
                }
                this.addNameOp(node.asName, ExprContextTy.Store);
                this.addOp(OpCodes.POP_TOP);
            } else {
                this.addNameOp(node.asName, ExprContextTy.Store);
            }
        } else {
            int dotIdx = node.name.indexOf(46);
            if (dotIdx >= 0) {
                this.addNameOp(node.name.substring(0, dotIdx), ExprContextTy.Store);
            } else {
                this.addNameOp(node.name, ExprContextTy.Store);
            }
        }
        return null;
    }

    @Override
    public Void visit(ArgTy node) {
        throw new IllegalStateException("Should not be visited");
    }

    @Override
    public Void visit(ArgumentsTy node) {
        throw new IllegalStateException("Should not be visited");
    }

    @Override
    public Void visit(ComprehensionTy node) {
        throw new IllegalStateException("Should not be visited");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visit(ExprTy.Attribute node) {
        SourceRange savedLocation = this.setLocation(node);
        try {
            node.value.accept(this);
            switch (node.context) {
                case Store: {
                    this.checkForbiddenName(node.attr, node.context);
                    Void void_ = this.addOpName(OpCodes.STORE_ATTR, this.unit.names, node.attr);
                    return void_;
                }
                case Del: {
                    Void void_ = this.addOpName(OpCodes.DELETE_ATTR, this.unit.names, node.attr);
                    return void_;
                }
            }
            Void void_ = this.addOpName(OpCodes.LOAD_ATTR, this.unit.names, node.attr);
            return void_;
        }
        finally {
            this.setLocation(savedLocation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visit(ExprTy.Await node) {
        if (!this.unit.scope.isFunction()) {
            throw this.parserCallbacks.onError(ParserCallbacks.ErrorType.Syntax, this.unit.currentLocation, "'await' outside function");
        }
        if (this.unit.scopeType != CompilationScope.AsyncFunction && this.unit.scopeType != CompilationScope.Comprehension) {
            throw this.parserCallbacks.onError(ParserCallbacks.ErrorType.Syntax, this.unit.currentLocation, "'await' outside async function");
        }
        SourceRange savedLocation = this.setLocation(node);
        try {
            node.value.accept(this);
            this.addOp(OpCodes.GET_AWAITABLE);
            this.addOp(OpCodes.LOAD_NONE);
            this.addYieldFrom();
            Void void_ = null;
            return void_;
        }
        finally {
            this.setLocation(savedLocation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visit(ExprTy.BinOp node) {
        SourceRange savedLocation = this.setLocation(node);
        try {
            node.left.accept(this);
            node.right.accept(this);
            switch (node.op) {
                case Add: {
                    this.addOp(OpCodes.BINARY_OP, BinaryOps.ADD.ordinal());
                    break;
                }
                case Sub: {
                    this.addOp(OpCodes.BINARY_OP, BinaryOps.SUB.ordinal());
                    break;
                }
                case Mult: {
                    this.addOp(OpCodes.BINARY_OP, BinaryOps.MUL.ordinal());
                    break;
                }
                case MatMult: {
                    this.addOp(OpCodes.BINARY_OP, BinaryOps.MATMUL.ordinal());
                    break;
                }
                case Div: {
                    this.addOp(OpCodes.BINARY_OP, BinaryOps.TRUEDIV.ordinal());
                    break;
                }
                case Mod: {
                    this.addOp(OpCodes.BINARY_OP, BinaryOps.MOD.ordinal());
                    break;
                }
                case Pow: {
                    this.addOp(OpCodes.BINARY_OP, BinaryOps.POW.ordinal());
                    break;
                }
                case LShift: {
                    this.addOp(OpCodes.BINARY_OP, BinaryOps.LSHIFT.ordinal());
                    break;
                }
                case RShift: {
                    this.addOp(OpCodes.BINARY_OP, BinaryOps.RSHIFT.ordinal());
                    break;
                }
                case BitOr: {
                    this.addOp(OpCodes.BINARY_OP, BinaryOps.OR.ordinal());
                    break;
                }
                case BitXor: {
                    this.addOp(OpCodes.BINARY_OP, BinaryOps.XOR.ordinal());
                    break;
                }
                case BitAnd: {
                    this.addOp(OpCodes.BINARY_OP, BinaryOps.AND.ordinal());
                    break;
                }
                case FloorDiv: {
                    this.addOp(OpCodes.BINARY_OP, BinaryOps.FLOORDIV.ordinal());
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown binary operation " + String.valueOf((Object)node.op));
                }
            }
            Void void_ = null;
            return void_;
        }
        finally {
            this.setLocation(savedLocation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visit(ExprTy.BoolOp node) {
        SourceRange savedLocation = this.setLocation(node);
        try {
            Block end = new Block();
            ExprTy[] values = node.values;
            OpCodes op = node.op == BoolOpTy.And ? OpCodes.JUMP_IF_FALSE_OR_POP : OpCodes.JUMP_IF_TRUE_OR_POP;
            for (int i = 0; i < values.length - 1; ++i) {
                ExprTy v = values[i];
                v.accept(this);
                this.addConditionalJump(op, end);
            }
            values[values.length - 1].accept(this);
            this.unit.useNextBlock(end);
            Void void_ = null;
            return void_;
        }
        finally {
            this.setLocation(savedLocation);
        }
    }

    private static boolean isAttributeLoad(ExprTy node) {
        return node instanceof ExprTy.Attribute && ((ExprTy.Attribute)node).context == ExprContextTy.Load;
    }

    private static boolean hasOnlyPlainArgs(ExprTy[] args, KeywordTy[] keywords) {
        if (keywords.length > 0) {
            return false;
        }
        for (ExprTy arg : args) {
            if (!(arg instanceof ExprTy.Starred)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visit(ExprTy.Call node) {
        SourceRange savedLocation = this.setLocation(node);
        SSTUtils.checkCaller(this.parserCallbacks, node.func);
        try {
            Void void_;
            boolean shortCall;
            OpCodes op = OpCodes.CALL_FUNCTION_VARARGS;
            int opArg = 0;
            ExprTy func = node.func;
            SSTNode[] args = node.args;
            KeywordTy[] keywords = node.keywords;
            if (Compiler.isAttributeLoad(func) && keywords.length == 0) {
                ((ExprTy.Attribute)func).value.accept(this);
                op = OpCodes.CALL_METHOD_VARARGS;
                String mangled = ScopeEnvironment.maybeMangle(this.unit.privateName, this.unit.scope, ((ExprTy.Attribute)func).attr);
                opArg = Compiler.addObject(this.unit.names, mangled);
                this.addOp(OpCodes.LOAD_METHOD, opArg);
                shortCall = args.length <= 3;
            } else {
                func.accept(this);
                boolean bl = shortCall = args.length <= 4;
            }
            if (Compiler.hasOnlyPlainArgs((ExprTy[])args, keywords) && shortCall) {
                op = op == OpCodes.CALL_METHOD_VARARGS ? OpCodes.CALL_METHOD : OpCodes.CALL_FUNCTION;
                opArg = args.length;
                this.visitSequence(args);
                void_ = this.addOp(op, opArg);
                return void_;
            }
            if (op == OpCodes.CALL_METHOD_VARARGS) {
                this.addOp(OpCodes.ROT_TWO);
            }
            void_ = this.callHelper(op, opArg, 0, (ExprTy[])args, keywords);
            return void_;
        }
        finally {
            this.setLocation(savedLocation);
        }
    }

    private Void callHelper(OpCodes op, int opArg, int alreadyOnStack, ExprTy[] args, KeywordTy[] keywords) {
        this.collectIntoArray(args, 192, op == OpCodes.CALL_METHOD_VARARGS ? 1 + alreadyOnStack : alreadyOnStack);
        if (keywords.length > 0) {
            assert (op == OpCodes.CALL_FUNCTION_VARARGS);
            this.collectKeywords(keywords, OpCodes.CALL_FUNCTION_KW);
            return this.addOp(OpCodes.CALL_FUNCTION_KW);
        }
        if (op == OpCodes.CALL_METHOD_VARARGS) {
            return this.addOp(op);
        }
        return this.addOp(op, opArg);
    }

    private void addCompareOp(CmpOpTy op) {
        switch (op) {
            case Eq: {
                this.addOp(OpCodes.BINARY_OP, BinaryOps.EQ.ordinal());
                break;
            }
            case NotEq: {
                this.addOp(OpCodes.BINARY_OP, BinaryOps.NE.ordinal());
                break;
            }
            case Lt: {
                this.addOp(OpCodes.BINARY_OP, BinaryOps.LT.ordinal());
                break;
            }
            case LtE: {
                this.addOp(OpCodes.BINARY_OP, BinaryOps.LE.ordinal());
                break;
            }
            case Gt: {
                this.addOp(OpCodes.BINARY_OP, BinaryOps.GT.ordinal());
                break;
            }
            case GtE: {
                this.addOp(OpCodes.BINARY_OP, BinaryOps.GE.ordinal());
                break;
            }
            case Is: {
                this.addOp(OpCodes.BINARY_OP, BinaryOps.IS.ordinal());
                break;
            }
            case IsNot: {
                this.addOp(OpCodes.BINARY_OP, BinaryOps.IS.ordinal());
                this.addOp(OpCodes.UNARY_OP, UnaryOps.NOT.ordinal());
                break;
            }
            case In: {
                this.addOp(OpCodes.BINARY_OP, BinaryOps.IN.ordinal());
                break;
            }
            case NotIn: {
                this.addOp(OpCodes.BINARY_OP, BinaryOps.IN.ordinal());
                this.addOp(OpCodes.UNARY_OP, UnaryOps.NOT.ordinal());
                break;
            }
            default: {
                throw new IllegalStateException("Unknown comparison operation " + String.valueOf((Object)op));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visit(ExprTy.Compare node) {
        SourceRange savedLocation = this.setLocation(node);
        SSTUtils.checkCompare(this.parserCallbacks, node);
        try {
            node.left.accept(this);
            if (node.comparators.length == 1) {
                this.visitSequence(node.comparators);
                this.addCompareOp(node.ops[0]);
            } else {
                int i;
                Block cleanup = new Block();
                for (i = 0; i < node.comparators.length - 1; ++i) {
                    node.comparators[i].accept(this);
                    this.addOp(OpCodes.DUP_TOP);
                    this.addOp(OpCodes.ROT_THREE);
                    this.addCompareOp(node.ops[i]);
                    this.addConditionalJump(OpCodes.JUMP_IF_FALSE_OR_POP, cleanup);
                }
                node.comparators[i].accept(this);
                this.addCompareOp(node.ops[i]);
                Block end = new Block();
                this.addOp(OpCodes.JUMP_FORWARD, end);
                this.unit.useNextBlock(cleanup);
                this.addOp(OpCodes.ROT_TWO);
                this.addOp(OpCodes.POP_TOP);
                this.unit.useNextBlock(end);
            }
            Void void_ = null;
            return void_;
        }
        finally {
            this.setLocation(savedLocation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visit(ExprTy.Constant node) {
        SourceRange savedLocation = this.setLocation(node);
        try {
            Void void_ = this.addConstant(node.value);
            return void_;
        }
        finally {
            this.setLocation(savedLocation);
        }
    }

    private Void addConstant(ConstantValue value) {
        switch (value.kind) {
            case NONE: {
                return this.addOp(OpCodes.LOAD_NONE);
            }
            case ELLIPSIS: {
                return this.addOp(OpCodes.LOAD_ELLIPSIS);
            }
            case BOOLEAN: {
                return this.addOp(value.getBoolean() ? OpCodes.LOAD_TRUE : OpCodes.LOAD_FALSE);
            }
            case LONG: {
                return this.addLoadNumber(value.getLong());
            }
            case DOUBLE: {
                return this.addOp(OpCodes.LOAD_DOUBLE, Compiler.addObject(this.unit.primitiveConstants, Double.doubleToRawLongBits(value.getDouble())));
            }
            case COMPLEX: {
                return this.addOp(OpCodes.LOAD_COMPLEX, Compiler.addObject(this.unit.constants, value.getComplex()));
            }
            case BIGINTEGER: {
                return this.addOp(OpCodes.LOAD_BIGINT, Compiler.addObject(this.unit.constants, value.getBigInteger()));
            }
            case CODEPOINTS: {
                return this.addOp(OpCodes.LOAD_STRING, Compiler.addObject(this.unit.constants, PythonUtils.codePointsToTruffleString(value.getCodePoints())));
            }
            case BYTES: {
                return this.addOp(OpCodes.LOAD_BYTES, Compiler.addObject(this.unit.constants, value.getBytes()));
            }
            case TUPLE: {
                this.addConstantList(value.getTupleElements());
                return this.addOp(OpCodes.TUPLE_FROM_LIST);
            }
            case FROZENSET: {
                this.addConstantList(value.getFrozensetElements());
                return this.addOp(OpCodes.FROZENSET_FROM_LIST);
            }
        }
        throw new IllegalStateException("Unknown constant kind " + String.valueOf((Object)value.kind));
    }

    private void addConstantList(ConstantValue[] values) {
        Collector collector = new Collector(32, 0);
        for (ConstantValue v : values) {
            this.addConstant(v);
            collector.appendItem();
        }
        collector.finishCollection();
    }

    private Void addLoadNumber(long value) {
        if (value == (long)((byte)value)) {
            return this.addOp(OpCodes.LOAD_BYTE, (byte)value);
        }
        if (value == (long)((int)value)) {
            return this.addOp(OpCodes.LOAD_INT, Compiler.addObject(this.unit.primitiveConstants, value));
        }
        return this.addOp(OpCodes.LOAD_LONG, Compiler.addObject(this.unit.primitiveConstants, value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visit(ExprTy.Dict node) {
        SourceRange savedLocation = this.setLocation(node);
        try {
            this.collectIntoDict(node.keys, node.values);
            Void void_ = null;
            return void_;
        }
        finally {
            this.setLocation(savedLocation);
        }
    }

    @Override
    public Void visit(ExprTy.DictComp node) {
        return this.visitComprehension(node, "<dictcomp>", node.generators, node.key, node.value, ComprehensionType.DICT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visit(ExprTy.FormattedValue node) {
        SourceRange savedLocation = this.setLocation(node);
        try {
            node.value.accept(this);
            int oparg = switch (node.conversion) {
                case 115 -> 1;
                case 114 -> 2;
                case 97 -> 3;
                case -1 -> 0;
                default -> throw this.parserCallbacks.onError(ParserCallbacks.ErrorType.System, node.getSourceRange(), "Unrecognized conversion character %d", node.conversion);
            };
            if (node.formatSpec != null) {
                node.formatSpec.accept(this);
                oparg |= 4;
            }
            this.addOp(OpCodes.FORMAT_VALUE, oparg);
            Void void_ = null;
            return void_;
        }
        finally {
            this.setLocation(savedLocation);
        }
    }

    @Override
    public Void visit(ExprTy.GeneratorExp node) {
        return this.visitComprehension(node, "<genexpr>", node.generators, node.element, null, ComprehensionType.GENEXPR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visit(ExprTy.IfExp node) {
        SourceRange savedLocation = this.setLocation(node);
        try {
            Block end = new Block();
            Block next = new Block();
            this.jumpIf(node.test, next, false);
            node.body.accept(this);
            this.addOp(OpCodes.JUMP_FORWARD, end);
            this.unit.useNextBlock(next);
            node.orElse.accept(this);
            this.unit.useNextBlock(end);
            Void void_ = null;
            return void_;
        }
        finally {
            this.setLocation(savedLocation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visit(ExprTy.JoinedStr node) {
        SourceRange savedLocation = this.setLocation(node);
        try {
            this.addOp(OpCodes.LOAD_STRING, Compiler.addObject(this.unit.constants, StringLiterals.T_EMPTY_STRING));
            this.addOpName(OpCodes.LOAD_METHOD, this.unit.names, "join");
            this.collectIntoArray(node.values, 32);
            this.addOp(OpCodes.CALL_METHOD, 1);
            Void void_ = null;
            return void_;
        }
        finally {
            this.setLocation(savedLocation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visit(ExprTy.Lambda node) {
        SourceRange savedLocation = this.setLocation(node);
        try {
            BytecodeCodeUnit code;
            SSTUtils.checkForbiddenArgs(this.parserCallbacks, this.unit.currentLocation, node.args);
            int makeFunctionFlags = this.collectDefaults(node.args);
            this.enterScope("<lambda>", CompilationScope.Lambda, node, node.args, node.getSourceRange());
            Compiler.addObject(this.unit.constants, PNone.NONE);
            try {
                node.body.accept(this);
                this.addOp(OpCodes.RETURN_VALUE);
                code = this.unit.assemble();
            }
            finally {
                this.exitScope();
            }
            this.makeClosure(code, makeFunctionFlags);
            Void void_ = null;
            return void_;
        }
        finally {
            this.setLocation(savedLocation);
        }
    }

    private Void unpackInto(ExprTy[] elements) {
        boolean unpack = false;
        for (int i = 0; i < elements.length; ++i) {
            ExprTy e = elements[i];
            if (!(e instanceof ExprTy.Starred)) continue;
            if (unpack) {
                throw this.parserCallbacks.onError(ParserCallbacks.ErrorType.Syntax, this.unit.currentLocation, "multiple starred expressions in assignment");
            }
            unpack = true;
            int n = elements.length;
            int countAfter = n - i - 1;
            if (countAfter != (byte)countAfter) {
                throw this.parserCallbacks.onError(ParserCallbacks.ErrorType.Syntax, this.unit.currentLocation, "too many expressions in star-unpacking assignment");
            }
            this.addOp(OpCodes.UNPACK_EX, i, new byte[]{(byte)countAfter});
        }
        if (!unpack) {
            this.addOp(OpCodes.UNPACK_SEQUENCE, elements.length);
        }
        for (ExprTy e : elements) {
            if (e instanceof ExprTy.Starred) {
                ((ExprTy.Starred)e).value.accept(this);
                continue;
            }
            if (e == null) continue;
            e.accept(this);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visit(ExprTy.List node) {
        SourceRange savedLocation = this.setLocation(node);
        try {
            switch (node.context) {
                case Store: {
                    Void void_ = this.unpackInto(node.elements);
                    return void_;
                }
                case Load: {
                    boolean emittedConstant = this.tryLoadConstantCollection(node.elements, 32);
                    if (emittedConstant) {
                        Void void_ = null;
                        return void_;
                    }
                    this.collectIntoArray(node.elements, 32);
                    Void void_ = null;
                    return void_;
                }
            }
            Void void_ = (Void)this.visitSequence(node.elements);
            return void_;
        }
        finally {
            this.setLocation(savedLocation);
        }
    }

    @Override
    public Void visit(ExprTy.ListComp node) {
        return this.visitComprehension(node, "<listcomp>", node.generators, node.element, null, ComprehensionType.LIST);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Void visitComprehension(ExprTy node, String name, ComprehensionTy[] generators, ExprTy element, ExprTy value, ComprehensionType type) {
        SourceRange savedLocation = this.setLocation(node);
        try {
            this.enterScope(name, CompilationScope.Comprehension, node, 1, 0, 0, false, false, node.getSourceRange());
            boolean isAsyncGenerator = this.unit.scope.isCoroutine();
            if (type != ComprehensionType.GENEXPR) {
                this.addOp(OpCodes.COLLECTION_FROM_STACK, type.typeBits);
            }
            if (isAsyncGenerator && type != ComprehensionType.GENEXPR && this.unit.scopeType != CompilationScope.AsyncFunction && this.unit.scopeType != CompilationScope.Comprehension) {
                throw this.parserCallbacks.onError(ParserCallbacks.ErrorType.Syntax, this.unit.currentLocation, "asynchronous comprehension outside of an asynchronous function");
            }
            this.visitComprehensionGenerator(generators, 0, element, value, type);
            if (type != ComprehensionType.GENEXPR) {
                this.addOp(OpCodes.RETURN_VALUE);
            }
            BytecodeCodeUnit code = this.unit.assemble();
            this.exitScope();
            this.makeClosure(code, 0);
            generators[0].iter.accept(this);
            if (generators[0].isAsync) {
                this.addOp(OpCodes.GET_AITER);
            } else {
                this.addOp(OpCodes.GET_ITER);
            }
            this.addOp(OpCodes.CALL_COMPREHENSION);
            if (type != ComprehensionType.GENEXPR && isAsyncGenerator) {
                this.addOp(OpCodes.GET_AWAITABLE);
                this.addOp(OpCodes.LOAD_NONE);
                this.addYieldFrom();
            }
            Void void_ = null;
            return void_;
        }
        finally {
            this.setLocation(savedLocation);
        }
    }

    private void visitComprehensionGenerator(ComprehensionTy[] generators, int i, ExprTy element, ExprTy value, ComprehensionType type) {
        ComprehensionTy gen = generators[i];
        if (i == 0) {
            this.addOp(OpCodes.LOAD_FAST, 0);
        } else {
            gen.iter.accept(this);
            if (gen.isAsync) {
                this.addOp(OpCodes.GET_AITER);
            } else {
                this.addOp(OpCodes.GET_ITER);
            }
        }
        Block start = new Block();
        Block ifCleanup = new Block();
        Block anchor = new Block();
        Block asyncForTry = gen.isAsync ? new Block() : null;
        Block asyncForExcept = gen.isAsync ? new Block() : null;
        Block asyncForBody = gen.isAsync ? new Block() : null;
        this.unit.useNextBlock(start);
        if (gen.isAsync) {
            this.addOp(OpCodes.DUP_TOP);
            this.unit.useNextBlock(asyncForTry);
            this.unit.pushBlock(new BlockInfo.AsyncForLoopExit(asyncForTry, asyncForExcept));
            this.addOp(OpCodes.GET_ANEXT);
            this.addOp(OpCodes.LOAD_NONE);
            this.addYieldFrom();
            this.unit.popBlock();
            this.unit.useNextBlock(asyncForBody);
            gen.target.accept(this);
        } else {
            this.addOp(OpCodes.FOR_ITER, anchor);
            gen.target.accept(this);
        }
        for (ExprTy ifExpr : gen.ifs) {
            this.jumpIf(ifExpr, ifCleanup, false);
        }
        if (i + 1 < generators.length) {
            this.visitComprehensionGenerator(generators, i + 1, element, value, type);
        }
        if (i == generators.length - 1) {
            element.accept(this);
            int collectionStackDepth = generators.length + 1;
            if (value != null) {
                value.accept(this);
                ++collectionStackDepth;
            }
            if (type == ComprehensionType.GENEXPR) {
                if (generators[i].isAsync) {
                    this.addOp(OpCodes.ASYNCGEN_WRAP);
                }
                this.addOp(OpCodes.YIELD_VALUE);
                this.addOp(OpCodes.RESUME_YIELD);
                this.addOp(OpCodes.POP_TOP);
            } else {
                if (collectionStackDepth > 31) {
                    throw this.parserCallbacks.onError(ParserCallbacks.ErrorType.Syntax, this.unit.currentLocation, "too many levels of nested comprehensions");
                }
                this.addOp(OpCodes.ADD_TO_COLLECTION, collectionStackDepth | type.typeBits);
            }
        }
        this.unit.useNextBlock(ifCleanup);
        this.addOp(OpCodes.JUMP_BACKWARD, start);
        if (gen.isAsync) {
            this.unit.useNextBlock(asyncForExcept);
            this.addOp(OpCodes.END_ASYNC_FOR);
        }
        this.unit.useNextBlock(anchor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visit(ExprTy.Name node) {
        SourceRange savedLocation = this.setLocation(node);
        try {
            this.addNameOp(node.id, node.context);
            Void void_ = null;
            return void_;
        }
        finally {
            this.setLocation(savedLocation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visit(ExprTy.NamedExpr node) {
        SourceRange savedLocation = this.setLocation(node);
        try {
            node.value.accept(this);
            this.addOp(OpCodes.DUP_TOP);
            node.target.accept(this);
            Void void_ = null;
            return void_;
        }
        finally {
            this.setLocation(savedLocation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visit(ExprTy.Set node) {
        SourceRange savedLocation = this.setLocation(node);
        try {
            this.collectIntoArray(node.elements, 96);
            Void void_ = null;
            return void_;
        }
        finally {
            this.setLocation(savedLocation);
        }
    }

    @Override
    public Void visit(ExprTy.SetComp node) {
        return this.visitComprehension(node, "<setcomp>", node.generators, node.element, null, ComprehensionType.SET);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visit(ExprTy.Slice node) {
        SourceRange savedLocation = this.setLocation(node);
        try {
            int n = 2;
            if (node.lower != null) {
                node.lower.accept(this);
            } else {
                this.addOp(OpCodes.LOAD_NONE);
            }
            if (node.upper != null) {
                node.upper.accept(this);
            } else {
                this.addOp(OpCodes.LOAD_NONE);
            }
            if (node.step != null) {
                node.step.accept(this);
                ++n;
            }
            this.addOp(OpCodes.BUILD_SLICE, n);
            Void void_ = null;
            return void_;
        }
        finally {
            this.setLocation(savedLocation);
        }
    }

    @Override
    public Void visit(ExprTy.Starred node) {
        if (node.context == ExprContextTy.Store) {
            throw this.parserCallbacks.onError(ParserCallbacks.ErrorType.Syntax, this.unit.currentLocation, "starred assignment target must be in a list or tuple");
        }
        throw this.parserCallbacks.onError(ParserCallbacks.ErrorType.Syntax, this.unit.currentLocation, "can't use starred expression here");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visit(ExprTy.Subscript node) {
        SourceRange savedLocation = this.setLocation(node);
        if (node.context == ExprContextTy.Load) {
            SSTUtils.checkSubscripter(this.parserCallbacks, node.value);
            SSTUtils.checkIndex(this.parserCallbacks, node.value, node.slice);
        }
        try {
            node.value.accept(this);
            node.slice.accept(this);
            switch (node.context) {
                case Load: {
                    Void void_ = this.addOp(OpCodes.BINARY_SUBSCR);
                    return void_;
                }
                case Store: {
                    Void void_ = this.addOp(OpCodes.STORE_SUBSCR);
                    return void_;
                }
            }
            Void void_ = this.addOp(OpCodes.DELETE_SUBSCR);
            return void_;
        }
        finally {
            this.setLocation(savedLocation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visit(ExprTy.Tuple node) {
        SourceRange savedLocation = this.setLocation(node);
        try {
            switch (node.context) {
                case Store: {
                    Void void_ = this.unpackInto(node.elements);
                    return void_;
                }
                case Load: {
                    boolean emittedConstant;
                    boolean useList = false;
                    if (node.elements != null) {
                        if (node.elements.length > 31) {
                            useList = true;
                        } else {
                            for (ExprTy e : node.elements) {
                                if (!(e instanceof ExprTy.Starred)) continue;
                                useList = true;
                                break;
                            }
                        }
                    }
                    if (emittedConstant = this.tryLoadConstantCollection(node.elements, 64)) {
                        Void void_ = null;
                        return void_;
                    }
                    if (!useList) {
                        this.collectIntoArray(node.elements, 64);
                    } else {
                        this.collectIntoArray(node.elements, 32);
                        this.addOp(OpCodes.TUPLE_FROM_LIST);
                    }
                    Void void_ = null;
                    return void_;
                }
            }
            Void void_ = (Void)this.visitSequence(node.elements);
            return void_;
        }
        finally {
            this.setLocation(savedLocation);
        }
    }

    private boolean tryLoadConstantCollection(ExprTy[] elements, int collectionKind) {
        ConstantCollection constantCollection = Compiler.tryCollectConstantCollection(elements);
        if (constantCollection == null) {
            return false;
        }
        this.addOp(OpCodes.LOAD_CONST_COLLECTION, Compiler.addObject(this.unit.constants, constantCollection.collection), new byte[]{(byte)(constantCollection.elementType | collectionKind)});
        return true;
    }

    public static ConstantCollection tryCollectConstantCollection(ExprTy[] elements) {
        if (elements == null || elements.length == 0) {
            return null;
        }
        int constantType = -1;
        ArrayList<Comparable<Boolean>> constants = new ArrayList<Comparable<Boolean>>();
        for (ExprTy e : elements) {
            if (e instanceof ExprTy.Constant) {
                ExprTy.Constant c = (ExprTy.Constant)e;
                if (c.value.kind == ConstantValue.Kind.BOOLEAN) {
                    constantType = Compiler.determineConstantType(constantType, 3);
                    constants.add(Boolean.valueOf(c.value.getBoolean()));
                    continue;
                }
                if (c.value.kind == ConstantValue.Kind.LONG) {
                    long val = c.value.getLong();
                    constantType = val == (long)((int)val) ? Compiler.determineConstantType(constantType, 1) : Compiler.determineConstantType(constantType, 2);
                    constants.add(Long.valueOf(val));
                    continue;
                }
                if (c.value.kind == ConstantValue.Kind.DOUBLE) {
                    constantType = Compiler.determineConstantType(constantType, 4);
                    constants.add(Double.valueOf(c.value.getDouble()));
                    continue;
                }
                if (c.value.kind == ConstantValue.Kind.CODEPOINTS) {
                    constantType = Compiler.determineConstantType(constantType, 5);
                    constants.add((Comparable<Boolean>)PythonUtils.codePointsToTruffleString(c.value.getCodePoints()));
                    continue;
                }
                if (c.value.kind == ConstantValue.Kind.NONE) {
                    constantType = Compiler.determineConstantType(constantType, 5);
                    constants.add(PNone.NONE);
                    continue;
                }
                return null;
            }
            return null;
        }
        Object[] newConstant = null;
        switch (constantType) {
            case 5: {
                newConstant = constants.toArray(new Object[0]);
                break;
            }
            case 1: {
                int i;
                int[] a = new int[constants.size()];
                for (i = 0; i < a.length; ++i) {
                    a[i] = (int)((Long)constants.get(i)).longValue();
                }
                newConstant = a;
                break;
            }
            case 2: {
                int i;
                long[] a = new long[constants.size()];
                for (i = 0; i < a.length; ++i) {
                    a[i] = (Long)constants.get(i);
                }
                newConstant = a;
                break;
            }
            case 3: {
                int i;
                boolean[] a = new boolean[constants.size()];
                for (i = 0; i < a.length; ++i) {
                    a[i] = (Boolean)constants.get(i);
                }
                newConstant = a;
                break;
            }
            case 4: {
                int i;
                double[] a = new double[constants.size()];
                for (i = 0; i < a.length; ++i) {
                    a[i] = (Double)constants.get(i);
                }
                newConstant = a;
                break;
            }
        }
        return new ConstantCollection(newConstant, constantType);
    }

    private static int determineConstantType(int existing, int type) {
        if (existing == -1 || existing == type) {
            return type;
        }
        if (existing == 2 && type == 1 || existing == 1 && type == 2) {
            return 2;
        }
        return 5;
    }

    @Override
    public Void visit(ExprTy.UnaryOp node) {
        SourceRange savedLocation = this.setLocation(node);
        try {
            if (node.op == UnaryOpTy.USub && node.operand instanceof ExprTy.Constant) {
                ExprTy.Constant c = (ExprTy.Constant)node.operand;
                if (c.value.kind == ConstantValue.Kind.BIGINTEGER || c.value.kind == ConstantValue.Kind.DOUBLE || c.value.kind == ConstantValue.Kind.LONG || c.value.kind == ConstantValue.Kind.COMPLEX) {
                    ConstantValue cv = c.value.negate();
                    Void void_ = this.visit(new ExprTy.Constant(cv, null, c.getSourceRange()));
                    return void_;
                }
            }
            node.operand.accept(this);
            switch (node.op) {
                case UAdd: {
                    Void void_ = this.addOp(OpCodes.UNARY_OP, UnaryOps.POSITIVE.ordinal());
                    return void_;
                }
                case Invert: {
                    Void void_ = this.addOp(OpCodes.UNARY_OP, UnaryOps.INVERT.ordinal());
                    return void_;
                }
                case Not: {
                    Void void_ = this.addOp(OpCodes.UNARY_OP, UnaryOps.NOT.ordinal());
                    return void_;
                }
                case USub: {
                    Void void_ = this.addOp(OpCodes.UNARY_OP, UnaryOps.NEGATIVE.ordinal());
                    return void_;
                }
            }
            throw new IllegalStateException("Unknown unary operation " + String.valueOf((Object)node.op));
        }
        finally {
            this.setLocation(savedLocation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visit(ExprTy.Yield node) {
        SourceRange savedLocation = this.setLocation(node);
        try {
            if (!this.unit.scope.isFunction()) {
                throw this.parserCallbacks.onError(ParserCallbacks.ErrorType.Syntax, this.unit.currentLocation, "'yield' outside function");
            }
            if (node.value != null) {
                node.value.accept(this);
            } else {
                this.addOp(OpCodes.LOAD_NONE);
            }
            if (this.unit.scopeType == CompilationScope.AsyncFunction) {
                this.addOp(OpCodes.ASYNCGEN_WRAP);
            }
            this.addOp(OpCodes.YIELD_VALUE);
            this.addOp(OpCodes.RESUME_YIELD);
            Void void_ = null;
            return void_;
        }
        finally {
            this.setLocation(savedLocation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visit(ExprTy.YieldFrom node) {
        SourceRange savedLocation = this.setLocation(node);
        try {
            if (!this.unit.scope.isFunction()) {
                throw this.parserCallbacks.onError(ParserCallbacks.ErrorType.Syntax, this.unit.currentLocation, "'yield from' outside function");
            }
            if (this.unit.scopeType == CompilationScope.AsyncFunction) {
                throw this.parserCallbacks.onError(ParserCallbacks.ErrorType.Syntax, this.unit.currentLocation, "'yield from' inside async function");
            }
            node.value.accept(this);
            this.addOp(OpCodes.GET_YIELD_FROM_ITER);
            this.addOp(OpCodes.LOAD_NONE);
            this.addYieldFrom();
            Void void_ = null;
            return void_;
        }
        finally {
            this.setLocation(savedLocation);
        }
    }

    private void addYieldFrom() {
        Block start = new Block();
        Block yield = new Block();
        Block resume = new Block();
        Block exit = new Block();
        Block exceptionHandler = new Block();
        this.unit.useNextBlock(start);
        this.addOp(OpCodes.SEND, exit);
        this.unit.useNextBlock(yield);
        this.addOp(OpCodes.YIELD_VALUE);
        this.unit.pushBlock(new BlockInfo.TryExcept(resume, exceptionHandler));
        this.unit.useNextBlock(resume);
        this.addOp(OpCodes.RESUME_YIELD);
        this.addOp(OpCodes.JUMP_BACKWARD, start);
        this.unit.popBlock();
        this.unit.useNextBlock(exceptionHandler);
        this.addOp(OpCodes.THROW, exit);
        this.addOp(OpCodes.JUMP_BACKWARD, yield);
        this.unit.useNextBlock(exit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visit(KeywordTy node) {
        node.value.accept(this);
        SourceRange savedLocation = this.setLocation(node);
        try {
            Void void_ = this.addOp(OpCodes.MAKE_KEYWORD, Compiler.addObject(this.unit.constants, PythonUtils.toTruffleStringUncached(node.arg)));
            return void_;
        }
        finally {
            this.setLocation(savedLocation);
        }
    }

    @Override
    public Void visit(ModTy.Expression node) {
        node.body.accept(this);
        this.addOp(OpCodes.RETURN_VALUE);
        return null;
    }

    @Override
    public Void visit(ModTy.FunctionType node) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Void visit(ModTy.Interactive node) {
        if (this.containsAnnotations(node.body)) {
            this.addOp(OpCodes.SETUP_ANNOTATIONS);
        }
        this.interactive = true;
        this.visitSequence(node.body);
        this.addOp(OpCodes.LOAD_NONE);
        this.addOp(OpCodes.RETURN_VALUE);
        return null;
    }

    @Override
    public Void visit(ModTy.Module node) {
        this.visitBody(node.body, true);
        return null;
    }

    @Override
    public Void visit(TypeIgnoreTy.TypeIgnore node) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Void visit(StmtTy.AnnAssign node) {
        boolean futureAnnotations;
        this.setLocation(node);
        if (node.value != null) {
            node.value.accept(this);
            node.target.accept(this);
        }
        if (node.target instanceof ExprTy.Name) {
            String name = ((ExprTy.Name)node.target).id;
            this.checkForbiddenName(name, ExprContextTy.Store);
            if (node.isSimple && (this.unit.scopeType == CompilationScope.Module || this.unit.scopeType == CompilationScope.Class)) {
                boolean futureAnnotations2 = this.futureFeatures.contains((Object)FutureFeature.ANNOTATIONS);
                if (futureAnnotations2) {
                    this.visitAnnexpr(node.annotation);
                } else {
                    node.annotation.accept(this);
                }
                this.addNameOp("__annotations__", ExprContextTy.Load);
                String mangled = ScopeEnvironment.maybeMangle(this.unit.privateName, this.unit.scope, name);
                this.addOp(OpCodes.LOAD_STRING, Compiler.addObject(this.unit.constants, PythonUtils.toTruffleStringUncached(mangled)));
                this.addOp(OpCodes.STORE_SUBSCR);
            }
        } else if (node.target instanceof ExprTy.Attribute) {
            if (node.value == null) {
                ExprTy.Attribute attr = (ExprTy.Attribute)node.target;
                this.checkForbiddenName(attr.attr, ExprContextTy.Store);
                if (attr.value != null) {
                    this.checkAnnExpr(attr.value);
                }
            }
        } else if (node.target instanceof ExprTy.Subscript) {
            if (node.value == null) {
                ExprTy.Subscript subscript = (ExprTy.Subscript)node.target;
                if (subscript.value != null) {
                    this.checkAnnExpr(subscript.value);
                }
                this.checkAnnSubscr(subscript.slice);
            }
        } else {
            throw this.parserCallbacks.onError(ParserCallbacks.ErrorType.Syntax, node.getSourceRange(), "invalid node type for annotated assignment");
        }
        if (!(node.isSimple || (futureAnnotations = this.futureFeatures.contains((Object)FutureFeature.ANNOTATIONS)) || this.unit.scopeType != CompilationScope.Module && this.unit.scopeType != CompilationScope.Class)) {
            this.checkAnnExpr(node.annotation);
        }
        return null;
    }

    private void checkAnnExpr(ExprTy expr) {
        expr.accept(this);
        this.addOp(OpCodes.POP_TOP);
    }

    private void checkAnnSubscr(ExprTy expr) {
        if (expr instanceof ExprTy.Slice) {
            ExprTy.Slice slice = (ExprTy.Slice)expr;
            if (slice.lower != null) {
                this.checkAnnExpr(slice.lower);
            }
            if (slice.upper != null) {
                this.checkAnnExpr(slice.upper);
            }
            if (slice.step != null) {
                this.checkAnnExpr(slice.step);
            }
        } else if (expr instanceof ExprTy.Tuple) {
            ExprTy.Tuple tuple = (ExprTy.Tuple)expr;
            for (int i = 0; i < tuple.elements.length; ++i) {
                this.checkAnnSubscr(tuple.elements[i]);
            }
        } else {
            this.checkAnnExpr(expr);
        }
    }

    private static boolean isNonEmptyTuple(ExprTy expr) {
        if (expr instanceof ExprTy.Tuple) {
            ExprTy.Tuple tuple = (ExprTy.Tuple)expr;
            return tuple.elements != null && tuple.elements.length > 0;
        }
        if (expr instanceof ExprTy.Constant) {
            ConstantValue cv = ((ExprTy.Constant)expr).value;
            return cv.kind == ConstantValue.Kind.TUPLE && cv.getTupleElements().length > 0;
        }
        return false;
    }

    @Override
    public Void visit(StmtTy.Assert node) {
        if (Compiler.isNonEmptyTuple(node.test)) {
            this.warn(node, "assertion is always true, perhaps remove parentheses?", new Object[0]);
        }
        if (this.optimizationLevel > 0) {
            return null;
        }
        this.setLocation(node);
        Block end = new Block();
        this.jumpIf(node.test, end, true);
        this.addOp(OpCodes.LOAD_ASSERTION_ERROR);
        if (node.msg != null) {
            node.msg.accept(this);
            this.addOp(OpCodes.CALL_FUNCTION, 1);
        }
        this.addOp(OpCodes.RAISE_VARARGS, 1);
        this.unit.useNextBlock(end);
        return null;
    }

    @Override
    public Void visit(StmtTy.Assign node) {
        this.setLocation(node);
        node.value.accept(this);
        for (int i = 0; i < node.targets.length; ++i) {
            if (i != node.targets.length - 1) {
                this.addOp(OpCodes.DUP_TOP);
            }
            node.targets[i].accept(this);
        }
        return null;
    }

    @Override
    public Void visit(StmtTy.AsyncFor node) {
        if (!this.unit.scope.isFunction()) {
            throw this.parserCallbacks.onError(ParserCallbacks.ErrorType.Syntax, this.unit.currentLocation, "'async for' outside function");
        }
        if (this.unit.scopeType != CompilationScope.AsyncFunction) {
            throw this.parserCallbacks.onError(ParserCallbacks.ErrorType.Syntax, this.unit.currentLocation, "'async for' outside async function");
        }
        this.visitAsyncFor(node);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void visitAsyncFor(StmtTy.AsyncFor node) {
        this.setLocation(node);
        Block head = new Block();
        Block body = new Block();
        Block end = new Block();
        Block except = new Block();
        Block loopTry = new Block();
        Block orelse = node.orElse != null ? new Block() : null;
        node.iter.accept(this);
        this.addOp(OpCodes.GET_AITER);
        this.unit.useNextBlock(head);
        this.unit.pushBlock(new BlockInfo.AsyncForLoop(head, end));
        this.addOp(OpCodes.DUP_TOP);
        this.addOp(OpCodes.GET_ANEXT);
        this.unit.useNextBlock(loopTry);
        this.unit.pushBlock(new BlockInfo.AsyncForLoopExit(loopTry, except));
        this.addOp(OpCodes.LOAD_NONE);
        this.addYieldFrom();
        this.unit.popBlock();
        this.unit.useNextBlock(body);
        try {
            node.target.accept(this);
            this.visitSequence(node.body);
            this.addOp(OpCodes.JUMP_BACKWARD, head);
        }
        finally {
            this.unit.popBlock();
        }
        this.addOp(OpCodes.JUMP_FORWARD, node.orElse != null ? orelse : end);
        this.unit.useNextBlock(except);
        this.addOp(OpCodes.END_ASYNC_FOR);
        if (node.orElse != null) {
            this.unit.useNextBlock(orelse);
            this.visitSequence(node.orElse);
        }
        this.unit.useNextBlock(end);
    }

    private Void emitNotImplemented(String what) {
        this.addGlobalVariableOpcode(ExprContextTy.Load, Compiler.addObject(this.unit.names, "NotImplementedError"), false);
        this.addOp(OpCodes.LOAD_STRING, Compiler.addObject(this.unit.constants, PythonUtils.toTruffleStringUncached(what)));
        this.addOp(OpCodes.CALL_FUNCTION, 1);
        this.addOp(OpCodes.RAISE_VARARGS, 1);
        return null;
    }

    @Override
    public Void visit(StmtTy.AsyncFunctionDef node) {
        return this.visitFunctionDef(node, node.name, node.args, node.body, node.decoratorList, node.returns, node.typeParams, true);
    }

    @Override
    public Void visit(StmtTy.AsyncWith node) {
        this.setLocation(node);
        if (!this.unit.scope.isFunction()) {
            throw this.parserCallbacks.onError(ParserCallbacks.ErrorType.Syntax, this.unit.currentLocation, "'async with' outside function");
        }
        if (this.unit.scopeType != CompilationScope.AsyncFunction && this.unit.scopeType != CompilationScope.Comprehension) {
            throw this.parserCallbacks.onError(ParserCallbacks.ErrorType.Syntax, this.unit.currentLocation, "'async with' outside async function");
        }
        this.visitAsyncWith(node, 0);
        this.unit.useNextBlock(new Block());
        return null;
    }

    private void visitAsyncWith(StmtTy.AsyncWith node, int itemIndex) {
        Block body = new Block();
        Block handler = new Block();
        WithItemTy item = node.items[itemIndex];
        item.contextExpr.accept(this);
        this.addOp(OpCodes.SETUP_AWITH);
        this.unit.pushBlock(new BlockInfo.AsyncWith(body, handler, node));
        this.unit.useNextBlock(body);
        this.addOp(OpCodes.GET_AWAITABLE);
        this.addOp(OpCodes.LOAD_NONE);
        this.addYieldFrom();
        handler.unwindOffset = -1;
        if (item.optionalVars != null) {
            item.optionalVars.accept(this);
        } else {
            this.addOp(OpCodes.POP_TOP);
        }
        if (itemIndex < node.items.length - 1) {
            this.visitAsyncWith(node, itemIndex + 1);
        } else {
            this.visitSequence(node.body);
        }
        this.addOp(OpCodes.LOAD_NONE);
        this.unit.popBlock();
        this.unit.useNextBlock(handler);
        this.setLocation(node);
        this.addOp(OpCodes.GET_AEXIT_CORO);
        this.addOp(OpCodes.GET_AWAITABLE);
        this.addOp(OpCodes.LOAD_NONE);
        this.addYieldFrom();
        this.addOp(OpCodes.EXIT_AWITH);
    }

    @Override
    public Void visit(StmtTy.AugAssign node) {
        ExprTy.Name name;
        ExprTy.Attribute attr;
        ExprTy target = node.target;
        this.setLocation(target);
        if (target instanceof ExprTy.Attribute) {
            attr = (ExprTy.Attribute)target;
            attr.value.accept(this);
            this.addOp(OpCodes.DUP_TOP);
            this.addOpName(OpCodes.LOAD_ATTR, this.unit.names, attr.attr);
        } else if (target instanceof ExprTy.Subscript) {
            ExprTy.Subscript subscript = (ExprTy.Subscript)target;
            subscript.value.accept(this);
            this.addOp(OpCodes.DUP_TOP);
            subscript.slice.accept(this);
            this.addOp(OpCodes.DUP_TOP);
            this.addOp(OpCodes.ROT_THREE);
            this.addOp(OpCodes.BINARY_SUBSCR);
        } else if (target instanceof ExprTy.Name) {
            name = (ExprTy.Name)target;
            this.addNameOp(name.id, ExprContextTy.Load);
        } else {
            throw new IllegalArgumentException("invalid node type for augmented assignment");
        }
        this.setLocation(node);
        node.value.accept(this);
        switch (node.op) {
            case Add: {
                this.addOp(OpCodes.BINARY_OP, BinaryOps.INPLACE_ADD.ordinal());
                break;
            }
            case Sub: {
                this.addOp(OpCodes.BINARY_OP, BinaryOps.INPLACE_SUB.ordinal());
                break;
            }
            case Mult: {
                this.addOp(OpCodes.BINARY_OP, BinaryOps.INPLACE_MUL.ordinal());
                break;
            }
            case MatMult: {
                this.addOp(OpCodes.BINARY_OP, BinaryOps.INPLACE_MATMUL.ordinal());
                break;
            }
            case Div: {
                this.addOp(OpCodes.BINARY_OP, BinaryOps.INPLACE_TRUEDIV.ordinal());
                break;
            }
            case Mod: {
                this.addOp(OpCodes.BINARY_OP, BinaryOps.INPLACE_MOD.ordinal());
                break;
            }
            case Pow: {
                this.addOp(OpCodes.BINARY_OP, BinaryOps.INPLACE_POW.ordinal());
                break;
            }
            case LShift: {
                this.addOp(OpCodes.BINARY_OP, BinaryOps.INPLACE_LSHIFT.ordinal());
                break;
            }
            case RShift: {
                this.addOp(OpCodes.BINARY_OP, BinaryOps.INPLACE_RSHIFT.ordinal());
                break;
            }
            case BitOr: {
                this.addOp(OpCodes.BINARY_OP, BinaryOps.INPLACE_OR.ordinal());
                break;
            }
            case BitXor: {
                this.addOp(OpCodes.BINARY_OP, BinaryOps.INPLACE_XOR.ordinal());
                break;
            }
            case BitAnd: {
                this.addOp(OpCodes.BINARY_OP, BinaryOps.INPLACE_AND.ordinal());
                break;
            }
            case FloorDiv: {
                this.addOp(OpCodes.BINARY_OP, BinaryOps.INPLACE_FLOORDIV.ordinal());
                break;
            }
            default: {
                throw new IllegalStateException("Unknown binary inplace operation " + String.valueOf((Object)node.op));
            }
        }
        this.setLocation(target);
        if (target instanceof ExprTy.Attribute) {
            attr = (ExprTy.Attribute)target;
            this.addOp(OpCodes.ROT_TWO);
            this.addOpName(OpCodes.STORE_ATTR, this.unit.names, attr.attr);
        } else if (target instanceof ExprTy.Subscript) {
            this.addOp(OpCodes.ROT_THREE);
            this.addOp(OpCodes.STORE_SUBSCR);
        } else {
            name = (ExprTy.Name)target;
            this.addNameOp(name.id, ExprContextTy.Store);
        }
        return null;
    }

    @Override
    public Void visit(StmtTy.ClassDef node) {
        boolean isGeneric;
        this.setLocation(node);
        this.visitSequence(node.decoratorList);
        SourceRange startLocation = node.getSourceRange();
        if (node.decoratorList != null && node.decoratorList.length > 0) {
            startLocation = node.decoratorList[0].getSourceRange();
        }
        boolean bl = isGeneric = node.typeParams != null && node.typeParams.length > 0;
        if (isGeneric) {
            String typeParamsName = "<generic parameters of " + node.name + ">";
            this.enterScope(typeParamsName, CompilationScope.TypeParams, node.typeParams, null, startLocation);
            this.unit.privateName = node.name;
            this.visitTypeParams(node.typeParams);
            this.addNameOp(".type_params", ExprContextTy.Store);
        }
        this.enterScope(node.name, CompilationScope.Class, node, 0, 0, 0, false, false, startLocation);
        this.addNameOp("__name__", ExprContextTy.Load);
        this.addNameOp("__module__", ExprContextTy.Store);
        this.addOp(OpCodes.LOAD_STRING, Compiler.addObject(this.unit.constants, PythonUtils.toTruffleStringUncached(this.unit.qualName)));
        this.addNameOp("__qualname__", ExprContextTy.Store);
        if (isGeneric) {
            this.addNameOp(".type_params", ExprContextTy.Load);
            this.addNameOp("__type_params__", ExprContextTy.Store);
        }
        if (this.unit.scope.needsClassDict()) {
            this.addOp(OpCodes.LOAD_LOCALS);
            this.addOp(OpCodes.STORE_DEREF, Compiler.addObject(this.unit.cellvars, "__classdict__"));
        }
        this.visitBody(node.body, false);
        if (this.unit.scope.needsClassDict()) {
            this.addOp(OpCodes.LOAD_CLOSURE, this.unit.cellvars.get("__classdict__"));
            this.addNameOp("__classdictcell__", ExprContextTy.Store);
        }
        if (this.unit.scope.needsClassClosure()) {
            int idx = this.unit.cellvars.get("__class__");
            this.addOp(OpCodes.LOAD_CLOSURE, idx);
            this.addOp(OpCodes.DUP_TOP);
            this.addNameOp("__classcell__", ExprContextTy.Store);
        } else {
            this.addOp(OpCodes.LOAD_NONE);
        }
        this.addOp(OpCodes.RETURN_VALUE);
        BytecodeCodeUnit co = this.unit.assemble();
        this.exitScope();
        this.addOp(OpCodes.LOAD_BUILD_CLASS);
        this.makeClosure(co, 0);
        this.addOp(OpCodes.LOAD_STRING, Compiler.addObject(this.unit.constants, PythonUtils.toTruffleStringUncached(node.name)));
        if (isGeneric) {
            ExprTy[] bases;
            this.addNameOp(".type_params", ExprContextTy.Load);
            this.addOp(OpCodes.MAKE_GENERIC);
            this.addNameOp(".generic_base", ExprContextTy.Store);
            ExprTy.Name nameNode = new ExprTy.Name(".generic_base", ExprContextTy.Load, node.getSourceRange());
            if (node.bases == null) {
                bases = new ExprTy[]{nameNode};
            } else {
                bases = PythonUtils.arrayCopyOf(node.bases, node.bases.length + 1);
                bases[bases.length - 1] = nameNode;
            }
            this.callHelper(OpCodes.CALL_FUNCTION_VARARGS, 0, 2, bases, node.keywords);
            this.addOp(OpCodes.RETURN_VALUE);
            BytecodeCodeUnit code = this.unit.assemble();
            this.exitScope();
            this.makeClosure(code, 0);
            this.addOp(OpCodes.CALL_FUNCTION, 0);
        } else {
            this.callHelper(OpCodes.CALL_FUNCTION_VARARGS, 0, 2, node.bases, node.keywords);
        }
        this.applyDecorators(node.decoratorList);
        this.addNameOp(node.name, ExprContextTy.Store);
        return null;
    }

    @Override
    public Void visit(StmtTy.Delete node) {
        this.setLocation(node);
        this.visitSequence(node.targets);
        return null;
    }

    @Override
    public Void visit(StmtTy.Expr node) {
        this.setLocation(node);
        if (this.interactive && this.nestingLevel <= 1) {
            node.value.accept(this);
            this.addOp(OpCodes.PRINT_EXPR);
        } else if (!(node.value instanceof ExprTy.Constant)) {
            node.value.accept(this);
            this.addOp(OpCodes.POP_TOP);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visit(StmtTy.For node) {
        this.setLocation(node);
        Block head = new Block();
        Block body = new Block();
        Block end = new Block();
        Block orelse = node.orElse != null ? new Block() : end;
        node.iter.accept(this);
        this.addOp(OpCodes.GET_ITER);
        this.unit.useNextBlock(head);
        this.addOp(OpCodes.FOR_ITER, orelse);
        this.unit.useNextBlock(body);
        this.unit.pushBlock(new BlockInfo.For(head, end));
        try {
            node.target.accept(this);
            this.visitSequence(node.body);
            this.addOp(OpCodes.JUMP_BACKWARD, head);
        }
        finally {
            this.unit.popBlock();
        }
        if (node.orElse != null) {
            this.unit.useNextBlock(orelse);
            this.visitSequence(node.orElse);
        }
        this.unit.useNextBlock(end);
        return null;
    }

    @Override
    public Void visit(StmtTy.FunctionDef node) {
        return this.visitFunctionDef(node, node.name, node.args, node.body, node.decoratorList, node.returns, node.typeParams, false);
    }

    private Void visitFunctionDef(StmtTy node, String name, ArgumentsTy args, StmtTy[] body, ExprTy[] decoratorList, ExprTy returns, TypeParamTy[] typeParams, boolean isAsync) {
        boolean hasAnnotations;
        this.setLocation(node);
        SSTUtils.checkForbiddenArgs(this.parserCallbacks, this.unit.currentLocation, args);
        this.visitSequence(decoratorList);
        SourceRange startLocation = node.getSourceRange();
        if (decoratorList != null && decoratorList.length > 0) {
            startLocation = decoratorList[0].getSourceRange();
        }
        boolean isGeneric = typeParams != null && typeParams.length > 0;
        int makeFunctionFlags = this.collectDefaults(args);
        int numTypeParamArgs = 0;
        if (isGeneric) {
            if ((makeFunctionFlags & 1) != 0) {
                ++numTypeParamArgs;
            }
            if ((makeFunctionFlags & 2) != 0) {
                ++numTypeParamArgs;
            }
            String typeParamsName = "<generic parameters of " + name + ">";
            this.enterScope(typeParamsName, CompilationScope.TypeParams, typeParams, numTypeParamArgs, 0, 0, false, false, startLocation);
            this.visitTypeParams(typeParams);
            if ((makeFunctionFlags & 3) != 0) {
                this.addOp(OpCodes.LOAD_FAST, 0);
            }
            if ((makeFunctionFlags & 3) == 3) {
                this.addOp(OpCodes.LOAD_FAST, 1);
            }
        }
        if (hasAnnotations = this.visitAnnotations(args, returns)) {
            makeFunctionFlags |= 4;
        }
        CompilationScope scopeType = isAsync ? CompilationScope.AsyncFunction : CompilationScope.Function;
        this.enterScope(name, scopeType, node, args, startLocation);
        TruffleString docString = this.getDocstring(body);
        Compiler.addObject(this.unit.constants, docString == null ? PNone.NONE : docString);
        this.visitSequence(body);
        BytecodeCodeUnit code = this.unit.assemble();
        this.exitScope();
        this.makeClosure(code, makeFunctionFlags);
        if (isGeneric) {
            this.addOp(OpCodes.DUP_TOP);
            this.addOp(OpCodes.ROT_THREE);
            this.addOpName(OpCodes.STORE_ATTR, this.unit.names, "__type_params__");
            this.addOp(OpCodes.RETURN_VALUE);
            BytecodeCodeUnit typeParamsCode = this.unit.assemble();
            this.exitScope();
            this.makeClosure(typeParamsCode, 0);
            if (numTypeParamArgs == 2) {
                this.addOp(OpCodes.ROT_THREE);
            } else if (numTypeParamArgs == 1) {
                this.addOp(OpCodes.ROT_TWO);
            }
            this.addOp(OpCodes.CALL_FUNCTION, numTypeParamArgs);
        }
        this.applyDecorators(decoratorList);
        this.addNameOp(name, ExprContextTy.Store);
        return null;
    }

    private void applyDecorators(ExprTy[] decoratorList) {
        if (decoratorList != null) {
            for (int i = decoratorList.length - 1; i >= 0; --i) {
                SourceRange savedLocation = this.setLocation(decoratorList[i]);
                this.addOp(OpCodes.CALL_FUNCTION, 1);
                this.setLocation(savedLocation);
            }
        }
    }

    private void visitTypeParams(TypeParamTy[] typeParams) {
        boolean useList = typeParams.length > 31;
        Collector typeParamCollector = new Collector(useList ? 32 : 64);
        for (TypeParamTy typeParam : typeParams) {
            typeParam.accept(this);
            typeParamCollector.appendItem();
        }
        typeParamCollector.finishCollection();
        if (useList) {
            this.addOp(OpCodes.TUPLE_FROM_LIST);
        }
    }

    private boolean visitAnnotations(ArgumentsTy args, ExprTy returns) {
        Collector collector = new Collector(128);
        if (args != null) {
            this.visitArgAnnotations(collector, args.args);
            this.visitArgAnnotations(collector, args.posOnlyArgs);
            if (args.varArg != null) {
                this.visitArgAnnotation(collector, args.varArg.arg, args.varArg.annotation);
            }
            this.visitArgAnnotations(collector, args.kwOnlyArgs);
            if (args.kwArg != null) {
                this.visitArgAnnotation(collector, args.kwArg.arg, args.kwArg.annotation);
            }
        }
        this.visitArgAnnotation(collector, "return", returns);
        if (collector.isEmpty()) {
            return false;
        }
        collector.finishCollection();
        return true;
    }

    private void visitArgAnnotations(Collector collector, ArgTy[] args) {
        for (int i = 0; i < args.length; ++i) {
            this.visitArgAnnotation(collector, args[i].arg, args[i].annotation);
        }
    }

    private void visitArgAnnotation(Collector collector, String name, ExprTy annotation) {
        if (annotation != null) {
            String mangled = ScopeEnvironment.maybeMangle(this.unit.privateName, this.unit.scope, name);
            this.addOp(OpCodes.LOAD_STRING, Compiler.addObject(this.unit.constants, PythonUtils.toTruffleStringUncached(mangled)));
            if (this.futureFeatures.contains((Object)FutureFeature.ANNOTATIONS)) {
                this.visitAnnexpr(annotation);
            } else if (annotation instanceof ExprTy.Starred) {
                ((ExprTy.Starred)annotation).value.accept(this);
                this.addOp(OpCodes.UNPACK_SEQUENCE, 1);
            } else {
                annotation.accept(this);
            }
            collector.appendItem();
        }
    }

    private void visitAnnexpr(ExprTy annotation) {
        this.addOp(OpCodes.LOAD_STRING, Compiler.addObject(this.unit.constants, Unparser.unparse(annotation)));
    }

    private int collectDefaults(ArgumentsTy args) {
        int makeFunctionFlags = 0;
        if (args != null) {
            if (args.defaults != null && args.defaults.length > 0) {
                this.collectIntoArray(args.defaults, 192);
                makeFunctionFlags |= 1;
            }
            if (args.kwDefaults != null && args.kwDefaults.length > 0) {
                ArrayList<KeywordTy> defs = new ArrayList<KeywordTy>();
                for (int i = 0; i < args.kwOnlyArgs.length; ++i) {
                    ArgTy arg = args.kwOnlyArgs[i];
                    ExprTy def = args.kwDefaults[i];
                    if (def == null) continue;
                    String mangled = ScopeEnvironment.maybeMangle(this.unit.privateName, this.unit.scope, arg.arg);
                    defs.add(new KeywordTy(mangled, def, arg.getSourceRange()));
                }
                if (!defs.isEmpty()) {
                    this.collectKeywords((KeywordTy[])defs.toArray(KeywordTy[]::new), null);
                    makeFunctionFlags |= 2;
                }
            }
        }
        return makeFunctionFlags;
    }

    @Override
    public Void visit(StmtTy.Global node) {
        this.setLocation(node);
        return null;
    }

    @Override
    public Void visit(StmtTy.If node) {
        this.setLocation(node);
        Block then = new Block();
        Block end = new Block();
        Block alt = node.orElse != null && node.orElse.length > 0 ? new Block() : end;
        this.jumpIf(node.test, alt, false);
        this.unit.useNextBlock(then);
        this.visitSequence(node.body);
        if (alt != end) {
            this.addOp(OpCodes.JUMP_FORWARD, end);
            this.unit.useNextBlock(alt);
            this.visitSequence(node.orElse);
        }
        this.unit.useNextBlock(end);
        return null;
    }

    private void jumpIf(ExprTy test, Block next, boolean jumpIfTrue) {
        if (test instanceof ExprTy.Compare) {
            SSTUtils.checkCompare(this.parserCallbacks, (ExprTy.Compare)test);
        }
        test.accept(this);
        if (jumpIfTrue) {
            this.addConditionalJump(OpCodes.POP_AND_JUMP_IF_TRUE, next);
        } else {
            this.addConditionalJump(OpCodes.POP_AND_JUMP_IF_FALSE, next);
        }
    }

    @Override
    public Void visit(StmtTy.Import node) {
        this.setLocation(node);
        return (Void)this.visitSequence(node.names);
    }

    @Override
    public Void visit(StmtTy.ImportFrom node) {
        String moduleName;
        this.setLocation(node);
        this.addLoadNumber(node.level);
        TruffleString[] names = new TruffleString[node.names.length];
        for (int i = 0; i < node.names.length; ++i) {
            names[i] = PythonUtils.toTruffleStringUncached(node.names[i].name);
        }
        if (node.getSourceRange().startLine > this.futureLineno && "__future__".equals(node.module)) {
            throw this.parserCallbacks.onError(ParserCallbacks.ErrorType.Syntax, node.getSourceRange(), "from __future__ imports must occur at the beginning of the file");
        }
        String string = moduleName = node.module != null ? node.module : "";
        if ("*".equals(node.names[0].name)) {
            this.addOpName(OpCodes.IMPORT_STAR, this.unit.names, moduleName);
        } else {
            this.addOp(OpCodes.LOAD_CONST, Compiler.addObject(this.unit.constants, names));
            this.addOpName(OpCodes.IMPORT_NAME, this.unit.names, moduleName);
            for (AliasTy alias : node.names) {
                this.addOpName(OpCodes.IMPORT_FROM, this.unit.names, alias.name);
                String storeName = alias.asName != null ? alias.asName : alias.name;
                this.addNameOp(storeName, ExprContextTy.Store);
            }
            this.addOp(OpCodes.POP_TOP);
        }
        return null;
    }

    @Override
    public Void visit(StmtTy.Match node) {
        this.setLocation(node);
        PatternContext pc = new PatternContext();
        node.subject.accept(this);
        Block end = new Block();
        assert (node.cases.length > 0);
        boolean hasDefault = node.cases.length > 1 && Compiler.wildcardCheck(node.cases[node.cases.length - 1].pattern);
        int lastIdx = hasDefault ? node.cases.length - 2 : node.cases.length - 1;
        for (int i = 0; i <= lastIdx; ++i) {
            MatchCaseTy c = node.cases[i];
            this.setLocation(c);
            if (i < lastIdx) {
                this.addOp(OpCodes.DUP_TOP);
            }
            pc.stores = new ArrayList();
            pc.allowIrrefutable = c.guard != null || i == node.cases.length - 1;
            pc.failPop = null;
            pc.onTop = 0;
            this.visit(c.pattern, pc);
            for (String name : pc.stores) {
                this.addNameOp(name, ExprContextTy.Store);
            }
            if (c.guard != null) {
                Compiler.ensureFailPop(i, pc);
                this.jumpIf(c.guard, pc.failPop.get(0), false);
            }
            if (i < lastIdx) {
                this.addOp(OpCodes.POP_TOP);
            }
            this.visitBody(c.body, false);
            this.addOp(OpCodes.JUMP_FORWARD, end);
            this.setLocation(c);
            this.emitAndResetFailPop(pc);
        }
        if (hasDefault) {
            MatchCaseTy c = node.cases[node.cases.length - 1];
            this.setLocation(c);
            if (node.cases.length == 1) {
                this.addOp(OpCodes.POP_TOP);
            } else {
                this.addOp(OpCodes.NOP);
            }
            if (c.guard != null) {
                this.jumpIf(c.guard, end, false);
            }
            this.visitBody(c.body, false);
        }
        this.unit.useNextBlock(end);
        return null;
    }

    private static boolean wildcardCheck(PatternTy pattern) {
        return pattern instanceof PatternTy.MatchAs && ((PatternTy.MatchAs)pattern).name == null;
    }

    private static boolean wildcardStarCheck(PatternTy pattern) {
        return pattern instanceof PatternTy.MatchStar && ((PatternTy.MatchStar)pattern).name == null;
    }

    public Void visit(PatternTy pattern, PatternContext pc) {
        if (pattern instanceof PatternTy.MatchAs) {
            return this.visit((PatternTy.MatchAs)pattern, pc);
        }
        if (pattern instanceof PatternTy.MatchMapping) {
            return this.visit((PatternTy.MatchMapping)pattern, pc);
        }
        if (pattern instanceof PatternTy.MatchSingleton) {
            return this.visit((PatternTy.MatchSingleton)pattern, pc);
        }
        if (pattern instanceof PatternTy.MatchClass) {
            return this.visit((PatternTy.MatchClass)pattern, pc);
        }
        if (pattern instanceof PatternTy.MatchOr) {
            return this.visit((PatternTy.MatchOr)pattern, pc);
        }
        if (pattern instanceof PatternTy.MatchSequence) {
            return this.visit((PatternTy.MatchSequence)pattern, pc);
        }
        if (pattern instanceof PatternTy.MatchStar) {
            return this.visit((PatternTy.MatchStar)pattern, pc);
        }
        if (pattern instanceof PatternTy.MatchValue) {
            return this.visit((PatternTy.MatchValue)pattern, pc);
        }
        throw new IllegalStateException("unknown PatternTy type " + String.valueOf(pattern.getClass()));
    }

    public Void visit(PatternTy.MatchStar node, PatternContext pc) {
        this.patternHelperStoreName(node.name, pc);
        return null;
    }

    public Void visit(PatternTy.MatchSequence node, PatternContext pc) {
        int size = Compiler.lengthOrZero(node.patterns);
        int star = -1;
        boolean onlyWildcard = true;
        boolean starWildcard = false;
        for (int i = 0; i < size; ++i) {
            PatternTy pattern = node.patterns[i];
            if (pattern instanceof PatternTy.MatchStar) {
                if (star >= 0) {
                    throw this.parserCallbacks.onError(ParserCallbacks.ErrorType.Syntax, node.getSourceRange(), "multiple starred names in sequence pattern");
                }
                starWildcard = Compiler.wildcardStarCheck(pattern);
                onlyWildcard &= starWildcard;
                star = i;
                continue;
            }
            onlyWildcard &= Compiler.wildcardCheck(pattern);
        }
        ++pc.onTop;
        this.addOp(OpCodes.MATCH_SEQUENCE);
        this.jumpToFailPop(OpCodes.POP_AND_JUMP_IF_FALSE, pc);
        if (star < 0) {
            this.addOp(OpCodes.GET_LEN);
            this.addLoadNumber(size);
            this.addCompareOp(CmpOpTy.Eq);
            this.jumpToFailPop(OpCodes.POP_AND_JUMP_IF_FALSE, pc);
        } else if (size > 1) {
            this.addOp(OpCodes.GET_LEN);
            this.addLoadNumber(size - 1);
            this.addCompareOp(CmpOpTy.GtE);
            this.jumpToFailPop(OpCodes.POP_AND_JUMP_IF_FALSE, pc);
        }
        --pc.onTop;
        if (onlyWildcard) {
            this.addOp(OpCodes.POP_TOP);
        } else if (starWildcard) {
            this.patternHelperSequenceSubscr(node.patterns, star, pc);
        } else {
            this.patternHelperSequenceUnpack(node.patterns, pc);
        }
        return null;
    }

    private void patternHelperSequenceSubscr(PatternTy[] patterns, int star, PatternContext pc) {
        ++pc.onTop;
        int size = Compiler.lengthOrZero(patterns);
        for (int i = 0; i < size; ++i) {
            PatternTy pattern = patterns[i];
            if (Compiler.wildcardCheck(pattern)) continue;
            if (i == star) {
                assert (Compiler.wildcardStarCheck(pattern));
                continue;
            }
            this.addOp(OpCodes.DUP_TOP);
            if (i < star) {
                this.addLoadNumber(i);
            } else {
                this.addOp(OpCodes.GET_LEN);
                this.addLoadNumber(size - i);
                this.addOp(OpCodes.BINARY_OP, BinaryOps.SUB.ordinal());
            }
            this.addOp(OpCodes.BINARY_SUBSCR);
            this.patternSubpattern(pattern, pc);
        }
        --pc.onTop;
        this.addOp(OpCodes.POP_TOP);
    }

    private void patternSubpattern(PatternTy pattern, PatternContext pc) {
        boolean allowIrrefutable = pc.allowIrrefutable;
        pc.allowIrrefutable = true;
        this.visit(pattern, pc);
        pc.allowIrrefutable = allowIrrefutable;
    }

    private void patternHelperSequenceUnpack(PatternTy[] patterns, PatternContext pc) {
        this.patternUnpackHelper(patterns);
        int size = Compiler.lengthOrZero(patterns);
        pc.onTop += size;
        for (int i = 0; i < size; ++i) {
            --pc.onTop;
            this.patternSubpattern(patterns[i], pc);
        }
    }

    private void patternUnpackHelper(PatternTy[] patterns) {
        int n = Compiler.lengthOrZero(patterns);
        boolean seenStar = false;
        for (int i = 0; i < n; ++i) {
            PatternTy pattern = patterns[i];
            if (!(pattern instanceof PatternTy.MatchStar)) continue;
            if (seenStar) {
                throw this.parserCallbacks.onError(ParserCallbacks.ErrorType.Syntax, this.unit.currentLocation, "multiple starred expressions in sequence pattern");
            }
            seenStar = true;
            int countAfter = n - i - 1;
            if (countAfter != (byte)countAfter) {
                throw this.parserCallbacks.onError(ParserCallbacks.ErrorType.Syntax, this.unit.currentLocation, "too many expressions in star-unpacking sequence pattern");
            }
            this.addOp(OpCodes.UNPACK_EX, i, new byte[]{(byte)countAfter});
        }
        if (!seenStar) {
            this.addOp(OpCodes.UNPACK_SEQUENCE, n);
        }
    }

    private static int lengthOrZero(Object[] p) {
        return p == null ? 0 : p.length;
    }

    public Void visit(PatternTy.MatchAs node, PatternContext pc) {
        if (node.pattern == null) {
            if (!pc.allowIrrefutable) {
                if (node.name != null) {
                    throw this.parserCallbacks.onError(ParserCallbacks.ErrorType.Syntax, this.unit.currentLocation, "name capture '%s' makes remaining patterns unreachable", node.name);
                }
                throw this.parserCallbacks.onError(ParserCallbacks.ErrorType.Syntax, this.unit.currentLocation, "wildcard makes remaining patterns unreachable");
            }
            this.patternHelperStoreName(node.name, pc);
            return null;
        }
        ++pc.onTop;
        this.addOp(OpCodes.DUP_TOP);
        this.visit(node.pattern, pc);
        --pc.onTop;
        this.patternHelperStoreName(node.name, pc);
        return null;
    }

    private void patternHelperStoreName(String n, PatternContext pc) {
        if (n == null) {
            this.addOp(OpCodes.POP_TOP);
            return;
        }
        this.checkForbiddenName(n, ExprContextTy.Store);
        if (pc.stores.contains(n)) {
            throw this.duplicateStoreError(n);
        }
        pc.stores.add(n);
        this.addOp(OpCodes.ROT_N, pc.onTop + pc.stores.size());
    }

    public Void visit(PatternTy.MatchClass node, PatternContext pc) {
        int i;
        int nKwdPatterns;
        Object[] patterns = node.patterns;
        Object[] kwdAttrs = node.kwdAttrs;
        Object[] kwdPatterns = node.kwdPatterns;
        int nargs = Compiler.lengthOrZero(patterns);
        int nattrs = Compiler.lengthOrZero(kwdAttrs);
        if (nattrs != (nKwdPatterns = Compiler.lengthOrZero(kwdPatterns))) {
            throw this.parserCallbacks.onError(ParserCallbacks.ErrorType.Syntax, this.unit.currentLocation, "kwd_attrs (%d) / kwd_patterns (%d) length mismatch in class pattern", nattrs, nKwdPatterns);
        }
        if (Integer.MAX_VALUE < nargs + nattrs - 1) {
            String id = node.cls instanceof ExprTy.Name ? ((ExprTy.Name)node.cls).id : node.cls.toString();
            throw this.parserCallbacks.onError(ParserCallbacks.ErrorType.Syntax, this.unit.currentLocation, "too many sub-patterns in class pattern %s", id);
        }
        if (nattrs > 0) {
            this.validateKwdAttrs((String[])kwdAttrs, (PatternTy[])kwdPatterns);
            this.setLocation(node);
        }
        node.cls.accept(this);
        TruffleString[] attrNames = new TruffleString[nattrs];
        for (i = 0; i < nattrs; ++i) {
            attrNames[i] = PythonUtils.toTruffleStringUncached((String)kwdAttrs[i]);
        }
        this.addOp(OpCodes.LOAD_CONST, Compiler.addObject(this.unit.constants, attrNames));
        this.addOp(OpCodes.MATCH_CLASS, nargs);
        ++pc.onTop;
        this.jumpToFailPop(OpCodes.POP_AND_JUMP_IF_FALSE, pc);
        for (i = 0; i < nargs + nattrs; ++i) {
            Object pattern = i < nargs ? patterns[i] : kwdPatterns[i - nargs];
            if (Compiler.wildcardCheck((PatternTy)pattern)) continue;
            this.addOp(OpCodes.DUP_TOP);
            this.addLoadNumber(i);
            this.addOp(OpCodes.BINARY_SUBSCR);
            this.patternSubpattern((PatternTy)pattern, pc);
        }
        --pc.onTop;
        this.addOp(OpCodes.POP_TOP);
        return null;
    }

    private void validateKwdAttrs(String[] attrs, PatternTy[] patterns) {
        int nattrs = Compiler.lengthOrZero(attrs);
        for (int i = 0; i < nattrs; ++i) {
            String attr = attrs[i];
            this.setLocation(patterns[i]);
            this.checkForbiddenName(attr, ExprContextTy.Store);
            for (int j = i + 1; j < nattrs; ++j) {
                String other = attrs[j];
                if (!attr.equals(other)) continue;
                this.setLocation(patterns[i]);
                throw this.parserCallbacks.onError(ParserCallbacks.ErrorType.Syntax, this.unit.currentLocation, "attribute name repeated in class pattern: `%s`", attr);
            }
        }
    }

    public Void visit(PatternTy.MatchMapping node, PatternContext pc) {
        int i;
        int npatterns;
        Object[] keys = node.keys;
        Object[] patterns = node.patterns;
        int size = Compiler.lengthOrZero(keys);
        if (size != (npatterns = Compiler.lengthOrZero(patterns))) {
            throw this.parserCallbacks.onError(ParserCallbacks.ErrorType.Syntax, this.unit.currentLocation, "keys (%d) / patterns (%d) length mismatch in mapping pattern", size, npatterns);
        }
        String starTarget = node.rest;
        ++pc.onTop;
        this.addOp(OpCodes.MATCH_MAPPING);
        this.jumpToFailPop(OpCodes.POP_AND_JUMP_IF_FALSE, pc);
        if (size == 0 && starTarget == null) {
            --pc.onTop;
            this.addOp(OpCodes.POP_TOP);
            return null;
        }
        if (Integer.MAX_VALUE < size - 1) {
            throw this.parserCallbacks.onError(ParserCallbacks.ErrorType.Syntax, this.unit.currentLocation, "too many sub-patterns in mapping pattern");
        }
        if (size > 0) {
            this.addOp(OpCodes.GET_LEN);
            this.addLoadNumber(size);
            this.addCompareOp(CmpOpTy.GtE);
            this.jumpToFailPop(OpCodes.POP_AND_JUMP_IF_FALSE, pc);
        }
        Collector collector = new Collector(192, 0);
        ArrayList<Object> seen = new ArrayList<Object>();
        for (i = 0; i < size; ++i) {
            Object key = keys[i];
            if (key == null) {
                this.setLocation((SSTNode)patterns[i]);
                throw this.parserCallbacks.onError(ParserCallbacks.ErrorType.Syntax, this.unit.currentLocation, "can't use NULL keys in MatchMapping (set 'rest' parameter instead)");
            }
            if (key instanceof ExprTy.Attribute) {
                ((SSTNode)key).accept(this);
            } else {
                ConstantValue constantValue = null;
                if (key instanceof ExprTy.UnaryOp || key instanceof ExprTy.BinOp) {
                    constantValue = this.foldConstantOp((ExprTy)key);
                } else if (key instanceof ExprTy.Constant) {
                    constantValue = ((ExprTy.Constant)key).value;
                } else {
                    throw this.parserCallbacks.onError(ParserCallbacks.ErrorType.Syntax, this.unit.currentLocation, "mapping pattern keys may only match literals and attribute lookups");
                }
                assert (constantValue != null);
                Object pythonValue = PythonUtils.pythonObjectFromConstantValue(constantValue);
                for (Object e : seen) {
                    if (!PyObjectRichCompareBool.executeEqUncached(e, pythonValue)) continue;
                    throw this.parserCallbacks.onError(ParserCallbacks.ErrorType.Syntax, this.unit.currentLocation, "mapping pattern checks duplicate key (%s)", pythonValue);
                }
                seen.add(pythonValue);
                this.addConstant(constantValue);
            }
            collector.appendItem();
        }
        collector.finishCollection();
        this.addOp(OpCodes.MATCH_KEYS);
        pc.onTop += 2;
        this.jumpToFailPop(OpCodes.POP_AND_JUMP_IF_FALSE, pc);
        for (i = 0; i < size; ++i) {
            PatternTy pattern = node.patterns[i];
            if (Compiler.wildcardCheck(pattern)) continue;
            this.addOp(OpCodes.DUP_TOP);
            this.addLoadNumber(i);
            this.addOp(OpCodes.BINARY_SUBSCR);
            this.patternSubpattern(pattern, pc);
        }
        pc.onTop -= 2;
        this.addOp(OpCodes.POP_TOP);
        if (starTarget != null) {
            this.addOp(OpCodes.COPY_DICT_WITHOUT_KEYS);
            this.patternHelperStoreName(starTarget, pc);
        } else {
            this.addOp(OpCodes.POP_TOP);
        }
        --pc.onTop;
        this.addOp(OpCodes.POP_TOP);
        return null;
    }

    public Void visit(PatternTy.MatchOr node, PatternContext pc) {
        Block end = new Block();
        int size = node.patterns.length;
        assert (size > 1);
        PatternContext oldPc = pc;
        ArrayList<String> control = null;
        for (int i = 0; i < size; ++i) {
            PatternTy pattern = node.patterns[i];
            this.setLocation(pattern);
            pc = new PatternContext();
            pc.stores = new ArrayList();
            pc.allowIrrefutable = i == size - 1 && oldPc.allowIrrefutable;
            pc.failPop = null;
            pc.onTop = 0;
            this.addOp(OpCodes.DUP_TOP);
            this.visit(pattern, pc);
            int nstores = pc.stores.size();
            if (i == 0) {
                assert (control == null);
                control = pc.stores;
            }
            if (nstores != control.size()) {
                throw this.altPatternsDiffNamesError();
            }
            if (nstores != 0) {
                int icontrol = nstores;
                while (icontrol-- > 0) {
                    String name = control.get(icontrol);
                    int istores = pc.stores.indexOf(name);
                    if (istores < 0) {
                        throw this.altPatternsDiffNamesError();
                    }
                    if (icontrol == istores) continue;
                    assert (istores < icontrol);
                    int rotations = istores + 1;
                    ArrayList<String> rotated = new ArrayList<String>();
                    Iterator<String> it = pc.stores.iterator();
                    int r = 0;
                    while (it.hasNext() && r++ < rotations) {
                        rotated.add(it.next());
                        it.remove();
                    }
                    for (int j = 0; j < rotated.size(); ++j) {
                        pc.stores.add(icontrol - istores + j, (String)rotated.get(j));
                    }
                    while (rotations-- > 0) {
                        this.addOp(OpCodes.ROT_N, icontrol + 1);
                    }
                }
            }
            assert (control != null);
            this.addOp(OpCodes.JUMP_FORWARD, end);
            this.unit.useNextBlock(new Block());
            this.emitAndResetFailPop(pc);
        }
        pc = oldPc;
        this.addOp(OpCodes.POP_TOP);
        this.jumpToFailPop(OpCodes.JUMP_FORWARD, pc);
        this.unit.useNextBlock(end);
        int nstores = control.size();
        int nrots = nstores + 1 + pc.onTop + pc.stores.size();
        for (int i = 0; i < nstores; ++i) {
            this.addOp(OpCodes.ROT_N, nrots);
            String name = (String)control.get(i);
            if (pc.stores.contains(name)) {
                throw this.duplicateStoreError(name);
            }
            pc.stores.add(name);
        }
        this.addOp(OpCodes.POP_TOP);
        return null;
    }

    private RuntimeException altPatternsDiffNamesError() {
        throw this.parserCallbacks.onError(ParserCallbacks.ErrorType.Syntax, this.unit.currentLocation, "alternative patterns bind different names");
    }

    private RuntimeException duplicateStoreError(String name) {
        throw this.parserCallbacks.onError(ParserCallbacks.ErrorType.Syntax, this.unit.currentLocation, "multiple assignments to name '%s' in pattern", name);
    }

    public Void visit(PatternTy.MatchSingleton node, PatternContext pc) {
        this.setLocation(node);
        switch (node.value.kind) {
            case BOOLEAN: {
                if (node.value.getBoolean()) {
                    this.addOp(OpCodes.LOAD_TRUE);
                    break;
                }
                this.addOp(OpCodes.LOAD_FALSE);
                break;
            }
            case NONE: {
                this.addOp(OpCodes.LOAD_NONE);
                break;
            }
            default: {
                throw new IllegalStateException("wrong MatchSingleton value kind " + String.valueOf((Object)node.value.kind));
            }
        }
        this.addCompareOp(CmpOpTy.Is);
        this.jumpToFailPop(OpCodes.POP_AND_JUMP_IF_FALSE, pc);
        return null;
    }

    public Void visit(PatternTy.MatchValue node, PatternContext pc) {
        this.setLocation(node);
        if (node.value instanceof ExprTy.UnaryOp || node.value instanceof ExprTy.BinOp) {
            this.addConstant(this.foldConstantOp(node.value));
        } else if (node.value instanceof ExprTy.Constant || node.value instanceof ExprTy.Attribute) {
            node.value.accept(this);
        } else {
            throw this.parserCallbacks.onError(ParserCallbacks.ErrorType.Syntax, this.unit.currentLocation, "patterns may only match literals and attribute lookups");
        }
        this.addCompareOp(CmpOpTy.Eq);
        this.jumpToFailPop(OpCodes.POP_AND_JUMP_IF_FALSE, pc);
        return null;
    }

    private ConstantValue foldConstantOp(ExprTy value) {
        if (value instanceof ExprTy.UnaryOp) {
            return this.foldUnaryOpConstant((ExprTy.UnaryOp)value);
        }
        if (value instanceof ExprTy.BinOp) {
            return this.foldBinOpComplexConstant((ExprTy.BinOp)value);
        }
        throw new IllegalStateException("should not reach here");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConstantValue foldUnaryOpConstant(ExprTy.UnaryOp unaryOp) {
        assert (unaryOp.op == UnaryOpTy.USub);
        assert (unaryOp.operand instanceof ExprTy.Constant) : unaryOp.operand;
        SourceRange savedLocation = this.setLocation(unaryOp);
        try {
            ExprTy.Constant c = (ExprTy.Constant)unaryOp.operand;
            ConstantValue ret = c.value.negate();
            assert (ret != null);
            ConstantValue constantValue = ret;
            return constantValue;
        }
        finally {
            this.setLocation(savedLocation);
        }
    }

    private ConstantValue foldBinOpComplexConstant(ExprTy.BinOp binOp) {
        assert ((binOp.left instanceof ExprTy.UnaryOp || binOp.left instanceof ExprTy.Constant) && binOp.right instanceof ExprTy.Constant) : String.valueOf(binOp.left) + " " + String.valueOf(binOp.right);
        assert (binOp.op == OperatorTy.Sub || binOp.op == OperatorTy.Add);
        SourceRange savedLocation = this.setLocation(binOp);
        try {
            ConstantValue left = binOp.left instanceof ExprTy.UnaryOp ? this.foldUnaryOpConstant((ExprTy.UnaryOp)binOp.left) : ((ExprTy.Constant)binOp.left).value;
            ExprTy.Constant right = (ExprTy.Constant)binOp.right;
            switch (binOp.op) {
                case Add: {
                    ConstantValue constantValue = left.addComplex(right.value);
                    return constantValue;
                }
                case Sub: {
                    ConstantValue constantValue = left.subComplex(right.value);
                    return constantValue;
                }
            }
            throw new IllegalStateException("wrong constant BinOp operator " + String.valueOf((Object)binOp.op));
        }
        finally {
            this.setLocation(savedLocation);
        }
    }

    private void jumpToFailPop(OpCodes op, PatternContext pc) {
        int pops = pc.onTop + (pc.stores == null ? 0 : pc.stores.size());
        Compiler.ensureFailPop(pops, pc);
        this.addConditionalJump(op, pc.failPop.get(pops));
        this.unit.useNextBlock(new Block());
    }

    private static void ensureFailPop(int n, PatternContext pc) {
        int size = n + 1;
        if (pc.failPop != null && size <= pc.failPop.size()) {
            return;
        }
        if (pc.failPop == null) {
            pc.failPop = new ArrayList();
        }
        while (pc.failPop.size() < size) {
            Block b = new Block();
            pc.failPop.add(b);
        }
    }

    private void emitAndResetFailPop(PatternContext pc) {
        if (pc.failPop == null) {
            this.unit.useNextBlock(new Block());
            return;
        }
        Collections.reverse(pc.failPop);
        Iterator<Block> it = pc.failPop.iterator();
        while (it.hasNext()) {
            Block b = it.next();
            this.unit.useNextBlock(b);
            it.remove();
            if (!it.hasNext()) continue;
            this.addOp(OpCodes.POP_TOP);
        }
    }

    @Override
    public Void visit(MatchCaseTy node) {
        throw new IllegalStateException("should not reach here");
    }

    @Override
    public Void visit(PatternTy.MatchValue node) {
        throw new IllegalStateException("should not reach here");
    }

    @Override
    public Void visit(PatternTy.MatchSingleton node) {
        throw new IllegalStateException("should not reach here");
    }

    @Override
    public Void visit(PatternTy.MatchAs node) {
        throw new IllegalStateException("should not reach here");
    }

    @Override
    public Void visit(PatternTy.MatchClass node) {
        throw new IllegalStateException("should not reach here");
    }

    @Override
    public Void visit(PatternTy.MatchMapping node) {
        throw new IllegalStateException("should not reach here");
    }

    @Override
    public Void visit(PatternTy.MatchOr node) {
        throw new IllegalStateException("should not reach here");
    }

    @Override
    public Void visit(PatternTy.MatchSequence node) {
        throw new IllegalStateException("should not reach here");
    }

    @Override
    public Void visit(PatternTy.MatchStar node) {
        throw new IllegalStateException("should not reach here");
    }

    @Override
    public Void visit(StmtTy.Nonlocal node) {
        this.setLocation(node);
        return null;
    }

    @Override
    public Void visit(StmtTy.Raise node) {
        this.setLocation(node);
        int argc = 0;
        if (node.exc != null) {
            ++argc;
            node.exc.accept(this);
            if (node.cause != null) {
                ++argc;
                node.cause.accept(this);
            }
        }
        this.addOp(OpCodes.RAISE_VARARGS, argc);
        this.unit.useNextBlock(new Block());
        return null;
    }

    @Override
    public Void visit(StmtTy.Return node) {
        this.setLocation(node);
        if (!this.unit.scope.isFunction()) {
            throw this.parserCallbacks.onError(ParserCallbacks.ErrorType.Syntax, this.unit.currentLocation, "'return' outside function");
        }
        if (node.value != null && this.unit.scope.isGenerator() && this.unit.scope.isCoroutine()) {
            throw this.parserCallbacks.onError(ParserCallbacks.ErrorType.Syntax, this.unit.currentLocation, "'return' with value in async generator");
        }
        if (node.value == null) {
            this.unwindBlockStack(UnwindType.RETURN_CONST);
            this.addOp(OpCodes.LOAD_NONE);
        } else if (node.value instanceof ExprTy.Constant) {
            this.unwindBlockStack(UnwindType.RETURN_CONST);
            node.value.accept(this);
        } else {
            node.value.accept(this);
            this.unwindBlockStack(UnwindType.RETURN_VALUE);
        }
        return this.addOp(OpCodes.RETURN_VALUE);
    }

    private void jumpToFinally(Block finalBlock, Block end) {
        if (finalBlock != null) {
            this.addOp(OpCodes.JUMP_FORWARD, finalBlock);
        } else {
            this.addOp(OpCodes.JUMP_FORWARD, end);
        }
    }

    @Override
    public Void visit(StmtTy.Try node) {
        Block elseBlock;
        boolean hasHandlers;
        this.setLocation(node);
        if (node.body[0].getSourceRange().startLine != node.getSourceRange().startLine) {
            this.addOp(OpCodes.NOP);
        }
        Block tryBody = new Block();
        Block end = new Block();
        boolean hasFinally = node.finalBody != null;
        boolean bl = hasHandlers = node.handlers != null && node.handlers.length > 0;
        assert (hasFinally || hasHandlers);
        Block exceptionHandlerBlock = null;
        Block finallyBlockNormal = null;
        Block finallyBlockExcept = null;
        Block finallyBlockExceptWithSavedExc = null;
        Block block = elseBlock = node.orElse != null ? new Block() : null;
        if (hasFinally) {
            finallyBlockNormal = new Block();
            finallyBlockExcept = new Block();
            finallyBlockExceptWithSavedExc = new Block();
            this.unit.pushBlock(new BlockInfo.TryFinally(tryBody, finallyBlockExcept, node.finalBody));
        }
        if (hasHandlers) {
            exceptionHandlerBlock = new Block();
            this.unit.pushBlock(new BlockInfo.TryExcept(tryBody, exceptionHandlerBlock));
        }
        this.unit.useNextBlock(tryBody);
        this.visitSequence(node.body);
        if (hasHandlers) {
            this.unit.popBlock();
        }
        if (elseBlock != null) {
            this.addOp(OpCodes.JUMP_FORWARD, elseBlock);
        } else {
            this.jumpToFinally(finallyBlockNormal, end);
        }
        if (hasHandlers) {
            this.unit.useNextBlock(exceptionHandlerBlock);
            this.addOp(OpCodes.PUSH_EXC_INFO);
            boolean hasBareExcept = false;
            Block nextHandler = new Block();
            Block commonCleanupHandler = new Block();
            this.unit.pushBlock(new BlockInfo.ExceptHandler(nextHandler, commonCleanupHandler));
            commonCleanupHandler.unwindOffset = -1;
            for (int i = 0; i < node.handlers.length; ++i) {
                ExceptHandlerTy.ExceptHandler handler = (ExceptHandlerTy.ExceptHandler)node.handlers[i];
                this.setLocation(handler);
                if (hasBareExcept) {
                    throw this.parserCallbacks.onError(ParserCallbacks.ErrorType.Syntax, this.unit.currentLocation, "default 'except:' must be last");
                }
                this.unit.useNextBlock(nextHandler);
                nextHandler = i < node.handlers.length - 1 ? new Block() : (hasFinally ? finallyBlockExceptWithSavedExc : commonCleanupHandler);
                Block bindingCleanerExcept = null;
                String bindingName = handler.name;
                if (handler.type != null) {
                    handler.type.accept(this);
                    this.addConditionalJump(OpCodes.MATCH_EXC_OR_JUMP, nextHandler);
                    if (bindingName != null) {
                        this.addOp(OpCodes.UNWRAP_EXC);
                        this.addNameOp(bindingName, ExprContextTy.Store);
                        Block handlerWithBinding = new Block();
                        bindingCleanerExcept = new Block();
                        this.unit.pushBlock(new BlockInfo.HandlerBindingCleanup(handlerWithBinding, bindingCleanerExcept, bindingName));
                        this.unit.useNextBlock(handlerWithBinding);
                    } else {
                        this.addOp(OpCodes.POP_TOP);
                    }
                } else {
                    hasBareExcept = true;
                    this.addOp(OpCodes.POP_TOP);
                }
                this.visitSequence(handler.body);
                if (bindingName != null) {
                    this.unit.popBlock();
                    this.unit.useNextBlock(new Block());
                    this.addOp(OpCodes.LOAD_NONE);
                    this.addNameOp(bindingName, ExprContextTy.Store);
                    this.addNameOp(bindingName, ExprContextTy.Del);
                }
                this.addOp(OpCodes.POP_EXCEPT);
                this.jumpToFinally(finallyBlockNormal, end);
                if (bindingName == null) continue;
                this.unit.useNextBlock(bindingCleanerExcept);
                this.addOp(OpCodes.LOAD_NONE);
                this.addNameOp(bindingName, ExprContextTy.Store);
                this.addNameOp(bindingName, ExprContextTy.Del);
                this.cleanupOnExceptionInHandler(hasFinally, finallyBlockExcept);
            }
            this.unit.popBlock();
            this.unit.useNextBlock(commonCleanupHandler);
            this.cleanupOnExceptionInHandler(hasFinally, finallyBlockExcept);
        }
        if (elseBlock != null) {
            this.unit.useNextBlock(elseBlock);
            this.visitSequence(node.orElse);
            this.jumpToFinally(finallyBlockNormal, end);
        }
        if (hasFinally) {
            this.unit.popBlock();
            this.unit.useNextBlock(finallyBlockExcept);
            this.addOp(OpCodes.PUSH_EXC_INFO);
            Block cleanupHandler = new Block();
            cleanupHandler.unwindOffset = -1;
            this.unit.pushBlock(new BlockInfo.FinallyHandler(finallyBlockExceptWithSavedExc, cleanupHandler));
            this.unit.useNextBlock(finallyBlockExceptWithSavedExc);
            this.visitSequence(node.finalBody);
            this.unit.popBlock();
            this.unit.useNextBlock(cleanupHandler);
            this.addOp(OpCodes.END_EXC_HANDLER);
            this.unit.useNextBlock(finallyBlockNormal);
            this.visitSequence(node.finalBody);
        }
        this.unit.useNextBlock(end);
        return null;
    }

    @Override
    public Void visit(StmtTy.TryStar node) {
        this.emitNotImplemented("try star");
        return null;
    }

    private void cleanupOnExceptionInHandler(boolean hasFinally, Block finallyBlockExcept) {
        if (hasFinally) {
            this.addOp(OpCodes.ROT_TWO);
            this.addOp(OpCodes.POP_EXCEPT);
            this.addOp(OpCodes.JUMP_FORWARD, finallyBlockExcept);
        } else {
            this.addOp(OpCodes.END_EXC_HANDLER);
        }
    }

    @Override
    public Void visit(ExceptHandlerTy.ExceptHandler node) {
        throw new IllegalStateException("should not reach here");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visit(StmtTy.While node) {
        this.setLocation(node);
        Block test = new Block();
        Block body = new Block();
        Block end = new Block();
        Block orelse = node.orElse != null ? new Block() : end;
        this.unit.useNextBlock(test);
        this.jumpIf(node.test, orelse, false);
        this.unit.useNextBlock(body);
        this.unit.pushBlock(new BlockInfo.While(test, end));
        try {
            this.visitSequence(node.body);
            this.addOp(OpCodes.JUMP_BACKWARD, test);
        }
        finally {
            this.unit.popBlock();
        }
        if (node.orElse != null) {
            this.unit.useNextBlock(orelse);
            this.visitSequence(node.orElse);
        }
        this.unit.useNextBlock(end);
        return null;
    }

    @Override
    public Void visit(StmtTy.With node) {
        this.setLocation(node);
        this.visitWith(node, 0);
        this.unit.useNextBlock(new Block());
        return null;
    }

    private void visitWith(StmtTy.With node, int itemIndex) {
        Block body = new Block();
        Block handler = new Block();
        WithItemTy item = node.items[itemIndex];
        item.contextExpr.accept(this);
        this.addOp(OpCodes.SETUP_WITH);
        this.unit.pushBlock(new BlockInfo.With(body, handler, node));
        this.unit.useNextBlock(body);
        handler.unwindOffset = -1;
        if (item.optionalVars != null) {
            item.optionalVars.accept(this);
        } else {
            this.addOp(OpCodes.POP_TOP);
        }
        if (itemIndex < node.items.length - 1) {
            this.visitWith(node, itemIndex + 1);
        } else {
            this.visitSequence(node.body);
        }
        this.addOp(OpCodes.LOAD_NONE);
        this.unit.popBlock();
        this.unit.useNextBlock(handler);
        this.setLocation(node);
        this.addOp(OpCodes.EXIT_WITH);
    }

    @Override
    public Void visit(WithItemTy node) {
        throw new IllegalStateException("should not reach here");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BlockInfo.Loop unwindBlockStack(UnwindType type) {
        BlockInfo savedInfo = this.unit.blockInfo;
        try {
            BlockInfo info = this.unit.blockInfo;
            while (info != null) {
                this.unit.blockInfo = info.outer;
                if (info instanceof BlockInfo.For) {
                    if (type == UnwindType.CONTINUE) {
                        var4_4 = (BlockInfo.Loop)info;
                        return var4_4;
                    }
                    if (type == UnwindType.RETURN_VALUE) {
                        this.addOp(OpCodes.ROT_TWO);
                    }
                    this.addOp(OpCodes.POP_TOP);
                    if (type == UnwindType.BREAK) {
                        var4_4 = (BlockInfo.Loop)info;
                        return var4_4;
                    }
                } else if (info instanceof BlockInfo.While) {
                    if (type == UnwindType.BREAK || type == UnwindType.CONTINUE) {
                        var4_4 = (BlockInfo.Loop)info;
                        return var4_4;
                    }
                } else if (info instanceof BlockInfo.With) {
                    this.unit.useNextBlock(new Block());
                    with = (BlockInfo.With)info;
                    this.setLocation(with.node);
                    if (type == UnwindType.RETURN_VALUE) {
                        this.addOp(OpCodes.ROT_THREE);
                    }
                    this.addOp(OpCodes.LOAD_NONE);
                    this.addOp(OpCodes.EXIT_WITH);
                } else if (info instanceof BlockInfo.AsyncWith) {
                    this.unit.useNextBlock(new Block());
                    with = (BlockInfo.AsyncWith)info;
                    this.setLocation(((BlockInfo.AsyncWith)with).node);
                    if (type == UnwindType.RETURN_VALUE) {
                        this.addOp(OpCodes.ROT_THREE);
                    }
                    this.addOp(OpCodes.LOAD_NONE);
                    this.addOp(OpCodes.GET_AEXIT_CORO);
                    this.addOp(OpCodes.GET_AWAITABLE);
                    this.addOp(OpCodes.LOAD_NONE);
                    this.addYieldFrom();
                    this.addOp(OpCodes.EXIT_AWITH);
                } else if (info instanceof BlockInfo.TryFinally) {
                    this.unit.useNextBlock(new Block());
                    if (type == UnwindType.RETURN_VALUE) {
                        this.unit.pushBlock(new BlockInfo.PopValue());
                    }
                    this.visitSequence(((BlockInfo.TryFinally)info).body);
                } else if (info instanceof BlockInfo.ExceptHandler) {
                    if (type == UnwindType.RETURN_VALUE) {
                        this.addOp(OpCodes.ROT_TWO);
                    }
                    this.addOp(OpCodes.POP_EXCEPT);
                } else if (info instanceof BlockInfo.HandlerBindingCleanup) {
                    String bindingName = ((BlockInfo.HandlerBindingCleanup)info).bindingName;
                    if (bindingName != null) {
                        this.addOp(OpCodes.LOAD_NONE);
                        this.addNameOp(bindingName, ExprContextTy.Store);
                        this.addNameOp(bindingName, ExprContextTy.Del);
                    }
                } else if (info instanceof BlockInfo.FinallyHandler) {
                    if (type == UnwindType.RETURN_VALUE) {
                        this.addOp(OpCodes.ROT_THREE);
                    }
                    this.addOp(OpCodes.POP_EXCEPT);
                    this.addOp(OpCodes.POP_TOP);
                } else if (info instanceof BlockInfo.PopValue) {
                    if (type == UnwindType.RETURN_VALUE) {
                        this.addOp(OpCodes.ROT_TWO);
                    }
                    this.addOp(OpCodes.POP_TOP);
                } else if (info instanceof BlockInfo.AsyncForLoop) {
                    if (type == UnwindType.CONTINUE) {
                        var4_4 = (BlockInfo.Loop)info;
                        return var4_4;
                    }
                    if (type == UnwindType.RETURN_VALUE) {
                        this.addOp(OpCodes.ROT_TWO);
                    }
                    this.addOp(OpCodes.POP_TOP);
                    if (type == UnwindType.BREAK) {
                        var4_4 = (BlockInfo.Loop)info;
                        return var4_4;
                    }
                }
                info = info.outer;
            }
        }
        finally {
            this.unit.blockInfo = savedInfo;
        }
        return null;
    }

    @Override
    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH"})
    public Void visit(StmtTy.Break node) {
        this.setLocation(node);
        SourceRange originLoc = this.unit.currentLocation;
        BlockInfo.Loop info = this.unwindBlockStack(UnwindType.BREAK);
        if (info == null) {
            throw this.parserCallbacks.onError(ParserCallbacks.ErrorType.Syntax, originLoc, "'break' outside loop");
        }
        this.addOp(OpCodes.JUMP_FORWARD, info.after);
        return null;
    }

    @Override
    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH"})
    public Void visit(StmtTy.Continue node) {
        this.setLocation(node);
        SourceRange originLoc = this.unit.currentLocation;
        BlockInfo.Loop info = this.unwindBlockStack(UnwindType.CONTINUE);
        if (info == null) {
            throw this.parserCallbacks.onError(ParserCallbacks.ErrorType.Syntax, originLoc, "'continue' not properly in loop");
        }
        this.addOp(OpCodes.JUMP_BACKWARD, info.start);
        return null;
    }

    @Override
    public Void visit(StmtTy.Pass node) {
        this.setLocation(node);
        this.addOp(OpCodes.NOP);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visit(StmtTy.TypeAlias node) {
        SourceRange savedLocation = this.setLocation(node);
        try {
            boolean isGeneric = node.typeParams != null && node.typeParams.length > 0;
            String name = ((ExprTy.Name)node.name).id;
            if (isGeneric) {
                String typeParamsName = "<generic parameters of " + name + ">";
                this.enterScope(typeParamsName, CompilationScope.TypeParams, node.typeParams, null, node.getSourceRange());
            }
            this.addOp(OpCodes.LOAD_STRING, Compiler.addObject(this.unit.constants, PythonUtils.toTruffleStringUncached(name)));
            if (isGeneric) {
                this.visitTypeParams(node.typeParams);
            } else {
                this.addOp(OpCodes.LOAD_NONE);
            }
            this.enterScope(name, CompilationScope.Function, node);
            Compiler.addObject(this.unit.constants, PNone.NONE);
            node.value.accept(this);
            this.addOp(OpCodes.RETURN_VALUE);
            BytecodeCodeUnit code = this.unit.assemble();
            this.exitScope();
            this.makeClosure(code, 0);
            this.addOp(OpCodes.MAKE_TYPE_ALIAS);
            if (isGeneric) {
                this.addOp(OpCodes.RETURN_VALUE);
                BytecodeCodeUnit typeParamsCode = this.unit.assemble();
                this.exitScope();
                this.makeClosure(typeParamsCode, 0);
                this.addOp(OpCodes.CALL_FUNCTION, 0);
            }
            this.addNameOp(name, ExprContextTy.Store);
            Void void_ = null;
            return void_;
        }
        finally {
            this.setLocation(savedLocation);
        }
    }

    @Override
    public Void visit(TypeParamTy.TypeVar node) {
        this.addOp(OpCodes.LOAD_STRING, Compiler.addObject(this.unit.constants, PythonUtils.toTruffleStringUncached(node.name)));
        if (node.bound != null) {
            this.enterScope(node.name, CompilationScope.TypeParams, node);
            node.bound.accept(this);
            this.addOp(OpCodes.RETURN_VALUE);
            BytecodeCodeUnit code = this.unit.assemble();
            this.exitScope();
            this.makeClosure(code, 0);
            this.addOp(OpCodes.MAKE_TYPE_PARAM, node.bound instanceof ExprTy.Tuple ? 4 : 3);
        } else {
            this.addOp(OpCodes.MAKE_TYPE_PARAM, 0);
        }
        this.addOp(OpCodes.DUP_TOP);
        this.addNameOp(node.name, ExprContextTy.Store);
        return null;
    }

    @Override
    public Void visit(TypeParamTy.ParamSpec node) {
        this.addOp(OpCodes.LOAD_STRING, Compiler.addObject(this.unit.constants, PythonUtils.toTruffleStringUncached(node.name)));
        this.addOp(OpCodes.MAKE_TYPE_PARAM, 2);
        this.addOp(OpCodes.DUP_TOP);
        this.addNameOp(node.name, ExprContextTy.Store);
        return null;
    }

    @Override
    public Void visit(TypeParamTy.TypeVarTuple node) {
        this.addOp(OpCodes.LOAD_STRING, Compiler.addObject(this.unit.constants, PythonUtils.toTruffleStringUncached(node.name)));
        this.addOp(OpCodes.MAKE_TYPE_PARAM, 1);
        this.addOp(OpCodes.DUP_TOP);
        this.addNameOp(node.name, ExprContextTy.Store);
        return null;
    }

    private void warn(SSTNode node, String message, Object ... arguments) {
        this.parserCallbacks.onWarning(ParserCallbacks.WarningType.Syntax, node.getSourceRange(), message, arguments);
    }

    public static Parser createParser(String src, ParserCallbacks errorCb, InputType inputType, boolean interactiveTerminal, boolean allowIncompleteInput) {
        EnumSet<AbstractParser.Flags> flags = EnumSet.noneOf(AbstractParser.Flags.class);
        if (interactiveTerminal) {
            flags.add(AbstractParser.Flags.INTERACTIVE_TERMINAL);
        }
        if (allowIncompleteInput) {
            flags.add(AbstractParser.Flags.ALLOW_INCOMPLETE_INPUT);
        }
        return Compiler.createParser(src, errorCb, inputType, flags, 12);
    }

    public static Parser createParser(String src, ParserCallbacks errorCb, InputType inputType, EnumSet<AbstractParser.Flags> flags, int featureVersion) {
        return new Parser(src, errorCb, inputType, flags, featureVersion);
    }

    public static final class Flags
    extends Enum<Flags> {
        private static final /* synthetic */ Flags[] $VALUES;

        public static Flags[] values() {
            return (Flags[])$VALUES.clone();
        }

        public static Flags valueOf(String name) {
            return Enum.valueOf(Flags.class, name);
        }

        private static /* synthetic */ Flags[] $values() {
            return new Flags[0];
        }

        static {
            $VALUES = Flags.$values();
        }
    }

    private class Collector {
        protected final int typeBits;
        protected final int stackItemsPerItem;
        protected int stackItems = 0;
        protected boolean collectionOnStack = false;

        public Collector(int typeBits) {
            this.typeBits = typeBits;
            this.stackItemsPerItem = typeBits == 128 ? 2 : 1;
        }

        public Collector(int typeBits, int stackItems) {
            this(typeBits);
            this.stackItems = stackItems;
        }

        public void appendItem() {
            this.stackItems += this.stackItemsPerItem;
            if (this.stackItems + this.stackItemsPerItem > 31) {
                this.doFlushStack();
            }
        }

        public void flushStackIfNecessary() {
            if (this.stackItems > 0) {
                this.doFlushStack();
            }
        }

        private void doFlushStack() {
            assert (this.stackItems <= 31);
            if (this.collectionOnStack) {
                Compiler.this.addOp(OpCodes.COLLECTION_ADD_STACK, this.typeBits | this.stackItems);
            } else {
                Compiler.this.addOp(OpCodes.COLLECTION_FROM_STACK, this.typeBits | this.stackItems);
            }
            this.collectionOnStack = true;
            this.stackItems = 0;
        }

        public void appendCollection() {
            assert (this.stackItems == 0);
            if (this.collectionOnStack) {
                Compiler.this.addOp(OpCodes.COLLECTION_ADD_COLLECTION, this.typeBits);
            } else {
                Compiler.this.addOp(OpCodes.COLLECTION_FROM_COLLECTION, this.typeBits);
            }
            this.collectionOnStack = true;
        }

        public void finishCollection() {
            if (this.stackItems > 0 || !this.collectionOnStack) {
                this.doFlushStack();
            }
        }

        public boolean isEmpty() {
            return this.stackItems == 0 && !this.collectionOnStack;
        }
    }

    private class KwargsMergingDictCollector
    extends Collector {
        private boolean namedKeywordDictOnStack;

        public KwargsMergingDictCollector(OpCodes callOp) {
            super(128);
            this.namedKeywordDictOnStack = false;
            assert (callOp == OpCodes.CALL_FUNCTION_KW);
        }

        @Override
        public void appendItem() {
            this.stackItems += this.stackItemsPerItem;
            if (this.stackItems + this.stackItemsPerItem > 31) {
                this.collectIntoNamedKeywordDict();
            }
        }

        @Override
        public void flushStackIfNecessary() {
            if (this.stackItems == 0 && !this.namedKeywordDictOnStack) {
                return;
            }
            if (this.stackItems > 0) {
                this.collectIntoNamedKeywordDict();
            }
            if (this.collectionOnStack) {
                Compiler.this.addOp(OpCodes.KWARGS_DICT_MERGE);
            }
            this.collectionOnStack = true;
            this.namedKeywordDictOnStack = false;
        }

        protected void collectIntoNamedKeywordDict() {
            if (this.namedKeywordDictOnStack) {
                Compiler.this.addOp(OpCodes.COLLECTION_ADD_STACK, this.typeBits | this.stackItems);
            } else {
                Compiler.this.addOp(OpCodes.COLLECTION_FROM_STACK, this.typeBits | this.stackItems);
                this.namedKeywordDictOnStack = true;
            }
            this.stackItems = 0;
        }

        @Override
        public void appendCollection() {
            assert (this.stackItems == 0);
            assert (!this.namedKeywordDictOnStack);
            if (this.collectionOnStack) {
                Compiler.this.addOp(OpCodes.KWARGS_DICT_MERGE);
            } else {
                Compiler.this.addOp(OpCodes.COLLECTION_FROM_COLLECTION, this.typeBits);
            }
            this.collectionOnStack = true;
        }

        @Override
        public void finishCollection() {
            this.flushStackIfNecessary();
        }

        @Override
        public boolean isEmpty() {
            return this.stackItems == 0 || !this.namedKeywordDictOnStack || !this.collectionOnStack;
        }
    }

    private static enum ComprehensionType {
        LIST(32),
        SET(96),
        DICT(128),
        GENEXPR(-1);

        public final int typeBits;

        private ComprehensionType(int typeBits) {
            this.typeBits = typeBits;
        }
    }

    public static final class ConstantCollection {
        public final Object collection;
        public final int elementType;

        ConstantCollection(Object collection, int elementType) {
            this.collection = collection;
            this.elementType = elementType;
        }
    }

    private static class PatternContext {
        ArrayList<String> stores;
        boolean allowIrrefutable;
        ArrayList<Block> failPop;
        int onTop;

        private PatternContext() {
        }
    }

    private static enum UnwindType {
        BREAK,
        CONTINUE,
        RETURN_VALUE,
        RETURN_CONST;

    }
}

