/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.util.io.DataEnumeratorEx;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnmodifiableEnumeratorWrapper<Data>
implements DataEnumeratorEx<Data> {
    @NotNull
    private final DataEnumeratorEx<Data> wrappedEnumerator;

    public UnmodifiableEnumeratorWrapper(@NotNull DataEnumeratorEx<Data> enumeratorToWrap) {
        if (enumeratorToWrap == null) {
            UnmodifiableEnumeratorWrapper.$$$reportNull$$$0(0);
        }
        this.wrappedEnumerator = enumeratorToWrap;
    }

    @Override
    public int enumerate(@Nullable Data value) throws IOException {
        int id = this.wrappedEnumerator.tryEnumerate(value);
        if (id == 0) {
            throw new IllegalStateException("Unmodifiable enumerator can't .enumerate() new values, but .enumerate(" + value + ") was requested");
        }
        return id;
    }

    @Override
    public int tryEnumerate(@Nullable Data value) throws IOException {
        return this.wrappedEnumerator.tryEnumerate(value);
    }

    @Override
    @Nullable
    public Data valueOf(int id) throws IOException {
        return this.wrappedEnumerator.valueOf(id);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumeratorToWrap", "com/intellij/util/io/UnmodifiableEnumeratorWrapper", "<init>"));
    }
}

