/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.plaf;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Shape;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.DimensionUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.IconUIResource;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.UIResource;
import org.jdesktop.swingx.painter.Painter;
import org.jdesktop.swingx.util.Contract;

public class UIManagerExt {
    private static UIDefaultsExt uiDefaultsExt = new UIDefaultsExt();

    private UIManagerExt() {
    }

    public static void addResourceBundle(String bundleName) {
        uiDefaultsExt.addResourceBundle(bundleName);
    }

    public static void removeResourceBundle(String bundleName) {
        uiDefaultsExt.removeResourceBundle(bundleName);
    }

    public static String getString(Object key) {
        return UIManagerExt.getString(key, null);
    }

    public static String getString(Object key, Locale l) {
        Object value = UIManager.get(key, l);
        if (value instanceof String) {
            return (String)value;
        }
        if (value == null && (value = UIManagerExt.uiDefaultsExt.getFromResourceBundle(key, l)) instanceof String) {
            return (String)value;
        }
        return null;
    }

    public static int getInt(Object key) {
        return UIManagerExt.getInt(key, null);
    }

    public static int getInt(Object key, Locale l) {
        Object value = UIManager.get(key, l);
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value == null) {
            value = UIManagerExt.uiDefaultsExt.getFromResourceBundle(key, l);
            if (value instanceof Integer) {
                return (Integer)value;
            }
            if (value instanceof String) {
                try {
                    return Integer.decode((String)value);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return 0;
    }

    public static boolean getBoolean(Object key) {
        return UIManagerExt.getBoolean(key, null);
    }

    public static boolean getBoolean(Object key, Locale l) {
        Object value = UIManager.get(key, l);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value == null) {
            value = UIManagerExt.uiDefaultsExt.getFromResourceBundle(key, l);
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
            if (value instanceof String) {
                return Boolean.valueOf((String)value);
            }
        }
        return false;
    }

    public static Color getColor(Object key) {
        return UIManagerExt.getColor(key, null);
    }

    public static Color getColor(Object key, Locale l) {
        Object value = UIManager.get(key, l);
        if (value instanceof Color) {
            return (Color)value;
        }
        if (value == null) {
            value = UIManagerExt.uiDefaultsExt.getFromResourceBundle(key, l);
            if (value instanceof Color) {
                return (Color)value;
            }
            if (value instanceof String) {
                try {
                    return Color.decode((String)value);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public static Shape getShape(Object key) {
        Object value = UIManager.getDefaults().get(key);
        return value instanceof Shape ? (Shape)value : null;
    }

    public static Shape getShape(Object key, Locale l) {
        Object value = UIManager.getDefaults().get(key, l);
        return value instanceof Shape ? (Shape)value : null;
    }

    public static Painter<?> getPainter(Object key) {
        Object value = UIManager.getDefaults().get(key);
        return value instanceof Painter ? (Painter)value : null;
    }

    public static Painter<?> getPainter(Object key, Locale l) {
        Object value = UIManager.getDefaults().get(key, l);
        return value instanceof Painter ? (Painter)value : null;
    }

    public static Border getSafeBorder(Object key, Border defaultBorder) {
        Contract.asNotNull(defaultBorder, "defaultBorder cannot be null");
        Border safeBorder = UIManager.getBorder(key);
        if (safeBorder == null) {
            safeBorder = defaultBorder;
        }
        if (!(safeBorder instanceof UIResource)) {
            safeBorder = new BorderUIResource(safeBorder);
        }
        return safeBorder;
    }

    public static Color getSafeColor(Object key, Color defaultColor) {
        Contract.asNotNull(defaultColor, "defaultColor cannot be null");
        Color safeColor = UIManager.getColor(key);
        if (safeColor == null) {
            safeColor = defaultColor;
        }
        if (!(safeColor instanceof UIResource)) {
            safeColor = new ColorUIResource(safeColor);
        }
        return safeColor;
    }

    public static Dimension getSafeDimension(Object key, Dimension defaultDimension) {
        Contract.asNotNull(defaultDimension, "defaultDimension cannot be null");
        Dimension safeDimension = UIManager.getDimension(key);
        if (safeDimension == null) {
            safeDimension = defaultDimension;
        }
        if (!(safeDimension instanceof UIResource)) {
            safeDimension = new DimensionUIResource(safeDimension.width, safeDimension.height);
        }
        return safeDimension;
    }

    public static Font getSafeFont(Object key, Font defaultFont) {
        Contract.asNotNull(defaultFont, "defaultFont cannot be null");
        Font safeFont = UIManager.getFont(key);
        if (safeFont == null) {
            safeFont = defaultFont;
        }
        if (!(safeFont instanceof UIResource)) {
            safeFont = new FontUIResource(safeFont);
        }
        return safeFont;
    }

    public static Icon getSafeIcon(Object key, Icon defaultIcon) {
        Contract.asNotNull(defaultIcon, "defaultIcon cannot be null");
        Icon safeIcon = UIManager.getIcon(key);
        if (safeIcon == null) {
            safeIcon = defaultIcon;
        }
        if (!(safeIcon instanceof UIResource)) {
            safeIcon = new IconUIResource(safeIcon);
        }
        return safeIcon;
    }

    public static Insets getSafeInsets(Object key, Insets defaultInsets) {
        Contract.asNotNull(defaultInsets, "defaultInsets cannot be null");
        Insets safeInsets = UIManager.getInsets(key);
        if (safeInsets == null) {
            safeInsets = defaultInsets;
        }
        if (!(safeInsets instanceof UIResource)) {
            safeInsets = new InsetsUIResource(safeInsets.top, safeInsets.left, safeInsets.bottom, safeInsets.right);
        }
        return safeInsets;
    }

    private static class UIDefaultsExt {
        private Vector<String> resourceBundles;
        private Map<Locale, Map<String, String>> resourceCache = new HashMap<Locale, Map<String, String>>();

        UIDefaultsExt() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object getFromResourceBundle(Object key, Locale l) {
            if (this.resourceBundles == null || this.resourceBundles.isEmpty() || !(key instanceof String)) {
                return null;
            }
            if (l == null) {
                l = Locale.getDefault();
            }
            UIDefaultsExt uIDefaultsExt = this;
            synchronized (uIDefaultsExt) {
                return this.getResourceCache(l).get((String)key);
            }
        }

        private Map<String, String> getResourceCache(Locale l) {
            Map<String, String> values = this.resourceCache.get(l);
            if (values == null) {
                values = new HashMap<String, String>();
                for (int i2 = this.resourceBundles.size() - 1; i2 >= 0; --i2) {
                    String bundleName = this.resourceBundles.get(i2);
                    try {
                        ResourceBundle b = ResourceBundle.getBundle(bundleName, l, UIManagerExt.class.getClassLoader());
                        Enumeration<String> keys = b.getKeys();
                        while (keys.hasMoreElements()) {
                            String key = keys.nextElement();
                            if (values.get(key) != null) continue;
                            Object value = b.getObject(key);
                            values.put(key, (String)value);
                        }
                        continue;
                    }
                    catch (MissingResourceException mre) {
                        // empty catch block
                    }
                }
                this.resourceCache.put(l, values);
            }
            return values;
        }

        public synchronized void addResourceBundle(String bundleName) {
            if (bundleName == null) {
                return;
            }
            if (this.resourceBundles == null) {
                this.resourceBundles = new Vector(5);
            }
            if (!this.resourceBundles.contains(bundleName)) {
                this.resourceBundles.add(bundleName);
                this.resourceCache.clear();
            }
        }

        public synchronized void removeResourceBundle(String bundleName) {
            if (this.resourceBundles != null) {
                this.resourceBundles.remove(bundleName);
            }
            this.resourceCache.clear();
        }
    }
}

