/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.mlapi.feature.json;

import com.jetbrains.mlapi.feature.Feature;
import com.jetbrains.mlapi.feature.FeatureSignature;
import com.jetbrains.mlapi.feature.PrimitiveType;
import com.jetbrains.mlapi.feature.UnionFeatureSignature;
import com.jetbrains.mlapi.feature.UnionType;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u0000 \u001f2\u00020\u00012\u00020\u0002:\u0001\u001fB\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0096\u0002J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u0004H\u0016J\u0010\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u0004H\u0016R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006 "}, d2={"Lcom/jetbrains/mlapi/feature/json/JsonFloatingFeature;", "Lcom/jetbrains/mlapi/feature/Feature$Float;", "Lcom/jetbrains/mlapi/feature/Feature$Double;", "name", "", "content", "(Ljava/lang/String;Ljava/lang/String;)V", "doubleValue", "", "getDoubleValue", "()D", "floatValue", "", "getFloatValue", "()F", "floatingAsString", "getFloatingAsString", "()Ljava/lang/String;", "signature", "Lcom/jetbrains/mlapi/feature/FeatureSignature;", "getSignature", "()Lcom/jetbrains/mlapi/feature/FeatureSignature;", "equals", "", "other", "", "hashCode", "", "toString", "withName", "newName", "Companion", "mlapi-core"})
public final class JsonFloatingFeature
implements Feature.Float,
Feature.Double {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String content;
    @NotNull
    private final FeatureSignature signature;
    @NotNull
    private static final UnionType FLOATING_TYPE;

    public JsonFloatingFeature(@NotNull String name, @NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        this.content = content;
        this.signature = new UnionFeatureSignature(name, FLOATING_TYPE, null, 4, null);
    }

    @Override
    @NotNull
    public FeatureSignature getSignature() {
        return this.signature;
    }

    @Override
    public float getFloatValue() {
        return Float.parseFloat(this.content);
    }

    @Override
    public double getDoubleValue() {
        return Double.parseDouble(this.content);
    }

    @Override
    @NotNull
    public String getFloatingAsString() {
        return this.content;
    }

    @Override
    @NotNull
    public JsonFloatingFeature withName(@NotNull String newName) {
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        return new JsonFloatingFeature(newName, this.content);
    }

    @NotNull
    public String toString() {
        return this.getName() + "(json-floating)='" + this.content + "'";
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type com.jetbrains.mlapi.feature.json.JsonFloatingFeature");
        JsonFloatingFeature cfr_ignored_0 = (JsonFloatingFeature)other;
        if (!Intrinsics.areEqual((Object)this.content, (Object)((JsonFloatingFeature)other).content)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.getSignature(), (Object)((JsonFloatingFeature)other).getSignature());
    }

    public int hashCode() {
        int result = this.content.hashCode();
        result = 31 * result + this.getSignature().hashCode();
        return result;
    }

    static {
        PrimitiveType[] primitiveTypeArray = new PrimitiveType[]{PrimitiveType.Float.INSTANCE, PrimitiveType.Double.INSTANCE};
        FLOATING_TYPE = new UnionType(primitiveTypeArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/mlapi/feature/json/JsonFloatingFeature$Companion;", "", "()V", "FLOATING_TYPE", "Lcom/jetbrains/mlapi/feature/UnionType;", "mlapi-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

