/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.ui.diff.util;

import com.intellij.diff.util.LineRange;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JD\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005J*\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002J\u001c\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/diff/util/LineRangeUtil;", "", "<init>", "()V", "extract", "", "Lcom/intellij/diff/util/LineRange;", "leftRange", "rightRange", "leftChangedRanges", "rightChangedRanges", "subtractRanges", "source", "subtract", "sumRanges", "ranges", "intellij.vcs.github"})
@SourceDebugExtension(value={"SMAP\nLineRangeUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LineRangeUtil.kt\norg/jetbrains/plugins/github/pullrequest/ui/diff/util/LineRangeUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,64:1\n1374#2:65\n1460#2,5:66\n1056#2:71\n*S KotlinDebug\n*F\n+ 1 LineRangeUtil.kt\norg/jetbrains/plugins/github/pullrequest/ui/diff/util/LineRangeUtil\n*L\n24#1:65\n24#1:66,5\n48#1:71\n*E\n"})
public final class LineRangeUtil {
    @NotNull
    public static final LineRangeUtil INSTANCE = new LineRangeUtil();

    private LineRangeUtil() {
    }

    @NotNull
    public final List<LineRange> extract(@NotNull List<LineRange> leftRange, @NotNull List<LineRange> rightRange, @NotNull List<LineRange> leftChangedRanges, @NotNull List<LineRange> rightChangedRanges) {
        Intrinsics.checkNotNullParameter(leftRange, (String)"leftRange");
        Intrinsics.checkNotNullParameter(rightRange, (String)"rightRange");
        Intrinsics.checkNotNullParameter(leftChangedRanges, (String)"leftChangedRanges");
        Intrinsics.checkNotNullParameter(rightChangedRanges, (String)"rightChangedRanges");
        List<LineRange> newLeftRanges = this.subtractRanges(leftRange, rightChangedRanges);
        List<LineRange> newRightRanges = this.subtractRanges(rightRange, leftChangedRanges);
        return this.sumRanges(CollectionsKt.plus((Collection)newLeftRanges, (Iterable)newRightRanges));
    }

    /*
     * WARNING - void declaration
     */
    private final List<LineRange> subtractRanges(List<LineRange> source, List<LineRange> subtract) {
        List results = source;
        for (LineRange subtractRange : subtract) {
            void $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv = results;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                List list;
                int overlapEnd;
                LineRange currentRange = (LineRange)element$iv$iv;
                boolean bl = false;
                int overlapStart = Math.max(currentRange.start, subtractRange.start);
                if (overlapStart >= (overlapEnd = Math.min(currentRange.end, subtractRange.end))) {
                    list = CollectionsKt.listOf((Object)currentRange);
                } else {
                    List newRanges = new ArrayList();
                    if (currentRange.start < overlapStart) {
                        newRanges.add(new LineRange(currentRange.start, overlapStart));
                    }
                    if (currentRange.end > overlapEnd) {
                        newRanges.add(new LineRange(overlapEnd, currentRange.end));
                    }
                    list = newRanges;
                }
                Iterable list$iv$iv = list;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            results = (List)destination$iv$iv;
        }
        return results;
    }

    private final List<LineRange> sumRanges(List<LineRange> ranges) {
        List results = new ArrayList();
        Iterable $this$sortedBy$iv = ranges;
        boolean $i$f$sortedBy = false;
        List sortedRanges = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                LineRange it = (LineRange)a;
                boolean bl = false;
                it = (LineRange)b;
                Comparable comparable = Integer.valueOf(it.start);
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Integer.valueOf(it.start));
            }
        });
        results.add(CollectionsKt.first((List)sortedRanges));
        int n = sortedRanges.size();
        for (int i = 1; i < n; ++i) {
            LineRange lineRange;
            LineRange current = (LineRange)CollectionsKt.last((List)results);
            LineRange next = (LineRange)sortedRanges.get(i);
            if (next.start <= current.end) {
                results.remove(results.size() - 1);
                lineRange = new LineRange(current.start, Math.max(current.end, next.end));
            } else {
                lineRange = next;
            }
            LineRange nextResult = lineRange;
            results.add(nextResult);
        }
        return results;
    }
}

