/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.filter;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.vcs.log.VcsLogDateFilter;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.impl.MainVcsLogUiProperties;
import com.intellij.vcs.log.ui.filter.FilterModel;
import com.intellij.vcs.log.visible.filters.VcsLogFilterObject;
import java.util.Date;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u0000 \u000f2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u000fB\u0019\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0018\u0010\t\u001a\u0004\u0018\u00010\u00022\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0014J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u000e\u001a\u00020\u0002H\u0014\u00a8\u0006\u0010"}, d2={"Lcom/intellij/vcs/log/ui/filter/DateFilterModel;", "Lcom/intellij/vcs/log/ui/filter/FilterModel$SingleFilterModel;", "Lcom/intellij/vcs/log/VcsLogDateFilter;", "uiProperties", "Lcom/intellij/vcs/log/impl/MainVcsLogUiProperties;", "filters", "Lcom/intellij/vcs/log/VcsLogFilterCollection;", "<init>", "(Lcom/intellij/vcs/log/impl/MainVcsLogUiProperties;Lcom/intellij/vcs/log/VcsLogFilterCollection;)V", "createFilter", "values", "", "", "getFilterValues", "filter", "Companion", "intellij.platform.vcs.log.impl"})
public final class DateFilterModel
extends FilterModel.SingleFilterModel<VcsLogDateFilter> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;

    public DateFilterModel(@NotNull MainVcsLogUiProperties uiProperties, @Nullable VcsLogFilterCollection filters) {
        Intrinsics.checkNotNullParameter((Object)uiProperties, (String)"uiProperties");
        VcsLogFilterCollection.FilterKey filterKey = VcsLogFilterCollection.DATE_FILTER;
        Intrinsics.checkNotNullExpressionValue((Object)filterKey, (String)"DATE_FILTER");
        super(filterKey, uiProperties, filters);
    }

    @Override
    @Nullable
    protected VcsLogDateFilter createFilter(@NotNull List<String> values) {
        Intrinsics.checkNotNullParameter(values, (String)"values");
        if (values.size() != 2) {
            LOG.warn("Can not create date filter from " + values + " before and after dates are required.");
            return null;
        }
        String string = values.get(0);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"get(...)");
        String after = string;
        String string2 = values.get(1);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"get(...)");
        String before = string2;
        try {
            return VcsLogFilterObject.fromDates(((CharSequence)after).length() == 0 ? 0L : Long.parseLong(after), ((CharSequence)before).length() == 0 ? 0L : Long.parseLong(before));
        }
        catch (NumberFormatException e) {
            LOG.warn("Can not create date filter from " + values);
            return null;
        }
    }

    @Override
    @NotNull
    protected List<String> getFilterValues(@NotNull VcsLogDateFilter filter) {
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        return Companion.getDateValues(filter);
    }

    static {
        Logger logger = Logger.getInstance(DateFilterModel.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bR\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/vcs/log/ui/filter/DateFilterModel$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getDateValues", "", "", "filter", "Lcom/intellij/vcs/log/VcsLogDateFilter;", "intellij.platform.vcs.log.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<String> getDateValues(@NotNull VcsLogDateFilter filter) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
            Date after = filter.getAfter();
            Date before = filter.getBefore();
            Object[] objectArray = new String[2];
            Object object2 = after;
            if (object2 == null || (object2 = String.valueOf(((Date)object2).getTime())) == null) {
                object2 = objectArray[0] = "";
            }
            if ((object = before) == null || (object = String.valueOf(((Date)object).getTime())) == null) {
                object = "";
            }
            objectArray[1] = object;
            return CollectionsKt.listOf((Object[])objectArray);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

