/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph;

import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.LafManagerListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.ui.JBColor;
import com.intellij.util.messages.SimpleMessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.vcs.log.paint.ColorGenerator;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.awt.Color;
import javax.swing.UIManager;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0007\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/vcs/log/graph/DefaultColorGenerator;", "Lcom/intellij/vcs/log/paint/ColorGenerator;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "colorMap", "Lit/unimi/dsi/fastutil/ints/Int2ObjectOpenHashMap;", "Lcom/intellij/ui/JBColor;", "getColor", "colorId", "", "Companion", "intellij.platform.vcs.log.impl"})
@ApiStatus.Internal
public final class DefaultColorGenerator
implements ColorGenerator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Int2ObjectOpenHashMap<JBColor> colorMap;
    @NotNull
    private static final float[] buffer = new float[3];

    /*
     * WARNING - void declaration
     */
    public DefaultColorGenerator(@NotNull CoroutineScope coroutineScope) {
        void it;
        Int2ObjectOpenHashMap int2ObjectOpenHashMap;
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        Int2ObjectOpenHashMap int2ObjectOpenHashMap2 = int2ObjectOpenHashMap = new Int2ObjectOpenHashMap();
        DefaultColorGenerator defaultColorGenerator = this;
        boolean bl = false;
        DefaultColorGenerator.Companion.putDefaultColor((Int2ObjectOpenHashMap<JBColor>)((Int2ObjectOpenHashMap)it));
        defaultColorGenerator.colorMap = int2ObjectOpenHashMap;
        SimpleMessageBusConnection simpleMessageBusConnection = ApplicationManager.getApplication().getMessageBus().connect(coroutineScope);
        Topic topic = LafManagerListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        simpleMessageBusConnection.subscribe(topic, arg_0 -> DefaultColorGenerator._init_$lambda$0(this, arg_0));
    }

    @NotNull
    public JBColor getColor(int colorId) {
        Object object = this.colorMap.computeIfAbsent(colorId, DefaultColorGenerator::getColor$lambda$0);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"computeIfAbsent(...)");
        return (JBColor)object;
    }

    private static final void _init_$lambda$0(DefaultColorGenerator this$0, LafManager it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.colorMap.clear();
        DefaultColorGenerator.Companion.putDefaultColor((Int2ObjectOpenHashMap<JBColor>)this$0.colorMap);
    }

    private static final JBColor getColor$lambda$0(int it) {
        return DefaultColorGenerator.Companion.calcColor(it);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u0014\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000fH\u0002J\u0016\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\r0\u0015H\u0002J\u0018\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0005H\u0002R\u0014\u0010\u0004\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/vcs/log/graph/DefaultColorGenerator$Companion;", "", "<init>", "()V", "saturation", "", "getSaturation", "()F", "brightness", "getBrightness", "buffer", "", "calcColor", "Lcom/intellij/ui/JBColor;", "colorId", "", "rangeFix", "n", "putDefaultColor", "", "map", "Lit/unimi/dsi/fastutil/ints/Int2ObjectOpenHashMap;", "namedFloat", "name", "", "default", "intellij.platform.vcs.log.impl"})
    public static final class Companion {
        private Companion() {
        }

        private final float getSaturation() {
            return RangesKt.coerceIn((float)this.namedFloat("VersionControl.Log.Graph.saturation", 0.4f), (float)0.0f, (float)1.0f);
        }

        private final float getBrightness() {
            return RangesKt.coerceIn((float)this.namedFloat("VersionControl.Log.Graph.brightness", 0.65f), (float)0.0f, (float)1.0f);
        }

        private final JBColor calcColor(int colorId) {
            JBColor jBColor;
            int r = colorId * 200 + 30;
            int g = colorId * 130 + 50;
            int b = colorId * 90 + 100;
            try {
                float[] hsb = Color.RGBtoHSB(this.rangeFix(r), this.rangeFix(g), this.rangeFix(b), buffer);
                int rgb = Color.HSBtoRGB(hsb[0], this.getSaturation(), this.getBrightness());
                Color color = new Color(rgb);
                jBColor = new JBColor(color, color);
            }
            catch (IllegalArgumentException a) {
                throw new IllegalArgumentException("Color: " + colorId + " " + r % 256 + " " + g % 256 + " " + b % 256);
            }
            return jBColor;
        }

        private final int rangeFix(int n) {
            return Math.abs(n % 100) + 70;
        }

        private final void putDefaultColor(Int2ObjectOpenHashMap<JBColor> map) {
            map.put(0, (Object)JBColor.BLACK);
        }

        private final float namedFloat(String name, float f) {
            float f2;
            Object value = UIManager.get(name);
            if (value instanceof Float) {
                f2 = ((Number)value).floatValue();
            } else if (value instanceof Double) {
                f2 = (float)((Number)value).doubleValue();
            } else if (value instanceof String) {
                Float f3 = StringsKt.toFloatOrNull((String)((String)value));
                f2 = f3 != null ? f3.floatValue() : f;
            } else {
                f2 = f;
            }
            return f2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

