/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.indices.update_aliases;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch.indices.update_aliases.Action;
import org.opensearch.client.opensearch.indices.update_aliases.ActionVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class RemoveIndexAction
implements ActionVariant,
PlainJsonSerializable,
ToCopyableBuilder<Builder, RemoveIndexAction> {
    @Nullable
    private final String index;
    @Nonnull
    private final List<String> indices;
    @Nullable
    private final Boolean mustExist;
    public static final JsonpDeserializer<RemoveIndexAction> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RemoveIndexAction::setupRemoveIndexActionDeserializer);

    private RemoveIndexAction(Builder builder) {
        this.index = builder.index;
        this.indices = ApiTypeHelper.unmodifiable(builder.indices);
        this.mustExist = builder.mustExist;
    }

    public static RemoveIndexAction of(Function<Builder, ObjectBuilder<RemoveIndexAction>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Action.Kind _actionKind() {
        return Action.Kind.RemoveIndex;
    }

    @Nullable
    public final String index() {
        return this.index;
    }

    @Nonnull
    public final List<String> indices() {
        return this.indices;
    }

    @Nullable
    public final Boolean mustExist() {
        return this.mustExist;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.index != null) {
            generator.writeKey("index");
            generator.write(this.index);
        }
        if (ApiTypeHelper.isDefined(this.indices)) {
            generator.writeKey("indices");
            generator.writeStartArray();
            for (String item0 : this.indices) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (this.mustExist != null) {
            generator.writeKey("must_exist");
            generator.write(this.mustExist.booleanValue());
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupRemoveIndexActionDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::index, JsonpDeserializer.stringDeserializer(), "index");
        op.add(Builder::indices, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "indices");
        op.add(Builder::mustExist, JsonpDeserializer.booleanDeserializer(), "must_exist");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.index);
        result = 31 * result + Objects.hashCode(this.indices);
        result = 31 * result + Objects.hashCode(this.mustExist);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RemoveIndexAction other = (RemoveIndexAction)o;
        return Objects.equals(this.index, other.index) && Objects.equals(this.indices, other.indices) && Objects.equals(this.mustExist, other.mustExist);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, RemoveIndexAction> {
        @Nullable
        private String index;
        @Nullable
        private List<String> indices;
        @Nullable
        private Boolean mustExist;

        public Builder() {
        }

        private Builder(RemoveIndexAction o) {
            this.index = o.index;
            this.indices = Builder._listCopy(o.indices);
            this.mustExist = o.mustExist;
        }

        private Builder(Builder o) {
            this.index = o.index;
            this.indices = Builder._listCopy(o.indices);
            this.mustExist = o.mustExist;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder index(@Nullable String value) {
            this.index = value;
            return this;
        }

        @Nonnull
        public final Builder indices(List<String> list) {
            this.indices = Builder._listAddAll(this.indices, list);
            return this;
        }

        @Nonnull
        public final Builder indices(String value, String ... values) {
            this.indices = Builder._listAdd(this.indices, value, values);
            return this;
        }

        @Nonnull
        public final Builder mustExist(@Nullable Boolean value) {
            this.mustExist = value;
            return this;
        }

        @Override
        @Nonnull
        public RemoveIndexAction build() {
            this._checkSingleUse();
            return new RemoveIndexAction(this);
        }
    }
}

