/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.transport.grpc.proto.request.search.query;

import org.opensearch.common.geo.GeoDistance;
import org.opensearch.common.geo.GeoPoint;
import org.opensearch.common.geo.GeoUtils;
import org.opensearch.common.unit.DistanceUnit;
import org.opensearch.index.query.GeoDistanceQueryBuilder;
import org.opensearch.index.query.GeoValidationMethod;
import org.opensearch.protobufs.GeoDistanceQuery;
import org.opensearch.protobufs.GeoDistanceType;
import org.opensearch.protobufs.GeoLocation;
import org.opensearch.transport.grpc.proto.request.common.GeoPointProtoUtils;

class GeoDistanceQueryBuilderProtoUtils {
    private GeoDistanceQueryBuilderProtoUtils() {
    }

    static GeoDistanceQueryBuilder fromProto(GeoDistanceQuery geoDistanceQueryProto) {
        float boost = 1.0f;
        String queryName = null;
        GeoPoint point = new GeoPoint(Double.NaN, Double.NaN);
        String fieldName = null;
        String vDistance = null;
        DistanceUnit unit = GeoDistanceQueryBuilder.DEFAULT_DISTANCE_UNIT;
        GeoDistance geoDistance = GeoDistanceQueryBuilder.DEFAULT_GEO_DISTANCE;
        GeoValidationMethod validationMethod = null;
        boolean ignoreUnmapped = false;
        if (geoDistanceQueryProto.getLocationMap().isEmpty()) {
            throw new IllegalArgumentException("GeoDistanceQuery must have at least one location");
        }
        fieldName = (String)geoDistanceQueryProto.getLocationMap().keySet().iterator().next();
        if (fieldName == null || fieldName.isEmpty()) {
            throw new IllegalArgumentException("Field name is required for GeoDistance query");
        }
        GeoLocation geoLocation = (GeoLocation)geoDistanceQueryProto.getLocationMap().get(fieldName);
        GeoPointProtoUtils.parseGeoPoint(geoLocation, point, false, GeoUtils.EffectivePoint.BOTTOM_LEFT);
        String distance = geoDistanceQueryProto.getDistance();
        if (distance == null || distance.isEmpty()) {
            throw new IllegalArgumentException("geo_distance requires 'distance' to be specified");
        }
        vDistance = distance;
        if (geoDistanceQueryProto.hasUnit()) {
            unit = GeoDistanceQueryBuilderProtoUtils.parseDistanceUnit(geoDistanceQueryProto.getUnit());
        }
        if (geoDistanceQueryProto.hasDistanceType()) {
            geoDistance = GeoDistanceQueryBuilderProtoUtils.parseDistanceType(geoDistanceQueryProto.getDistanceType());
        }
        if (geoDistanceQueryProto.hasValidationMethod()) {
            validationMethod = GeoDistanceQueryBuilderProtoUtils.parseValidationMethod(geoDistanceQueryProto.getValidationMethod());
        }
        if (geoDistanceQueryProto.hasIgnoreUnmapped()) {
            ignoreUnmapped = geoDistanceQueryProto.getIgnoreUnmapped();
        }
        if (geoDistanceQueryProto.hasBoost()) {
            boost = geoDistanceQueryProto.getBoost();
        }
        if (geoDistanceQueryProto.hasXName()) {
            queryName = geoDistanceQueryProto.getXName();
        }
        GeoDistanceQueryBuilder qb = new GeoDistanceQueryBuilder(fieldName);
        if (vDistance instanceof Number) {
            Number number = (Number)((Object)vDistance);
            qb.distance(number.doubleValue(), unit);
        } else {
            qb.distance(vDistance, unit);
        }
        qb.point(point);
        if (validationMethod != null) {
            qb.setValidationMethod(validationMethod);
        }
        qb.geoDistance(geoDistance);
        qb.boost(boost);
        qb.queryName(queryName);
        qb.ignoreUnmapped(ignoreUnmapped);
        return qb;
    }

    private static GeoDistance parseDistanceType(GeoDistanceType distanceTypeProto) {
        switch (distanceTypeProto) {
            case GEO_DISTANCE_TYPE_PLANE: {
                return GeoDistance.PLANE;
            }
            case GEO_DISTANCE_TYPE_ARC: {
                return GeoDistance.ARC;
            }
        }
        return GeoDistance.ARC;
    }

    private static GeoValidationMethod parseValidationMethod(org.opensearch.protobufs.GeoValidationMethod validationMethodProto) {
        switch (validationMethodProto) {
            case GEO_VALIDATION_METHOD_COERCE: {
                return GeoValidationMethod.COERCE;
            }
            case GEO_VALIDATION_METHOD_IGNORE_MALFORMED: {
                return GeoValidationMethod.IGNORE_MALFORMED;
            }
            case GEO_VALIDATION_METHOD_STRICT: {
                return GeoValidationMethod.STRICT;
            }
        }
        return GeoValidationMethod.STRICT;
    }

    private static DistanceUnit parseDistanceUnit(org.opensearch.protobufs.DistanceUnit distanceUnitProto) {
        switch (distanceUnitProto) {
            case DISTANCE_UNIT_CM: {
                return DistanceUnit.CENTIMETERS;
            }
            case DISTANCE_UNIT_FT: {
                return DistanceUnit.FEET;
            }
            case DISTANCE_UNIT_IN: {
                return DistanceUnit.INCH;
            }
            case DISTANCE_UNIT_KM: {
                return DistanceUnit.KILOMETERS;
            }
            case DISTANCE_UNIT_M: {
                return DistanceUnit.METERS;
            }
            case DISTANCE_UNIT_MI: {
                return DistanceUnit.MILES;
            }
            case DISTANCE_UNIT_MM: {
                return DistanceUnit.MILLIMETERS;
            }
            case DISTANCE_UNIT_NMI: {
                return DistanceUnit.NAUTICALMILES;
            }
            case DISTANCE_UNIT_YD: {
                return DistanceUnit.YARD;
            }
        }
        return DistanceUnit.METERS;
    }
}

