/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import okhttp3.internal._NormalizeJvmKt;
import okhttp3.internal._UtilCommonKt;
import okhttp3.internal.idn.IdnaMappingTableInstanceKt;
import okhttp3.internal.idn.Punycode;
import okio.Buffer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\r\u001a\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0000\u001a0\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\nH\u0000\u001a\"\u0010\r\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0000\u001a\u0012\u0010\u000e\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000f\u001a\u00020\bH\u0000\u001a\u0010\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0004\u001a\u00020\u0003H\u0000\u001a\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0004\u001a\u00020\u0003H\u0000\u001a\u0010\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0004\u001a\u00020\u0003H\u0002\u001a\n\u0010\u0013\u001a\u00020\u0006*\u00020\b\u001a\f\u0010\u0014\u001a\u00020\u0006*\u00020\bH\u0000\u001a\f\u0010\u0015\u001a\u00020\u0006*\u00020\bH\u0000\u001a\u000e\u0010\u0016\u001a\u0004\u0018\u00010\b*\u00020\bH\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"VERIFY_AS_IP_ADDRESS", "Lkotlin/text/Regex;", "canonicalizeInetAddress", "", "address", "decodeIpv4Suffix", "", "input", "", "pos", "", "limit", "addressOffset", "decodeIpv6", "idnToAscii", "host", "inet4AddressToAscii", "inet6AddressToAscii", "isMappedIpv4Address", "canParseAsIpAddress", "containsInvalidHostnameAsciiCodes", "containsInvalidLabelLengths", "toCanonicalHost", "okhttp"})
public final class _HostnamesCommonKt {
    @NotNull
    private static final Regex VERIFY_AS_IP_ADDRESS = new Regex("([0-9a-fA-F]*:[0-9a-fA-F:.]*)|([\\d.]+)");

    public static final boolean canParseAsIpAddress(@NotNull String $this$canParseAsIpAddress) {
        Intrinsics.checkNotNullParameter((Object)$this$canParseAsIpAddress, (String)"<this>");
        return VERIFY_AS_IP_ADDRESS.matches((CharSequence)$this$canParseAsIpAddress);
    }

    public static final boolean containsInvalidLabelLengths(@NotNull String $this$containsInvalidLabelLengths) {
        Intrinsics.checkNotNullParameter((Object)$this$containsInvalidLabelLengths, (String)"<this>");
        int n = $this$containsInvalidLabelLengths.length();
        if (!(1 <= n ? n < 254 : false)) {
            return true;
        }
        int labelStart = 0;
        while (true) {
            int dot;
            int labelLength;
            int n2 = labelLength = (dot = StringsKt.indexOf$default((CharSequence)$this$containsInvalidLabelLengths, (char)'.', (int)labelStart, (boolean)false, (int)4, null)) == -1 ? $this$containsInvalidLabelLengths.length() - labelStart : dot - labelStart;
            if (!(1 <= labelLength ? labelLength < 64 : false)) {
                return true;
            }
            if (dot == -1 || dot == $this$containsInvalidLabelLengths.length() - 1) break;
            labelStart = dot + 1;
        }
        return false;
    }

    public static final boolean containsInvalidHostnameAsciiCodes(@NotNull String $this$containsInvalidHostnameAsciiCodes) {
        Intrinsics.checkNotNullParameter((Object)$this$containsInvalidHostnameAsciiCodes, (String)"<this>");
        int n = $this$containsInvalidHostnameAsciiCodes.length();
        for (int i2 = 0; i2 < n; ++i2) {
            char c = $this$containsInvalidHostnameAsciiCodes.charAt(i2);
            if (Intrinsics.compare((int)c, (int)31) <= 0 || Intrinsics.compare((int)c, (int)127) >= 0) {
                return true;
            }
            if (StringsKt.indexOf$default((CharSequence)" #%/:?@[\\]", (char)c, (int)0, (boolean)false, (int)6, null) == -1) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static final byte[] decodeIpv6(@NotNull String input, int pos, int limit) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        byte[] address = new byte[16];
        int b = 0;
        int compress = -1;
        int groupOffset = -1;
        int i2 = pos;
        while (i2 < limit) {
            int hexDigit;
            if (b == address.length) {
                return null;
            }
            if (i2 + 2 <= limit && StringsKt.startsWith$default((String)input, (String)"::", (int)i2, (boolean)false, (int)4, null)) {
                if (compress != -1) {
                    return null;
                }
                compress = b += 2;
                if ((i2 += 2) == limit) {
                    break;
                }
            } else if (b != 0 && !StringsKt.startsWith$default((String)input, (String)":", (int)i2, (boolean)false, (int)4, null)) {
                if (StringsKt.startsWith$default((String)input, (String)".", (int)i2, (boolean)false, (int)4, null)) {
                    if (!_HostnamesCommonKt.decodeIpv4Suffix(input, groupOffset, limit, address, b - 2)) {
                        return null;
                    }
                    b += 2;
                    break;
                }
                return null;
            }
            int value = 0;
            groupOffset = ++i2;
            while (i2 < limit && (hexDigit = _UtilCommonKt.parseHexDigit(input.charAt(i2))) != -1) {
                value = (value << 4) + hexDigit;
                ++i2;
            }
            int groupLength = i2 - groupOffset;
            if (groupLength == 0 || groupLength > 4) {
                return null;
            }
            address[b++] = (byte)(value >>> 8 & 0xFF);
            address[b++] = (byte)(value & 0xFF);
        }
        if (b != address.length) {
            if (compress == -1) {
                return null;
            }
            ArraysKt.copyInto((byte[])address, (byte[])address, (int)(address.length - (b - compress)), (int)compress, (int)b);
            ArraysKt.fill((byte[])address, (byte)0, (int)compress, (int)(compress + (address.length - b)));
        }
        return address;
    }

    public static final boolean decodeIpv4Suffix(@NotNull String input, int pos, int limit, @NotNull byte[] address, int addressOffset) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        int b = addressOffset;
        int i2 = pos;
        while (i2 < limit) {
            char c;
            if (b == address.length) {
                return false;
            }
            if (b != addressOffset && input.charAt(i2) != '.') {
                return false;
            }
            int value = 0;
            int groupOffset = ++i2;
            while (i2 < limit && Intrinsics.compare((int)(c = input.charAt(i2)), (int)48) >= 0 && Intrinsics.compare((int)c, (int)57) <= 0) {
                if (value == 0 && groupOffset != i2) {
                    return false;
                }
                if ((value = value * 10 + c - 48) > 255) {
                    return false;
                }
                ++i2;
            }
            int groupLength = i2 - groupOffset;
            if (groupLength == 0) {
                return false;
            }
            address[b++] = (byte)value;
        }
        return b == addressOffset + 4;
    }

    @NotNull
    public static final String inet6AddressToAscii(@NotNull byte[] address) {
        int i2;
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        int longestRunOffset = 0;
        longestRunOffset = -1;
        int longestRunLength = 0;
        boolean bl = false;
        for (i2 = 0; i2 < address.length; i2 += 2) {
            int currentRunOffset = i2;
            while (i2 < 16 && address[i2] == 0 && address[i2 + 1] == 0) {
                i2 += 2;
            }
            int currentRunLength = i2 - currentRunOffset;
            if (currentRunLength <= longestRunLength || currentRunLength < 4) continue;
            longestRunOffset = currentRunOffset;
            longestRunLength = currentRunLength;
        }
        Buffer result2 = new Buffer();
        i2 = 0;
        while (i2 < address.length) {
            if (i2 == longestRunOffset) {
                result2.writeByte(58);
                if ((i2 += longestRunLength) != 16) continue;
                result2.writeByte(58);
                continue;
            }
            if (i2 > 0) {
                result2.writeByte(58);
            }
            int group = _UtilCommonKt.and(address[i2], 255) << 8 | _UtilCommonKt.and(address[i2 + 1], 255);
            result2.writeHexadecimalUnsignedLong(group);
            i2 += 2;
        }
        return result2.readUtf8();
    }

    @NotNull
    public static final byte[] canonicalizeInetAddress(@NotNull byte[] address) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        return _HostnamesCommonKt.isMappedIpv4Address(address) ? ArraysKt.sliceArray((byte[])address, (IntRange)RangesKt.until((int)12, (int)16)) : address;
    }

    private static final boolean isMappedIpv4Address(byte[] address) {
        if (address.length != 16) {
            return false;
        }
        for (int i2 = 0; i2 < 10; ++i2) {
            if (address[i2] == 0) continue;
            return false;
        }
        if (address[10] != -1) {
            return false;
        }
        return address[11] == -1;
    }

    @NotNull
    public static final String inet4AddressToAscii(@NotNull byte[] address) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        if (!(address.length == 4)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        return new Buffer().writeDecimalLong(_UtilCommonKt.and(address[0], 255)).writeByte(46).writeDecimalLong(_UtilCommonKt.and(address[1], 255)).writeByte(46).writeDecimalLong(_UtilCommonKt.and(address[2], 255)).writeByte(46).writeDecimalLong(_UtilCommonKt.and(address[3], 255)).readUtf8();
    }

    @Nullable
    public static final String toCanonicalHost(@NotNull String $this$toCanonicalHost) {
        Intrinsics.checkNotNullParameter((Object)$this$toCanonicalHost, (String)"<this>");
        String host = $this$toCanonicalHost;
        if (StringsKt.contains$default((CharSequence)host, (CharSequence)":", (boolean)false, (int)2, null)) {
            byte[] byArray = StringsKt.startsWith$default((String)host, (String)"[", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)host, (String)"]", (boolean)false, (int)2, null) ? _HostnamesCommonKt.decodeIpv6(host, 1, host.length() - 1) : _HostnamesCommonKt.decodeIpv6(host, 0, host.length());
            if (byArray == null) {
                return null;
            }
            byte[] inetAddressByteArray = byArray;
            byte[] address = _HostnamesCommonKt.canonicalizeInetAddress(inetAddressByteArray);
            if (address.length == 16) {
                return _HostnamesCommonKt.inet6AddressToAscii(address);
            }
            if (address.length == 4) {
                return _HostnamesCommonKt.inet4AddressToAscii(address);
            }
            throw new AssertionError((Object)("Invalid IPv6 address: '" + host + '\''));
        }
        String string2 = _HostnamesCommonKt.idnToAscii(host);
        if (string2 == null) {
            return null;
        }
        String result2 = string2;
        if (((CharSequence)result2).length() == 0) {
            return null;
        }
        if (_HostnamesCommonKt.containsInvalidHostnameAsciiCodes(result2)) {
            return null;
        }
        if (_HostnamesCommonKt.containsInvalidLabelLengths(result2)) {
            return null;
        }
        return result2;
    }

    @Nullable
    public static final String idnToAscii(@NotNull String host) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Buffer bufferA = new Buffer().writeUtf8(host);
        Buffer bufferB = new Buffer();
        while (!bufferA.exhausted()) {
            int codePoint = bufferA.readUtf8CodePoint();
            if (IdnaMappingTableInstanceKt.getIDNA_MAPPING_TABLE().map(codePoint, bufferB)) continue;
            return null;
        }
        String normalized = _NormalizeJvmKt.normalizeNfc(bufferB.readUtf8());
        bufferA.writeUtf8(normalized);
        String string2 = Punycode.INSTANCE.decode(bufferA.readUtf8());
        if (string2 == null) {
            return null;
        }
        String decoded = string2;
        if (!Intrinsics.areEqual((Object)decoded, (Object)_NormalizeJvmKt.normalizeNfc(decoded))) {
            return null;
        }
        return Punycode.INSTANCE.encode(decoded);
    }
}

