﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/cloudformation/CloudFormation_EXPORTS.h>
#include <aws/cloudformation/model/ChangeSetSummary.h>
#include <aws/cloudformation/model/ResponseMetadata.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Xml {
class XmlDocument;
}  // namespace Xml
}  // namespace Utils
namespace CloudFormation {
namespace Model {
/**
 * <p>The output for the <a>ListChangeSets</a> action.</p><p><h3>See Also:</h3>
 * <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListChangeSetsOutput">AWS
 * API Reference</a></p>
 */
class ListChangeSetsResult {
 public:
  AWS_CLOUDFORMATION_API ListChangeSetsResult() = default;
  AWS_CLOUDFORMATION_API ListChangeSetsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);
  AWS_CLOUDFORMATION_API ListChangeSetsResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);

  ///@{
  /**
   * <p>A list of <code>ChangeSetSummary</code> structures that provides the ID and
   * status of each change set for the specified stack.</p>
   */
  inline const Aws::Vector<ChangeSetSummary>& GetSummaries() const { return m_summaries; }
  template <typename SummariesT = Aws::Vector<ChangeSetSummary>>
  void SetSummaries(SummariesT&& value) {
    m_summariesHasBeenSet = true;
    m_summaries = std::forward<SummariesT>(value);
  }
  template <typename SummariesT = Aws::Vector<ChangeSetSummary>>
  ListChangeSetsResult& WithSummaries(SummariesT&& value) {
    SetSummaries(std::forward<SummariesT>(value));
    return *this;
  }
  template <typename SummariesT = ChangeSetSummary>
  ListChangeSetsResult& AddSummaries(SummariesT&& value) {
    m_summariesHasBeenSet = true;
    m_summaries.emplace_back(std::forward<SummariesT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>If the output exceeds 1 MB, a string that identifies the next page of change
   * sets. If there is no additional page, this value is <code>null</code>.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  ListChangeSetsResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const ResponseMetadata& GetResponseMetadata() const { return m_responseMetadata; }
  template <typename ResponseMetadataT = ResponseMetadata>
  void SetResponseMetadata(ResponseMetadataT&& value) {
    m_responseMetadataHasBeenSet = true;
    m_responseMetadata = std::forward<ResponseMetadataT>(value);
  }
  template <typename ResponseMetadataT = ResponseMetadata>
  ListChangeSetsResult& WithResponseMetadata(ResponseMetadataT&& value) {
    SetResponseMetadata(std::forward<ResponseMetadataT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<ChangeSetSummary> m_summaries;

  Aws::String m_nextToken;

  ResponseMetadata m_responseMetadata;
  bool m_summariesHasBeenSet = false;
  bool m_nextTokenHasBeenSet = false;
  bool m_responseMetadataHasBeenSet = false;
};

}  // namespace Model
}  // namespace CloudFormation
}  // namespace Aws
