/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.commandline.state;

import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaRetrievalOptions;
import schemacrawler.tools.commandline.state.ShellState;
import us.fatehi.utility.string.ObjectToStringFormat;

public final class StateUtility {
    private static final Logger LOGGER = Logger.getLogger(StateUtility.class.getName());

    public static void logState(ShellState state, boolean showlog) {
        SchemaCrawlerOptions schemaCrawlerOptions;
        if (state == null) {
            return;
        }
        if (!state.isConnected()) {
            StateUtility.log(Level.CONFIG, () -> "No database connection available", showlog);
        }
        if ((schemaCrawlerOptions = state.getSchemaCrawlerOptions()) != null) {
            StateUtility.log(Level.CONFIG, (Supplier<String>)new ObjectToStringFormat((Object)schemaCrawlerOptions), showlog);
        }
        if (state.getSchemaRetrievalOptions() != null) {
            SchemaRetrievalOptions schemaRetrievalOptions = state.getSchemaRetrievalOptions();
            StateUtility.log(Level.CONFIG, (Supplier<String>)new ObjectToStringFormat((Object)schemaRetrievalOptions), showlog);
        }
        StateUtility.log(Level.FINE, (Supplier<String>)new ObjectToStringFormat((Object)state.getConfig()), showlog);
    }

    private static void log(Level level, Supplier<String> toLog, boolean showlog) {
        if (showlog) {
            System.out.println(toLog.get());
        } else {
            LOGGER.log(level, toLog);
        }
    }
}

