/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.Python3Core;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.CmathModuleBuiltinsFactory;
import com.oracle.graal.python.builtins.modules.MathGuards;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.complex.ComplexBuiltins;
import com.oracle.graal.python.builtins.objects.complex.PComplex;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.lib.PyFloatAsDoubleNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.truffle.PythonIntegerAndFloatTypes;
import com.oracle.graal.python.nodes.util.CoerceToComplexNode;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.dsl.TypeSystemReference;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.utilities.MathUtils;
import java.util.List;

@CoreFunctions(defineModule="cmath")
public final class CmathModuleBuiltins
extends PythonBuiltins {
    static final double INF = Double.POSITIVE_INFINITY;
    static final double NAN = Double.NaN;
    static final double P = Math.PI;
    static final double P14 = 0.7853981633974483;
    static final double P12 = 1.5707963267948966;
    static final double P34 = 2.356194490192345;
    static final double LARGE_DOUBLE = 4.4942328371557893E307;
    static final double LOG_LARGE_DOUBLE = Math.log(4.4942328371557893E307);
    static final double LN_2 = 0.6931471805599453;
    static final double LN_10 = 2.302585092994046;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return CmathModuleBuiltinsFactory.getFactories();
    }

    @Override
    public void initialize(Python3Core core) {
        this.addBuiltinConstant("pi", (Object)Math.PI);
        this.addBuiltinConstant("e", (Object)Math.E);
        this.addBuiltinConstant("tau", (Object)(Math.PI * 2));
        this.addBuiltinConstant("inf", (Object)Double.POSITIVE_INFINITY);
        this.addBuiltinConstant("nan", (Object)Double.NaN);
        this.addBuiltinConstant("infj", (Object)PFactory.createComplex(core.getLanguage(), 0.0, Double.POSITIVE_INFINITY));
        this.addBuiltinConstant("nanj", (Object)PFactory.createComplex(core.getLanguage(), 0.0, Double.NaN));
        super.initialize(core);
    }

    static PComplex specialValue(PythonLanguage language, ComplexValue[][] table, double real, double imag) {
        ComplexValue v = CmathModuleBuiltins.specialValue(table, real, imag);
        return v == null ? null : v.toPComplex(language);
    }

    static ComplexValue specialValue(ComplexValue[][] table, double real, double imag) {
        if (!Double.isFinite(real) || !Double.isFinite(imag)) {
            ComplexValue c = table[SpecialType.ofDouble(real).ordinal()][SpecialType.ofDouble(imag).ordinal()];
            if (c == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new IllegalStateException("should not be reached");
            }
            return c;
        }
        return null;
    }

    static ComplexValue C(double real, double imag) {
        return new ComplexValue(real, imag);
    }

    @CompilerDirectives.ValueType
    static class ComplexValue {
        final double real;
        final double imag;

        ComplexValue(double real, double imag) {
            this.real = real;
            this.imag = imag;
        }

        PComplex toPComplex(PythonLanguage language) {
            return PFactory.createComplex(language, this.real, this.imag);
        }
    }

    static enum SpecialType {
        NINF,
        NEG,
        NZERO,
        PZERO,
        POS,
        PINF,
        NAN;


        @CompilerDirectives.TruffleBoundary
        static SpecialType ofDouble(double d) {
            if (Double.isFinite(d)) {
                if (d != 0.0) {
                    if (Math.copySign(1.0, d) == 1.0) {
                        return POS;
                    }
                    return NEG;
                }
                if (Math.copySign(1.0, d) == 1.0) {
                    return PZERO;
                }
                return NZERO;
            }
            if (Double.isNaN(d)) {
                return NAN;
            }
            if (Math.copySign(1.0, d) == 1.0) {
                return PINF;
            }
            return NINF;
        }
    }

    @Builtin(name="isclose", minNumOfPositionalArgs=2, parameterNames={"a", "b"}, keywordOnlyNames={"rel_tol", "abs_tol"})
    @TypeSystemReference(value=PythonIntegerAndFloatTypes.class)
    @ImportStatic(value={MathGuards.class})
    @GenerateNodeFactory
    static abstract class IsCloseNode
    extends PythonBuiltinNode {
        private static final double DEFAULT_REL_TOL = 1.0E-9;
        private static final double DEFAULT_ABS_TOL = 0.0;

        IsCloseNode() {
        }

        @Specialization
        static boolean doCCDD(PComplex a, PComplex b, double relTolObj, double absTolObj, @Bind Node inliningTarget, @Cached.Shared @Cached ComplexBuiltins.AbsNode absNode, @Cached.Shared @Cached PRaiseNode raiseNode) {
            return IsCloseNode.isClose(inliningTarget, a, b, relTolObj, absTolObj, absNode, raiseNode);
        }

        @Specialization
        static boolean doCCNN(PComplex a, PComplex b, PNone relTolObj, PNone absTolObj, @Bind Node inliningTarget, @Cached.Shared @Cached ComplexBuiltins.AbsNode absNode, @Cached.Shared @Cached PRaiseNode raiseNode) {
            return IsCloseNode.isClose(inliningTarget, a, b, 1.0E-9, 0.0, absNode, raiseNode);
        }

        @Specialization
        static boolean doGeneral(VirtualFrame frame, Object aObj, Object bObj, Object relTolObj, Object absTolObj, @Bind Node inliningTarget, @Cached CoerceToComplexNode coerceAToComplex, @Cached CoerceToComplexNode coerceBToComplex, @Cached PyFloatAsDoubleNode relAsDoubleNode, @Cached PyFloatAsDoubleNode absAsDoubleNode, @Cached.Shared @Cached ComplexBuiltins.AbsNode absNode, @Cached.Exclusive @Cached PRaiseNode raiseNode) {
            PComplex a = coerceAToComplex.execute(frame, inliningTarget, aObj);
            PComplex b = coerceBToComplex.execute(frame, inliningTarget, bObj);
            double relTol = PGuards.isNoValue(relTolObj) ? 1.0E-9 : relAsDoubleNode.execute(frame, inliningTarget, relTolObj);
            double absTol = PGuards.isPNone(absTolObj) ? 0.0 : absAsDoubleNode.execute(frame, inliningTarget, absTolObj);
            return IsCloseNode.isClose(inliningTarget, a, b, relTol, absTol, absNode, raiseNode);
        }

        private static boolean isClose(Node inliningTarget, PComplex a, PComplex b, double relTol, double absTol, ComplexBuiltins.AbsNode absNode, PRaiseNode raiseNode) {
            if (relTol < 0.0 || absTol < 0.0) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.ValueError, ErrorMessages.TOLERANCE_MUST_NON_NEGATIVE);
            }
            if (a.getReal() == b.getReal() && a.getImag() == b.getImag()) {
                return true;
            }
            if (Double.isInfinite(a.getReal()) || Double.isInfinite(a.getImag()) || Double.isInfinite(b.getReal()) || Double.isInfinite(b.getImag())) {
                return false;
            }
            PComplex diff = PFactory.createComplex(PythonLanguage.get(inliningTarget), a.getReal() - b.getReal(), a.getImag() - b.getImag());
            double len = absNode.executeDouble(diff);
            return len <= absTol || len <= relTol * absNode.executeDouble(b) || len <= relTol * absNode.executeDouble(a);
        }
    }

    @Builtin(name="tanh", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class TanhNode
    extends PythonUnaryBuiltinNode {
        @CompilerDirectives.CompilationFinal(dimensions=2)
        private static final ComplexValue[][] SPECIAL_VALUES = new ComplexValue[][]{{CmathModuleBuiltins.C(-1.0, 0.0), null, CmathModuleBuiltins.C(-1.0, -0.0), CmathModuleBuiltins.C(-1.0, 0.0), null, CmathModuleBuiltins.C(-1.0, 0.0), CmathModuleBuiltins.C(-1.0, 0.0)}, {CmathModuleBuiltins.C(Double.NaN, Double.NaN), null, null, null, null, CmathModuleBuiltins.C(Double.NaN, Double.NaN), CmathModuleBuiltins.C(Double.NaN, Double.NaN)}, {CmathModuleBuiltins.C(Double.NaN, Double.NaN), null, CmathModuleBuiltins.C(-0.0, -0.0), CmathModuleBuiltins.C(-0.0, 0.0), null, CmathModuleBuiltins.C(Double.NaN, Double.NaN), CmathModuleBuiltins.C(Double.NaN, Double.NaN)}, {CmathModuleBuiltins.C(Double.NaN, Double.NaN), null, CmathModuleBuiltins.C(0.0, -0.0), CmathModuleBuiltins.C(0.0, 0.0), null, CmathModuleBuiltins.C(Double.NaN, Double.NaN), CmathModuleBuiltins.C(Double.NaN, Double.NaN)}, {CmathModuleBuiltins.C(Double.NaN, Double.NaN), null, null, null, null, CmathModuleBuiltins.C(Double.NaN, Double.NaN), CmathModuleBuiltins.C(Double.NaN, Double.NaN)}, {CmathModuleBuiltins.C(1.0, 0.0), null, CmathModuleBuiltins.C(1.0, -0.0), CmathModuleBuiltins.C(1.0, 0.0), null, CmathModuleBuiltins.C(1.0, 0.0), CmathModuleBuiltins.C(1.0, 0.0)}, {CmathModuleBuiltins.C(Double.NaN, Double.NaN), CmathModuleBuiltins.C(Double.NaN, Double.NaN), CmathModuleBuiltins.C(Double.NaN, -0.0), CmathModuleBuiltins.C(Double.NaN, 0.0), CmathModuleBuiltins.C(Double.NaN, Double.NaN), CmathModuleBuiltins.C(Double.NaN, Double.NaN), CmathModuleBuiltins.C(Double.NaN, Double.NaN)}};

        TanhNode() {
        }

        @Specialization
        static PComplex doIt(VirtualFrame frame, Object value, @Bind Node inliningTarget, @Cached CmathComplexUnaryHelperNode helperNode) {
            return helperNode.execute(frame, inliningTarget, value, TanhNode::compute);
        }

        static ComplexValue compute(Node inliningTarget, double real, double imag, PRaiseNode raiseNode) {
            if (!Double.isFinite(real) || !Double.isFinite(imag)) {
                if (Double.isInfinite(imag) && Double.isFinite(real)) {
                    throw raiseNode.raise(inliningTarget, PythonErrorType.ValueError, ErrorMessages.MATH_DOMAIN_ERROR);
                }
                if (Double.isInfinite(real) && Double.isFinite(imag) && imag != 0.0) {
                    return new ComplexValue(real > 0.0 ? 1.0 : -1.0, Math.copySign(0.0, 2.0 * Math.sin(imag) * Math.cos(imag)));
                }
                return CmathModuleBuiltins.specialValue(SPECIAL_VALUES, real, imag);
            }
            if (Math.abs(real) > LOG_LARGE_DOUBLE) {
                return new ComplexValue(Math.copySign(1.0, real), 4.0 * Math.sin(imag) * Math.cos(imag) * Math.exp(-20.0 * Math.abs(real)));
            }
            double tx = Math.tanh(real);
            double ty = Math.tan(imag);
            double cx = 1.0 / Math.cosh(real);
            double txty = tx * ty;
            double denom = 1.0 + txty * txty;
            return new ComplexValue(tx * (1.0 + ty * ty) / denom, ty / denom * cx * cx);
        }
    }

    @Builtin(name="tan", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class TanNode
    extends PythonUnaryBuiltinNode {
        TanNode() {
        }

        @Specialization
        static PComplex doIt(VirtualFrame frame, Object value, @Bind Node inliningTarget, @Cached CmathComplexUnaryHelperNode helperNode) {
            return helperNode.execute(frame, inliningTarget, value, TanNode::compute);
        }

        static ComplexValue compute(Node inliningTarget, double real, double imag, PRaiseNode raiseNode) {
            ComplexValue s = TanhNode.compute(inliningTarget, -imag, real, raiseNode);
            return new ComplexValue(s.imag, -s.real);
        }
    }

    @Builtin(name="sinh", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class SinhNode
    extends PythonUnaryBuiltinNode {
        @CompilerDirectives.CompilationFinal(dimensions=2)
        private static final ComplexValue[][] SPECIAL_VALUES = new ComplexValue[][]{{CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, Double.NaN), null, CmathModuleBuiltins.C(Double.NEGATIVE_INFINITY, -0.0), CmathModuleBuiltins.C(Double.NEGATIVE_INFINITY, 0.0), null, CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, Double.NaN), CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, Double.NaN)}, {CmathModuleBuiltins.C(Double.NaN, Double.NaN), null, null, null, null, CmathModuleBuiltins.C(Double.NaN, Double.NaN), CmathModuleBuiltins.C(Double.NaN, Double.NaN)}, {CmathModuleBuiltins.C(0.0, Double.NaN), null, CmathModuleBuiltins.C(-0.0, -0.0), CmathModuleBuiltins.C(-0.0, 0.0), null, CmathModuleBuiltins.C(0.0, Double.NaN), CmathModuleBuiltins.C(0.0, Double.NaN)}, {CmathModuleBuiltins.C(0.0, Double.NaN), null, CmathModuleBuiltins.C(0.0, -0.0), CmathModuleBuiltins.C(0.0, 0.0), null, CmathModuleBuiltins.C(0.0, Double.NaN), CmathModuleBuiltins.C(0.0, Double.NaN)}, {CmathModuleBuiltins.C(Double.NaN, Double.NaN), null, null, null, null, CmathModuleBuiltins.C(Double.NaN, Double.NaN), CmathModuleBuiltins.C(Double.NaN, Double.NaN)}, {CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, Double.NaN), null, CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, -0.0), CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, 0.0), null, CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, Double.NaN), CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, Double.NaN)}, {CmathModuleBuiltins.C(Double.NaN, Double.NaN), CmathModuleBuiltins.C(Double.NaN, Double.NaN), CmathModuleBuiltins.C(Double.NaN, -0.0), CmathModuleBuiltins.C(Double.NaN, 0.0), CmathModuleBuiltins.C(Double.NaN, Double.NaN), CmathModuleBuiltins.C(Double.NaN, Double.NaN), CmathModuleBuiltins.C(Double.NaN, Double.NaN)}};

        SinhNode() {
        }

        @Specialization
        static PComplex doIt(VirtualFrame frame, Object value, @Bind Node inliningTarget, @Cached CmathComplexUnaryHelperNode helperNode) {
            return helperNode.execute(frame, inliningTarget, value, SinhNode::compute);
        }

        static ComplexValue compute(Node inliningTarget, double real, double imag, PRaiseNode raiseNode) {
            double rimag;
            double rreal;
            if (!Double.isFinite(real) || !Double.isFinite(imag)) {
                if (Double.isInfinite(imag) && !Double.isNaN(real)) {
                    throw raiseNode.raise(inliningTarget, PythonErrorType.ValueError, ErrorMessages.MATH_DOMAIN_ERROR);
                }
                if (Double.isInfinite(real) && Double.isFinite(imag) && imag != 0.0) {
                    double r = Math.copySign(Double.POSITIVE_INFINITY, Math.cos(imag));
                    return new ComplexValue(real > 0.0 ? r : -r, Math.copySign(Double.POSITIVE_INFINITY, Math.sin(imag)));
                }
                return CmathModuleBuiltins.specialValue(SPECIAL_VALUES, real, imag);
            }
            if (Math.abs(real) > LOG_LARGE_DOUBLE) {
                double x_minus_one = real - Math.copySign(1.0, real);
                rreal = Math.cos(imag) * Math.sinh(x_minus_one) * Math.E;
                rimag = Math.sin(imag) * Math.cosh(x_minus_one) * Math.E;
            } else {
                rreal = Math.cos(imag) * Math.sinh(real);
                rimag = Math.sin(imag) * Math.cosh(real);
            }
            if (Double.isInfinite(rreal) || Double.isInfinite(rimag)) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.OverflowError, ErrorMessages.MATH_RANGE_ERROR);
            }
            return new ComplexValue(rreal, rimag);
        }
    }

    @Builtin(name="sin", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class SinNode
    extends PythonUnaryBuiltinNode {
        SinNode() {
        }

        @Specialization
        static PComplex doIt(VirtualFrame frame, Object value, @Bind Node inliningTarget, @Cached CmathComplexUnaryHelperNode helperNode) {
            return helperNode.execute(frame, inliningTarget, value, SinNode::compute);
        }

        static ComplexValue compute(Node inliningTarget, double real, double imag, PRaiseNode raiseNode) {
            ComplexValue s = SinhNode.compute(inliningTarget, -imag, real, raiseNode);
            return new ComplexValue(s.imag, -s.real);
        }
    }

    @Builtin(name="cosh", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class CoshNode
    extends PythonUnaryBuiltinNode {
        @CompilerDirectives.CompilationFinal(dimensions=2)
        private static final ComplexValue[][] SPECIAL_VALUES = new ComplexValue[][]{{CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, Double.NaN), null, CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, 0.0), CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, -0.0), null, CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, Double.NaN), CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, Double.NaN)}, {CmathModuleBuiltins.C(Double.NaN, Double.NaN), null, null, null, null, CmathModuleBuiltins.C(Double.NaN, Double.NaN), CmathModuleBuiltins.C(Double.NaN, Double.NaN)}, {CmathModuleBuiltins.C(Double.NaN, 0.0), null, CmathModuleBuiltins.C(1.0, 0.0), CmathModuleBuiltins.C(1.0, -0.0), null, CmathModuleBuiltins.C(Double.NaN, 0.0), CmathModuleBuiltins.C(Double.NaN, 0.0)}, {CmathModuleBuiltins.C(Double.NaN, 0.0), null, CmathModuleBuiltins.C(1.0, -0.0), CmathModuleBuiltins.C(1.0, 0.0), null, CmathModuleBuiltins.C(Double.NaN, 0.0), CmathModuleBuiltins.C(Double.NaN, 0.0)}, {CmathModuleBuiltins.C(Double.NaN, Double.NaN), null, null, null, null, CmathModuleBuiltins.C(Double.NaN, Double.NaN), CmathModuleBuiltins.C(Double.NaN, Double.NaN)}, {CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, Double.NaN), null, CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, -0.0), CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, 0.0), null, CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, Double.NaN), CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, Double.NaN)}, {CmathModuleBuiltins.C(Double.NaN, Double.NaN), CmathModuleBuiltins.C(Double.NaN, Double.NaN), CmathModuleBuiltins.C(Double.NaN, 0.0), CmathModuleBuiltins.C(Double.NaN, 0.0), CmathModuleBuiltins.C(Double.NaN, Double.NaN), CmathModuleBuiltins.C(Double.NaN, Double.NaN), CmathModuleBuiltins.C(Double.NaN, Double.NaN)}};

        CoshNode() {
        }

        @Specialization
        static PComplex doIt(VirtualFrame frame, Object value, @Bind Node inliningTarget, @Cached CmathComplexUnaryHelperNode helperNode) {
            return helperNode.execute(frame, inliningTarget, value, CoshNode::compute);
        }

        static ComplexValue compute(Node inliningTarget, double real, double imag, PRaiseNode raiseNode) {
            double rimag;
            double rreal;
            if (!Double.isFinite(real) || !Double.isFinite(imag)) {
                if (Double.isInfinite(imag) && !Double.isNaN(real)) {
                    throw raiseNode.raise(inliningTarget, PythonErrorType.ValueError, ErrorMessages.MATH_DOMAIN_ERROR);
                }
                if (Double.isInfinite(real) && Double.isFinite(imag) && imag != 0.0) {
                    double r = Math.copySign(Double.POSITIVE_INFINITY, Math.sin(imag));
                    return new ComplexValue(Math.copySign(Double.POSITIVE_INFINITY, Math.cos(imag)), real > 0.0 ? r : -r);
                }
                return CmathModuleBuiltins.specialValue(SPECIAL_VALUES, real, imag);
            }
            if (Math.abs(real) > LOG_LARGE_DOUBLE) {
                double x_minus_one = real - Math.copySign(1.0, real);
                rreal = Math.cos(imag) * Math.cosh(x_minus_one) * Math.E;
                rimag = Math.sin(imag) * Math.sinh(x_minus_one) * Math.E;
            } else {
                rreal = Math.cos(imag) * Math.cosh(real);
                rimag = Math.sin(imag) * Math.sinh(real);
            }
            if (Double.isInfinite(rreal) || Double.isInfinite(rimag)) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.OverflowError, ErrorMessages.MATH_RANGE_ERROR);
            }
            return new ComplexValue(rreal, rimag);
        }
    }

    @Builtin(name="cos", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class CosNode
    extends PythonUnaryBuiltinNode {
        CosNode() {
        }

        @Specialization
        static PComplex doIt(VirtualFrame frame, Object value, @Bind Node inliningTarget, @Cached CmathComplexUnaryHelperNode helperNode) {
            return helperNode.execute(frame, inliningTarget, value, CosNode::compute);
        }

        static ComplexValue compute(Node inliningTarget, double real, double imag, PRaiseNode raiseNode) {
            return CoshNode.compute(inliningTarget, -imag, real, raiseNode);
        }
    }

    @Builtin(name="exp", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class ExpNode
    extends PythonUnaryBuiltinNode {
        @CompilerDirectives.CompilationFinal(dimensions=2)
        private static final ComplexValue[][] SPECIAL_VALUES = new ComplexValue[][]{{CmathModuleBuiltins.C(0.0, 0.0), null, CmathModuleBuiltins.C(0.0, -0.0), CmathModuleBuiltins.C(0.0, 0.0), null, CmathModuleBuiltins.C(0.0, 0.0), CmathModuleBuiltins.C(0.0, 0.0)}, {CmathModuleBuiltins.C(Double.NaN, Double.NaN), null, null, null, null, CmathModuleBuiltins.C(Double.NaN, Double.NaN), CmathModuleBuiltins.C(Double.NaN, Double.NaN)}, {CmathModuleBuiltins.C(Double.NaN, Double.NaN), null, CmathModuleBuiltins.C(1.0, -0.0), CmathModuleBuiltins.C(1.0, 0.0), null, CmathModuleBuiltins.C(Double.NaN, Double.NaN), CmathModuleBuiltins.C(Double.NaN, Double.NaN)}, {CmathModuleBuiltins.C(Double.NaN, Double.NaN), null, CmathModuleBuiltins.C(1.0, -0.0), CmathModuleBuiltins.C(1.0, 0.0), null, CmathModuleBuiltins.C(Double.NaN, Double.NaN), CmathModuleBuiltins.C(Double.NaN, Double.NaN)}, {CmathModuleBuiltins.C(Double.NaN, Double.NaN), null, null, null, null, CmathModuleBuiltins.C(Double.NaN, Double.NaN), CmathModuleBuiltins.C(Double.NaN, Double.NaN)}, {CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, Double.NaN), null, CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, -0.0), CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, 0.0), null, CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, Double.NaN), CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, Double.NaN)}, {CmathModuleBuiltins.C(Double.NaN, Double.NaN), CmathModuleBuiltins.C(Double.NaN, Double.NaN), CmathModuleBuiltins.C(Double.NaN, -0.0), CmathModuleBuiltins.C(Double.NaN, 0.0), CmathModuleBuiltins.C(Double.NaN, Double.NaN), CmathModuleBuiltins.C(Double.NaN, Double.NaN), CmathModuleBuiltins.C(Double.NaN, Double.NaN)}};

        ExpNode() {
        }

        @Specialization
        static PComplex doIt(VirtualFrame frame, Object value, @Bind Node inliningTarget, @Cached CmathComplexUnaryHelperNode helperNode) {
            return helperNode.execute(frame, inliningTarget, value, ExpNode::compute);
        }

        static ComplexValue compute(Node inliningTarget, double real, double imag, PRaiseNode raiseNode) {
            double rimag;
            double rreal;
            if (!Double.isFinite(real) || !Double.isFinite(imag)) {
                ComplexValue r = Double.isInfinite(real) && Double.isFinite(imag) && imag != 0.0 ? (real > 0.0 ? new ComplexValue(Math.copySign(Double.POSITIVE_INFINITY, Math.cos(imag)), Math.copySign(Double.POSITIVE_INFINITY, Math.sin(imag))) : new ComplexValue(Math.copySign(0.0, Math.cos(imag)), Math.copySign(0.0, Math.sin(imag)))) : CmathModuleBuiltins.specialValue(SPECIAL_VALUES, real, imag);
                if (Double.isInfinite(imag) && (Double.isFinite(real) || Double.isInfinite(real) && real > 0.0)) {
                    throw raiseNode.raise(inliningTarget, PythonErrorType.ValueError, ErrorMessages.MATH_DOMAIN_ERROR);
                }
                return r;
            }
            if (real > LOG_LARGE_DOUBLE) {
                double l = Math.exp(real - 1.0);
                rreal = l * Math.cos(imag) * Math.E;
                rimag = l * Math.sin(imag) * Math.E;
            } else {
                double l = Math.exp(real);
                rreal = l * Math.cos(imag);
                rimag = l * Math.sin(imag);
            }
            if (Double.isInfinite(rreal) || Double.isInfinite(rimag)) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.OverflowError, ErrorMessages.MATH_RANGE_ERROR);
            }
            return new ComplexValue(rreal, rimag);
        }
    }

    @Builtin(name="atanh", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class AtanhNode
    extends PythonUnaryBuiltinNode {
        static final double SQRT_LARGE_DOUBLE = Math.sqrt(4.4942328371557893E307);
        static final double CM_SQRT_DBL_MIN = Math.sqrt(Double.MIN_NORMAL);
        @CompilerDirectives.CompilationFinal(dimensions=2)
        private static final ComplexValue[][] SPECIAL_VALUES = new ComplexValue[][]{{CmathModuleBuiltins.C(-0.0, -1.5707963267948966), CmathModuleBuiltins.C(-0.0, -1.5707963267948966), CmathModuleBuiltins.C(-0.0, -1.5707963267948966), CmathModuleBuiltins.C(-0.0, 1.5707963267948966), CmathModuleBuiltins.C(-0.0, 1.5707963267948966), CmathModuleBuiltins.C(-0.0, 1.5707963267948966), CmathModuleBuiltins.C(-0.0, Double.NaN)}, {CmathModuleBuiltins.C(-0.0, -1.5707963267948966), null, null, null, null, CmathModuleBuiltins.C(-0.0, 1.5707963267948966), CmathModuleBuiltins.C(Double.NaN, Double.NaN)}, {CmathModuleBuiltins.C(-0.0, -1.5707963267948966), null, CmathModuleBuiltins.C(-0.0, -0.0), CmathModuleBuiltins.C(-0.0, 0.0), null, CmathModuleBuiltins.C(-0.0, 1.5707963267948966), CmathModuleBuiltins.C(-0.0, Double.NaN)}, {CmathModuleBuiltins.C(0.0, -1.5707963267948966), null, CmathModuleBuiltins.C(0.0, -0.0), CmathModuleBuiltins.C(0.0, 0.0), null, CmathModuleBuiltins.C(0.0, 1.5707963267948966), CmathModuleBuiltins.C(0.0, Double.NaN)}, {CmathModuleBuiltins.C(0.0, -1.5707963267948966), null, null, null, null, CmathModuleBuiltins.C(0.0, 1.5707963267948966), CmathModuleBuiltins.C(Double.NaN, Double.NaN)}, {CmathModuleBuiltins.C(0.0, -1.5707963267948966), CmathModuleBuiltins.C(0.0, -1.5707963267948966), CmathModuleBuiltins.C(0.0, -1.5707963267948966), CmathModuleBuiltins.C(0.0, 1.5707963267948966), CmathModuleBuiltins.C(0.0, 1.5707963267948966), CmathModuleBuiltins.C(0.0, 1.5707963267948966), CmathModuleBuiltins.C(0.0, Double.NaN)}, {CmathModuleBuiltins.C(0.0, -1.5707963267948966), CmathModuleBuiltins.C(Double.NaN, Double.NaN), CmathModuleBuiltins.C(Double.NaN, Double.NaN), CmathModuleBuiltins.C(Double.NaN, Double.NaN), CmathModuleBuiltins.C(Double.NaN, Double.NaN), CmathModuleBuiltins.C(0.0, 1.5707963267948966), CmathModuleBuiltins.C(Double.NaN, Double.NaN)}};

        AtanhNode() {
        }

        @Specialization
        static PComplex doIt(VirtualFrame frame, Object value, @Bind Node inliningTarget, @Cached CmathComplexUnaryHelperNode helperNode) {
            return helperNode.execute(frame, inliningTarget, value, AtanhNode::compute);
        }

        static ComplexValue compute(Node inliningTarget, double real, double imag, PRaiseNode raiseNode) {
            ComplexValue result = CmathModuleBuiltins.specialValue(SPECIAL_VALUES, real, imag);
            if (result != null) {
                return result;
            }
            if (real < 0.0) {
                return AtanhNode.computeWithRealPositive(inliningTarget, -real, -imag, -1.0, raiseNode);
            }
            return AtanhNode.computeWithRealPositive(inliningTarget, real, imag, 1.0, raiseNode);
        }

        private static ComplexValue computeWithRealPositive(Node inliningTarget, double real, double imag, double resultScale, PRaiseNode raiseNode) {
            double rimag;
            double rreal;
            double ay = Math.abs(imag);
            if (real > SQRT_LARGE_DOUBLE || ay > SQRT_LARGE_DOUBLE) {
                double h = Math.hypot(real / 2.0, imag / 2.0);
                rreal = real / 4.0 / h / h;
                rimag = -Math.copySign(1.5707963267948966, -imag);
            } else if (real == 1.0 && ay < CM_SQRT_DBL_MIN) {
                if (ay == 0.0) {
                    throw raiseNode.raise(inliningTarget, PythonErrorType.ValueError, ErrorMessages.MATH_DOMAIN_ERROR);
                }
                rreal = -Math.log(Math.sqrt(ay) / Math.sqrt(Math.hypot(ay, 2.0)));
                rimag = Math.copySign(Math.atan2(2.0, -ay) / 2.0, imag);
            } else {
                rreal = Math.log1p(4.0 * real / ((1.0 - real) * (1.0 - real) + ay * ay)) / 4.0;
                rimag = -Math.atan2(-2.0 * imag, (1.0 - real) * (1.0 + real) - ay * ay) / 2.0;
            }
            return new ComplexValue(resultScale * rreal, resultScale * rimag);
        }
    }

    @Builtin(name="atan", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class AtanNode
    extends PythonUnaryBuiltinNode {
        AtanNode() {
        }

        @Specialization
        static PComplex doIt(VirtualFrame frame, Object value, @Bind Node inliningTarget, @Cached CmathComplexUnaryHelperNode helperNode) {
            return helperNode.execute(frame, inliningTarget, value, AtanNode::compute);
        }

        static ComplexValue compute(Node inliningTarget, double real, double imag, PRaiseNode raiseNode) {
            ComplexValue s = AtanhNode.compute(inliningTarget, -imag, real, raiseNode);
            return new ComplexValue(s.imag, -s.real);
        }
    }

    @Builtin(name="asinh", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class AsinhNode
    extends PythonUnaryBuiltinNode {
        @CompilerDirectives.CompilationFinal(dimensions=2)
        private static final ComplexValue[][] SPECIAL_VALUES = new ComplexValue[][]{{CmathModuleBuiltins.C(Double.NEGATIVE_INFINITY, -0.7853981633974483), CmathModuleBuiltins.C(Double.NEGATIVE_INFINITY, -0.0), CmathModuleBuiltins.C(Double.NEGATIVE_INFINITY, -0.0), CmathModuleBuiltins.C(Double.NEGATIVE_INFINITY, 0.0), CmathModuleBuiltins.C(Double.NEGATIVE_INFINITY, 0.0), CmathModuleBuiltins.C(Double.NEGATIVE_INFINITY, 0.7853981633974483), CmathModuleBuiltins.C(Double.NEGATIVE_INFINITY, Double.NaN)}, {CmathModuleBuiltins.C(Double.NEGATIVE_INFINITY, -1.5707963267948966), null, null, null, null, CmathModuleBuiltins.C(Double.NEGATIVE_INFINITY, 1.5707963267948966), CmathModuleBuiltins.C(Double.NaN, Double.NaN)}, {CmathModuleBuiltins.C(Double.NEGATIVE_INFINITY, -1.5707963267948966), null, CmathModuleBuiltins.C(-0.0, -0.0), CmathModuleBuiltins.C(-0.0, 0.0), null, CmathModuleBuiltins.C(Double.NEGATIVE_INFINITY, 1.5707963267948966), CmathModuleBuiltins.C(Double.NaN, Double.NaN)}, {CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, -1.5707963267948966), null, CmathModuleBuiltins.C(0.0, -0.0), CmathModuleBuiltins.C(0.0, 0.0), null, CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, 1.5707963267948966), CmathModuleBuiltins.C(Double.NaN, Double.NaN)}, {CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, -1.5707963267948966), null, null, null, null, CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, 1.5707963267948966), CmathModuleBuiltins.C(Double.NaN, Double.NaN)}, {CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, -0.7853981633974483), CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, -0.0), CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, -0.0), CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, 0.0), CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, 0.0), CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, 0.7853981633974483), CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, Double.NaN)}, {CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, Double.NaN), CmathModuleBuiltins.C(Double.NaN, Double.NaN), CmathModuleBuiltins.C(Double.NaN, -0.0), CmathModuleBuiltins.C(Double.NaN, 0.0), CmathModuleBuiltins.C(Double.NaN, Double.NaN), CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, Double.NaN), CmathModuleBuiltins.C(Double.NaN, Double.NaN)}};

        AsinhNode() {
        }

        @Specialization
        static PComplex doIt(VirtualFrame frame, Object value, @Bind Node inliningTarget, @Cached CmathComplexUnaryHelperNode helperNode) {
            return helperNode.execute(frame, inliningTarget, value, AsinhNode::compute);
        }

        static ComplexValue compute(Node inliningTarget, double real, double imag, PRaiseNode raiseNode) {
            double rimag;
            double rreal;
            ComplexValue result = CmathModuleBuiltins.specialValue(SPECIAL_VALUES, real, imag);
            if (result != null) {
                return result;
            }
            if (Math.abs(real) > 4.4942328371557893E307 || Math.abs(imag) > 4.4942328371557893E307) {
                double s = Math.log(Math.hypot(real / 2.0, imag / 2.0)) + 1.3862943611198906;
                rreal = imag >= 0.0 ? Math.copySign(s, real) : -Math.copySign(s, -real);
                rimag = Math.atan2(imag, Math.abs(real));
            } else {
                ComplexValue s1 = SqrtNode.compute(inliningTarget, 1.0 + imag, -real, raiseNode);
                ComplexValue s2 = SqrtNode.compute(inliningTarget, 1.0 - imag, real, raiseNode);
                rreal = MathUtils.asinh((double)(s1.real * s2.imag - s2.real * s1.imag));
                rimag = Math.atan2(imag, s1.real * s2.real - s1.imag * s2.imag);
            }
            return new ComplexValue(rreal, rimag);
        }
    }

    @Builtin(name="asin", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class AsinNode
    extends PythonUnaryBuiltinNode {
        AsinNode() {
        }

        @Specialization
        static PComplex doIt(VirtualFrame frame, Object value, @Bind Node inliningTarget, @Cached CmathComplexUnaryHelperNode helperNode) {
            return helperNode.execute(frame, inliningTarget, value, AsinNode::compute);
        }

        static ComplexValue compute(Node inliningTarget, double real, double imag, PRaiseNode raiseNode) {
            ComplexValue s = AsinhNode.compute(inliningTarget, -imag, real, raiseNode);
            return new ComplexValue(s.imag, -s.real);
        }
    }

    @Builtin(name="acosh", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class AcoshNode
    extends PythonUnaryBuiltinNode {
        @CompilerDirectives.CompilationFinal(dimensions=2)
        private static final ComplexValue[][] SPECIAL_VALUES = new ComplexValue[][]{{CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, -2.356194490192345), CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, -Math.PI), CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, -Math.PI), CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, Math.PI), CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, Math.PI), CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, 2.356194490192345), CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, Double.NaN)}, {CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, -1.5707963267948966), null, null, null, null, CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, 1.5707963267948966), CmathModuleBuiltins.C(Double.NaN, Double.NaN)}, {CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, -1.5707963267948966), null, CmathModuleBuiltins.C(0.0, -1.5707963267948966), CmathModuleBuiltins.C(0.0, 1.5707963267948966), null, CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, 1.5707963267948966), CmathModuleBuiltins.C(Double.NaN, Double.NaN)}, {CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, -1.5707963267948966), null, CmathModuleBuiltins.C(0.0, -1.5707963267948966), CmathModuleBuiltins.C(0.0, 1.5707963267948966), null, CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, 1.5707963267948966), CmathModuleBuiltins.C(Double.NaN, Double.NaN)}, {CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, -1.5707963267948966), null, null, null, null, CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, 1.5707963267948966), CmathModuleBuiltins.C(Double.NaN, Double.NaN)}, {CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, -0.7853981633974483), CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, -0.0), CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, -0.0), CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, 0.0), CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, 0.0), CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, 0.7853981633974483), CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, Double.NaN)}, {CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, Double.NaN), CmathModuleBuiltins.C(Double.NaN, Double.NaN), CmathModuleBuiltins.C(Double.NaN, Double.NaN), CmathModuleBuiltins.C(Double.NaN, Double.NaN), CmathModuleBuiltins.C(Double.NaN, Double.NaN), CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, Double.NaN), CmathModuleBuiltins.C(Double.NaN, Double.NaN)}};

        AcoshNode() {
        }

        @Specialization
        static PComplex doIt(VirtualFrame frame, Object value, @Bind Node inliningTarget, @Cached CmathComplexUnaryHelperNode helperNode) {
            return helperNode.execute(frame, inliningTarget, value, AcoshNode::compute);
        }

        static ComplexValue compute(Node inliningTarget, double real, double imag, PRaiseNode raiseNode) {
            double rimag;
            double rreal;
            ComplexValue result = CmathModuleBuiltins.specialValue(SPECIAL_VALUES, real, imag);
            if (result != null) {
                return result;
            }
            if (Math.abs(real) > 4.4942328371557893E307 || Math.abs(imag) > 4.4942328371557893E307) {
                rreal = Math.log(Math.hypot(real / 2.0, imag / 2.0)) + 1.3862943611198906;
                rimag = Math.atan2(imag, real);
            } else {
                ComplexValue s1 = SqrtNode.compute(inliningTarget, real - 1.0, imag, raiseNode);
                ComplexValue s2 = SqrtNode.compute(inliningTarget, real + 1.0, imag, raiseNode);
                rreal = MathUtils.asinh((double)(s1.real * s2.real + s1.imag * s2.imag));
                rimag = 2.0 * Math.atan2(s1.imag, s2.real);
            }
            return new ComplexValue(rreal, rimag);
        }
    }

    @Builtin(name="acos", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class AcosNode
    extends PythonUnaryBuiltinNode {
        @CompilerDirectives.CompilationFinal(dimensions=2)
        private static final ComplexValue[][] SPECIAL_VALUES = new ComplexValue[][]{{CmathModuleBuiltins.C(2.356194490192345, Double.POSITIVE_INFINITY), CmathModuleBuiltins.C(Math.PI, Double.POSITIVE_INFINITY), CmathModuleBuiltins.C(Math.PI, Double.POSITIVE_INFINITY), CmathModuleBuiltins.C(Math.PI, Double.NEGATIVE_INFINITY), CmathModuleBuiltins.C(Math.PI, Double.NEGATIVE_INFINITY), CmathModuleBuiltins.C(2.356194490192345, Double.NEGATIVE_INFINITY), CmathModuleBuiltins.C(Double.NaN, Double.POSITIVE_INFINITY)}, {CmathModuleBuiltins.C(1.5707963267948966, Double.POSITIVE_INFINITY), null, null, null, null, CmathModuleBuiltins.C(1.5707963267948966, Double.NEGATIVE_INFINITY), CmathModuleBuiltins.C(Double.NaN, Double.NaN)}, {CmathModuleBuiltins.C(1.5707963267948966, Double.POSITIVE_INFINITY), null, CmathModuleBuiltins.C(1.5707963267948966, 0.0), CmathModuleBuiltins.C(1.5707963267948966, -0.0), null, CmathModuleBuiltins.C(1.5707963267948966, Double.NEGATIVE_INFINITY), CmathModuleBuiltins.C(1.5707963267948966, Double.NaN)}, {CmathModuleBuiltins.C(1.5707963267948966, Double.POSITIVE_INFINITY), null, CmathModuleBuiltins.C(1.5707963267948966, 0.0), CmathModuleBuiltins.C(1.5707963267948966, -0.0), null, CmathModuleBuiltins.C(1.5707963267948966, Double.NEGATIVE_INFINITY), CmathModuleBuiltins.C(1.5707963267948966, Double.NaN)}, {CmathModuleBuiltins.C(1.5707963267948966, Double.POSITIVE_INFINITY), null, null, null, null, CmathModuleBuiltins.C(1.5707963267948966, Double.NEGATIVE_INFINITY), CmathModuleBuiltins.C(Double.NaN, Double.NaN)}, {CmathModuleBuiltins.C(0.7853981633974483, Double.POSITIVE_INFINITY), CmathModuleBuiltins.C(0.0, Double.POSITIVE_INFINITY), CmathModuleBuiltins.C(0.0, Double.POSITIVE_INFINITY), CmathModuleBuiltins.C(0.0, Double.NEGATIVE_INFINITY), CmathModuleBuiltins.C(0.0, Double.NEGATIVE_INFINITY), CmathModuleBuiltins.C(0.7853981633974483, Double.NEGATIVE_INFINITY), CmathModuleBuiltins.C(Double.NaN, Double.POSITIVE_INFINITY)}, {CmathModuleBuiltins.C(Double.NaN, Double.POSITIVE_INFINITY), CmathModuleBuiltins.C(Double.NaN, Double.NaN), CmathModuleBuiltins.C(Double.NaN, Double.NaN), CmathModuleBuiltins.C(Double.NaN, Double.NaN), CmathModuleBuiltins.C(Double.NaN, Double.NaN), CmathModuleBuiltins.C(Double.NaN, Double.NEGATIVE_INFINITY), CmathModuleBuiltins.C(Double.NaN, Double.NaN)}};

        AcosNode() {
        }

        @Specialization
        static PComplex doIt(VirtualFrame frame, Object value, @Bind Node inliningTarget, @Cached CmathComplexUnaryHelperNode helperNode) {
            return helperNode.execute(frame, inliningTarget, value, AcosNode::compute);
        }

        static ComplexValue compute(Node inliningTarget, double real, double imag, PRaiseNode raiseNode) {
            double rimag;
            double rreal;
            ComplexValue result = CmathModuleBuiltins.specialValue(SPECIAL_VALUES, real, imag);
            if (result != null) {
                return result;
            }
            if (Math.abs(real) > 4.4942328371557893E307 || Math.abs(imag) > 4.4942328371557893E307) {
                rreal = Math.atan2(Math.abs(imag), real);
                double s = Math.log(Math.hypot(real / 2.0, imag / 2.0)) + 1.3862943611198906;
                rimag = real < 0.0 ? -Math.copySign(s, imag) : Math.copySign(s, -imag);
            } else {
                ComplexValue s1 = SqrtNode.compute(inliningTarget, 1.0 - real, -imag, raiseNode);
                ComplexValue s2 = SqrtNode.compute(inliningTarget, 1.0 + real, imag, raiseNode);
                rreal = 2.0 * Math.atan2(s1.real, s2.real);
                rimag = MathUtils.asinh((double)(s2.real * s1.imag - s2.imag * s1.real));
            }
            return new ComplexValue(rreal, rimag);
        }
    }

    @Builtin(name="sqrt", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class SqrtNode
    extends PythonUnaryBuiltinNode {
        @CompilerDirectives.CompilationFinal(dimensions=2)
        private static final ComplexValue[][] SPECIAL_VALUES = new ComplexValue[][]{{CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY), CmathModuleBuiltins.C(0.0, Double.NEGATIVE_INFINITY), CmathModuleBuiltins.C(0.0, Double.NEGATIVE_INFINITY), CmathModuleBuiltins.C(0.0, Double.POSITIVE_INFINITY), CmathModuleBuiltins.C(0.0, Double.POSITIVE_INFINITY), CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY), CmathModuleBuiltins.C(Double.NaN, Double.POSITIVE_INFINITY)}, {CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY), null, null, null, null, CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY), CmathModuleBuiltins.C(Double.NaN, Double.NaN)}, {CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY), null, CmathModuleBuiltins.C(0.0, -0.0), CmathModuleBuiltins.C(0.0, 0.0), null, CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY), CmathModuleBuiltins.C(Double.NaN, Double.NaN)}, {CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY), null, CmathModuleBuiltins.C(0.0, -0.0), CmathModuleBuiltins.C(0.0, 0.0), null, CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY), CmathModuleBuiltins.C(Double.NaN, Double.NaN)}, {CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY), null, null, null, null, CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY), CmathModuleBuiltins.C(Double.NaN, Double.NaN)}, {CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY), CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, -0.0), CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, -0.0), CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, 0.0), CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, 0.0), CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY), CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, Double.NaN)}, {CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY), CmathModuleBuiltins.C(Double.NaN, Double.NaN), CmathModuleBuiltins.C(Double.NaN, Double.NaN), CmathModuleBuiltins.C(Double.NaN, Double.NaN), CmathModuleBuiltins.C(Double.NaN, Double.NaN), CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY), CmathModuleBuiltins.C(Double.NaN, Double.NaN)}};

        SqrtNode() {
        }

        @Specialization
        static PComplex doIt(VirtualFrame frame, Object value, @Bind Node inliningTarget, @Cached CmathComplexUnaryHelperNode helperNode) {
            return helperNode.execute(frame, inliningTarget, value, SqrtNode::compute);
        }

        static ComplexValue compute(Node inliningTarget, double real, double imag, PRaiseNode raiseNode) {
            double s;
            ComplexValue result = CmathModuleBuiltins.specialValue(SPECIAL_VALUES, real, imag);
            if (result != null) {
                return result;
            }
            if (real == 0.0 && imag == 0.0) {
                return new ComplexValue(0.0, imag);
            }
            double ax = Math.abs(real);
            double ay = Math.abs(imag);
            if (ax < Double.MIN_NORMAL && ay < Double.MIN_NORMAL && (ax > 0.0 || ay > 0.0)) {
                double scaleUp = 9.007199254740992E15;
                double scaleDown = 7.450580596923828E-9;
                s = Math.sqrt((ax *= 9.007199254740992E15) + Math.hypot(ax, ay * 9.007199254740992E15)) * 7.450580596923828E-9;
            } else {
                s = 2.0 * Math.sqrt((ax /= 8.0) + Math.hypot(ax, ay / 8.0));
            }
            double d = ay / (2.0 * s);
            if (real >= 0.0) {
                return new ComplexValue(s, Math.copySign(d, imag));
            }
            return new ComplexValue(d, Math.copySign(s, imag));
        }
    }

    @Builtin(name="log10", minNumOfPositionalArgs=1)
    @TypeSystemReference(value=PythonIntegerAndFloatTypes.class)
    @ImportStatic(value={MathGuards.class})
    @GenerateNodeFactory
    static abstract class Log10Node
    extends PythonUnaryBuiltinNode {
        @Node.Child
        LogNode logNode = LogNode.create();

        Log10Node() {
        }

        @Specialization
        PComplex doComplex(VirtualFrame frame, PComplex z, @Bind PythonLanguage language) {
            PComplex r = this.logNode.executeComplex(frame, z, PNone.NO_VALUE);
            return PFactory.createComplex(language, r.getReal() / 2.302585092994046, r.getImag() / 2.302585092994046);
        }

        @Specialization
        PComplex doGeneral(VirtualFrame frame, Object zObj, @Bind Node inliningTarget, @Cached CoerceToComplexNode coerceXToComplex, @Bind PythonLanguage language) {
            return this.doComplex(frame, coerceXToComplex.execute(frame, inliningTarget, zObj), language);
        }
    }

    @Builtin(name="log", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2)
    @TypeSystemReference(value=PythonIntegerAndFloatTypes.class)
    @ImportStatic(value={MathGuards.class})
    @GenerateNodeFactory
    static abstract class LogNode
    extends PythonBinaryBuiltinNode {
        @CompilerDirectives.CompilationFinal(dimensions=2)
        private static final ComplexValue[][] SPECIAL_VALUES = new ComplexValue[][]{{CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, -2.356194490192345), CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, -Math.PI), CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, -Math.PI), CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, Math.PI), CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, Math.PI), CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, 2.356194490192345), CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, Double.NaN)}, {CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, -1.5707963267948966), null, null, null, null, CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, 1.5707963267948966), CmathModuleBuiltins.C(Double.NaN, Double.NaN)}, {CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, -1.5707963267948966), null, CmathModuleBuiltins.C(Double.NEGATIVE_INFINITY, -Math.PI), CmathModuleBuiltins.C(Double.NEGATIVE_INFINITY, Math.PI), null, CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, 1.5707963267948966), CmathModuleBuiltins.C(Double.NaN, Double.NaN)}, {CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, -1.5707963267948966), null, CmathModuleBuiltins.C(Double.NEGATIVE_INFINITY, -0.0), CmathModuleBuiltins.C(Double.NEGATIVE_INFINITY, 0.0), null, CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, 1.5707963267948966), CmathModuleBuiltins.C(Double.NaN, Double.NaN)}, {CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, -1.5707963267948966), null, null, null, null, CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, 1.5707963267948966), CmathModuleBuiltins.C(Double.NaN, Double.NaN)}, {CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, -0.7853981633974483), CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, -0.0), CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, -0.0), CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, 0.0), CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, 0.0), CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, 0.7853981633974483), CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, Double.NaN)}, {CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, Double.NaN), CmathModuleBuiltins.C(Double.NaN, Double.NaN), CmathModuleBuiltins.C(Double.NaN, Double.NaN), CmathModuleBuiltins.C(Double.NaN, Double.NaN), CmathModuleBuiltins.C(Double.NaN, Double.NaN), CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, Double.NaN), CmathModuleBuiltins.C(Double.NaN, Double.NaN)}};

        LogNode() {
        }

        abstract PComplex executeComplex(VirtualFrame var1, Object var2, Object var3);

        static LogNode create() {
            return CmathModuleBuiltinsFactory.LogNodeFactory.create();
        }

        @Specialization(guards={"isNoValue(y)"})
        PComplex doComplexNone(PComplex x, PNone y, @Bind PythonLanguage language) {
            return this.log(x, language);
        }

        @Specialization
        PComplex doComplexComplex(VirtualFrame frame, PComplex x, PComplex y, @Cached.Shared @Cached ComplexBuiltins.DivNode divNode, @Bind PythonLanguage language) {
            return divNode.executeComplex(frame, this.log(x, language), this.log(y, language));
        }

        @Specialization(guards={"isNoValue(yObj)"})
        PComplex doGeneral(VirtualFrame frame, Object xObj, PNone yObj, @Bind Node inliningTarget, @Cached.Shared @Cached CoerceToComplexNode coerceXToComplex, @Cached.Shared @Cached CoerceToComplexNode coerceYToComplex, @Bind PythonLanguage language) {
            return this.log(coerceXToComplex.execute(frame, inliningTarget, xObj), language);
        }

        @Specialization(guards={"!isNoValue(yObj)"})
        PComplex doGeneral(VirtualFrame frame, Object xObj, Object yObj, @Bind Node inliningTarget, @Cached.Shared @Cached CoerceToComplexNode coerceXToComplex, @Cached.Shared @Cached CoerceToComplexNode coerceYToComplex, @Cached.Shared @Cached ComplexBuiltins.DivNode divNode, @Bind PythonLanguage language) {
            PComplex x = this.log(coerceXToComplex.execute(frame, inliningTarget, xObj), language);
            PComplex y = this.log(coerceYToComplex.execute(frame, inliningTarget, yObj), language);
            return divNode.executeComplex(frame, x, y);
        }

        private PComplex log(PComplex z, PythonLanguage language) {
            PComplex r = CmathModuleBuiltins.specialValue(language, SPECIAL_VALUES, z.getReal(), z.getImag());
            if (r != null) {
                return r;
            }
            double real = this.computeRealPart(z.getReal(), z.getImag());
            double imag = Math.atan2(z.getImag(), z.getReal());
            return PFactory.createComplex(language, real, imag);
        }

        @CompilerDirectives.TruffleBoundary
        private double computeRealPart(double real, double imag) {
            double ax = Math.abs(real);
            double ay = Math.abs(imag);
            if (ax > 4.4942328371557893E307 || ay > 4.4942328371557893E307) {
                return Math.log(Math.hypot(ax / 2.0, ay / 2.0)) + 0.6931471805599453;
            }
            if (ax < Double.MIN_NORMAL && ay < Double.MIN_NORMAL) {
                if (ax > 0.0 || ay > 0.0) {
                    double scaleUp = 9.007199254740992E15;
                    return Math.log(Math.hypot(ax * 9.007199254740992E15, ay * 9.007199254740992E15)) - 36.7368005696771;
                }
                throw PRaiseNode.raiseStatic((Node)this, PythonErrorType.ValueError, ErrorMessages.MATH_DOMAIN_ERROR);
            }
            double h = Math.hypot(ax, ay);
            if (0.71 <= h && h <= 1.73) {
                double am = Math.max(ax, ay);
                double an = Math.min(ax, ay);
                return Math.log1p((am - 1.0) * (am + 1.0) + an * an) / 2.0;
            }
            return Math.log(h);
        }
    }

    @Builtin(name="rect", minNumOfPositionalArgs=2)
    @TypeSystemReference(value=PythonIntegerAndFloatTypes.class)
    @ImportStatic(value={MathGuards.class})
    @GenerateNodeFactory
    static abstract class RectNode
    extends PythonBinaryBuiltinNode {
        @CompilerDirectives.CompilationFinal(dimensions=2)
        private static final ComplexValue[][] SPECIAL_VALUES = new ComplexValue[][]{{CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, Double.NaN), null, CmathModuleBuiltins.C(Double.NEGATIVE_INFINITY, 0.0), CmathModuleBuiltins.C(Double.NEGATIVE_INFINITY, -0.0), null, CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, Double.NaN), CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, Double.NaN)}, {CmathModuleBuiltins.C(Double.NaN, Double.NaN), null, null, null, null, CmathModuleBuiltins.C(Double.NaN, Double.NaN), CmathModuleBuiltins.C(Double.NaN, Double.NaN)}, {CmathModuleBuiltins.C(0.0, 0.0), null, CmathModuleBuiltins.C(-0.0, 0.0), CmathModuleBuiltins.C(-0.0, -0.0), null, CmathModuleBuiltins.C(0.0, 0.0), CmathModuleBuiltins.C(0.0, 0.0)}, {CmathModuleBuiltins.C(0.0, 0.0), null, CmathModuleBuiltins.C(0.0, -0.0), CmathModuleBuiltins.C(0.0, 0.0), null, CmathModuleBuiltins.C(0.0, 0.0), CmathModuleBuiltins.C(0.0, 0.0)}, {CmathModuleBuiltins.C(Double.NaN, Double.NaN), null, null, null, null, CmathModuleBuiltins.C(Double.NaN, Double.NaN), CmathModuleBuiltins.C(Double.NaN, Double.NaN)}, {CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, Double.NaN), null, CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, -0.0), CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, 0.0), null, CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, Double.NaN), CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, Double.NaN)}, {CmathModuleBuiltins.C(Double.NaN, Double.NaN), CmathModuleBuiltins.C(Double.NaN, Double.NaN), CmathModuleBuiltins.C(Double.NaN, 0.0), CmathModuleBuiltins.C(Double.NaN, 0.0), CmathModuleBuiltins.C(Double.NaN, Double.NaN), CmathModuleBuiltins.C(Double.NaN, Double.NaN), CmathModuleBuiltins.C(Double.NaN, Double.NaN)}};

        RectNode() {
        }

        @Specialization
        PComplex doLL(long r, long phi) {
            return RectNode.rect(this, r, phi);
        }

        @Specialization
        PComplex doLD(long r, double phi) {
            return RectNode.rect(this, r, phi);
        }

        @Specialization
        PComplex doDL(double r, long phi) {
            return RectNode.rect(this, r, phi);
        }

        @Specialization
        PComplex doDD(double r, double phi) {
            return RectNode.rect(this, r, phi);
        }

        @Specialization
        static PComplex doGeneral(VirtualFrame frame, Object r, Object phi, @Bind Node inliningTarget, @Cached PyFloatAsDoubleNode rAsDoubleNode, @Cached PyFloatAsDoubleNode phiAsDoubleNode) {
            return RectNode.rect(inliningTarget, rAsDoubleNode.execute(frame, inliningTarget, r), phiAsDoubleNode.execute(frame, inliningTarget, phi));
        }

        @CompilerDirectives.TruffleBoundary
        private static PComplex rect(Node raisingNode, double r, double phi) {
            PythonLanguage language = PythonLanguage.get(null);
            if (!Double.isFinite(r) || !Double.isFinite(phi)) {
                if (r != 0.0 && !Double.isNaN(r) && Double.isInfinite(phi)) {
                    throw PRaiseNode.raiseStatic(raisingNode, PythonErrorType.ValueError, ErrorMessages.MATH_DOMAIN_ERROR);
                }
                if (Double.isInfinite(r) && Double.isFinite(phi) && phi != 0.0) {
                    double real = Math.copySign(Double.POSITIVE_INFINITY, Math.cos(phi));
                    double imag = Math.copySign(Double.POSITIVE_INFINITY, Math.sin(phi));
                    if (r > 0.0) {
                        return PFactory.createComplex(language, real, imag);
                    }
                    return PFactory.createComplex(language, -real, -imag);
                }
                return CmathModuleBuiltins.specialValue(language, SPECIAL_VALUES, r, phi);
            }
            return PFactory.createComplex(language, r * Math.cos(phi), r * Math.sin(phi));
        }
    }

    @Builtin(name="polar", minNumOfPositionalArgs=1)
    @TypeSystemReference(value=PythonIntegerAndFloatTypes.class)
    @ImportStatic(value={MathGuards.class})
    @GenerateNodeFactory
    static abstract class PolarNode
    extends PythonUnaryBuiltinNode {
        PolarNode() {
        }

        @Specialization
        static PTuple doL(long value, @Bind PythonLanguage language) {
            return PolarNode.doD(value, language);
        }

        @Specialization
        static PTuple doD(double value, @Bind PythonLanguage language) {
            return PFactory.createTuple(language, new Object[]{Math.abs(value), value < 0.0 ? Math.PI : 0.0});
        }

        @Specialization
        static PTuple doC(PComplex value, @Cached.Shared @Cached ComplexBuiltins.AbsNode absNode, @Bind PythonLanguage language) {
            return PolarNode.toPolar(value, absNode, language);
        }

        @Specialization
        static PTuple doGeneral(VirtualFrame frame, Object value, @Bind Node inliningTarget, @Cached CoerceToComplexNode coerceToComplex, @Cached.Shared @Cached ComplexBuiltins.AbsNode absNode, @Bind PythonLanguage language) {
            return PolarNode.toPolar(coerceToComplex.execute(frame, inliningTarget, value), absNode, language);
        }

        private static PTuple toPolar(PComplex value, ComplexBuiltins.AbsNode absNode, PythonLanguage language) {
            double r = absNode.executeDouble(value);
            return PFactory.createTuple(language, new Object[]{r, Math.atan2(value.getImag(), value.getReal())});
        }
    }

    @Builtin(name="phase", minNumOfPositionalArgs=1)
    @TypeSystemReference(value=PythonIntegerAndFloatTypes.class)
    @ImportStatic(value={MathGuards.class})
    @GenerateNodeFactory
    static abstract class PhaseNode
    extends PythonUnaryBuiltinNode {
        PhaseNode() {
        }

        @Specialization
        static double doL(long value) {
            return value < 0L ? Math.PI : 0.0;
        }

        @Specialization
        static double doD(double value) {
            return value < 0.0 ? Math.PI : 0.0;
        }

        @Specialization
        static double doC(PComplex value) {
            return Math.atan2(value.getImag(), value.getReal());
        }

        @Specialization
        static double doGeneral(VirtualFrame frame, Object value, @Bind Node inliningTarget, @Cached CoerceToComplexNode coerceToComplex) {
            return PhaseNode.doC(coerceToComplex.execute(frame, inliningTarget, value));
        }
    }

    @Builtin(name="isfinite", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class IsFiniteNode
    extends PythonUnaryBuiltinNode {
        IsFiniteNode() {
        }

        @Specialization
        static boolean doIt(VirtualFrame frame, Object o, @Bind Node inliningTarget, @Cached CmathBooleanUnaryHelperNode helper) {
            return helper.execute(frame, inliningTarget, o, (real, imag) -> Double.isFinite(real) && Double.isFinite(imag));
        }
    }

    @Builtin(name="isinf", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class IsInfNode
    extends PythonUnaryBuiltinNode {
        IsInfNode() {
        }

        @Specialization
        static boolean doIt(VirtualFrame frame, Object o, @Bind Node inliningTarget, @Cached CmathBooleanUnaryHelperNode helper) {
            return helper.execute(frame, inliningTarget, o, (real, imag) -> Double.isInfinite(real) || Double.isInfinite(imag));
        }
    }

    @Builtin(name="isnan", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class IsNanNode
    extends PythonUnaryBuiltinNode {
        IsNanNode() {
        }

        @Specialization
        static boolean doIt(VirtualFrame frame, Object o, @Bind Node inliningTarget, @Cached CmathBooleanUnaryHelperNode helper) {
            return helper.execute(frame, inliningTarget, o, (real, imag) -> Double.isNaN(real) || Double.isNaN(imag));
        }
    }

    @TypeSystemReference(value=PythonIntegerAndFloatTypes.class)
    @ImportStatic(value={MathGuards.class})
    @GenerateInline
    @GenerateCached(value=false)
    static abstract class CmathBooleanUnaryHelperNode
    extends Node {
        CmathBooleanUnaryHelperNode() {
        }

        abstract boolean execute(VirtualFrame var1, Node var2, Object var3, Op var4);

        @Specialization
        static boolean doL(long value, Op op) {
            return op.compute(value, 0.0);
        }

        @Specialization
        static boolean doD(double value, Op op) {
            return op.compute(value, 0.0);
        }

        @Specialization
        static boolean doC(PComplex value, Op op) {
            return op.compute(value.getReal(), value.getImag());
        }

        @Specialization
        static boolean doGeneral(VirtualFrame frame, Node inliningTarget, Object value, Op op, @Cached CoerceToComplexNode coerceToComplex) {
            return CmathBooleanUnaryHelperNode.doC(coerceToComplex.execute(frame, inliningTarget, value), op);
        }

        @FunctionalInterface
        static interface Op {
            public boolean compute(double var1, double var3);
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    @TypeSystemReference(value=PythonIntegerAndFloatTypes.class)
    @ImportStatic(value={MathGuards.class})
    static abstract class CmathComplexUnaryHelperNode
    extends Node {
        CmathComplexUnaryHelperNode() {
        }

        abstract PComplex execute(VirtualFrame var1, Node var2, Object var3, Op var4);

        @Specialization
        static PComplex doL(Node inliningTarget, long value, Op op, @Bind PythonLanguage language, @Cached.Shared @Cached PRaiseNode raiseNode) {
            return op.compute(inliningTarget, value, 0.0, raiseNode).toPComplex(language);
        }

        @Specialization
        static PComplex doD(Node inliningTarget, double value, Op op, @Bind PythonLanguage language, @Cached.Shared @Cached PRaiseNode raiseNode) {
            return op.compute(inliningTarget, value, 0.0, raiseNode).toPComplex(language);
        }

        @Specialization
        static PComplex doC(Node inliningTarget, PComplex value, Op op, @Bind PythonLanguage language, @Cached.Shared @Cached PRaiseNode raiseNode) {
            return op.compute(inliningTarget, value.getReal(), value.getImag(), raiseNode).toPComplex(language);
        }

        @Specialization
        static PComplex doGeneral(VirtualFrame frame, Node inliningTarget, Object value, Op op, @Cached CoerceToComplexNode coerceToComplex, @Bind PythonLanguage language, @Cached.Exclusive @Cached PRaiseNode raiseNode) {
            return CmathComplexUnaryHelperNode.doC(inliningTarget, coerceToComplex.execute(frame, inliningTarget, value), op, language, raiseNode);
        }

        @FunctionalInterface
        static interface Op {
            public ComplexValue compute(Node var1, double var2, double var4, PRaiseNode var6);
        }
    }
}

