/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng;

import java.sql.SQLException;
import java.util.Objects;
import org.firebirdsql.gds.ng.FbDatabase;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.gds.ng.OperationCloseHandle;
import org.firebirdsql.gds.ng.OperationMonitor;
import org.firebirdsql.gds.ng.monitor.Operation;

final class FbDatabaseOperation
implements Operation,
OperationCloseHandle {
    private static final Runnable NO_OP = () -> {};
    private final Operation.Type type;
    private volatile FbDatabase fbDatabase;
    private volatile boolean cancelled;
    private Runnable onCompletion;

    private FbDatabaseOperation(Operation.Type type, FbDatabase fbDatabase, Runnable onCompletion) {
        this.type = Objects.requireNonNull(type, "type");
        this.onCompletion = onCompletion != null ? onCompletion : NO_OP;
        this.fbDatabase = Objects.requireNonNull(fbDatabase, "fbDatabase");
    }

    @Override
    public Operation.Type getType() {
        return this.type;
    }

    @Override
    public void cancel() throws SQLException {
        FbDatabase current = this.fbDatabase;
        if (current == null) {
            throw FbExceptionBuilder.forException(337248298).messageParameter("cancel").toSQLException();
        }
        this.cancelled = true;
        current.cancelOperation(3);
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public void close() {
        FbDatabase previous = this.fbDatabase;
        Runnable onCompletion = this.onCompletion;
        this.onCompletion = null;
        this.fbDatabase = null;
        if (previous != null) {
            OperationMonitor.endOperation(this);
            onCompletion.run();
        }
    }

    static OperationCloseHandle signalExecute(FbDatabase fbDatabase) {
        return FbDatabaseOperation.signalOperation(fbDatabase, Operation.Type.STATEMENT_EXECUTE);
    }

    static OperationCloseHandle signalFetch(FbDatabase fbDatabase, Runnable onCompletion) {
        return FbDatabaseOperation.signalOperation(fbDatabase, Operation.Type.STATEMENT_FETCH, onCompletion);
    }

    private static OperationCloseHandle signalOperation(FbDatabase fbDatabase, Operation.Type type) {
        return FbDatabaseOperation.signalOperation(fbDatabase, type, NO_OP);
    }

    private static OperationCloseHandle signalOperation(FbDatabase fbDatabase, Operation.Type type, Runnable onCompletion) {
        FbDatabaseOperation fbDatabaseOperation = new FbDatabaseOperation(type, fbDatabase, onCompletion);
        OperationMonitor.startOperation(fbDatabaseOperation);
        return fbDatabaseOperation;
    }
}

