/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.compiler;

import com.oracle.graal.python.compiler.Block;
import com.oracle.graal.python.compiler.BlockInfo;
import com.oracle.graal.python.compiler.BytecodeCodeUnit;
import com.oracle.graal.python.compiler.CompilationScope;
import com.oracle.graal.python.compiler.Instruction;
import com.oracle.graal.python.compiler.OpCodes;
import com.oracle.graal.python.compiler.SourceMap;
import com.oracle.graal.python.pegparser.FutureFeature;
import com.oracle.graal.python.pegparser.scope.Scope;
import com.oracle.graal.python.pegparser.tokenizer.SourceRange;
import com.oracle.graal.python.util.Function;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.strings.TruffleString;
import java.io.ByteArrayOutputStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Deque;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

public final class CompilationUnit {
    final String name;
    final String qualName;
    final HashMap<Object, Integer> constants = new HashMap();
    final HashMap<Long, Integer> primitiveConstants = new HashMap();
    final HashMap<String, Integer> names = new HashMap();
    final HashMap<String, Integer> varnames = new HashMap();
    final HashMap<String, Integer> cellvars;
    final HashMap<String, Integer> freevars;
    final int[] cell2arg;
    final int argCount;
    final int positionalOnlyArgCount;
    final int kwOnlyArgCount;
    final boolean takesVarArgs;
    final boolean takesVarKeywordArgs;
    final Block startBlock;
    final Scope scope;
    final CompilationScope scopeType;
    String privateName;
    BlockInfo blockInfo;
    int conditionProfileCount;
    Block currentBlock = this.startBlock = new Block();
    int maxStackSize = 0;
    SourceRange startLocation;
    SourceRange currentLocation;
    final EnumSet<FutureFeature> futureFeatures;
    private static final EnumSet<OpCodes> UNCONDITIONAL_JUMP_OPCODES = EnumSet.of(OpCodes.JUMP_BACKWARD, OpCodes.JUMP_FORWARD, OpCodes.RETURN_VALUE, OpCodes.RAISE_VARARGS, OpCodes.END_EXC_HANDLER);

    CompilationUnit(CompilationScope scopeType, Scope scope, String name, String qualName, CompilationUnit parent, int argCount, int positionalOnlyArgCount, int kwOnlyArgCount, boolean takesVarArgs, boolean takesVarKeywordArgs, SourceRange startLocation, EnumSet<FutureFeature> futureFeatures) {
        this.scopeType = scopeType;
        this.scope = scope;
        this.name = name;
        this.argCount = argCount;
        this.positionalOnlyArgCount = positionalOnlyArgCount;
        this.kwOnlyArgCount = kwOnlyArgCount;
        this.takesVarArgs = takesVarArgs;
        this.takesVarKeywordArgs = takesVarKeywordArgs;
        this.startLocation = startLocation;
        this.futureFeatures = futureFeatures;
        this.currentLocation = startLocation;
        this.privateName = scopeType == CompilationScope.Class ? name : (parent != null ? parent.privateName : null);
        this.qualName = qualName;
        for (int i = 0; i < scope.getVarnames().size(); ++i) {
            this.varnames.put(scope.getVarnames().get(i), i);
        }
        this.cellvars = scope.getSymbolsByType(EnumSet.of(Scope.DefUse.Cell), 0);
        if (scope.needsClassClosure()) {
            assert (scopeType == CompilationScope.Class);
            assert (this.cellvars.isEmpty());
            this.cellvars.put("__class__", 0);
        }
        if (scope.needsClassDict()) {
            assert (scopeType == CompilationScope.Class);
            this.cellvars.put("__classdict__", this.cellvars.size());
        }
        int[] cell2argValue = new int[this.cellvars.size()];
        boolean hasArgCell = false;
        Arrays.fill(cell2argValue, -1);
        for (String cellvar : this.cellvars.keySet()) {
            if (!this.varnames.containsKey(cellvar)) continue;
            cell2argValue[this.cellvars.get((Object)cellvar).intValue()] = this.varnames.get(cellvar);
            hasArgCell = true;
        }
        this.cell2arg = (int[])(hasArgCell ? cell2argValue : null);
        this.freevars = scope.getSymbolsByType(EnumSet.of(Scope.DefUse.Free, Scope.DefUse.DefFreeClass), this.cellvars.size());
    }

    void useNextBlock(Block b) {
        if (b == this.currentBlock) {
            return;
        }
        assert (this.currentBlock.next == null);
        this.currentBlock.next = b;
        this.useBlock(b);
    }

    void useBlock(Block b) {
        b.info = this.blockInfo;
        this.currentBlock = b;
    }

    private void addImplicitReturn() {
        Block b = this.startBlock;
        while (b.next != null) {
            b = b.next;
        }
        if (!b.isReturn()) {
            b.instr.add(new Instruction(OpCodes.LOAD_NONE, 0, null, null, this.currentLocation));
            b.instr.add(new Instruction(OpCodes.RETURN_VALUE, 0, null, null, this.currentLocation));
        }
    }

    public BytecodeCodeUnit assemble() {
        this.addImplicitReturn();
        this.calculateJumpInstructionArguments();
        SourceMap.Builder sourceMapBuilder = new SourceMap.Builder(this.startLocation.startLine, this.startLocation.startColumn);
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        this.computeStackLevels();
        int varCount = this.varnames.size();
        ArrayList<Instruction> quickenedInstructions = new ArrayList<Instruction>();
        ArrayList variableStores = new ArrayList(varCount);
        for (int i = 0; i < varCount; ++i) {
            variableStores.add(new ArrayList());
        }
        int[] boxingMetric = new int[varCount];
        byte[] shouldUnboxVariable = new byte[varCount];
        Arrays.fill(shouldUnboxVariable, (byte)-1);
        TreeSet<int[]> finishedExceptionHandlerRanges = new TreeSet<int[]>(Comparator.comparingInt(a -> a[0]));
        Block b = this.startBlock;
        HashMap<Block, List> handlerBlocks = new HashMap<Block, List>();
        while (b != null) {
            b.startBci = buf.size();
            int quickenMetricWeight = b.computeLoopDepth() * 3 + 1;
            BlockInfo.AbstractExceptionHandler handler = b.findExceptionHandler();
            if (handler != null) {
                handlerBlocks.computeIfAbsent(handler.exceptionHandler, x -> new ArrayList()).add(b);
            }
            if (handlerBlocks.containsKey(b)) {
                List blocks = (List)handlerBlocks.get(b);
                Block firstBlock = (Block)blocks.get(0);
                int stackLevel = firstBlock.findExceptionHandler().tryBlock.stackLevel + b.unwindOffset;
                int start = firstBlock.startBci;
                int end = firstBlock.endBci;
                int handlerBci = buf.size();
                for (int i = 1; i < blocks.size(); ++i) {
                    assert (start >= 0 && end >= 0);
                    Block block = (Block)blocks.get(i);
                    if (block.startBci != end) {
                        CompilationUnit.addExceptionRange(finishedExceptionHandlerRanges, start, end, handlerBci, stackLevel);
                        start = block.startBci;
                    }
                    end = block.endBci;
                }
                CompilationUnit.addExceptionRange(finishedExceptionHandlerRanges, start, end, handlerBci, stackLevel);
            }
            for (Instruction i : b.instr) {
                if (i.quickenOutput != 0 || i.quickeningGeneralizeList != null) {
                    quickenedInstructions.add(i);
                }
                if (i.opcode == OpCodes.STORE_FAST) {
                    ((List)variableStores.get(i.arg)).add(i);
                } else if (i.opcode == OpCodes.LOAD_FAST) {
                    int n = i.arg;
                    boxingMetric[n] = boxingMetric[n] + (i.quickenOutput != 0 ? quickenMetricWeight : -quickenMetricWeight);
                }
                i.bci = buf.size();
                CompilationUnit.emitBytecode(i, buf, sourceMapBuilder);
            }
            b.endBci = buf.size();
            b = b.next;
        }
        int flags = 3;
        flags |= this.takesVarArgs ? 4 : 0;
        flags |= this.takesVarKeywordArgs ? 8 : 0;
        if (this.scope.isNested()) {
            flags |= 0x10;
        }
        if (this.scope.isModule()) {
            flags |= 0x1000;
        }
        if (this.scope.isGenerator() && this.scope.isCoroutine()) {
            flags |= 0x200;
        } else if (this.scope.isGenerator()) {
            flags |= 0x20;
        } else if (this.scope.isCoroutine()) {
            flags |= 0x80;
        }
        for (FutureFeature flag : this.futureFeatures) {
            flags |= flag.flagValue;
        }
        int rangeElements = 4;
        int[] exceptionHandlerRanges = new int[finishedExceptionHandlerRanges.size() * 4];
        int rangeIndex = 0;
        for (int[] range : finishedExceptionHandlerRanges) {
            assert (range.length == 4);
            System.arraycopy(range, 0, exceptionHandlerRanges, rangeIndex, 4);
            rangeIndex += 4;
        }
        byte[] finishedCanQuickenOutput = new byte[buf.size()];
        int[][] finishedGeneralizeInputsMap = new int[buf.size()][];
        int[][] finishedGeneralizeVarsMap = new int[varCount][];
        for (Instruction insn : quickenedInstructions) {
            int insnBodyBci = insn.bodyBci();
            finishedCanQuickenOutput[insnBodyBci] = insn.quickenOutput;
            if (insn.quickeningGeneralizeList == null || insn.quickeningGeneralizeList.size() <= 0) continue;
            finishedGeneralizeInputsMap[insnBodyBci] = new int[insn.quickeningGeneralizeList.size()];
            for (int j = 0; j < finishedGeneralizeInputsMap[insnBodyBci].length; ++j) {
                int bci = insn.quickeningGeneralizeList.get(j).bodyBci();
                assert (bci >= 0);
                finishedGeneralizeInputsMap[insnBodyBci][j] = bci;
            }
        }
        if (this.cell2arg != null) {
            for (int i = 0; i < this.cell2arg.length; ++i) {
                if (this.cell2arg[i] == -1 || this.cell2arg[i] >= varCount) continue;
                shouldUnboxVariable[this.cell2arg[i]] = 0;
            }
        }
        if (!this.scope.isGenerator()) {
            for (int i = 0; i < varCount; ++i) {
                List stores = (List)variableStores.get(i);
                finishedGeneralizeVarsMap[i] = new int[stores.size()];
                for (int j = 0; j < stores.size(); ++j) {
                    finishedGeneralizeVarsMap[i][j] = ((Instruction)stores.get(j)).bodyBci();
                }
                if (boxingMetric[i] > 0) continue;
                shouldUnboxVariable[i] = 0;
            }
        }
        return new BytecodeCodeUnit(PythonUtils.toTruffleStringUncached(this.name), PythonUtils.toTruffleStringUncached(this.qualName), this.argCount, this.kwOnlyArgCount, this.positionalOnlyArgCount, flags, CompilationUnit.orderedKeys(this.names, new TruffleString[0], PythonUtils::toTruffleStringUncached), CompilationUnit.orderedKeys(this.varnames, new TruffleString[0], PythonUtils::toTruffleStringUncached), CompilationUnit.orderedKeys(this.cellvars, new TruffleString[0], PythonUtils::toTruffleStringUncached), CompilationUnit.orderedKeys(this.freevars, new TruffleString[0], this.cellvars.size(), PythonUtils::toTruffleStringUncached), this.cell2arg, CompilationUnit.orderedKeys(this.constants, new Object[0]), this.startLocation.startLine, this.startLocation.startColumn, this.startLocation.endLine, this.startLocation.endColumn, buf.toByteArray(), sourceMapBuilder.build(), CompilationUnit.orderedLong(this.primitiveConstants), exceptionHandlerRanges, this.maxStackSize, this.conditionProfileCount, finishedCanQuickenOutput, shouldUnboxVariable, finishedGeneralizeInputsMap, finishedGeneralizeVarsMap);
    }

    private static void addExceptionRange(Collection<int[]> finishedExceptionHandlerRanges, int start, int end, int handler, int stackLevel) {
        if (start == end) {
            return;
        }
        int[] range = new int[]{start, end, handler, stackLevel};
        finishedExceptionHandlerRanges.add(range);
    }

    private void computeStackLevels() {
        ArrayDeque<Block> todo = new ArrayDeque<Block>();
        todo.add(this.startBlock);
        this.startBlock.stackLevel = 0;
        while (!todo.isEmpty()) {
            Block block = (Block)todo.pop();
            int level = block.stackLevel;
            assert (level >= 0);
            this.maxStackSize = Math.max(this.maxStackSize, level);
            BlockInfo.AbstractExceptionHandler handler = block.findExceptionHandler();
            if (handler != null) {
                assert (handler.tryBlock.stackLevel != -1);
                int handlerLevel = handler.tryBlock.stackLevel + handler.exceptionHandler.unwindOffset + 1;
                CompilationUnit.computeStackLevels(handler.exceptionHandler, handlerLevel, todo);
            }
            boolean fallthrough = true;
            for (Instruction i : block.instr) {
                Block target = i.target;
                if (target != null) {
                    int jumpLevel = level + i.opcode.getStackEffect(i.arg, i.followingArgs, true);
                    CompilationUnit.computeStackLevels(target, jumpLevel, todo);
                }
                if (UNCONDITIONAL_JUMP_OPCODES.contains((Object)i.opcode)) {
                    assert (i.opcode != OpCodes.RETURN_VALUE || level == 1);
                    fallthrough = false;
                    break;
                }
                assert ((level += i.opcode.getStackEffect(i.arg, i.followingArgs, false)) >= 0);
                this.maxStackSize = Math.max(this.maxStackSize, level);
            }
            if (!fallthrough || block.next == null) continue;
            CompilationUnit.computeStackLevels(block.next, level, todo);
        }
    }

    private static void computeStackLevels(Block block, int level, Deque<Block> todo) {
        if (block.stackLevel == -1) {
            block.stackLevel = level;
            todo.push(block);
        } else assert (block.stackLevel == level);
    }

    private void calculateJumpInstructionArguments() {
        boolean repeat;
        HashMap<Block, Integer> blockLocationMap = new HashMap<Block, Integer>();
        do {
            repeat = false;
            int bci = 0;
            Block block = this.startBlock;
            while (block != null) {
                blockLocationMap.put(block, bci);
                for (Instruction i : block.instr) {
                    bci += i.extendedLength();
                }
                block = block.next;
            }
            bci = 0;
            block = this.startBlock;
            while (block != null) {
                for (int i = 0; i < block.instr.size(); ++i) {
                    Instruction instr = block.instr.get(i);
                    Block target = instr.target;
                    if (target != null) {
                        int targetPos = (Integer)blockLocationMap.get(target);
                        int distance = Math.abs(bci + instr.extensions() * 2 - targetPos);
                        int prevLength = instr.extendedLength();
                        instr.arg = distance;
                        if (instr.extendedLength() != prevLength) {
                            repeat = true;
                        }
                    }
                    bci += instr.extendedLength();
                }
                block = block.next;
            }
        } while (repeat);
    }

    private static void emitBytecode(Instruction instr, ByteArrayOutputStream buf, SourceMap.Builder sourceMapBuilder) throws IllegalStateException {
        OpCodes opcode = instr.opcode;
        if (opcode == OpCodes.LOAD_BYTE) {
            opcode = (instr.quickenOutput & 2) != 0 ? OpCodes.LOAD_BYTE_I : OpCodes.LOAD_BYTE_O;
        } else if (opcode == OpCodes.LOAD_INT) {
            opcode = (instr.quickenOutput & 2) != 0 ? OpCodes.LOAD_INT_I : OpCodes.LOAD_INT_O;
        } else if (opcode == OpCodes.LOAD_LONG) {
            opcode = (instr.quickenOutput & 4) != 0 ? OpCodes.LOAD_LONG_L : OpCodes.LOAD_LONG_O;
        } else if (opcode == OpCodes.LOAD_DOUBLE) {
            opcode = (instr.quickenOutput & 8) != 0 ? OpCodes.LOAD_DOUBLE_D : OpCodes.LOAD_DOUBLE_O;
        } else if (opcode == OpCodes.LOAD_TRUE) {
            opcode = (instr.quickenOutput & 0x10) != 0 ? OpCodes.LOAD_TRUE_B : OpCodes.LOAD_TRUE_O;
        } else if (opcode == OpCodes.LOAD_FALSE) {
            OpCodes opCodes = opcode = (instr.quickenOutput & 0x10) != 0 ? OpCodes.LOAD_FALSE_B : OpCodes.LOAD_FALSE_O;
        }
        assert (opcode.ordinal() < 256);
        SourceRange location = instr.location;
        sourceMapBuilder.appendLocation(location.startLine, location.startColumn, location.endLine, location.endColumn);
        if (!opcode.hasArg()) {
            buf.write(opcode.ordinal());
        } else {
            int i;
            int oparg = instr.arg;
            for (i = instr.extensions(); i >= 1; --i) {
                buf.write(OpCodes.EXTENDED_ARG.ordinal());
                buf.write(oparg >> i * 8 & 0xFF);
                sourceMapBuilder.appendLocation(location.startLine, location.startColumn, location.endLine, location.endColumn);
            }
            buf.write(opcode.ordinal());
            buf.write(oparg & 0xFF);
            if (opcode.argLength > 1) {
                assert (instr.followingArgs.length == opcode.argLength - 1);
                for (i = 0; i < instr.followingArgs.length; ++i) {
                    buf.write(instr.followingArgs[i]);
                }
            }
        }
    }

    private static <T, U> U[] orderedKeys(HashMap<T, Integer> map, U[] template, int offset, Function<T, U> convertor) {
        U[] ary = Arrays.copyOf(template, map.size());
        for (Map.Entry<T, Integer> e : map.entrySet()) {
            ary[e.getValue().intValue() - offset] = convertor.apply(e.getKey());
        }
        return ary;
    }

    private static <T> T[] orderedKeys(HashMap<T, Integer> map, T[] template) {
        return CompilationUnit.orderedKeys(map, template, 0, i -> i);
    }

    private static <T, U> U[] orderedKeys(HashMap<T, Integer> map, U[] template, Function<T, U> convertor) {
        return CompilationUnit.orderedKeys(map, template, 0, convertor);
    }

    private static long[] orderedLong(HashMap<Long, Integer> map) {
        long[] ary = new long[map.size()];
        for (Map.Entry<Long, Integer> e : map.entrySet()) {
            ary[e.getValue().intValue()] = e.getKey();
        }
        return ary;
    }

    void pushBlock(BlockInfo info) {
        info.outer = this.blockInfo;
        this.blockInfo = info;
    }

    void popBlock() {
        this.blockInfo = this.blockInfo.outer;
    }
}

