/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.VarcharAccessor;
import oracle.jdbc.logging.annotations.DefaultLevel;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Logging;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.sql.CharacterSet;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.OCI_INTERNAL})
class T2CVarcharAccessor
extends VarcharAccessor {
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;

    T2CVarcharAccessor(OracleStatement stmt, int max_len, short form, int external_type, boolean forBind) throws SQLException {
        super(stmt, max_len, form, external_type, forBind);
        boolean bl = (0x2000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, T2CVarcharAccessor.class, $$$methodRef$$$1, null, stmt, max_len, form, external_type, forBind);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, T2CVarcharAccessor.class, $$$methodRef$$$1, null);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, T2CVarcharAccessor.class, $$$methodRef$$$1, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, T2CVarcharAccessor.class, $$$methodRef$$$1, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @DefaultLevel(value=Logging.FINEST)
    byte[] getBytesInternal(int n2) throws SQLException {
        boolean bl = (0x2000000L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, T2CVarcharAccessor.class, $$$methodRef$$$0, this, n2);
            }
            if (this.formOfUse == 2) {
                if (!$assertionsDisabled && this.isNull((int)currentRow)) {
                    AssertionError assertionError = new AssertionError();
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$0, Level.FINEST, T2CVarcharAccessor.class, $$$methodRef$$$0, this, (Throwable)((Object)assertionError));
                    }
                    throw assertionError;
                }
                CharacterSet cs = this.statement.connection.conversion.getCharacterSet(this.formOfUse);
                String str = this.rowData.getString(this.getOffset((int)currentRow), this.getLength((int)currentRow), cs);
                byte[] byArray = DBConversion.stringToDriverCharBytes(str, (short)cs.getOracleId());
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, T2CVarcharAccessor.class, $$$methodRef$$$0, this, byArray);
                    ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, T2CVarcharAccessor.class, $$$methodRef$$$0, this, null);
                }
                return byArray;
            }
            byte[] byArray = super.getBytesInternal((int)currentRow);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, T2CVarcharAccessor.class, $$$methodRef$$$0, this, byArray);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, T2CVarcharAccessor.class, $$$methodRef$$$0, this, null);
            }
            return byArray;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, T2CVarcharAccessor.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$1 = T2CVarcharAccessor.class.getDeclaredConstructor(OracleStatement.class, Integer.TYPE, Short.TYPE, Integer.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = T2CVarcharAccessor.class.getDeclaredMethod("getBytesInternal", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

