/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.wire.crypt;

import org.firebirdsql.gds.ng.wire.crypt.CryptSessionConfigImpl;
import org.firebirdsql.gds.ng.wire.crypt.EncryptionIdentifier;

public interface CryptSessionConfig
extends AutoCloseable {
    public EncryptionIdentifier getEncryptionIdentifier();

    public byte[] getEncryptKey();

    public byte[] getDecryptKey();

    public byte[] getSpecificData();

    @Override
    public void close();

    public static CryptSessionConfig symmetric(EncryptionIdentifier encryptionIdentifier, byte[] sessionKey, byte[] specificData) {
        if (encryptionIdentifier.isTypeSymmetric()) {
            return new CryptSessionConfigImpl(encryptionIdentifier, sessionKey, sessionKey, specificData);
        }
        throw new IllegalArgumentException("Wrong type for encryption identifier. Expected 'Symmetric/*', was '" + encryptionIdentifier + "'");
    }
}

