/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.server;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.ssl.SslHandler;
import java.net.SocketAddress;
import java.util.List;
import javax.annotation.Nullable;
import reactor.netty.http.server.NonSslRedirectHandler;
import reactor.netty.tcp.SslProvider;

final class NonSslRedirectDetector
extends ByteToMessageDecoder {
    private static final int SSL_RECORD_HEADER_LENGTH = 5;
    private final SslProvider sslProvider;
    private final SocketAddress remoteAddress;
    private final boolean sslDebug;

    public NonSslRedirectDetector(SslProvider sslProvider, @Nullable SocketAddress remoteAddress, boolean sslDebug) {
        this.sslProvider = sslProvider;
        this.remoteAddress = remoteAddress;
        this.sslDebug = sslDebug;
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) {
        if (in.readableBytes() < 5) {
            return;
        }
        ChannelPipeline pipeline = ctx.pipeline();
        if (SslHandler.isEncrypted((ByteBuf)in, (boolean)false)) {
            this.sslProvider.addSslHandler(ctx.channel(), this.remoteAddress, this.sslDebug);
        } else {
            pipeline.addBefore("reactor.right.reactiveBridge", "reactor.left.nonSslRedirectHandler", (ChannelHandler)new NonSslRedirectHandler());
        }
        pipeline.remove((ChannelHandler)this);
    }
}

