Compromising the macOS Kernel through Safari by Chaining Six Vulnerabilities
======================================================================================

Overview
---------
This repository contains exploitation and technical details of [our Pwn2Own
2020 winning submission targeting Apple Safari with a kernel escalation
of privilege for macOS 10.15.3](https://www.thezdi.com/blog/2020/3/17/welcome-to-pwn2own-2020-the-schedule-and-live-results).
For further information, you can also check [our Blackhat USA 2020
slides](https://gts3.org/assets/papers/2020/jin:pwn2own2020-safari-slides.pdf).
This repository also includes [our demo video](./movie.mov) for the succesful
exploitation.


Build from source
-----------------

```shell
# Install xcode first
$ python3 -m pip install --user "lief==0.10.1"
$ make
```

Authors
-------
- Yonghwi Jin (jinmoteam@gmail.com)
- Jungwon Lim (setuid0@protonmail.com)
- Insu Yun (insu@gatech.edu)
- Taesoo Kim (taesoo@gatech.edu)

Citation
--------
```txt
@inproceedings{jin:pwn2own2020-safari,
  title        = {{Compromising the macOS kernel through Safari by chaining six vulnerabilities}},
  author       = {Yonghwi Jin and Jungwon Lim and Insu Yun and Taesoo Kim},
  booktitle    = {Black Hat USA Briefings (Black Hat USA)},
  month        = aug,
  year         = 2020,
  address      = {Las Vegas, NV},
}
```

Reference
---------
- https://github.com/sslab-gatech/pwn2own2020
- https://github.com/saelo/pwn2own2018
- https://github.com/LinusHenze/WebKit-RegEx-Exploit
- https://github.com/niklasb/sploits/blob/master/safari/regexp-uxss.html
- https://i.blackhat.com/eu-19/Thursday/eu-19-Wang-Thinking-Outside-The-JIT-Compiler-Understanding-And-Bypassing-StructureID-Randomization-With-Generic-And-Old-School-Methods.pdf
