/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.schema.internal;

import java.net.URL;
import java.util.Map;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.internal.FormatStyle;
import org.hibernate.engine.jdbc.internal.Formatter;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.tool.schema.internal.Helper;
import org.hibernate.tool.schema.internal.exec.ScriptSourceInputFromUrl;
import org.hibernate.tool.schema.internal.exec.ScriptSourceInputNonExistentImpl;
import org.hibernate.tool.schema.spi.ExecutionOptions;
import org.hibernate.tool.schema.spi.GenerationTarget;
import org.hibernate.tool.schema.spi.SchemaManagementException;
import org.hibernate.tool.schema.spi.ScriptSourceInput;
import org.hibernate.tool.schema.spi.SqlScriptCommandExtractor;

public abstract class AbstractSchemaPopulator {
    public static final String DEFAULT_IMPORT_FILE = "/import.sql";

    abstract ClassLoaderService getClassLoaderService();

    void applyImportSources(ExecutionOptions options, SqlScriptCommandExtractor commandExtractor, boolean format, Dialect dialect, GenerationTarget ... targets) {
        Formatter formatter;
        boolean hasDefaultImportFileScriptBeenExecuted = this.applyImportScript(options, commandExtractor, dialect, formatter = AbstractSchemaPopulator.getImportScriptFormatter(format), targets);
        this.applyImportFiles(options, commandExtractor, dialect, formatter, hasDefaultImportFileScriptBeenExecuted ? "" : this.getDefaultImportFile(options), targets);
    }

    private String getDefaultImportFile(ExecutionOptions options) {
        return AbstractSchemaPopulator.skipDefaultFileImport(options) ? "" : DEFAULT_IMPORT_FILE;
    }

    private static boolean skipDefaultFileImport(ExecutionOptions options) {
        return ConfigurationHelper.getBoolean("hibernate.hbm2ddl.skip_default_import_file", options.getConfigurationValues(), false);
    }

    private static Formatter getImportScriptFormatter(boolean format) {
        return FormatStyle.NONE.getFormatter();
    }

    private boolean applyImportScript(ExecutionOptions options, SqlScriptCommandExtractor commandExtractor, Dialect dialect, Formatter formatter, GenerationTarget[] targets) {
        Object importScriptSetting = AbstractSchemaPopulator.getImportScriptSetting(options);
        if (importScriptSetting != null) {
            ScriptSourceInput importScriptInput = Helper.interpretScriptSourceSetting(importScriptSetting, this.getClassLoaderService(), AbstractSchemaPopulator.getCharsetName(options));
            Helper.applyScript(options, commandExtractor, dialect, importScriptInput, formatter, targets);
            return this.containsDefaultImportFile(importScriptInput, options);
        }
        return false;
    }

    private boolean containsDefaultImportFile(ScriptSourceInput importScriptInput, ExecutionOptions options) {
        if (AbstractSchemaPopulator.skipDefaultFileImport(options)) {
            return false;
        }
        URL defaultImportFileUrl = this.getClassLoaderService().locateResource(DEFAULT_IMPORT_FILE);
        return defaultImportFileUrl != null && importScriptInput.containsScript(defaultImportFileUrl);
    }

    private void applyImportFiles(ExecutionOptions options, SqlScriptCommandExtractor commandExtractor, Dialect dialect, Formatter formatter, String defaultImportFile, GenerationTarget[] targets) {
        String[] importFiles = StringHelper.split(",", ConfigurationHelper.getString("hibernate.hbm2ddl.import_files", options.getConfigurationValues(), defaultImportFile));
        String charsetName = AbstractSchemaPopulator.getCharsetName(options);
        ClassLoaderService classLoaderService = this.getClassLoaderService();
        for (String currentFile : importFiles) {
            String resourceName = currentFile.trim();
            if (resourceName.isEmpty()) continue;
            Helper.applyScript(options, commandExtractor, dialect, this.interpretLegacyImportScriptSetting(resourceName, classLoaderService, charsetName), formatter, targets);
        }
    }

    private ScriptSourceInput interpretLegacyImportScriptSetting(String resourceName, ClassLoaderService classLoaderService, String charsetName) {
        try {
            URL resourceUrl = classLoaderService.locateResource(resourceName);
            return resourceUrl == null ? ScriptSourceInputNonExistentImpl.INSTANCE : new ScriptSourceInputFromUrl(resourceUrl, charsetName);
        }
        catch (Exception e) {
            throw new SchemaManagementException("Error resolving legacy import resource : " + resourceName, e);
        }
    }

    private static String getCharsetName(ExecutionOptions options) {
        return (String)options.getConfigurationValues().get("hibernate.hbm2ddl.charset_name");
    }

    private static Object getImportScriptSetting(ExecutionOptions options) {
        Map<String, Object> configuration = options.getConfigurationValues();
        Object importScriptSetting = configuration.get("javax.persistence.sql-load-script-source");
        return importScriptSetting == null ? configuration.get("jakarta.persistence.sql-load-script-source") : importScriptSetting;
    }
}

