/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.jdbc.oracle.runtime;

import io.quarkus.runtime.annotations.Recorder;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import oracle.sql.CharacterSet;

@Recorder
public class OracleInitRecorder {
    public void setupCharSets(boolean addAllCharsets) {
        if (addAllCharsets) {
            for (short id : this.reflectivelyReadAllCharacterSetIdentifiers()) {
                CharacterSet.make((int)id);
            }
        } else {
            CharacterSet.make((int)873);
            CharacterSet.make((int)2000);
        }
    }

    private List<Short> reflectivelyReadAllCharacterSetIdentifiers() {
        Field[] fields = CharacterSet.class.getFields();
        ArrayList<Short> collectedIds = new ArrayList<Short>(fields.length);
        for (Field field : fields) {
            if (field.getType() != Short.TYPE || !field.getName().endsWith("_CHARSET")) continue;
            try {
                collectedIds.add(field.getShort(null));
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return collectedIds;
    }
}

