/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.crypto;

import java.security.PrivateKey;
import java.security.Signature;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.List;
import org.keycloak.crypto.JavaAlgorithm;
import org.keycloak.crypto.KeyWrapper;
import org.keycloak.crypto.SignatureException;
import org.keycloak.crypto.SignatureSignerContext;

public class AsymmetricSignatureSignerContext
implements SignatureSignerContext {
    protected final KeyWrapper key;

    public AsymmetricSignatureSignerContext(KeyWrapper key) throws SignatureException {
        this.key = key;
    }

    @Override
    public String getKid() {
        return this.key.getKid();
    }

    @Override
    public String getAlgorithm() {
        return this.key.getAlgorithmOrDefault();
    }

    @Override
    public String getHashAlgorithm() {
        return JavaAlgorithm.getJavaAlgorithmForHash(this.key.getAlgorithmOrDefault(), this.key.getCurve());
    }

    @Override
    public byte[] sign(byte[] data) throws SignatureException {
        try {
            Signature signature = Signature.getInstance(JavaAlgorithm.getJavaAlgorithm(this.key.getAlgorithmOrDefault(), this.key.getCurve()));
            signature.initSign((PrivateKey)this.key.getPrivateKey());
            signature.update(data);
            return signature.sign();
        }
        catch (Exception e) {
            throw new SignatureException("Signing failed", e);
        }
    }

    @Override
    public List<X509Certificate> getCertificateChain() {
        if (this.key.getCertificateChain() != null && !this.key.getCertificateChain().isEmpty()) {
            return this.key.getCertificateChain();
        }
        if (this.key.getCertificate() != null) {
            return Collections.singletonList(this.key.getCertificate());
        }
        return null;
    }
}

