/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.filter;

import java.awt.event.ActionEvent;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.features.filter.FilterConditionEditor;
import org.freeplane.features.filter.FilterController;
import org.freeplane.features.filter.condition.ASelectableCondition;
import org.freeplane.features.filter.condition.DisjunctConditions;
import org.freeplane.features.filter.condition.NoFilteringCondition;

class QuickOrFilterAction
extends AFreeplaneAction {
    private static final long serialVersionUID = 1L;
    private final FilterController filterController;
    private final FilterConditionEditor filterEditor;

    QuickOrFilterAction(FilterController filterController, FilterConditionEditor quickEditor) {
        super("QuickOrFilterAction");
        this.filterController = filterController;
        this.filterEditor = quickEditor;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ASelectableCondition condition = this.filterEditor.getCondition();
        if (condition == null) {
            return;
        }
        ASelectableCondition selectedCondition = this.filterController.getSelectedCondition();
        if (condition.equals(selectedCondition)) {
            return;
        }
        if (NoFilteringCondition.createCondition().equals(selectedCondition)) {
            this.filterController.apply(condition);
        } else {
            this.filterController.apply(DisjunctConditions.combine(selectedCondition, condition));
        }
    }
}

