/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.ui.components;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JSeparator;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;

public class ToolbarLayout
implements LayoutManager {
    public static final int MAX_WIDTH_BY_PARENT_WIDTH = -1;
    private BlockEndPosition blockEndPosition;
    private int maximumWidth = -1;
    private int horizontalGap = 0;
    private int verticalGap = 0;
    private boolean addsHorizontalMargins = false;
    private boolean addsVerticalMargins = false;
    private final boolean isOrientationVertical;

    public static ToolbarLayout fix() {
        return new ToolbarLayout(BlockEndPosition.ON_EVERY_SEPARATOR, false);
    }

    public static ToolbarLayout horizontal() {
        return new ToolbarLayout(BlockEndPosition.ON_SEPARATOR, false);
    }

    public static ToolbarLayout vertical() {
        return new ToolbarLayout(BlockEndPosition.ANYWHERE, true);
    }

    public static ToolbarLayout floatingHorizontal() {
        return new ToolbarLayout(BlockEndPosition.ANYWHERE, false);
    }

    ToolbarLayout(BlockEndPosition blockEndPosition, boolean isOrientationVertical) {
        this.blockEndPosition = blockEndPosition;
        this.isOrientationVertical = isOrientationVertical;
    }

    public int getMaximumWidth() {
        return this.maximumWidth;
    }

    public void setMaximumWidth(int maximumWidth) {
        this.maximumWidth = maximumWidth;
    }

    public void setGap(int horizontalGap, int verticalGap, boolean addsHorizontalMargins, boolean addsVerticalMargins) {
        this.horizontalGap = horizontalGap;
        this.verticalGap = verticalGap;
        this.addsHorizontalMargins = addsHorizontalMargins;
        this.addsVerticalMargins = addsVerticalMargins;
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void layoutContainer(Container container) {
        if (!container.isVisible()) {
            return;
        }
        int blockWidth = 0;
        int blockHeight = 0;
        boolean hasVisibleComponentInBlock = false;
        int lastBlockWidth = 0;
        int lastBlockHeight = 0;
        int lastBlockStart = 0;
        int lastBlockFinish = 0;
        Insets insets = container.getInsets();
        int leftMargin = insets.left;
        int height = insets.top;
        if (this.addsVerticalMargins) {
            height += this.verticalGap;
        }
        int maximumWidth = this.calculateMaxWidth(container) - insets.left - insets.right;
        int i = 0;
        while (true) {
            Component component;
            Component component2 = component = i < container.getComponentCount() ? container.getComponent(i) : null;
            if (component == null || component instanceof JSeparator || this.blockEndPosition == BlockEndPosition.ANYWHERE) {
                int totalBlockWidth = blockWidth;
                if (i > container.getComponentCount() || this.blockEndPosition == BlockEndPosition.ON_EVERY_SEPARATOR || lastBlockWidth + totalBlockWidth > maximumWidth) {
                    int x = leftMargin;
                    if (this.addsHorizontalMargins) {
                        x += this.horizontalGap;
                    }
                    int actualWidth = 0;
                    if (this.addsHorizontalMargins) {
                        actualWidth += this.horizontalGap;
                    }
                    boolean addGap = false;
                    for (int j = lastBlockStart; j < lastBlockFinish; ++j) {
                        Component c = container.getComponent(j);
                        int width = this.getPreferredWidth(c, maximumWidth);
                        if (addGap && c.isVisible()) {
                            x += this.horizontalGap;
                            actualWidth += this.horizontalGap;
                        }
                        c.setBounds(x, height, width, lastBlockHeight);
                        x += width;
                        actualWidth += width;
                        if (!c.isVisible()) continue;
                        addGap = true;
                    }
                    if (this.addsHorizontalMargins) {
                        actualWidth += this.horizontalGap;
                    }
                    assert (actualWidth == lastBlockWidth) : "Width calculation mismatch: calculated=" + lastBlockWidth + ", actual=" + actualWidth;
                    if (lastBlockHeight > 0) {
                        height += lastBlockHeight + this.verticalGap;
                    }
                    lastBlockWidth = totalBlockWidth;
                    lastBlockHeight = blockHeight;
                    lastBlockStart = lastBlockFinish;
                } else {
                    lastBlockWidth += totalBlockWidth;
                    lastBlockHeight = Math.max(blockHeight, lastBlockHeight);
                }
                lastBlockFinish = i;
                blockHeight = 0;
                blockWidth = 0;
                hasVisibleComponentInBlock = false;
            }
            if (component == null) {
                if (lastBlockStart == container.getComponentCount()) break;
                lastBlockFinish = container.getComponentCount();
            } else {
                if (component.isVisible() && hasVisibleComponentInBlock) {
                    blockWidth += this.horizontalGap;
                }
                blockWidth += this.getPreferredWidth(component, maximumWidth);
                if (component.isVisible() && !hasVisibleComponentInBlock && this.addsHorizontalMargins) {
                    blockWidth += 2 * this.horizontalGap;
                }
                if (component.isVisible()) {
                    hasVisibleComponentInBlock = true;
                    Dimension compPreferredSize = component.getPreferredSize();
                    blockHeight = Math.max(compPreferredSize.height, blockHeight);
                }
            }
            ++i;
        }
    }

    private int calculateMaxWidth(Container container) {
        if (container.isMaximumSizeSet()) {
            return container.getMaximumSize().width;
        }
        Container viewport = SwingUtilities.getAncestorOfClass(JViewport.class, container);
        if (viewport != null) {
            return viewport.getWidth();
        }
        Container parent = container.getParent();
        if (parent != null) {
            return parent.getWidth();
        }
        if (this.maximumWidth >= 0) {
            return this.maximumWidth;
        }
        return Integer.MAX_VALUE;
    }

    private int getPreferredWidth(Component c, int maxWidth) {
        int width = !c.isVisible() ? 0 : (c instanceof JSeparator && this.isOrientationVertical ? maxWidth : c.getPreferredSize().width);
        return width;
    }

    @Override
    public Dimension minimumLayoutSize(Container comp) {
        return new Dimension(0, 0);
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        Insets insets = container.getInsets();
        int maxWidth = this.calculateMaxWidth(container) - insets.left - insets.right;
        while (true) {
            int width = 0;
            int height = 0;
            if (this.addsVerticalMargins) {
                height += this.verticalGap;
            }
            int blockWidth = 0;
            int blockHeight = 0;
            boolean hasVisibleComponentInBlock = false;
            int lastBlockWidth = 0;
            int lastBlockHeight = 0;
            int lastBlockStart = 0;
            int lastBlockFinish = 0;
            int i = 0;
            while (true) {
                Component component;
                Component component2 = component = i < container.getComponentCount() ? container.getComponent(i) : null;
                if (component == null || component instanceof JSeparator || this.blockEndPosition == BlockEndPosition.ANYWHERE) {
                    int totalBlockWidth = blockWidth;
                    if (i > container.getComponentCount() || this.blockEndPosition == BlockEndPosition.ON_EVERY_SEPARATOR || lastBlockWidth + totalBlockWidth > maxWidth) {
                        if (lastBlockHeight > 0) {
                            height += lastBlockHeight + this.verticalGap;
                        }
                        lastBlockWidth = totalBlockWidth;
                        lastBlockHeight = blockHeight;
                        lastBlockStart = lastBlockFinish;
                    } else {
                        lastBlockWidth += totalBlockWidth;
                        lastBlockHeight = Math.max(blockHeight, lastBlockHeight);
                    }
                    width = Math.max(width, lastBlockWidth);
                    lastBlockFinish = i;
                    blockHeight = 0;
                    blockWidth = 0;
                    hasVisibleComponentInBlock = false;
                }
                if (component == null) {
                    if (lastBlockStart == container.getComponentCount()) break;
                    lastBlockFinish = container.getComponentCount();
                } else {
                    if (component.isVisible() && hasVisibleComponentInBlock) {
                        blockWidth += this.horizontalGap;
                    }
                    blockWidth += this.getPreferredWidth(component, maxWidth);
                    if (component.isVisible() && !hasVisibleComponentInBlock && this.addsHorizontalMargins) {
                        blockWidth += 2 * this.horizontalGap;
                    }
                    if (component.isVisible()) {
                        hasVisibleComponentInBlock = true;
                        Dimension compPreferredSize = component.getPreferredSize();
                        blockHeight = Math.max(compPreferredSize.height, blockHeight);
                    }
                }
                ++i;
            }
            if (!this.addsVerticalMargins && height > 0) {
                height -= this.verticalGap;
            }
            if (maxWidth >= width) {
                Dimension preferredSize = new Dimension(width + insets.left + insets.right, height + insets.top + insets.bottom);
                Dimension minimumSize = container.getMinimumSize();
                if (minimumSize != null) {
                    preferredSize.width = Math.max(preferredSize.width, minimumSize.width);
                    preferredSize.height = Math.max(preferredSize.height, minimumSize.height);
                }
                return preferredSize;
            }
            maxWidth = width;
        }
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    static enum BlockEndPosition {
        ON_SEPARATOR,
        ON_EVERY_SEPARATOR,
        ANYWHERE;

    }
}

