from typing import Optional

from pydantic import BaseModel
from sqlalchemy import Column, Integer, ForeignKey, Double, String
from sqlalchemy.orm import relationship

from ..base import Base


class RegionMetrics(Base):
    __tablename__ = 'region_metrics'
    id = Column(Integer, primary_key=True, index=True)
    region_id = Column(Integer, ForeignKey('region.id'))
    region = relationship('Region', back_populates='region_metrics')

    name = Column(String, nullable=False, default="")
    value = Column(Double, nullable=True)
    unit = Column(String, nullable=False, default="")


class RegionMetricsInDB(BaseModel):
    name: str
    value: Optional[float]
    unit: str

    class Config:
        from_attributes = True


class RegionMetricsCreate(BaseModel):
    name: str
    value: Optional[float] = None
    unit: str = ""

    class Config:
        from_attributes = True
