/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.internal;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.PluginResolutionException;
import org.apache.maven.plugin.internal.PlexusUtilsInjector;
import org.apache.maven.plugin.internal.PluginDependenciesResolver;
import org.apache.maven.plugin.internal.WagonExcluder;
import org.apache.maven.repository.internal.RelocatedArtifact;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.StringUtils;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.RequestTrace;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.collection.DependencyCollectionException;
import org.eclipse.aether.collection.DependencyGraphTransformer;
import org.eclipse.aether.collection.DependencySelector;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.graph.DependencyVisitor;
import org.eclipse.aether.graph.Exclusion;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactDescriptorException;
import org.eclipse.aether.resolution.ArtifactDescriptorRequest;
import org.eclipse.aether.resolution.ArtifactDescriptorResult;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.aether.util.filter.AndDependencyFilter;
import org.eclipse.aether.util.filter.ScopeDependencyFilter;
import org.eclipse.aether.util.graph.manager.DependencyManagerUtils;
import org.eclipse.aether.util.graph.selector.AndDependencySelector;
import org.eclipse.aether.util.graph.transformer.ChainedDependencyGraphTransformer;
import org.eclipse.aether.util.repository.SimpleArtifactDescriptorPolicy;

@Component(role=PluginDependenciesResolver.class)
public class DefaultPluginDependenciesResolver
implements PluginDependenciesResolver {
    private static final String REPOSITORY_CONTEXT = "plugin";
    @Requirement
    private Logger logger;
    @Requirement
    private RepositorySystem repoSystem;

    private Artifact toArtifact(Plugin plugin, RepositorySystemSession session2) {
        return new DefaultArtifact(plugin.getGroupId(), plugin.getArtifactId(), null, "jar", plugin.getVersion(), session2.getArtifactTypeRegistry().get("maven-plugin"));
    }

    @Override
    public Artifact resolve(Plugin plugin, List<RemoteRepository> repositories, RepositorySystemSession session2) throws PluginResolutionException {
        RequestTrace trace2 = RequestTrace.newChild(null, plugin);
        Artifact pluginArtifact = this.toArtifact(plugin, session2);
        try {
            String requiredMavenVersion;
            DefaultRepositorySystemSession pluginSession = new DefaultRepositorySystemSession(session2);
            pluginSession.setArtifactDescriptorPolicy(new SimpleArtifactDescriptorPolicy(true, false));
            ArtifactDescriptorRequest request = new ArtifactDescriptorRequest(pluginArtifact, repositories, REPOSITORY_CONTEXT);
            request.setTrace(trace2);
            ArtifactDescriptorResult result = this.repoSystem.readArtifactDescriptor(pluginSession, request);
            pluginArtifact = result.getArtifact();
            if (this.logger.isWarnEnabled() && !result.getRelocations().isEmpty()) {
                String message = pluginArtifact instanceof RelocatedArtifact ? ((RelocatedArtifact)pluginArtifact).getMessage() : null;
                this.logger.warn("The artifact " + result.getRelocations().get(0) + " has been relocated to " + pluginArtifact + (message != null ? ": " + message : ""));
            }
            if ((requiredMavenVersion = (String)result.getProperties().get("prerequisites.maven")) != null) {
                LinkedHashMap<String, String> props = new LinkedHashMap<String, String>(pluginArtifact.getProperties());
                props.put("requiredMavenVersion", requiredMavenVersion);
                pluginArtifact = pluginArtifact.setProperties(props);
            }
        }
        catch (ArtifactDescriptorException e2) {
            throw new PluginResolutionException(plugin, (Throwable)e2);
        }
        try {
            ArtifactRequest request = new ArtifactRequest(pluginArtifact, repositories, REPOSITORY_CONTEXT);
            request.setTrace(trace2);
            pluginArtifact = this.repoSystem.resolveArtifact(session2, request).getArtifact();
        }
        catch (ArtifactResolutionException e3) {
            throw new PluginResolutionException(plugin, (Throwable)e3);
        }
        return pluginArtifact;
    }

    public DependencyNode resolveCoreExtension(Plugin plugin, DependencyFilter dependencyFilter, List<RemoteRepository> repositories, RepositorySystemSession session2) throws PluginResolutionException {
        return this.resolveInternal(plugin, null, dependencyFilter, null, repositories, session2);
    }

    @Override
    public DependencyNode resolve(Plugin plugin, Artifact pluginArtifact, DependencyFilter dependencyFilter, List<RemoteRepository> repositories, RepositorySystemSession session2) throws PluginResolutionException {
        return this.resolveInternal(plugin, pluginArtifact, dependencyFilter, new PlexusUtilsInjector(), repositories, session2);
    }

    private DependencyNode resolveInternal(Plugin plugin, Artifact pluginArtifact, DependencyFilter dependencyFilter, DependencyGraphTransformer transformer, List<RemoteRepository> repositories, RepositorySystemSession session2) throws PluginResolutionException {
        DependencyNode node2;
        RequestTrace trace2 = RequestTrace.newChild(null, plugin);
        if (pluginArtifact == null) {
            pluginArtifact = this.toArtifact(plugin, session2);
        }
        ScopeDependencyFilter collectionFilter = new ScopeDependencyFilter("provided", "test");
        DependencyFilter resolutionFilter = AndDependencyFilter.newInstance(collectionFilter, dependencyFilter);
        try {
            DependencySelector selector = AndDependencySelector.newInstance(session2.getDependencySelector(), new WagonExcluder());
            transformer = ChainedDependencyGraphTransformer.newInstance(session2.getDependencyGraphTransformer(), transformer);
            DefaultRepositorySystemSession pluginSession = new DefaultRepositorySystemSession(session2);
            pluginSession.setDependencySelector(selector);
            pluginSession.setDependencyGraphTransformer(transformer);
            CollectRequest request = new CollectRequest();
            request.setRequestContext(REPOSITORY_CONTEXT);
            request.setRepositories(repositories);
            request.setRoot(new Dependency(pluginArtifact, null));
            for (org.apache.maven.model.Dependency dependency : plugin.getDependencies()) {
                Dependency pluginDep = RepositoryUtils.toDependency(dependency, session2.getArtifactTypeRegistry());
                if (!"system".equals(pluginDep.getScope())) {
                    pluginDep = pluginDep.setScope("runtime");
                }
                request.addDependency(pluginDep);
            }
            DependencyRequest depRequest = new DependencyRequest(request, resolutionFilter);
            depRequest.setTrace(trace2);
            request.setTrace(RequestTrace.newChild(trace2, depRequest));
            node2 = this.repoSystem.collectDependencies(pluginSession, request).getRoot();
            if (this.logger.isDebugEnabled()) {
                node2.accept(new GraphLogger());
            }
            depRequest.setRoot(node2);
            this.repoSystem.resolveDependencies(session2, depRequest);
        }
        catch (DependencyCollectionException e2) {
            throw new PluginResolutionException(plugin, (Throwable)e2);
        }
        catch (DependencyResolutionException e3) {
            throw new PluginResolutionException(plugin, e3.getCause());
        }
        return node2;
    }

    class GraphLogger
    implements DependencyVisitor {
        private String indent = "";

        GraphLogger() {
        }

        @Override
        public boolean visitEnter(DependencyNode node2) {
            StringBuilder buffer2 = new StringBuilder(128);
            buffer2.append(this.indent);
            Dependency dep = node2.getDependency();
            if (dep != null) {
                Artifact art = dep.getArtifact();
                buffer2.append(art);
                if (StringUtils.isNotEmpty(dep.getScope())) {
                    buffer2.append(':').append(dep.getScope());
                }
                if (dep.isOptional()) {
                    buffer2.append(" (optional)");
                }
                if ((node2.getManagedBits() & 2) == 2) {
                    String premanagedScope = DependencyManagerUtils.getPremanagedScope(node2);
                    buffer2.append(" (scope managed from ");
                    buffer2.append(Objects.toString(premanagedScope, "default"));
                    buffer2.append(')');
                }
                if ((node2.getManagedBits() & 1) == 1) {
                    String premanagedVersion = DependencyManagerUtils.getPremanagedVersion(node2);
                    buffer2.append(" (version managed from ");
                    buffer2.append(Objects.toString(premanagedVersion, "default"));
                    buffer2.append(')');
                }
                if ((node2.getManagedBits() & 4) == 4) {
                    Boolean premanagedOptional = DependencyManagerUtils.getPremanagedOptional(node2);
                    buffer2.append(" (optionality managed from ");
                    buffer2.append(Objects.toString(premanagedOptional, "default"));
                    buffer2.append(')');
                }
                if ((node2.getManagedBits() & 0x10) == 16) {
                    Collection<Exclusion> premanagedExclusions = DependencyManagerUtils.getPremanagedExclusions(node2);
                    buffer2.append(" (exclusions managed from ");
                    buffer2.append(Objects.toString(premanagedExclusions, "default"));
                    buffer2.append(')');
                }
                if ((node2.getManagedBits() & 8) == 8) {
                    Map<String, String> premanagedProperties = DependencyManagerUtils.getPremanagedProperties(node2);
                    buffer2.append(" (properties managed from ");
                    buffer2.append(Objects.toString(premanagedProperties, "default"));
                    buffer2.append(')');
                }
            }
            DefaultPluginDependenciesResolver.this.logger.debug(buffer2.toString());
            this.indent = this.indent + "   ";
            return true;
        }

        @Override
        public boolean visitLeave(DependencyNode node2) {
            this.indent = this.indent.substring(0, this.indent.length() - 3);
            return true;
        }
    }
}

