﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/iot-managed-integrations/IoTManagedIntegrations_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace IoTManagedIntegrations {
namespace Model {

/**
 * <p>Structure representing one over-the-air (OTA) task
 * configuration.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/iot-managed-integrations-2025-03-03/OtaTaskConfigurationSummary">AWS
 * API Reference</a></p>
 */
class OtaTaskConfigurationSummary {
 public:
  AWS_IOTMANAGEDINTEGRATIONS_API OtaTaskConfigurationSummary() = default;
  AWS_IOTMANAGEDINTEGRATIONS_API OtaTaskConfigurationSummary(Aws::Utils::Json::JsonView jsonValue);
  AWS_IOTMANAGEDINTEGRATIONS_API OtaTaskConfigurationSummary& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_IOTMANAGEDINTEGRATIONS_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The id of the over-the-air (OTA) task configuration</p>
   */
  inline const Aws::String& GetTaskConfigurationId() const { return m_taskConfigurationId; }
  inline bool TaskConfigurationIdHasBeenSet() const { return m_taskConfigurationIdHasBeenSet; }
  template <typename TaskConfigurationIdT = Aws::String>
  void SetTaskConfigurationId(TaskConfigurationIdT&& value) {
    m_taskConfigurationIdHasBeenSet = true;
    m_taskConfigurationId = std::forward<TaskConfigurationIdT>(value);
  }
  template <typename TaskConfigurationIdT = Aws::String>
  OtaTaskConfigurationSummary& WithTaskConfigurationId(TaskConfigurationIdT&& value) {
    SetTaskConfigurationId(std::forward<TaskConfigurationIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the over-the-air (OTA) task configuration.</p>
   */
  inline const Aws::String& GetName() const { return m_name; }
  inline bool NameHasBeenSet() const { return m_nameHasBeenSet; }
  template <typename NameT = Aws::String>
  void SetName(NameT&& value) {
    m_nameHasBeenSet = true;
    m_name = std::forward<NameT>(value);
  }
  template <typename NameT = Aws::String>
  OtaTaskConfigurationSummary& WithName(NameT&& value) {
    SetName(std::forward<NameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The timestamp value of when the over-the-air (OTA) task configuration was
   * created at.</p>
   */
  inline const Aws::Utils::DateTime& GetCreatedAt() const { return m_createdAt; }
  inline bool CreatedAtHasBeenSet() const { return m_createdAtHasBeenSet; }
  template <typename CreatedAtT = Aws::Utils::DateTime>
  void SetCreatedAt(CreatedAtT&& value) {
    m_createdAtHasBeenSet = true;
    m_createdAt = std::forward<CreatedAtT>(value);
  }
  template <typename CreatedAtT = Aws::Utils::DateTime>
  OtaTaskConfigurationSummary& WithCreatedAt(CreatedAtT&& value) {
    SetCreatedAt(std::forward<CreatedAtT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_taskConfigurationId;
  bool m_taskConfigurationIdHasBeenSet = false;

  Aws::String m_name;
  bool m_nameHasBeenSet = false;

  Aws::Utils::DateTime m_createdAt{};
  bool m_createdAtHasBeenSet = false;
};

}  // namespace Model
}  // namespace IoTManagedIntegrations
}  // namespace Aws
