﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/databrew/GlueDataBrew_EXPORTS.h>
#include <aws/databrew/model/Dataset.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace GlueDataBrew {
namespace Model {
class ListDatasetsResult {
 public:
  AWS_GLUEDATABREW_API ListDatasetsResult() = default;
  AWS_GLUEDATABREW_API ListDatasetsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_GLUEDATABREW_API ListDatasetsResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>A list of datasets that are defined.</p>
   */
  inline const Aws::Vector<Dataset>& GetDatasets() const { return m_datasets; }
  template <typename DatasetsT = Aws::Vector<Dataset>>
  void SetDatasets(DatasetsT&& value) {
    m_datasetsHasBeenSet = true;
    m_datasets = std::forward<DatasetsT>(value);
  }
  template <typename DatasetsT = Aws::Vector<Dataset>>
  ListDatasetsResult& WithDatasets(DatasetsT&& value) {
    SetDatasets(std::forward<DatasetsT>(value));
    return *this;
  }
  template <typename DatasetsT = Dataset>
  ListDatasetsResult& AddDatasets(DatasetsT&& value) {
    m_datasetsHasBeenSet = true;
    m_datasets.emplace_back(std::forward<DatasetsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A token that you can use in a subsequent call to retrieve the next set of
   * results.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  ListDatasetsResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  ListDatasetsResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<Dataset> m_datasets;
  bool m_datasetsHasBeenSet = false;

  Aws::String m_nextToken;
  bool m_nextTokenHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace GlueDataBrew
}  // namespace Aws
