/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.mindmap;

import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.ParserPass;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.color.NoSuchColorException;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.mindmap.IdeaShape;
import net.sourceforge.plantuml.mindmap.MindMapDiagram;
import net.sourceforge.plantuml.regex.IRegex;
import net.sourceforge.plantuml.regex.RegexConcat;
import net.sourceforge.plantuml.regex.RegexLeaf;
import net.sourceforge.plantuml.regex.RegexOptional;
import net.sourceforge.plantuml.regex.RegexResult;
import net.sourceforge.plantuml.utils.LineLocation;

public class CommandMindMapOrgmode
extends SingleLineCommand2<MindMapDiagram> {
    public CommandMindMapOrgmode() {
        super(false, CommandMindMapOrgmode.getRegexConcat());
    }

    static IRegex getRegexConcat() {
        return RegexConcat.build(CommandMindMapOrgmode.class.getName(), RegexLeaf.start(), new RegexLeaf(1, "TYPE", "([ \t]*[*#]+)"), new RegexOptional((IRegex)new RegexLeaf(1, "BACKCOLOR", "\\[(#\\w+)\\]")), new RegexLeaf(1, "SHAPE", "(_)?"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf(1, "LABEL", "(.*)"), RegexLeaf.end());
    }

    @Override
    protected CommandExecutionResult executeArg(MindMapDiagram diagram, LineLocation location, RegexResult arg, ParserPass currentPass) throws NoSuchColorException {
        String type = arg.get("TYPE", 0);
        String label = arg.get("LABEL", 0);
        String stringColor = arg.get("BACKCOLOR", 0);
        HColor backColor = null;
        if (stringColor != null) {
            backColor = diagram.getSkinParam().getIHtmlColorSet().getColor(stringColor);
        }
        return diagram.addIdea(backColor, diagram.getSmartLevel(type), Display.getWithNewlines(diagram.getPragma(), label), IdeaShape.fromDesc(arg.get("SHAPE", 0)));
    }
}

