/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.registry.classloading.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.Set;
import org.hibernate.boot.registry.classloading.internal.AggregatedClassLoader;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;

abstract class AggregatedServiceLoader<S> {
    private static final CoreMessageLogger log = CoreLogging.messageLogger(AggregatedServiceLoader.class);

    AggregatedServiceLoader() {
    }

    static <S> AggregatedServiceLoader<S> create(AggregatedClassLoader aggregatedClassLoader, Class<S> serviceContract) {
        return new ClassPathAndModulePathAggregatedServiceLoader<S>(aggregatedClassLoader, serviceContract);
    }

    public abstract Collection<S> getAll();

    public abstract void close();

    private static class ClassPathAndModulePathAggregatedServiceLoader<S>
    extends AggregatedServiceLoader<S> {
        private final Class<S> serviceContract;
        private final ServiceLoader<S> aggregatedClassLoaderServiceLoader;
        private final List<ServiceLoader<S>> delegates;
        private Collection<S> cache = null;

        private ClassPathAndModulePathAggregatedServiceLoader(AggregatedClassLoader aggregatedClassLoader, Class<S> serviceContract) {
            this.serviceContract = serviceContract;
            this.delegates = new ArrayList<ServiceLoader<S>>();
            this.aggregatedClassLoaderServiceLoader = ServiceLoader.load(serviceContract, aggregatedClassLoader);
            Iterator<ClassLoader> clIterator = aggregatedClassLoader.newClassLoaderIterator();
            while (clIterator.hasNext()) {
                this.delegates.add(ServiceLoader.load(serviceContract, clIterator.next()));
            }
        }

        @Override
        public Collection<S> getAll() {
            if (this.cache == null) {
                this.cache = Collections.unmodifiableCollection(this.loadAll());
            }
            return this.cache;
        }

        private Collection<S> loadAll() {
            HashSet<String> alreadyEncountered = new HashSet<String>();
            LinkedHashSet result = new LinkedHashSet();
            Iterator providerIterator = this.aggregatedClassLoaderServiceLoader.stream().iterator();
            while (providerIterator.hasNext()) {
                ServiceLoader.Provider provider = (ServiceLoader.Provider)providerIterator.next();
                this.collectServiceIfNotDuplicate(result, alreadyEncountered, provider);
            }
            for (ServiceLoader<S> delegate : this.delegates) {
                providerIterator = delegate.stream().iterator();
                while (this.hasNextIgnoringServiceConfigurationError(providerIterator)) {
                    ServiceLoader.Provider provider = (ServiceLoader.Provider)providerIterator.next();
                    this.collectServiceIfNotDuplicate(result, alreadyEncountered, provider);
                }
            }
            return result;
        }

        private boolean hasNextIgnoringServiceConfigurationError(Iterator<?> iterator) {
            while (true) {
                try {
                    return iterator.hasNext();
                }
                catch (ServiceConfigurationError e) {
                    log.ignoringServiceConfigurationError(this.serviceContract.getName(), e);
                    continue;
                }
                break;
            }
        }

        private void collectServiceIfNotDuplicate(Set<S> result, Set<String> alreadyEncountered, ServiceLoader.Provider<S> provider) {
            Class<S> type = provider.type();
            String typeName = type.getName();
            if (alreadyEncountered.add(typeName)) {
                result.add(provider.get());
            }
        }

        @Override
        public void close() {
            this.cache = null;
        }
    }
}

