/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.forms.login.freemarker.model;

import java.util.Collections;
import java.util.List;
import org.keycloak.authentication.AuthenticationFlowContext;
import org.keycloak.authentication.AuthenticationSelectionOption;
import org.keycloak.forms.login.LoginFormsPages;
import org.keycloak.sessions.AuthenticationSessionModel;

public class AuthenticationContextBean {
    private final AuthenticationFlowContext context;
    private final LoginFormsPages page;

    public AuthenticationContextBean(AuthenticationFlowContext context, LoginFormsPages page) {
        this.context = context;
        this.page = page;
    }

    public List<AuthenticationSelectionOption> getAuthenticationSelections() {
        return this.context == null ? Collections.emptyList() : this.context.getAuthenticationSelections();
    }

    public boolean showTryAnotherWayLink() {
        return this.getAuthenticationSelections().size() > 1 && this.page != LoginFormsPages.LOGIN_SELECT_AUTHENTICATOR;
    }

    public boolean showUsername() {
        if (this.context == null) {
            return false;
        }
        AuthenticationSessionModel authenticationSession = this.context.getAuthenticationSession();
        if (Boolean.parseBoolean(authenticationSession.getAuthNote("USERNAME_HIDDEN"))) {
            return this.getAttemptedUsername() != null;
        }
        return this.context.getUser() != null && authenticationSession != null && this.page != LoginFormsPages.ERROR;
    }

    public boolean showResetCredentials() {
        return this.showUsername() && this.page == LoginFormsPages.LOGIN_RESET_PASSWORD;
    }

    public String getAttemptedUsername() {
        if (this.context == null) {
            return null;
        }
        String username = this.context.getAuthenticationSession().getAuthNote("ATTEMPTED_USERNAME");
        if (username == null && this.context.getUser() != null) {
            username = this.context.getUser().getUsername();
        }
        return username;
    }
}

