/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.mapping;

import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.jboss.resteasy.reactive.server.mapping.Dumpable;
import org.jboss.resteasy.reactive.server.mapping.SubstringMap;

class PathMatcher<T>
implements Dumpable {
    private final T defaultHandler;
    private final SubstringMap<T> paths;
    private final int[] lengths;

    PathMatcher(T defaultHandler, SubstringMap<T> paths, int[] lengths) {
        this.defaultHandler = defaultHandler;
        this.paths = paths;
        this.lengths = lengths;
    }

    PathMatch<T> match(String path) {
        int length = path.length();
        int[] lengths = this.lengths;
        for (int i = 0; i < lengths.length; ++i) {
            SubstringMap.SubstringMatch<T> next;
            int pathLength = lengths[i];
            if (pathLength == length) {
                next = this.paths.get(path, length);
                if (next == null) continue;
                return new PathMatch<T>(path, "", next.getValue());
            }
            if (pathLength >= length || (next = this.paths.get(path, pathLength)) == null) continue;
            return new PathMatch<T>(next.getKey(), path.substring(pathLength), next.getValue());
        }
        return this.defaultMatch(path);
    }

    PathMatch<T> defaultMatch(String path) {
        return new PathMatch<T>("/", path, this.defaultHandler);
    }

    @Override
    public void dump(int level) {
        System.err.println("Paths: " + this.paths.size());
        for (String key : this.paths.keys()) {
            System.err.println(" " + key + ": ");
            SubstringMap.SubstringMatch<T> match = this.paths.get(key);
            System.err.println("  matchKey: " + match.getKey());
            System.err.println("  matchValue: ");
            this.dumpValue(match.getValue(), 3);
        }
        System.err.println("Default handler: " + String.valueOf(this.defaultHandler));
    }

    private void dumpValue(T value, int level) {
        if (value instanceof List) {
            for (Object x : (List)value) {
                if (!(x instanceof Dumpable)) continue;
                ((Dumpable)x).dump(level);
            }
        }
    }

    public static final class PathMatch<T> {
        private final String matched;
        private final String remaining;
        private final T value;

        public PathMatch(String matched, String remaining, T value) {
            this.matched = matched;
            this.remaining = remaining;
            this.value = value;
        }

        public String getRemaining() {
            return this.remaining;
        }

        public String getMatched() {
            return this.matched;
        }

        public T getValue() {
            return this.value;
        }
    }

    static class Builder<T> {
        private static final String STRING_PATH_SEPARATOR = "/";
        private T defaultHandler;
        private final SubstringMap.Builder<T> pathsBuilder = new SubstringMap.Builder();

        Builder() {
        }

        void addPrefixPath(String path, T handler) {
            if (path.isEmpty()) {
                throw new IllegalArgumentException("Path not specified");
            }
            if (STRING_PATH_SEPARATOR.equals(path)) {
                this.defaultHandler = handler;
                return;
            }
            if (path.endsWith(STRING_PATH_SEPARATOR)) {
                throw new RuntimeException("Prefix path cannot end with /");
            }
            this.pathsBuilder.put(path, handler);
        }

        private int[] buildLengths(SubstringMap<T> paths) {
            TreeSet<Integer> lengths = new TreeSet<Integer>(new Comparator<Integer>(){

                @Override
                public int compare(Integer o1, Integer o2) {
                    return -o1.compareTo(o2);
                }
            });
            for (String p : paths.keys()) {
                lengths.add(p.length());
            }
            int[] lengthArray = new int[lengths.size()];
            int pos = 0;
            Iterator iterator = lengths.iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                lengthArray[pos++] = i;
            }
            return lengthArray;
        }

        public PathMatcher<T> build() {
            SubstringMap<T> paths = this.pathsBuilder.build();
            return new PathMatcher<T>(this.defaultHandler, paths, this.buildLengths(paths));
        }
    }
}

