# frozen_string_literal: true

class FinalizeBackfillIdentifierNamesOfVulnerabilityReads < Gitlab::Database::Migration[2.2]
  MIGRATION = "BackfillIdentifierNamesOfVulnerabilityReads"

  milestone '17.6'
  restrict_gitlab_migration gitlab_schema: :gitlab_sec

  disable_ddl_transaction!

  def up
    ensure_batched_background_migration_is_finished(
      job_class_name: MIGRATION,
      table_name: :vulnerability_reads,
      column_name: :id,
      job_arguments: [],
      finalize: true
    )
  end

  def down; end
end
