/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.core;

import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.HTMLTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBDatabaseException;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.core.WorkbenchContextListener;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPErrorAssistant;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPMessageType;
import org.jkiss.dbeaver.model.access.DBAPasswordChangeInfo;
import org.jkiss.dbeaver.model.connection.DBPAuthInfo;
import org.jkiss.dbeaver.model.exec.DBExecUtils;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.fs.DBNPathBase;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProcessDescriptor;
import org.jkiss.dbeaver.model.runtime.DBRProcessListener;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithResult;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithReturn;
import org.jkiss.dbeaver.model.runtime.RunnableWithResult;
import org.jkiss.dbeaver.model.runtime.load.ILoadService;
import org.jkiss.dbeaver.model.runtime.load.ILoadVisualizer;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.ui.DBPPlatformUI;
import org.jkiss.dbeaver.runtime.ui.console.ConsoleUserInterface;
import org.jkiss.dbeaver.ui.LoadingJob;
import org.jkiss.dbeaver.ui.ShellUtils;
import org.jkiss.dbeaver.ui.UIExecutionQueue;
import org.jkiss.dbeaver.ui.UITask;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.actions.datasource.DataSourceInvalidateHandler;
import org.jkiss.dbeaver.ui.dialogs.AcceptLicenseDialog;
import org.jkiss.dbeaver.ui.dialogs.BaseAuthDialog;
import org.jkiss.dbeaver.ui.dialogs.EnterNameDialog;
import org.jkiss.dbeaver.ui.dialogs.MessageBoxBuilder;
import org.jkiss.dbeaver.ui.dialogs.Reply;
import org.jkiss.dbeaver.ui.dialogs.StandardErrorDialog;
import org.jkiss.dbeaver.ui.dialogs.connection.PasswordChangeDialog;
import org.jkiss.dbeaver.ui.dialogs.driver.DriverEditHelpers;
import org.jkiss.dbeaver.ui.dialogs.exec.ExecutionQueueErrorJob;
import org.jkiss.dbeaver.ui.internal.UIConnectionMessages;
import org.jkiss.dbeaver.ui.navigator.actions.NavigatorHandlerObjectOpen;
import org.jkiss.dbeaver.ui.navigator.dialogs.ObjectBrowserDialog;
import org.jkiss.dbeaver.ui.notifications.NotificationUtils;
import org.jkiss.dbeaver.ui.views.process.ProcessPropertyTester;
import org.jkiss.dbeaver.ui.views.process.ShellProcessView;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class DesktopUI
extends ConsoleUserInterface {
    private static final Log log = Log.getLog(DesktopUI.class);
    private WorkbenchContextListener contextListener;

    public static DesktopUI getInstance() {
        return (DesktopUI)DBWorkbench.getPlatformUI();
    }

    static void disposeUI() {
        DBPPlatformUI platformUI = DBWorkbench.getPlatformUI();
        if (platformUI instanceof DesktopUI) {
            DesktopUI desktopUI = (DesktopUI)platformUI;
            try {
                desktopUI.dispose();
            }
            catch (Throwable e) {
                log.error((Object)e);
            }
        }
    }

    private void dispose() {
        if (this.contextListener != null) {
            this.contextListener.dispose();
        }
    }

    public void initialize() {
        new AbstractJob("Workbench listener"){

            @NotNull
            protected IStatus run(@NotNull DBRProgressMonitor monitor) {
                if (PlatformUI.isWorkbenchRunning() && !PlatformUI.getWorkbench().isStarting()) {
                    UIUtils.asyncExec(() -> {
                        WorkbenchContextListener workbenchContextListener = DesktopUI.this.contextListener = WorkbenchContextListener.registerInWorkbench();
                    });
                } else {
                    this.schedule(50L);
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    public boolean acceptLicense(final String message, final String licenseText) {
        return (Boolean)new UITask<Boolean>(){

            protected Boolean runTask() {
                return AcceptLicenseDialog.acceptLicense((Shell)UIUtils.getActiveWorkbenchShell(), (String)message, (String)licenseText);
            }
        }.execute();
    }

    public DBPPlatformUI.UserResponse showError(@NotNull String title, @Nullable String message, @NotNull IStatus status) {
        if (DesktopUI.isHeadlessMode()) {
            return super.showError(title, message, status);
        }
        IStatus rootStatus = status;
        IStatus s = status;
        while (s != null) {
            if (s.getException() instanceof DBException) {
                DBPPlatformUI.UserResponse dbErrorResp = DesktopUI.showDatabaseError(message, (DBException)s.getException());
                if (dbErrorResp == null) break;
                return dbErrorResp;
            }
            if (s.getChildren() == null || s.getChildren().length <= 0) break;
            s = rootStatus = s.getChildren()[0];
        }
        if (rootStatus == Status.CANCEL_STATUS) {
            return DBPPlatformUI.UserResponse.CANCEL;
        }
        log.error((Object)rootStatus.getMessage(), rootStatus.getException());
        Runnable runnable = () -> {
            StandardErrorDialog dialog = new StandardErrorDialog(UIUtils.getActiveWorkbenchShell(), Objects.requireNonNull(title, "Error"), message, status, 4);
            dialog.open();
        };
        UIUtils.syncExec((Runnable)runnable);
        return DBPPlatformUI.UserResponse.OK;
    }

    private static boolean isHeadlessMode() {
        return DBWorkbench.getPlatform().getApplication().isHeadlessMode();
    }

    public DBPPlatformUI.UserResponse showError(@NotNull String title, @Nullable String message, @NotNull Throwable error) {
        if (DesktopUI.isHeadlessMode()) {
            return super.showError(title, message, error);
        }
        return this.showError(title, message, GeneralUtils.makeExceptionStatus((Throwable)error));
    }

    public DBPPlatformUI.UserResponse showError(@NotNull String title, @Nullable String message) {
        if (DesktopUI.isHeadlessMode()) {
            return super.showError(title, message);
        }
        return this.showError(title, null, (IStatus)new Status(4, "org.jkiss.dbeaver.core", message));
    }

    public void showMessageBox(@NotNull String title, String message, boolean error) {
        if (DesktopUI.isHeadlessMode()) {
            super.showMessageBox(title, message, error);
        } else if (error) {
            DesktopUI.showMessageBox(title, message, (DBPImage)DBIcon.STATUS_ERROR);
        } else {
            DesktopUI.showMessageBox(title, message, (DBPImage)DBIcon.STATUS_INFO);
        }
    }

    private static void showMessageBox(@NotNull String title, @NotNull String message, @NotNull DBPImage image) {
        UIUtils.syncExec(() -> {
            Reply reply = MessageBoxBuilder.builder((Shell)Display.getCurrent().getActiveShell()).setTitle(title).setMessage(message).setPrimaryImage(image).setReplies(new Reply[]{Reply.OK}).showMessageBox();
        });
    }

    public void showWarningMessageBox(@NotNull String title, String message) {
        if (DesktopUI.isHeadlessMode()) {
            super.showWarningMessageBox(title, message);
        } else {
            DesktopUI.showMessageBox(title, message, (DBPImage)DBIcon.STATUS_WARNING);
        }
    }

    public void showNotification(@NotNull String title, String message, boolean error, @Nullable Runnable feedback) {
        NotificationUtils.sendNotification((String)"generic", (String)title, (String)message, (DBPMessageType)(error ? DBPMessageType.ERROR : DBPMessageType.INFORMATION), (Runnable)feedback);
    }

    public void showWarningNotification(@NotNull String title, String message) {
        NotificationUtils.sendNotification((String)"generic", (String)title, (String)message, (DBPMessageType)DBPMessageType.WARNING, null);
    }

    public boolean confirmAction(String title, String message) {
        if (DesktopUI.isHeadlessMode()) {
            return super.confirmAction(title, message);
        }
        return UIUtils.confirmAction((String)title, (String)message);
    }

    public boolean confirmAction(String title, String message, boolean isWarning) {
        if (DesktopUI.isHeadlessMode()) {
            return super.confirmAction(title, message, isWarning);
        }
        return UIUtils.confirmAction(null, (String)title, (String)message, (DBPImage)(isWarning ? DBIcon.STATUS_WARNING : DBIcon.STATUS_QUESTION));
    }

    public boolean confirmAction(@NotNull String title, @NotNull String message, @NotNull String buttonLabel, boolean isWarning) {
        if (DesktopUI.isHeadlessMode()) {
            return super.confirmAction(title, message, buttonLabel, isWarning);
        }
        Reply confirm = new Reply(buttonLabel);
        Reply[] decision = new Reply[1];
        UIUtils.syncExec(() -> {
            replyArray[0] = MessageBoxBuilder.builder((Shell)UIUtils.getActiveWorkbenchShell()).setTitle(title).setMessage(message).setReplies(new Reply[]{confirm, Reply.CANCEL}).setDefaultReply(Reply.CANCEL).setPrimaryImage((DBPImage)(isWarning ? DBIcon.STATUS_WARNING : DBIcon.STATUS_QUESTION)).showMessageBox();
        });
        return decision[0] == confirm;
    }

    @NotNull
    public DBPPlatformUI.UserChoiceResponse showUserChoice(final @NotNull String title, final @Nullable String message, @NotNull List<String> labels, final @NotNull List<String> forAllLabels, final @Nullable Integer previousChoice, int defaultChoice) {
        if (DesktopUI.isHeadlessMode()) {
            return super.showUserChoice(title, message, labels, forAllLabels, previousChoice, defaultChoice);
        }
        final List<Reply> reply = labels.stream().map(s -> CommonUtils.isEmpty((String)s) ? null : new Reply(s)).toList();
        DBPPlatformUI.UserChoiceResponse userChoice = (DBPPlatformUI.UserChoiceResponse)UIUtils.syncExec((RunnableWithResult)new RunnableWithResult<DBPPlatformUI.UserChoiceResponse>(){

            public DBPPlatformUI.UserChoiceResponse runWithResult() {
                ArrayList extraCheckboxes = new ArrayList(forAllLabels.size());
                Integer[] selectedCheckboxIndex = new Integer[1];
                MessageBoxBuilder mbb = MessageBoxBuilder.builder((Shell)UIUtils.getActiveWorkbenchShell()).setTitle(title).setMessage(message).setReplies((Reply[])reply.stream().filter(Objects::nonNull).toArray(Reply[]::new)).setPrimaryImage((DBPImage)DBIcon.STATUS_WARNING);
                if (previousChoice != null && reply.get(previousChoice) != null) {
                    mbb.setDefaultReply((Reply)reply.get(previousChoice));
                }
                if (!forAllLabels.isEmpty()) {
                    mbb.setCustomArea(pp -> {
                        SelectionListener selectionListener = SelectionListener.widgetSelectedAdapter(e -> {
                            int chkIndex = (Integer)e.widget.getData();
                            if (((Button)extraCheckboxes.get(chkIndex)).getSelection()) {
                                integerArray[0] = chkIndex;
                                int index = 0;
                                while (index < extraCheckboxes.size()) {
                                    if (index != chkIndex) {
                                        ((Button)extraCheckboxes.get(index)).setSelection(false);
                                    }
                                    ++index;
                                }
                            }
                        });
                        int index = 0;
                        while (index < forAllLabels.size()) {
                            Button chk = UIUtils.createCheckbox((Composite)pp, (String)((String)forAllLabels.get(index)), (boolean)false);
                            chk.setData((Object)index);
                            chk.addSelectionListener(selectionListener);
                            extraCheckboxes.add(chk);
                            ++index;
                        }
                    });
                }
                Reply result = mbb.showMessageBox();
                int choiceIndex = reply.indexOf(result);
                return new DBPPlatformUI.UserChoiceResponse(choiceIndex, selectedCheckboxIndex[0]);
            }
        });
        return userChoice == null ? new DBPPlatformUI.UserChoiceResponse(0, null) : userChoice;
    }

    public DBPPlatformUI.UserResponse showErrorStopRetryIgnore(String task, Throwable error, boolean queue) {
        return ExecutionQueueErrorJob.showError((String)task, (Throwable)error, (boolean)queue);
    }

    private static DBPPlatformUI.UserResponse showDatabaseError(String message, DBException error) {
        DBPDataSource dBPDataSource;
        if (error instanceof DBDatabaseException) {
            DBDatabaseException dbe = (DBDatabaseException)error;
            dBPDataSource = dbe.getDataSource();
        } else {
            dBPDataSource = null;
        }
        DBPDataSource dataSource = dBPDataSource;
        DBPErrorAssistant.ErrorType errorType = dataSource == null ? DBPErrorAssistant.ErrorType.NORMAL : DBExecUtils.discoverErrorType((DBPDataSource)dataSource, (Throwable)error);
        switch (errorType) {
            case CONNECTION_LOST: {
                if (dataSource.getContainer().getDataSource() == null) {
                    return null;
                }
                DataSourceInvalidateHandler.showConnectionLostDialog(null, message, error);
                return DBPPlatformUI.UserResponse.OK;
            }
            case DRIVER_CLASS_MISSING: {
                DriverEditHelpers.showBadConfigDialog(null, (String)message, (DBException)error);
                return DBPPlatformUI.UserResponse.OK;
            }
        }
        return null;
    }

    @Nullable
    public DBPAuthInfo promptUserCredentials(@Nullable String prompt, @Nullable String description, @Nullable String userName, @Nullable String userPassword, boolean passwordOnly, boolean showSavePassword) {
        return this.promptUserCredentials(prompt, description, UIConnectionMessages.dialog_connection_auth_label_username, userName, UIConnectionMessages.dialog_connection_auth_label_password, userPassword, passwordOnly, showSavePassword);
    }

    @Nullable
    public DBPAuthInfo promptUserCredentials(final @Nullable String prompt, final @Nullable String description, final @NotNull String userNameLabel, final @Nullable String userName, final @NotNull String passwordLabel, final @Nullable String userPassword, final boolean passwordOnly, final boolean showSavePassword) {
        return (DBPAuthInfo)new UITask<DBPAuthInfo>(){

            public DBPAuthInfo runTask() {
                Shell shell = UIUtils.getActiveWorkbenchShell();
                BaseAuthDialog authDialog = new BaseAuthDialog(shell, prompt, passwordOnly, showSavePassword);
                authDialog.setUserNameLabel(userNameLabel);
                authDialog.setPasswordLabel(passwordLabel);
                authDialog.setDescription(description == null ? prompt : description);
                if (!passwordOnly) {
                    authDialog.setUserName(userName);
                }
                authDialog.setUserPassword(userPassword);
                if (authDialog.open() == 0) {
                    return authDialog.getAuthInfo();
                }
                return null;
            }
        }.execute();
    }

    @Nullable
    public DBAPasswordChangeInfo promptUserPasswordChange(final String prompt, final String userName, final String oldPassword, final boolean userEditable, final boolean oldPasswordVisible) {
        return (DBAPasswordChangeInfo)new UITask<DBAPasswordChangeInfo>(){

            public DBAPasswordChangeInfo runTask() {
                Shell shell = UIUtils.getActiveWorkbenchShell();
                PasswordChangeDialog passwordChangeDialog = new PasswordChangeDialog(shell, prompt, userName, oldPassword, userEditable, oldPasswordVisible);
                if (passwordChangeDialog.open() == 0) {
                    return passwordChangeDialog.getPasswordInfo();
                }
                return null;
            }
        }.execute();
    }

    public String promptProperty(final String prompt, final String defValue) {
        return (String)new UITask<String>(){

            public String runTask() {
                Shell shell = UIUtils.getActiveWorkbenchShell();
                EnterNameDialog dialog = new EnterNameDialog(shell, prompt, defValue);
                if (dialog.open() == 0) {
                    return dialog.getResult();
                }
                return null;
            }
        }.execute();
    }

    public DBNNode selectObject(@NotNull Object parentShell, String title, DBNNode rootNode, DBNNode selectedNode, Class<?>[] allowedTypes, Class<?>[] resultTypes, Class<?>[] leafTypes) {
        DBNNode[] result = new DBNNode[1];
        UIUtils.syncExec(() -> {
            Shell shell = parentShell instanceof Shell ? (Shell)parentShell : UIUtils.getActiveWorkbenchShell();
            dBNNodeArray[0] = ObjectBrowserDialog.selectObject((Shell)shell, (String)title, (DBNNode)rootNode, (DBNNode)selectedNode, (Class[])allowedTypes, (Class[])resultTypes, (Class[])leafTypes);
        });
        return result[0];
    }

    public void openEntityEditor(@NotNull DBSObject object) {
        UIUtils.syncExec(() -> {
            IEditorPart iEditorPart = NavigatorHandlerObjectOpen.openEntityEditor((DBSObject)object);
        });
    }

    public void openEntityEditor(@NotNull DBNNode selectedNode, String defaultPageId) {
        UIUtils.syncExec(() -> {
            IEditorPart iEditorPart = NavigatorHandlerObjectOpen.openEntityEditor((DBNNode)selectedNode, (String)defaultPageId, (IWorkbenchWindow)UIUtils.getActiveWorkbenchWindow());
        });
    }

    public void openConnectionEditor(@NotNull DBPDataSourceContainer dataSourceContainer) {
        UIUtils.syncExec(() -> NavigatorHandlerObjectOpen.openConnectionEditor((IWorkbenchWindow)UIUtils.getActiveWorkbenchWindow(), (DBPDataSourceContainer)dataSourceContainer));
    }

    public void executeProcess(@NotNull DBRProcessDescriptor processDescriptor) {
        processDescriptor.setProcessListener(new DBRProcessListener(){

            public void onProcessStarted() {
                ProcessPropertyTester.firePropertyChange("running");
            }

            public void onProcessTerminated(int resultCode) {
                ProcessPropertyTester.firePropertyChange("running");
            }
        });
        try {
            processDescriptor.execute();
        }
        catch (DBException e) {
            this.showError("Execute process", processDescriptor.getName(), e);
        }
        if (processDescriptor.getCommand().isShowProcessPanel()) {
            UIUtils.asyncExec(() -> {
                try {
                    ShellProcessView processView = (ShellProcessView)UIUtils.getActiveWorkbenchWindow().getActivePage().showView("org.jkiss.dbeaver.core.shellProcess", ShellProcessView.getNextId(), 2);
                    processView.initProcess(processDescriptor);
                }
                catch (PartInitException e) {
                    log.error((Object)e);
                }
            });
        }
    }

    public void executeInMainThread(@NotNull Runnable runnable) {
        UIUtils.syncExec((Runnable)runnable);
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public <T> Future<T> executeWithProgressBlocking(final @NotNull String operationDescription, final @NotNull DBRRunnableWithResult<Future<T>> runnable) {
        job = new AbstractJob(operationDescription){

            @NotNull
            protected IStatus run(@NotNull DBRProgressMonitor monitor) {
                monitor.beginTask(operationDescription, -1);
                try {
                    UIExecutionQueue.blockQueue();
                    runnable.run(monitor);
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                catch (Exception ex) {
                    IStatus iStatus = GeneralUtils.makeExceptionStatus((Throwable)ex);
                    return iStatus;
                }
                finally {
                    UIExecutionQueue.unblockQueue();
                    monitor.done();
                }
            }

            protected void canceling() {
                runnable.cancel();
            }
        };
        job.schedule();
        if (UIUtils.isUIThread() && !(display = UIUtils.getDisplay()).isDisposed()) {
            block14: {
                shortWaitResult = new CompletableFuture<T>();
                modalShortWait = (Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$9(java.util.concurrent.CompletableFuture org.jkiss.dbeaver.model.runtime.AbstractJob org.eclipse.swt.widgets.Display ), ()V)(shortWaitResult, (AbstractJob)job, (Display)display);
                workbench = PlatformUI.isWorkbenchRunning() != false ? PlatformUI.getWorkbench() : null;
                workbenchInitializing = workbench == null || workbench.isStarting() != false || workbench.isClosing() != false;
                shells = display.getShells();
                if (!workbenchInitializing) {
                    var13_11 = shells;
                    var12_14 = shells.length;
                    var11_15 = 0;
                    while (var11_15 < var12_14) {
                        shell = var13_11[var11_15];
                        shell.setEnabled(false);
                        ++var11_15;
                    }
                }
                try {
                    BusyIndicator.showWhile((Display)display, (Runnable)modalShortWait);
                }
                finally {
                    if (workbenchInitializing) break block14;
                    var14_22 = display.getShells();
                    var13_13 = var14_22.length;
                    var12_14 = 0;
                    ** while (var12_14 < var13_13)
                }
lbl-1000:
                // 1 sources

                {
                    shell = var14_22[var12_14];
                    shell.setEnabled(true);
                    ++var12_14;
                    continue;
                }
            }
            try {
                if (((Boolean)shortWaitResult.get()).booleanValue()) {
                    progress = new ProgressMonitorDialog(display.getActiveShell()){

                        protected void cancelPressed() {
                            job.cancel();
                            super.cancelPressed();
                        }
                    };
                    progress.run(true, true, (IRunnableWithProgress)LambdaMetafactory.metafactory(null, null, null, (Lorg/eclipse/core/runtime/IProgressMonitor;)V, lambda$11(java.lang.String org.jkiss.dbeaver.model.runtime.AbstractJob org.eclipse.core.runtime.IProgressMonitor ), (Lorg/eclipse/core/runtime/IProgressMonitor;)V)((String)operationDescription, (AbstractJob)job));
                }
            }
            catch (Exception ex) {
                return CompletableFuture.failedFuture(ex);
            }
        }
        try {
            job.join();
        }
        catch (InterruptedException ex) {
            return CompletableFuture.failedFuture(ex);
        }
        result = job.getResult();
        if (result == null) {
            return CompletableFuture.failedFuture(new DBException("the result of the job is null. Has it finished?"));
        }
        if (result.isOK()) {
            return (Future)runnable.getResult();
        }
        return CompletableFuture.failedFuture(result.getException());
    }

    public <T> T runWithMonitor(@NotNull DBRRunnableWithReturn<T> runnable) throws DBException {
        return (T)UIUtils.runWithMonitor(runnable);
    }

    public <T> T runWithProgress(@NotNull DBRRunnableWithReturn<T> runnable) throws DBException {
        return (T)UIUtils.runWithDialog(runnable);
    }

    @NotNull
    public <RESULT> Job createLoadingService(@NotNull ILoadService<RESULT> loadingService, @NotNull ILoadVisualizer<RESULT> visualizer) {
        return LoadingJob.createService(loadingService, visualizer);
    }

    public void copyTextToClipboard(@NotNull String text, boolean htmlFormat) {
        if (CommonUtils.isEmpty((String)text)) {
            return;
        }
        UIUtils.syncExec(() -> {
            TextTransfer textTransfer = TextTransfer.getInstance();
            Clipboard clipboard = new Clipboard(UIUtils.getDisplay());
            if (htmlFormat) {
                HTMLTransfer htmlTransfer = HTMLTransfer.getInstance();
                clipboard.setContents(new Object[]{text, text}, new Transfer[]{textTransfer, htmlTransfer});
            } else {
                clipboard.setContents(new Object[]{text}, new Transfer[]{textTransfer});
            }
        });
    }

    public void executeShellProgram(@NotNull String shellCommand) {
        UIUtils.asyncExec(() -> {
            boolean bl = ShellUtils.launchProgram((String)shellCommand);
        });
    }

    public void showInSystemExplorer(@NotNull String path) {
        UIUtils.asyncExec(() -> ShellUtils.showInSystemExplorer((String)path));
    }

    public DBNPathBase openFileSystemSelector(@NotNull String title, boolean folder, int style, boolean binary, String[] filterExt, String defaultValue) {
        this.showMessageBox("Not supported", "External file system are not supported", true);
        return null;
    }

    public boolean readAndDispatchEvents() {
        if (this.contextListener == null) {
            return false;
        }
        Display currentDisplay = Display.getCurrent();
        if (currentDisplay != null) {
            IWorkbench workbench;
            if (!(currentDisplay.readAndDispatch() || (workbench = PlatformUI.getWorkbench()).isStarting() || workbench.isClosing())) {
                currentDisplay.sleep();
            }
            return true;
        }
        return false;
    }

    private static long getLongOperationTime() {
        try {
            return PlatformUI.getWorkbench().getProgressService().getLongOperationTime();
        }
        catch (Exception exception) {
            return 800L;
        }
    }

    private static /* synthetic */ void lambda$9(CompletableFuture completableFuture, AbstractJob abstractJob, Display display) {
        try {
            ModalContext.run(monitor -> {
                try {
                    completableFuture.complete(!abstractJob.join(DesktopUI.getLongOperationTime(), (IProgressMonitor)new NullProgressMonitor()));
                }
                catch (Exception ex) {
                    completableFuture.completeExceptionally(ex);
                }
            }, (boolean)true, (IProgressMonitor)new NullProgressMonitor(), (Display)display);
        }
        catch (Exception ex) {
            completableFuture.completeExceptionally(ex);
        }
    }

    private static /* synthetic */ void lambda$11(String string, AbstractJob abstractJob, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        monitor.beginTask(string, -1);
        abstractJob.join();
        monitor.done();
    }
}

