/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.registry;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.Strictness;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.data.json.JSONUtils;
import org.jkiss.dbeaver.model.exec.DBCScriptContext;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.internal.SQLModelActivator;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;

public class SQLVariablesRegistry {
    private static final Log log = Log.getLog(SQLVariablesRegistry.class);
    public static final String CONFIG_FILE_PREFIX = "sql-variables-";
    public static final String CONFIG_FILE_SUFFIX = ".json";
    public static final String CONFIG_FILE_TYPE_DRIVER = "driver";
    public static final String CONFIG_FILE_TYPE_CONNECTION = "con";
    public static final String VARIABLES_STORE_DIR = "variables";
    private static final Gson CONFIG_GSON = new GsonBuilder().setStrictness(Strictness.LENIENT).serializeNulls().setPrettyPrinting().create();
    private static SQLVariablesRegistry registry;
    private final Map<DBPDriver, List<DBCScriptContext.VariableInfo>> driverVariables = new HashMap<DBPDriver, List<DBCScriptContext.VariableInfo>>();
    private final Map<String, List<DBCScriptContext.VariableInfo>> connectionVariables = new HashMap<String, List<DBCScriptContext.VariableInfo>>();
    private ConfigSaver configSaver;
    private final List<Object> saveLock = new ArrayList<Object>();

    private SQLVariablesRegistry() {
    }

    public static synchronized SQLVariablesRegistry getInstance() {
        if (registry == null) {
            registry = new SQLVariablesRegistry();
            registry.loadVariables();
        }
        return registry;
    }

    private void loadVariables() {
        Path[] configFiles;
        Path configLocation = this.getConfigLocation();
        if (Files.notExists(configLocation, new LinkOption[0])) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var4_5 = null;
            try (Stream<Path> stream = Files.list(configLocation);){
                configFiles = (Path[])stream.filter(f -> f.getFileName().toString().startsWith(CONFIG_FILE_PREFIX)).toArray(Path[]::new);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            log.debug((Object)e);
            return;
        }
        Path[] pathArray = configFiles;
        int n = configFiles.length;
        int n2 = 0;
        while (n2 < n) {
            Path configFile = pathArray[n2];
            String configName = configFile.getFileName().toString();
            if (!configName.endsWith(CONFIG_FILE_SUFFIX)) {
                log.debug((Object)("Skip variables config: bad file extension (" + String.valueOf(configFile) + ")"));
            } else {
                this.loadVariablesFromFile(configFile);
            }
            ++n2;
        }
    }

    private void loadVariablesFromFile(Path file) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (InputStream is = Files.newInputStream(file, new OpenOption[0]);){
                Throwable throwable2 = null;
                Object var6_10 = null;
                try (InputStreamReader r = new InputStreamReader(is, StandardCharsets.UTF_8);){
                    Map map = JSONUtils.parseMap((Gson)CONFIG_GSON, (Reader)r);
                    String driverId = JSONUtils.getString((Map)map, (String)CONFIG_FILE_TYPE_DRIVER);
                    String dataSourceId = JSONUtils.getString((Map)map, (String)"datasource");
                    Map varSrc = JSONUtils.getObject((Map)map, (String)VARIABLES_STORE_DIR);
                    ArrayList<DBCScriptContext.VariableInfo> variables = new ArrayList<DBCScriptContext.VariableInfo>();
                    for (Map.Entry entry : varSrc.entrySet()) {
                        DBCScriptContext.VariableInfo variableInfo;
                        if (entry.getValue() instanceof Map) {
                            Map valueMap = (Map)entry.getValue();
                            Object value = valueMap.get("value");
                            String type = JSONUtils.getString((Map)valueMap, (String)"type");
                            if (value == null || type == null) {
                                log.debug((Object)("Invalid variable declaration (" + (String)entry.getKey() + ")"));
                                continue;
                            }
                            variableInfo = new DBCScriptContext.VariableInfo((String)entry.getKey(), value, (DBCScriptContext.VariableType)CommonUtils.valueOf(DBCScriptContext.VariableType.class, (String)type, (Enum)DBCScriptContext.VariableType.VARIABLE));
                        } else {
                            variableInfo = new DBCScriptContext.VariableInfo((String)entry.getKey(), entry.getValue(), DBCScriptContext.VariableType.VARIABLE);
                        }
                        variables.add(variableInfo);
                    }
                    if (driverId != null) {
                        DBPDriver driver = DBWorkbench.getPlatform().getDataSourceProviderRegistry().findDriver(driverId);
                        if (driver == null) {
                            log.debug((Object)("Driver '" + driverId + "' not found. Saved variables ignored (" + String.valueOf(file) + ")"));
                        } else {
                            this.driverVariables.put(driver, variables);
                        }
                    } else if (dataSourceId != null) {
                        this.connectionVariables.put(dataSourceId, variables);
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            log.error((Object)e);
        }
    }

    private Path getConfigLocation() {
        return RuntimeUtils.getPluginStateLocation((Plugin)SQLModelActivator.getInstance()).resolve(VARIABLES_STORE_DIR);
    }

    @NotNull
    public List<DBCScriptContext.VariableInfo> getDriverVariables(DBPDriver driver) {
        List<DBCScriptContext.VariableInfo> variables = this.driverVariables.get(driver);
        return variables == null ? Collections.emptyList() : new ArrayList<DBCScriptContext.VariableInfo>(variables);
    }

    @NotNull
    public List<DBCScriptContext.VariableInfo> getDataSourceVariables(DBPDataSourceContainer dataSource) {
        List<DBCScriptContext.VariableInfo> variables = this.connectionVariables.get(dataSource);
        if (variables == null) {
            return this.getDriverVariables(dataSource.getDriver());
        }
        ArrayList<DBCScriptContext.VariableInfo> result = new ArrayList<DBCScriptContext.VariableInfo>(variables);
        result.addAll(this.getDriverVariables(dataSource.getDriver()));
        return result;
    }

    public void updateVariables(@Nullable DBPDriver driver, @Nullable DBPDataSourceContainer dataSource, @NotNull List<DBCScriptContext.VariableInfo> variables) {
        if (dataSource != null) {
            List<DBCScriptContext.VariableInfo> vars = this.connectionVariables.get(dataSource.getId());
            if (vars == null) {
                this.connectionVariables.put(dataSource.getId(), new ArrayList<DBCScriptContext.VariableInfo>(variables));
            } else {
                vars.addAll(variables);
            }
        } else if (driver != null) {
            List<DBCScriptContext.VariableInfo> vars = this.driverVariables.get(driver.getId());
            if (vars == null) {
                this.driverVariables.put(driver, new ArrayList<DBCScriptContext.VariableInfo>(variables));
            } else {
                vars.addAll(variables);
            }
        }
        this.saveConfig(driver, dataSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saveConfig(@Nullable DBPDriver driver, @Nullable DBPDataSourceContainer dataSource) {
        List<Object> list = this.saveLock;
        synchronized (list) {
            if (this.configSaver != null) {
                this.configSaver.cancel();
                this.configSaver = null;
            }
            if (driver != null && !this.saveLock.contains(driver)) {
                this.saveLock.add(driver);
            }
            if (dataSource != null && !this.saveLock.contains(dataSource)) {
                this.saveLock.add(dataSource);
            }
            this.configSaver = new ConfigSaver();
            this.configSaver.schedule(1000L);
        }
    }

    private class ConfigSaver
    extends AbstractJob {
        ConfigSaver() {
            super("Tab folders configuration save");
            this.setSystem(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(DBRProgressMonitor monitor) {
            ArrayList<Object> toSave;
            List<Object> list = SQLVariablesRegistry.this.saveLock;
            synchronized (list) {
                toSave = new ArrayList<Object>(SQLVariablesRegistry.this.saveLock);
                SQLVariablesRegistry.this.saveLock.clear();
            }
            this.flushConfig(toSave);
            return Status.OK_STATUS;
        }

        private void flushConfig(List<Object> toSave) {
            Path configLocation = SQLVariablesRegistry.this.getConfigLocation();
            if (!Files.exists(configLocation, new LinkOption[0])) {
                try {
                    Files.createDirectories(configLocation, new FileAttribute[0]);
                }
                catch (IOException e) {
                    log.error((Object)("Error creating variables storage location: " + String.valueOf(configLocation)), (Throwable)e);
                    return;
                }
            }
            for (Object so : toSave) {
                Object fileName;
                DBPDriver driver = null;
                DBPDataSourceContainer con = null;
                if (so instanceof DBPDriver) {
                    driver = (DBPDriver)so;
                    fileName = "sql-variables-driver-" + driver.getFullId() + SQLVariablesRegistry.CONFIG_FILE_SUFFIX;
                } else {
                    if (!(so instanceof DBPDataSourceContainer)) continue;
                    con = (DBPDataSourceContainer)so;
                    fileName = "sql-variables-con-" + ((DBPDataSourceContainer)so).getId() + SQLVariablesRegistry.CONFIG_FILE_SUFFIX;
                }
                fileName = CommonUtils.escapeFileName((String)fileName);
                Path configFile = configLocation.resolve((String)fileName);
                this.saveConfigToFile(configFile, driver, con);
            }
        }

        private void saveConfigToFile(Path configFile, DBPDriver driver, DBPDataSourceContainer con) {
            List<DBCScriptContext.VariableInfo> variables;
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            if (driver != null) {
                map.put(SQLVariablesRegistry.CONFIG_FILE_TYPE_DRIVER, driver.getFullId());
                variables = SQLVariablesRegistry.this.driverVariables.get(driver);
            } else if (con != null) {
                map.put("datasource", con.getId());
                variables = SQLVariablesRegistry.this.connectionVariables.get(con.getId());
            } else {
                log.debug((Object)"Both driver and connection are null");
                return;
            }
            LinkedHashMap<String, Object> varMap = new LinkedHashMap<String, Object>();
            for (DBCScriptContext.VariableInfo v : variables) {
                if (v.type == DBCScriptContext.VariableType.VARIABLE) {
                    varMap.put(v.name, v.value);
                    continue;
                }
                LinkedHashMap<String, Object> varDetails = new LinkedHashMap<String, Object>();
                varDetails.put("type", v.type.name());
                varDetails.put("value", v.value);
                varMap.put(v.name, varDetails);
            }
            map.put(SQLVariablesRegistry.VARIABLES_STORE_DIR, varMap);
            try {
                Files.writeString(configFile, (CharSequence)CONFIG_GSON.toJson(map, Map.class), new OpenOption[0]);
            }
            catch (IOException e) {
                log.error((Object)e);
            }
        }
    }
}

