﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/backup/Backup_EXPORTS.h>
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace Backup {
namespace Model {
class UpdateFrameworkResult {
 public:
  AWS_BACKUP_API UpdateFrameworkResult() = default;
  AWS_BACKUP_API UpdateFrameworkResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_BACKUP_API UpdateFrameworkResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The unique name of a framework. This name is between 1 and 256 characters,
   * starting with a letter, and consisting of letters (a-z, A-Z), numbers (0-9), and
   * underscores (_).</p>
   */
  inline const Aws::String& GetFrameworkName() const { return m_frameworkName; }
  template <typename FrameworkNameT = Aws::String>
  void SetFrameworkName(FrameworkNameT&& value) {
    m_frameworkNameHasBeenSet = true;
    m_frameworkName = std::forward<FrameworkNameT>(value);
  }
  template <typename FrameworkNameT = Aws::String>
  UpdateFrameworkResult& WithFrameworkName(FrameworkNameT&& value) {
    SetFrameworkName(std::forward<FrameworkNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>An Amazon Resource Name (ARN) that uniquely identifies a resource. The format
   * of the ARN depends on the resource type.</p>
   */
  inline const Aws::String& GetFrameworkArn() const { return m_frameworkArn; }
  template <typename FrameworkArnT = Aws::String>
  void SetFrameworkArn(FrameworkArnT&& value) {
    m_frameworkArnHasBeenSet = true;
    m_frameworkArn = std::forward<FrameworkArnT>(value);
  }
  template <typename FrameworkArnT = Aws::String>
  UpdateFrameworkResult& WithFrameworkArn(FrameworkArnT&& value) {
    SetFrameworkArn(std::forward<FrameworkArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The date and time that a framework is created, in ISO 8601 representation.
   * The value of <code>CreationTime</code> is accurate to milliseconds. For example,
   * 2020-07-10T15:00:00.000-08:00 represents the 10th of July 2020 at 3:00 PM 8
   * hours behind UTC.</p>
   */
  inline const Aws::Utils::DateTime& GetCreationTime() const { return m_creationTime; }
  template <typename CreationTimeT = Aws::Utils::DateTime>
  void SetCreationTime(CreationTimeT&& value) {
    m_creationTimeHasBeenSet = true;
    m_creationTime = std::forward<CreationTimeT>(value);
  }
  template <typename CreationTimeT = Aws::Utils::DateTime>
  UpdateFrameworkResult& WithCreationTime(CreationTimeT&& value) {
    SetCreationTime(std::forward<CreationTimeT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  UpdateFrameworkResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_frameworkName;
  bool m_frameworkNameHasBeenSet = false;

  Aws::String m_frameworkArn;
  bool m_frameworkArnHasBeenSet = false;

  Aws::Utils::DateTime m_creationTime{};
  bool m_creationTimeHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace Backup
}  // namespace Aws
